/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

import java.util.*;
import java.net.*;
import java.io.*;

/**
 * This class manages SNMP connections to various SNMP agents
 * on the network.  A process can have several connections
 * open simutaneously but it is limited in number.  Instead of opening
 * and closing different connections every time a different SNMP device 
 * is polled, a number of open connections can be cached. This class
 * manages the list of open SNMP connections and will open new 
 * connections and close old ones.
 * <P>
 * @version     $Id: ConnectManager.java,v 1.4 1997/05/18 08:11:53 alex Exp $
 * @author      Alex Kowalenko
 * @see Connect
 * @see Pdu
 */

public class ConnectManager {

    short _cacheSize;
    int _timeOut;
    Hashtable _cache; // Dictionary<String, Connect>

/**
 * Creates a manager with a cache of cacheSize
 */

    ConnectManager(short cacheSize) {
	_cacheSize = cacheSize;
	_cache = new Hashtable(cacheSize);
    };
  
/**
 * finalize
 */

  protected void finalize() {
      for(Enumeration e = _cache.elements(); e.hasMoreElements(); ) {
	  ((Connect)e.nextElement()).close();
      };
  };

/**
 *  Set the lenght of timeouts for a SNMP response
 */
    
    void setTimeOut(int seconds) {
	_timeOut = seconds;
    };
  
/**
 * Send a PDU packet to the SNMP agent at this address.
 * Return the SNMP agents reply as a PDU packet.
 */

    PDU send(String address, PDU pdu) 
	throws SnmpPDUException, SnmpNetException, SnmpTimeOutException,
	SocketException, IOException, UnknownHostException {
	    if(!_cache.containsKey(address)) {
		if(_cache.size() > _cacheSize) {    
		    // Close a connection.
		    String removeAddress = null;
		    int count = 0;
		    for(Enumeration iter = _cache.keys(); 
			iter.hasMoreElements(); ) {
			String item = ((String)iter.nextElement());
			if(((Connect)_cache.get(item)).count() > count)
			    removeAddress = item;
		    }
		    if(removeAddress != null)
			((Connect)_cache.get(removeAddress)).close();
		    _cache.remove(removeAddress);
		}
		Connect con = new Connect(address, 
					  _timeOut, 
					  Connect.SNMP_PORT);
		con.open();
		_cache.put(address,con);
	    }
	    ByteBuffer result = 
		((Connect)_cache.get(address)).send(pdu.BERSerialize());
	    return new PDU(result); // Parse returned buffer. 
    }          

}
