/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

$Id: Access.java,v 1.4 1997/05/21 10:09:56 alex Exp $

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.snmp;

/**
 * Thee SNMP Access Attribute
 * @version     $Id: Access.java,v 1.4 1997/05/21 10:09:56 alex Exp $
 * @author      Alex Kowalenko
 */

import java.io.*;

public class Access implements Serializable {

    final static int VOID = -1;
    final static int READ_ONLY = 1;
    final static int READ_WRITE = 2;
    final static int WRITE_ONLY = 3;
    final static int NOT_ACCESSIBLE = 4;

  private int _value;
 
/**
 * Default Constructor   
 */
    
  public Access() {
      _value = VOID;
  };
    
/**
 * Constructor from the integer representation 
 */
    
  public Access(int theAccess) {
      _value = theAccess;
  };

/** 
 * Constructor from the string representation
 */
    
  public Access(String string) {
      if(string.equals("read-only"))
	  _value = READ_ONLY;
      else if(string.equals("read-write"))
	  _value = READ_WRITE;
      else if(string.equals("write-only"))
	  _value = WRITE_ONLY;
      else if(string.equals("not-accessiable"))
	  _value = READ_ONLY;
      else _value = VOID;
  };
    
/**
 * Return the integer representation
 */
    
  public int value() {
      return _value;
  };
    
/**
 * Return string representation
 */

  public String toString() {
      switch( _value) {
	case READ_ONLY: 
	  return "Read Only";
	case READ_WRITE:
	  return "Read Write";
	case WRITE_ONLY:
	  return "Write Only";
	case NOT_ACCESSIBLE:
	  return "Not Accessible";
      }
      return "Unknown";
  }

/**
 * Test Harness
 */
  
    static public void main(String args[]) {
	Access s = new Access();
	System.out.println(s);
	s = new Access(Access.WRITE_ONLY);
	System.out.println(s);
    }
}
