/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.
This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 
Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
$Id: mc.lex,v 1.3 1997/06/05 11:59:11 alex Exp $
*/
package aka.mc;
/**
 * Lexical Analyser for mc
 * @version     $Id: mc.lex,v 1.3 1997/06/05 11:59:11 alex Exp $
 * @author      Alex Kowalenko
 */
import java_cup.runtime.*;


class Yylex {
	private final int YY_BUFFER_SIZE = 512;
	private final int YY_F = -1;
	private final int YY_NO_STATE = -1;
	private final int YY_NOT_ACCEPT = 0;
	private final int YY_START = 1;
	private final int YY_END = 2;
	private final int YY_NO_ANCHOR = 4;
	private final byte YYEOF = -1;

/**
 * Test harness
 */
    public static void main(String args[]) {
	Yylex lex = new Yylex(System.in);
	while(true) {
	    try {
		token token = lex.yylex();
		System.out.println(token.sym + " " + lex.yytext());
	    } catch(Exception e) {
	    };
	};
    };
	private java.io.DataInputStream yy_instream;
	private int yy_buffer_index;
	private int yy_buffer_read;
	private int yy_buffer_start;
	private int yy_buffer_end;
	private byte yy_buffer[];
	private int yyline;
	private int yy_lexical_state;
	Yylex (java.io.InputStream instream) {
		if (null == instream) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_instream = new java.io.DataInputStream(instream);
		yy_buffer = new byte[YY_BUFFER_SIZE];
		yy_buffer_read = 0;
		yy_buffer_index = 0;
		yy_buffer_start = 0;
		yy_buffer_end = 0;
		yyline = 0;
		yy_lexical_state = YYINITIAL;
	}
	private boolean yy_eof_done = false;
	private final int YYINITIAL = 0;
	private final int yy_state_dtrans[] = {
		0
	};
	private void yybegin (int state) {
		yy_lexical_state = state;
	}
	private byte yy_advance ()
		throws java.io.IOException {
		int next_read;
		int i;
		int j;

		if (yy_buffer_index < yy_buffer_read) {
			return yy_buffer[yy_buffer_index++];
		}

		if (0 != yy_buffer_start) {
			i = yy_buffer_start;
			j = 0;
			while (i < yy_buffer_read) {
				yy_buffer[j] = yy_buffer[i];
				++i;
				++j;
			}
			yy_buffer_end = yy_buffer_end - yy_buffer_start;
			yy_buffer_start = 0;
			yy_buffer_read = j;
			yy_buffer_index = j;
			next_read = yy_instream.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YYEOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}

		while (yy_buffer_index >= yy_buffer_read) {
			if (yy_buffer_index >= yy_buffer.length) {
				yy_buffer = yy_double(yy_buffer);
			}
			next_read = yy_instream.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YYEOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}
		return yy_buffer[yy_buffer_index++];
	}
	private void yy_move_start () {
		if ((byte) '\n' == yy_buffer[yy_buffer_start]) {
			++yyline;
		}
		++yy_buffer_start;
	}
	private void yy_pushback () {
		--yy_buffer_end;
	}
	private void yy_mark_start () {
		int i;
		for (i = yy_buffer_start; i < yy_buffer_index; ++i) {
			if ((byte) '\n' == yy_buffer[i]) {
				++yyline;
			}
		}
		yy_buffer_start = yy_buffer_index;
	}
	private void yy_mark_end () {
		yy_buffer_end = yy_buffer_index;
	}
	private void yy_to_mark () {
		yy_buffer_index = yy_buffer_end;
	}
	private java.lang.String yytext () {
		return (new java.lang.String(yy_buffer,0,
			yy_buffer_start,
			yy_buffer_end - yy_buffer_start));
	}
	private int yylength () {
		return yy_buffer_end - yy_buffer_start;
	}
	private byte[] yy_double (byte buf[]) {
		int i;
		byte newbuf[];
		newbuf = new byte[2*buf.length];
		for (i = 0; i < buf.length; ++i) {
			newbuf[i] = buf[i];
		}
		return newbuf;
	}
	private final int YY_E_INTERNAL = 0;
	private final int YY_E_MATCH = 1;
	private java.lang.String yy_error_string[] = {
		"Error: Internal error.\n",
		"Error: Unmatched input.\n"
	};
	private void yy_error (int code,boolean fatal) {
		java.lang.System.out.print(yy_error_string[code]);
		java.lang.System.out.flush();
		if (fatal) {
			throw new Error("Fatal Error.\n");
		}
	}
	private int yy_acpt[] = {
		YY_NOT_ACCEPT,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_END,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NOT_ACCEPT,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NOT_ACCEPT,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NOT_ACCEPT,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NOT_ACCEPT,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR,
		YY_NO_ANCHOR
	};
	private int yy_cmap[] = {
		0, 0, 0, 0, 0, 0, 0, 0,
		1, 1, 2, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		1, 0, 3, 0, 0, 0, 0, 4,
		5, 6, 0, 0, 7, 8, 9, 0,
		10, 10, 10, 10, 10, 10, 10, 10,
		10, 10, 11, 12, 0, 13, 0, 0,
		0, 14, 15, 16, 17, 18, 19, 20,
		21, 22, 23, 24, 24, 25, 26, 27,
		28, 29, 30, 31, 32, 33, 24, 24,
		34, 35, 36, 0, 0, 0, 0, 0,
		0, 37, 37, 37, 37, 37, 37, 24,
		24, 24, 24, 24, 24, 24, 24, 24,
		24, 24, 24, 24, 24, 24, 24, 24,
		24, 24, 24, 38, 39, 40, 0, 0
		
	};
	private int yy_rmap[] = {
		0, 1, 2, 1, 1, 1, 1, 3,
		1, 4, 1, 1, 1, 1, 5, 1,
		1, 1, 5, 5, 5, 5, 5, 5,
		6, 5, 5, 5, 5, 5, 5, 5,
		5, 5, 7, 8, 9, 8, 10, 11,
		12, 13, 14, 15, 16, 17, 18, 19,
		20, 21, 22, 23, 24, 25, 26, 27,
		28, 29, 30, 31, 32, 33, 34, 35,
		36, 37, 38, 39, 40, 41, 42, 43,
		44, 45, 46, 47, 48, 49, 50, 51,
		52, 53, 54, 55, 56, 57, 58, 59,
		60, 61, 62, 63, 64, 65, 66, 67,
		68, 69, 70, 71, 72, 73, 74, 75,
		76, 77, 78, 79, 80, 81, 82, 83,
		84, 85, 86, 87, 5, 88, 89, 90,
		91, 92 
	};
	private int yy_nxt[][] = {
		{ 1, 2, 2, 3, 35, 4, 5, 6,
			38, 41, 7, 44, 8, 1, 9, 90,
			116, 120, 59, 75, 116, 116, 91, 116,
			116, 116, 116, 36, 116, 116, 116, 76,
			116, 116, 116, 116, 116, 116, 10, 11,
			12 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1 
		},
		{ -1, 2, 2, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, 7, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			92, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			115, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, 15, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, 34, -1, -1, -1,
			-1, -1, 37, -1, -1, -1, 37, 37,
			37, 37, 37, 37, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, 37, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 96,
			116, 116, 116, 14, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			40, -1, 7, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 18, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ 40, 40, 16, 40, 40, 40, 40, 40,
			40, 40, 40, 40, 40, 40, 40, 40,
			40, 40, 40, 40, 40, 40, 40, 40,
			40, 40, 40, 40, 40, 40, 40, 40,
			40, 40, 40, 40, 40, 40, 40, 40,
			40 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			-1, 13, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 19, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, 17, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, 43, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 20, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 21, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 22, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 23,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			24, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 25,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 26, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 27,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 28,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 29, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 30, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 31,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 32, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 33, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 39, 116, 116, 116, 116, 116,
			116, 116, 94, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 42, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 45, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 46, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 47, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 48,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			49, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 50, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 51, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			52, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			53, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			54, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 55, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 56, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 57, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 58, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 60, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 97, 116, 116, 116, 61, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			98, 116, 116, 99, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 62, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 63, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 64, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 65, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			66, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			67, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 68, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 69, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 70, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 71, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 72, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 73, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 74, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 77, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 95, 116, 116, 116, 116, 116, 116,
			116, 117, 78, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			79, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 100, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 101,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 102, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 103, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 80,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 105, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 81, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 82, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 118, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			106, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 83, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 107, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 84, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 108, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 119, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			121, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 85, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 110, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			113, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 114, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 86, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 87, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			88, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			89, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 104, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 109, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 111, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 93, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		},
		{ -1, -1, -1, -1, -1, -1, -1, -1,
			116, -1, 116, -1, -1, -1, 116, 116,
			116, 116, 116, 116, 116, 116, 112, 116,
			116, 116, 116, 116, 116, 116, 116, 116,
			116, 116, 116, 116, 116, 116, -1, -1,
			-1 
		}
	};
	public token yylex ()
		throws java.io.IOException {
		byte yy_lookahead;
		int yy_anchor = YY_NO_ANCHOR;
		int yy_state = yy_state_dtrans[yy_lexical_state];
		int yy_next_state = YY_NO_STATE;
		int yy_last_accept_state = YY_NO_STATE;
		boolean yy_initial = true;
		int yy_this_accept;

		yy_mark_start();
		yy_this_accept = yy_acpt[yy_state];
		if (YY_NOT_ACCEPT != yy_this_accept) {
			yy_last_accept_state = yy_state;
			yy_mark_end();
		}
		while (true) {
			yy_lookahead = yy_advance();
			yy_next_state = YY_F;
			if (YYEOF != yy_lookahead) {
				yy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];
			}
			if (YY_F != yy_next_state) {
				yy_state = yy_next_state;
				yy_initial = false;
				yy_this_accept = yy_acpt[yy_state];
				if (YY_NOT_ACCEPT != yy_this_accept) {
					yy_last_accept_state = yy_state;
					yy_mark_end();
				}
			}
			else {
				if (YYEOF == yy_lookahead && true == yy_initial) {

    return new  token(Symbol.EOF);
				}
				else if (YY_NO_STATE == yy_last_accept_state) {
					throw (new Error("Lexical Error: Unmatched Input."));
				}
				else {
					yy_to_mark();
					yy_anchor = yy_acpt[yy_last_accept_state];
					if (0 != (YY_END & yy_anchor)) {
						yy_pushback();
					}
					if (0 != (YY_START & yy_anchor)) {
						yy_move_start();
					}
					switch (yy_last_accept_state) {
					case 1:
						{ System.out.println("Unknown lexical element" + yytext()); }
					case -2:
						break;
					case 2:
						{ }
					case -3:
						break;
					case 3:
						{ StringBuffer buffer = new StringBuffer();
     int line = yyline;
     char c = (char) yy_advance();
     while(c != '"') {
	 buffer.append(c);
	 c = (char) yy_advance();
     }
     return new str_token(Symbol.STRING, buffer.toString());
   }
					case -4:
						break;
					case 4:
						{ return new token(Symbol.L_BRACKET); }
					case -5:
						break;
					case 5:
						{ return new token(Symbol.R_BRACKET); }
					case -6:
						break;
					case 6:
						{ return new token(Symbol.COMMA); }
					case -7:
						break;
					case 7:
						{ return new int_token(Symbol.NUMBER, Integer.parseInt(yytext()) ); }
					case -8:
						break;
					case 8:
						{ return new token(Symbol.SEMI); }
					case -9:
						break;
					case 9:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -10:
						break;
					case 10:
						{ return new token(Symbol.L_BRACE); }
					case -11:
						break;
					case 11:
						{ return new token(Symbol.BAR); }
					case -12:
						break;
					case 12:
						{ return new token(Symbol.R_BRACE); }
					case -13:
						break;
					case 13:
						{ return new token(Symbol.ELLIP); }
					case -14:
						break;
					case 14:
						{ return new token(Symbol.OF); }
					case -15:
						break;
					case 15:
						{ return new str_token(Symbol.HEXSTRING, yytext()); }
					case -16:
						break;
					case 16:
						{ }
					case -17:
						break;
					case 17:
						{ return new token(Symbol.ASSIGN); }
					case -18:
						break;
					case 18:
						{ return new token(Symbol.END); }
					case -19:
						break;
					case 19:
						{ return new token(Symbol.FROM); }
					case -20:
						break;
					case 20:
						{ return new token(Symbol.SIZE); }
					case -21:
						break;
					case 21:
						{ return new token(Symbol.BEGIN); }
					case -22:
						break;
					case 22:
						{ return new token(Symbol.INDEX); }
					case -23:
						break;
					case 23:
						{ return new token(Symbol.ACCESS); }
					case -24:
						break;
					case 24:
						{ return new token(Symbol.OBJECT); }
					case -25:
						break;
					case 25:
						{ return new token(Symbol.STATUS); }
					case -26:
						break;
					case 26:
						{ return new token(Symbol.SYNTAX); }
					case -27:
						break;
					case 27:
						{ return new token(Symbol.EXPORTS); }
					case -28:
						break;
					case 28:
						{ return new token(Symbol.IMPORTS); }
					case -29:
						break;
					case 29:
						{ return new token(Symbol.SEQUENCE); }
					case -30:
						break;
					case 30:
						{ return new token(Symbol.IDENTIFIER); }
					case -31:
						break;
					case 31:
						{ return new token(Symbol.DEF); }
					case -32:
						break;
					case 32:
						{ return new token(Symbol.DESCRIPTION); }
					case -33:
						break;
					case 33:
						{ return new token(Symbol.OBJECT_TYPE); }
					case -34:
						break;
					case 35:
						{ System.out.println("Unknown lexical element" + yytext()); }
					case -35:
						break;
					case 36:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -36:
						break;
					case 38:
						{ System.out.println("Unknown lexical element" + yytext()); }
					case -37:
						break;
					case 39:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -38:
						break;
					case 41:
						{ System.out.println("Unknown lexical element" + yytext()); }
					case -39:
						break;
					case 42:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -40:
						break;
					case 44:
						{ System.out.println("Unknown lexical element" + yytext()); }
					case -41:
						break;
					case 45:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -42:
						break;
					case 46:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -43:
						break;
					case 47:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -44:
						break;
					case 48:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -45:
						break;
					case 49:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -46:
						break;
					case 50:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -47:
						break;
					case 51:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -48:
						break;
					case 52:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -49:
						break;
					case 53:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -50:
						break;
					case 54:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -51:
						break;
					case 55:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -52:
						break;
					case 56:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -53:
						break;
					case 57:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -54:
						break;
					case 58:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -55:
						break;
					case 59:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -56:
						break;
					case 60:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -57:
						break;
					case 61:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -58:
						break;
					case 62:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -59:
						break;
					case 63:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -60:
						break;
					case 64:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -61:
						break;
					case 65:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -62:
						break;
					case 66:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -63:
						break;
					case 67:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -64:
						break;
					case 68:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -65:
						break;
					case 69:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -66:
						break;
					case 70:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -67:
						break;
					case 71:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -68:
						break;
					case 72:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -69:
						break;
					case 73:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -70:
						break;
					case 74:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -71:
						break;
					case 75:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -72:
						break;
					case 76:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -73:
						break;
					case 77:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -74:
						break;
					case 78:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -75:
						break;
					case 79:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -76:
						break;
					case 80:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -77:
						break;
					case 81:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -78:
						break;
					case 82:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -79:
						break;
					case 83:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -80:
						break;
					case 84:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -81:
						break;
					case 85:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -82:
						break;
					case 86:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -83:
						break;
					case 87:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -84:
						break;
					case 88:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -85:
						break;
					case 89:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -86:
						break;
					case 90:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -87:
						break;
					case 91:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -88:
						break;
					case 92:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -89:
						break;
					case 93:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -90:
						break;
					case 94:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -91:
						break;
					case 95:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -92:
						break;
					case 96:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -93:
						break;
					case 97:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -94:
						break;
					case 98:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -95:
						break;
					case 99:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -96:
						break;
					case 100:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -97:
						break;
					case 101:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -98:
						break;
					case 102:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -99:
						break;
					case 103:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -100:
						break;
					case 104:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -101:
						break;
					case 105:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -102:
						break;
					case 106:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -103:
						break;
					case 107:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -104:
						break;
					case 108:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -105:
						break;
					case 109:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -106:
						break;
					case 110:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -107:
						break;
					case 111:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -108:
						break;
					case 112:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -109:
						break;
					case 113:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -110:
						break;
					case 114:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -111:
						break;
					case 115:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -112:
						break;
					case 116:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -113:
						break;
					case 117:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -114:
						break;
					case 118:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -115:
						break;
					case 119:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -116:
						break;
					case 120:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -117:
						break;
					case 121:
						{ return new str_token(Symbol.IDENT, yytext()); }
					case -118:
						break;
					default:
						yy_error(YY_E_INTERNAL,false);
					case -1:
					}
					yy_initial = true;
					yy_state = yy_state_dtrans[yy_lexical_state];
					yy_next_state = YY_NO_STATE;
					yy_last_accept_state = YY_NO_STATE;
					yy_mark_start();
					yy_this_accept = yy_acpt[yy_state];
					if (YY_NOT_ACCEPT != yy_this_accept) {
						yy_last_accept_state = yy_state;
					}
				}
			}
		}
	}
}
