/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    

$Id: mc.lex,v 1.3 1997/06/05 11:59:11 alex Exp $

*/

package aka.mc;

/**
 * Lexical Analyser for mc
 * @version     $Id: mc.lex,v 1.3 1997/06/05 11:59:11 alex Exp $
 * @author      Alex Kowalenko
 */

import java_cup.runtime.*;

%%

%line
%cup
%type token

%{

/**
 * Test harness
 */

    public static void main(String args[]) {
	Yylex lex = new Yylex(System.in);
	while(true) {
	    try {
		token token = lex.yylex();
		System.out.println(token.sym + " " + lex.yytext());
	    } catch(Exception e) {
	    };
	};
    };

%}

%eofval{
    return new  token(Symbol.EOF);
%eofval}

letter=[A-Za-z]
digit=[0-9]
ident={letter}({letter}|{digit}|\-)*
number=(\-)?{digit}+
hexNumber=\'({digit}|[A-Fa-f])*\'H
whiteSpace=[\n\ \t\b\012]
comment=\-\-.*$

%%

{whiteSpace}+ { }
{comment} { }

"DEFINITIONS"    { return new token(Symbol.DEF); }
"BEGIN"          { return new token(Symbol.BEGIN); }
"END"            { return new token(Symbol.END); }
"OBJECT"         { return new token(Symbol.OBJECT); }
"IMPORTS"        { return new token(Symbol.IMPORTS); }
"OBJECT-TYPE"    { return new token(Symbol.OBJECT_TYPE); }
"SYNTAX"         { return new token(Symbol.SYNTAX); }
"ACCESS"         { return new token(Symbol.ACCESS); }
"STATUS"         { return new token(Symbol.STATUS); }
"DESCRIPTION"    { return new token(Symbol.DESCRIPTION); }
"SIZE"           { return new token(Symbol.SIZE); }
"INDEX"          { return new token(Symbol.INDEX); }
"SEQUENCE"       { return new token(Symbol.SEQUENCE); }
"OF"             { return new token(Symbol.OF); }
"IDENTIFIER"     { return new token(Symbol.IDENTIFIER); } 
"FROM"           { return new token(Symbol.FROM); }    
"EXPORTS"        { return new token(Symbol.EXPORTS); } 
  
{ident} { return new str_token(Symbol.IDENT, yytext()); }
{number} { return new int_token(Symbol.NUMBER, Integer.parseInt(yytext()) ); }
{hexNumber} { return new str_token(Symbol.HEXSTRING, yytext()); }

"{" { return new token(Symbol.L_BRACE); }
"}" { return new token(Symbol.R_BRACE); }
"(" { return new token(Symbol.L_BRACKET); }
")" { return new token(Symbol.R_BRACKET); }

"|" { return new token(Symbol.BAR); }
"::=" { return new token(Symbol.ASSIGN); }
"," { return new token(Symbol.COMMA); }
";" { return new token(Symbol.SEMI); }
".." { return new token(Symbol.ELLIP); }


\" { StringBuffer buffer = new StringBuffer();
     int line = yyline;
     char c = (char) yy_advance();
     while(c != '"') {
	 buffer.append(c);
	 c = (char) yy_advance();
     }
     return new str_token(Symbol.STRING, buffer.toString());

   }

. { System.out.println("Unknown lexical element" + yytext()); }
