/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

package aka.mc;
import aka.snmp.*;

import java.io.*;

/**
 * Implements mc - compiler for MIB definitions
 * @see 
 * @version     $Id: Main.java,v 1.5 1997/06/05 11:59:10 alex Exp $
 * @author      Alex Kowalenko
 */

class Main {

  public static void main(String args[]) {
      
      InputStream input;
      String outputFilename;

      try {
	  if(args.length <= 0) {
	      input = System.in;
	  }
	  else {
	      input = new FileInputStream(args[0]);
	  };
      } catch(FileNotFoundException e) {
	  System.err.println("File not found : " + args[0]);
	  System.exit(1);
	  return;
      };
      
      MibManagerSerializer manager = new MibManagerSerializer();  
      Parser parser = new Parser();
      parser.setMibManager(manager);
      parser.setInputStream(input);
      try {
	  // parser.debug_parse();
	  parser.parse();
      } catch (Exception e) {
	  System.err.println("Exception: " + e.getMessage());
	  e.printStackTrace();
      }
      
      // Write serial file

      if(input == System.in) {
	  outputFilename = "mibs.ser";
      }
      else {
	  outputFilename = args[0] + ".ser";
      };

      try {
	  manager.SerializeToFile(outputFilename);
      } catch(FileNotFoundException e) {
	  System.err.println("File not found : " + args[0]);
	  System.exit(1);
	  return;
      } catch(IOException e) {
	  System.err.println("File not found : " + args[0]);
	  System.exit(1);
	  return;
      } 
  };

};
