/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

/**
 * Class Description
 * @see 
 * @version     $Id: SnmpTableListener.java,v 1.3 1997/05/30 11:50:39 alex Exp $
 * @author      Alex Kowalenko
 */

package aka.gui;

import java.awt.*;
import java.awt.event.*;

class SnmpTableListener implements ActionListener, WindowListener {

    static final int MENU_FILE_QUIT = 1;
    static final int MENU_EDIT_ADDVAR = 2;
    static final int MENU_EDIT_DELVAR = 9;
    static final int MENU_EDIT_SETPOLL = 3;
    static final int MENU_EDIT_SETCN = 4;
    static final int GET_VARIABLE = 5;
    static final int GET_POLLING = 6;
    static final int GET_COMMUNITY = 7;
    static final int GET_HOSTNAME = 8;
    
    int _id;
    SnmpTable _app;
    SnmpTableGui _gui;
    Window _window = null;

  public SnmpTableListener(SnmpTable app, SnmpTableGui gui) {
      _app = app;
      _gui = gui;
      _id = 0;
  };

  public SnmpTableListener(int id, SnmpTable app, SnmpTableGui gui) {
      _id = id;
      _app = app;
      _gui = gui;
  };

  public SnmpTableListener(int id, SnmpTable app, Window window) {
      _id = id;
      _app = app;
      _window = window;
  };

/**
 * 
 */
  public void actionPerformed(ActionEvent e) {
      switch(_id) {
	case MENU_FILE_QUIT :
	  _app.quit();
	  System.exit(0);
	  break;
	case MENU_EDIT_ADDVAR:
	  _gui.doDialog("Add Variable", "Add new Variable", GET_VARIABLE);
	  break;	

	case MENU_EDIT_DELVAR:
	  String name = _gui.getSelected();
	  if(name != null) {
	      _app.deleteVariable(name);
	  };
	  break;	

	case MENU_EDIT_SETPOLL:
	  _gui.doDialog("Polling Interval", "Set Polling Interval", GET_POLLING);
	  break;
	case MENU_EDIT_SETCN:
	  _gui.doDialog("Community Name", "Set Community Name", GET_COMMUNITY);
	  break;

	case GET_VARIABLE:
	  _app.addVariable(_gui.getDialogString());
	  break;

	case GET_POLLING:
	   _app.setPollingInterval(Integer.parseInt(_gui.getDialogString()));
	   break;
	   
	case GET_COMMUNITY:
	  _app.setCommunityName(_gui.getDialogString());
	  break;

	case GET_HOSTNAME:
	  System.out.println("Hostname =" + _gui.getHostName() + ".");
	  _app.setHost(_gui.getHostName());
	  break;

      };
  };

  public void windowOpened(WindowEvent e) {};
  public void windowClosing(WindowEvent e) {
      if(_window != null) {
	  _window.dispose();
      }
      else {
	  _app.quit();
	  System.exit(0);
      };
  };
  public void windowClosed(WindowEvent e) {};
  public void windowIconified(WindowEvent e) {};
  public void windowDeiconified(WindowEvent e) {};
  public void windowActivated(WindowEvent e) {};  
  public void windowDeactivated(WindowEvent e) {};

};

