/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

/**
 * Class Description
 * @see 
 * @version     $Id: SnmpTableGui.java,v 1.3 1997/05/30 11:50:39 alex Exp $
 * @author      Alex Kowalenko
 */

package aka.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

class SnmpTableGui implements Observer {

    private SnmpTable _app;
    private Frame _f;
    private List _l;
   
    private TextField _hostField;

    private TextField _dialogTextField;
    private Dialog _dialog;

  public SnmpTableGui(SnmpTable app) {
      _app = app; 
      app.addObserver(this);

      _f = new Frame("Snmp Table");
      initMenus();
      initFrame();
      _f.show();

  }
    
  private void initMenus() {
      MenuBar bar = new MenuBar();
      
      // File menu     
      Menu menu = new Menu("File");
      MenuItem item = new MenuItem("Quit");
      item.addActionListener(
	  new SnmpTableListener(SnmpTableListener.MENU_FILE_QUIT, _app, this));
      menu.add(item);
      bar.add(menu);

      // Edit Menu
      menu = new Menu("Edit");
      item = new MenuItem("Add variable");
      item.addActionListener(
	  new SnmpTableListener(SnmpTableListener.MENU_EDIT_ADDVAR, _app, this));
      menu.add(item);
       
      item = new MenuItem("Delete variable");
      item.addActionListener(
	  new SnmpTableListener(SnmpTableListener.MENU_EDIT_DELVAR, _app, this)); 
      menu.add(item);
      
      item = new MenuItem("Set polling interval");
      item.addActionListener(
	  new SnmpTableListener(SnmpTableListener.MENU_EDIT_SETPOLL, _app, this));
      menu.add(item);
      
      item = new MenuItem("Set community name");
      item.addActionListener(
	  new SnmpTableListener(SnmpTableListener.MENU_EDIT_SETCN, _app, this));
      menu.add(item);
      bar.add(menu);
      
      _f.setMenuBar(bar);
  };
    
  private void initFrame() {
      // Layout manager is GridBag

      _f.setLayout(new BorderLayout());
      _f.add(new Label("Snmp Polling"), "North");
      
      Panel pp = new Panel();
      _f.add(pp, "Center");

      pp.add(new Label("Host"), "East");
      _hostField = new TextField("localhost", 40);
      _hostField.addActionListener(new SnmpTableListener(SnmpTableListener.GET_HOSTNAME,
						_app, 
						this));
      pp.add(_hostField, "West");
      _app.setHost("localhost");

      _l = new List(10);
      _f.add(_l, "South");

      _f.pack();
      _f.setSize(_f.getPreferredSize());

      _f.addWindowListener(new SnmpTableListener(_app, this));
  };

  public void update(Observable o, Object arg) {
      // Update List

      _l.removeAll();
      Enumeration e = _app.getObjects();
      while(e.hasMoreElements()) {
	  String[] object = (String[]) e.nextElement();
	  _l.add( object[0] + " = " + object[1]);
      };
  };

  public void doDialog(String name, String text, int action) {
      _dialog = new Dialog(_f, name);
      _dialog.add(new Label(text), "West");
      _dialogTextField = new TextField(30);
      _dialog.add(_dialogTextField, "East");
      Button b = new Button("OK");
      b.addActionListener(new SnmpTableListener(action, _app, this));
      _dialog.add(b, "South");
      _dialog.pack();
      _dialog.show();
      _dialog.addWindowListener(new SnmpTableListener(0, _app, _dialog));
      return;
  };

  public String getDialogString() {
      _dialog.dispose();
      if(_dialogTextField != null) {
	  return _dialogTextField.getText();
      } else {
	  return new String();
      };
  };

  public String getHostName() {
      return _hostField.getText();
  };
    

  public String getSelected() {
      return _l.getSelectedItem();
  };
};
