/*
Snmp Library
Copyright (C) 1997 Alex Kowalenko Associates Pty Ltd. All rights reserved.

This software maybe be free distributed, any any form, without fee, 
but may not be modified in any way without express permission of 
the directors of Alex Kowalenko Associates Pty Ltd. 

Alex Kowalenko Associates Pty Ltd makes no representations or
warranties about the suitabililty of the software, not even the
implied warranty of merchantability or fitness for any particular
purpose.    
*/

/**
 * Class Description
 * @see 
 * @version     $Id: SnmpTable.java,v 1.4 1997/06/09 09:22:58 alex Exp $
 * @author      Alex Kowalenko
 */

package aka.gui;

import java.util.*;
import aka.snmp.*;

class SnmpTable extends Observable implements Runnable {

    private String _host; 
    private String _communityName = "public";
    private int _polling = 10;

    private Vector _objects;
    private Snmp _snmp;
    
  public SnmpTable() {
      _objects = new Vector();

      // Set up snmp

      _snmp = new Snmp();
      try {
	  _snmp.readFile("mibs.ser");
      } catch (Exception e) {
	  System.err.println("Problem reading mib file " + e.getMessage());
	  System.err.flush();
	  return;
      }
      _snmp.setTimeOut(3);
      _snmp.setCommunityName(_communityName);
      
      // Start polling
      String value[] = new String[2];
      value[0] = "sysName"; value[1] = "";
      _objects.addElement(value);
      String value2[] = new String[2];
      value2[0] = "sysUpTime"; value2[1] = "";
      _objects.addElement(value2);
      (new Thread(this)).start();
  }

  public void setHost(String host) {
      _host = host;
      return;
  };

  public void setCommunityName(String name) {
      _communityName = name;
      _snmp.setCommunityName(name);
      return;
  };
    
  public void quit() {
      System.out.println("Quit");
  };

  public void addVariable(String name) {
      String value[] = new String[2];
      value[0] = name; value[1] = "";
      _objects.addElement(value); 
      poll();
      return;
  };

  public void deleteVariable(String name) {
      for(Enumeration e = _objects.elements(); e.hasMoreElements();) {
	  String object[] = (String[]) e.nextElement();
	  if(name.startsWith(object[0])) {
	      _objects.removeElement(object);
	      poll();
	  };
      };
  };

  public void setPollingInterval(int poll) {
      _polling = poll;
      return;
  };
   
  public Enumeration getObjects() {
      return _objects.elements();
  };

  private synchronized void poll() {
      // get values
      for(Enumeration e  = _objects.elements(); e.hasMoreElements();) {
	  String[] object = (String[]) e.nextElement();
	  try {
	      Type resultVal = _snmp.get(_host, object[0], 0);
	      object[1] = resultVal.toString();
	  } catch(Exception ex) {
	      object[1] = "Exception: " + ex.getMessage();
	  };
      };
      setChanged();
      notifyObservers();
      clearChanged();
  };
     
  public void run() {
      
      while(true) {
	  poll();

	  // sleep polling interval
	  try {
	      Thread.currentThread().sleep(_polling * 1000);
	  } catch(Exception e) {};
      };
  };

  public static void main(String args[]) {
      SnmpTable app = new SnmpTable();
      SnmpTableGui gui = new SnmpTableGui(app);
  };
}
