/*++ BUILD Version: 0001    // Increment this if a change has global effects

Copyright (c) 1992, Microsoft Corporation

Module Name:

    mgmtapi.h

Abstract:

    Definitions for SNMP Management API Development.


    This PRE-RELEASE header file contains definitions that may change
    prior to the official release of Windows NT.   Microsoft makes no
    warranty of any kind as to the suitability or correctness of this
    code.


--*/

#ifndef mgmtapi_h
#define mgmtapi_h



// Necessary includes.

#include <winsock.h>


// Errors... (unique from those in snmp.h)

#define SNMP_MGMTAPI_TIMEOUT         40
#define SNMP_MGMTAPI_SELECT_FDERRORS 41
#define SNMP_MGMTAPI_TRAP_ERRORS     42
#define SNMP_MGMTAPI_TRAP_DUPINIT    43
#define SNMP_MGMTAPI_NOTRAPS         44
#define SNMP_MGMTAPI_AGAIN           45


// Types...

typedef SOCKET SockDesc;

#define RECVBUFSIZE 4096

typedef struct _SNMP_MGR_SESSION {
    SockDesc        fd;                   // socket
    struct sockaddr destAddr;             // destination agent address
    LPSTR           community;            // community name
    INT             timeout;              // comm time-out (milliseconds)
    INT             retries;              // comm retry count
    AsnInteger      requestId;            // RFC1157 requestId
    char            recvBuf[RECVBUFSIZE]; // receive buffer
} SNMP_MGR_SESSION, *LPSNMP_MGR_SESSION;


// Prototypes...

LPSNMP_MGR_SESSION _stdcall SnmpMgrOpen(
    IN LPSTR lpAgentAddress,    // Name/address of target SNMP agent
    IN LPSTR lpAgentCommunity,  // Community for target SNMP agent
    IN INT   nTimeOut,          // Communication time-out in milliseconds
    IN INT   nRetries);         // Communication time-out/retry count

BOOL _stdcall SnmpMgrClose(
    IN LPSNMP_MGR_SESSION session);   // SNMP session pointer

SNMPAPI _stdcall SnmpMgrRequest(
    IN     LPSNMP_MGR_SESSION session,           // SNMP session pointer
    IN     BYTE               requestType,       // Get, GetNext, or Set
    IN OUT RFC1157VarBindList *variableBindings, // Varible bindings
    OUT    AsnInteger         *errorStatus,      // Result error status
    OUT    AsnInteger         *errorIndex);      // Result error index


BOOL _stdcall SnmpMgrStrToOid(
    IN  LPSTR               string,   // OID string to be converted
    OUT AsnObjectIdentifier *oid);    // OID internal representation

BOOL _stdcall SnmpMgrOidToStr(
    IN  AsnObjectIdentifier *oid,     // OID internal rep to be converted
    OUT LPSTR               *string); // OID string representation


BOOL _stdcall SnmpMgrTrapListen(
    OUT HANDLE *phTrapAvailable); // Event handle indicating trap(s) available

BOOL _stdcall SnmpMgrGetTrap(
    OUT AsnObjectIdentifier *enterprise,       // Generating enterprise
    OUT AsnInteger          *genericTrap,      // Generic trap type
    OUT AsnInteger          *specificTrap,     // Enterprise specific type
    OUT AsnTimeticks        *timeStamp,        // Time stamp
    OUT RFC1157VarBindList  *variableBindings);// Variable bindings


#endif /* mgmtapi_h */
