/*
**  xstrcmp() - compares strings using DOS wildcards
**              'mask' may contain '*' and '?'
**               returns 1 if 's' matches 'mask', otherwise 0
**               public domain by Steffen Offermann 1991
*/


int xstrcmp (char *mask, char *s)
{
      while (*mask)
      {
            switch (*mask)
            {
            case '?':
                  if (!*s)
                        return 0;
                  s++;
                  mask++;
                  break;

            case '*':
                  while (*mask == '*')
                        mask++;
                  if (!*mask)
                        return 1;
                  if (*mask == '?')
                        break;
                  while (*s != *mask)
                  {
                        if (!*s)
                              return 0;
                        s++;
                  }
                  s++;
                  mask++;
                  break;

            default:
                  if (*s != *mask)
                        return 0;
                  s++;
                  mask++;
            }
      }

      if (!*s && *mask)
            return 0;
      if (*s)
            return 0;
      return 1;
}

#ifdef TEST

#include <stdio.h>

main(int argc, char *argv[])
{
      if (3 != argc)
      {
            puts("Usage: XSTRCMP mask string");
            return -1;
      }
      printf("xstrcmp(\"%s\", \"%s\") returned %d\n", argv[1], argv[2],
            xstrcmp(argv[1], argv[2]));
      return 0;
}

#endif /* TEST */
