#define INCL_WINHOOKS
#define INCL_DOSMODULEMGR
#define INCL_WINWINDOWMGR
#define INCL_WINPOINTERS
#define INCL_WINSWITCHLIST

#include <os2.h>
#include <string.h>
#include "senddll.h"
#include "sendyes.h"

#define CLS_NAME "SendYesObj"
#define CLS_ID   1024
#define DLL_FILE  "senddll"

/***** G L O B A L S *********************************************************/

BOOL gfPutInSwitchList = TRUE;	       /* put line in switch list */

/***** P R O T O T Y P E S ***************************************************/

MRESULT EXPENTRY ObjWndProc (HWND, ULONG, MPARAM, MPARAM);

/***** M A I N ***************************************************************/

int main ( int argc, char *argv[] )
{
  HAB     hab;
  HMQ     hmq;
  QMSG    qmsq;
  HWND    hwndFrame, hwndClient;
  ULONG   ulFlags = FCF_TASKLIST;

  /* should we add an entry to the switch list? */
  gfPutInSwitchList = (argc == 1) ? FALSE : TRUE;

  hab = WinInitialize (0);
  if ( hab != NULLHANDLE )
    hmq = WinCreateMsgQueue (hab, 0);
  else
    return 1;

  /* register the object class */
  WinRegisterClass (hab, CLS_NAME, ObjWndProc, 0, 0);

  /* create the object window */
/*  WinCreateWindow (HWND_OBJECT, CLS_NAME, "", 0, 0, 0, 0, 0, 0,
		   HWND_BOTTOM, CLS_ID, 0, 0); */

  hwndFrame = WinCreateStdWindow (HWND_DESKTOP, 0L, &ulFlags, 
				  CLS_NAME, "SendYes!", 0L, NULLHANDLE, 0, 
				  &hwndClient);

  if ( hwndFrame != NULLHANDLE )
    {
      /* enter dispatch loop */
      while ( WinGetMsg (hab, &qmsq, (HWND)NULL, 0, 0) )
	WinDispatchMsg (hab, &qmsq);
    }

  WinDestroyMsgQueue (hmq);
  WinTerminate (hab);
  return 0;
}

/***** O B J W N D P R O C ***************************************************/

MRESULT EXPENTRY
ObjWndProc (HWND hwnd, ULONG ulMsg, MPARAM mp1, MPARAM mp2)
{
  static HMODULE hModule = 0;
  static HAB     hab;
  static PFN     pProcSendMsg;

  switch ( ulMsg )
    {
    case WM_CREATE:		       /* window being created */
      {
	
	/* get hab */
	hab = WinQueryAnchorBlock (hwnd);
	
	/* get handle to DLL file containing hook */
	if ( DosQueryModuleHandle (DLL_FILE, &hModule) != 0 )
	  {
	    CHAR   achLoadError[100];

	    /* load the DLL module */
	    if ( DosLoadModule (achLoadError, sizeof (achLoadError),
			   DLL_FILE, &hModule) != 0 )
	      /* something is wrong */
	      return MRFROMSHORT (TRUE);
	  }
	
	/* start the SendMsg hook */
	DosQueryProcAddr (hModule, 0, "SendMsgHook", &pProcSendMsg);
	WinSetHook (hab, NULLHANDLE, HK_SENDMSG, pProcSendMsg, hModule);

	/* remove switch list if user doesn't want it */
	if ( gfPutInSwitchList == FALSE )
	  {
	    HWND hwndFrame = WinQueryWindow (hwnd, QW_PARENT);
	    WinRemoveSwitchEntry (WinQuerySwitchHandle (hwndFrame, 0));
	  }
	else	   
	  {
	    /* at least remove entry from jump list */
	    HSWITCH hswitch;
	    SWCNTRL swcntrl;
	    HWND    hwndFrame;
	    
	    /* get current switch entry */
	    hwndFrame = WinQueryWindow (hwnd, QW_PARENT);
	    hswitch = WinQuerySwitchHandle (hwndFrame, (PID)0);
	    WinQuerySwitchEntry (hswitch, &swcntrl);

	    /* change it so it's not jumpable and put it back */
	    swcntrl.fbJump = SWL_NOTJUMPABLE;
	    WinChangeSwitchEntry (hswitch, &swcntrl);
	  }
      }
      break;

    case WM_DESTROY:		       /* window being destroyed */
      /* retract the hook */
      WinReleaseHook (hab, NULLHANDLE, HK_SENDMSG, pProcSendMsg, (HMODULE)0);

      /* free the DLL module */
      DosFreeModule (hModule);

      break;

    default:
      return WinDefWindowProc (hwnd, ulMsg, mp1, mp2);
    }
  return MRFROMSHORT (FALSE);
}

