/*
** Copyright (C) by Intratek Computing, 1994-1995. All rights reserved.
*/

/*
** SMLTools
*/

/*
** Contains function(s) that are useful when dealing with SML.
**
** put_sml_error()
** sar()
*/

#include <stdio.h>
#include "sml.h"
#include "smltools.h"

/*
** _put_sml_error()             Print SML error to stderr
**
** Input:
**      - file = file error occurred
**      - line = line error occurred
**
** Output:
**      - none
**
** Notes:
**      - Don't call directly, use put_sml_error()
*/

void _put_sml_error(char *file, int line)
{
        static char *error_msg[] =
        {
                "SML was successful",
                "SML was passed a bad argument",
                "SML couldn't allocate memory",
                "SML was given a bad position to operate on",
                "SML could not find the substring",
                "SML was not initialized"
        };

        fprintf(stderr, "FILE: %s LINE: %d ERROR: %s\n", file, line,
                error_msg[sml_rerr()]);
}

/*
** sar()                        Search-and-replace
**
** Input:
**      - string = string to be searched
**      - srch = substring to search for (to be replaced)
**      - rep = substring to replace srch with
**      - cs = is sar() case-sensitive or case-insensitive
**
** Output:
**      - pointer to passed string
**              - NULL if fail condition
**
** Notes:
**      - make sure total memory controlled by string is large enough
**        for rep insert
*/

/*
** Why isn't this part of the SML library, but part of SMLTools?
**
** Because,  a search-and-replace mechanism has  many variations; also I felt
** that  it was not an actual primitive operation, as the SML library is, but
** an end product.
*/

char * sar(char *string, char *srch, char *rep, SML_CASE cs)
{
        int  found;      /* element srch is found at */

        /*
        ** Notice how *easy* this is...
        **
        ** - if substring found
        **      - delete it
        **      - insert rep in it's place
        **      - return string
        ** - else
        **      - return NULL
        */

        if ( (found = sml_esearch(string, srch, cs)) >= 0 )
        {
                /*
                ** Why use sml_ssdel() when the lightning fast sml_ndel() can
                ** be used since we know exactly where srch is?
                */

                sml_ndel(string, found + 1, strlen(srch));

                /*
                ** sml_insert() cannot be used to concat a string, remember?
                */

                if ( string[found] == '\0' )
                        strcat(string, rep);
                else
                        sml_insert(string, rep, found + 1);

                return (string);
        }

        return (NULL);
}
