/* --------------------------------------------------------------------------
** This dummy program is just developed as an example source code for the
** Source Mapper (SM). The program is divided into more functions than
** actually makes sense. That's just to have functions enough to show you
** what SM can do.
**
** Compiler options:
** OS2 = Compile for OS/2.
** DOS = Compile for grand old DOS.
** GUI = Compile GUI version (supported for both DOS and OS2 version).
** ------------------------------------------------------------------------ */



#if defined (DOS) && defined (OS2)
#  error "Only one of these macros must be defined!"
#endif

#if !defined (DOS) && !defined (OS2)
#  error "You must define one and only one of these macros!"
#endif

#ifdef __BORLANDC__
#  include <conio.h>
#else
#  error "This program is to be compiled by Borland C++"
#endif

#ifdef OS2
#  define INCL_DOSDATETIME
#  define INCL_DOSPROCESS
#  ifdef GUI
#     define INCL_WIN
#     define INCL_GPI
#  endif
#  include <os2.h>
#endif

#ifdef DOS
#  include <dos.h>
#  ifdef GUI
#     ifndef __LARGE__
#        error "Graphics library needs large memory model!"
#     endif
#     include <graphics.h>
#  endif
#endif

#ifdef GUI
#  define MAXHSPEED 8
#  define MAXVSPEED 8
#  define DELAY     20
#  ifdef OS2
#     define BLACK  CLR_BLACK
#     define WHITE  CLR_WHITE
#  else
#     define BLACK  0x0
#     define WHITE  0xF
#  endif
#else
#  define MAXHSPEED 2
#  define MAXVSPEED 1
#  define DELAY     50
#  define BLACK     0x0
#  define WHITE     0xF
#endif

#define MAXBALLS  50
#define MAXCOLOR  16

#define NEWSPEED(max) (random (max) + 1)
#define NEWCOLOR(c) { (c) = random (MAXCOLOR); (c) = ((c) == BLACK) ? WHITE : (c); }

#include <mem.h>
#include <time.h>
#include <stdlib.h>

typedef struct
{
   int iColor;            /* Color of the ball */
   int iXPos;             /* Horizontal position of the ball */
   int iYPos;             /* Vertical position of the ball */
   int iHSpeed;           /* Horizontal speed of the ball */
   int iVSpeed;           /* Vertical speed of the ball */
}
   BALL;

typedef struct
{
   int iNr;               /* Number of balls */
   BALL Ball[MAXBALLS];   /* CB of every possible ball */
}
   BALLS;

extern void GetScrSize ( int *, int * );
extern void RunBalls ( BALLS * );
extern void MoveHorizontally ( BALL * );
extern void MoveVertically ( BALL * );
extern void RunBall ( BALL * );
extern void PaintBall ( BALL *, int );
extern void Pause ( int );
extern void ClrScr ( void );
extern void RestoreScreen ( void );
extern void Initialize ( int, char *[], BALLS * );
extern void Run ( BALLS * );
extern void Terminate ( void );
extern void InitScreen ( void );

extern int iScreenW;              /* Width of screen */
extern int iScreenH;              /* Height of screen */
extern BALLS Balls;

#if defined (OS2) && defined (GUI)
MRESULT EXPENTRY ClientWndProc ( HWND, ULONG, MPARAM, MPARAM );
extern HAB hAB;
extern HMQ hMQ;
extern HPS hPS;
extern HDC hDC;
extern QMSG QMsg;
extern HWND hWndFrame;
extern HWND hWndClient;
extern ULONG ulFrameFlags;
#define TID_MOVE (TID_USERMAX - 1)
#endif
