
Program Sample6;

  { Sample program to list a file directory, including long descriptions }

Uses Filedef,Dir,Sublist,General,Message;

var dirname: string;
    longdescrip: msgptr;
    filerec: dirtype;
    i: integer;
    ok: boolean;


  Procedure ProcessFile (n: longint);    { recursive processing routine }
  Begin
    ReadDir(filerec,n);
    if filerec.leaf.left<>0 then begin
      ProcessFile(filerec.leaf.left);   { Do the left branch }
      ReadDir(filerec,n);               { Get the original record back }
    end;

    with filerec do begin  { here is where we display each filename }
      writeln(name,' : ',descrip);   { name and short description }

      if EdfTxt<>0 then begin            { File has an extended description }
        GetDescription(EdfTxt,LongDescrip);
        if (LongDescrip<>Nil) then begin      { See Note (1) Below }
          for i:=1 to LongDescrip^.MsgLen do
            writeln(' ',LongDescrip^.MsgLin[i]^);
          DisposeMsg(Longdescrip);
        end;
      end else begin               { Check for old style description }
        for i:=1 to 2 do           { See Note (2) Below }
          if Edescrip[i]<>'' then writeln(Edescrip[i]);
      end;
      writeln;
    end;

    if filerec.leaf.right<>0
      then ProcessFile(filerec.leaf.right);    { Do the right branch }
  end;




Begin

  { Open CONFIG and NODES files }
  if OpenFiles([CONFIGF,NODESF]) then begin

    { Initialize list of filedirs }
    ok:=SubLIstInit(Filedirs,'');

    { get name of directory to process }
    writeln;
    writeln('Enter name of directory to list:');
    readln(dirname);
    writeln;

    Upstr(dirname);         { convert to all uppercase }
    StripSpaces(dirname);   { remove leading & trailing spaces }

    if OpenDir(dirname,MainDir) then begin
      ProcessFile(DirFileRoot);   { Start processing from root }
      CloseDir(MainDir);
    end else begin
      writeln('Error: could not open directory ',dirname);
    end;

    CloseAllFiles;
  end
  else writeln('Could not open CONFIG File!');

end.


{ Notes:
  (1) After calling GetDescription, check to see if result is Nil; if
      so, do not process description. The result might be Nil in the
      case where the EdfTxt pointer is garbage, or points to text that
      is no longer available (some records may contain garbage as a
      result of having been added by software which did not clear the
      unused space in the record to zeros before adding the record).
      Be sure to fill "Unused" areas of all Searchlight data structures
      with binary zeros before saving them, so that future programs that
      use the areas will know when there is valid data present.

  (2) Notice that we look at the Edescrip fields only if we did not find
      a pointer in EdfTxt. This assumes that any program which stores an
      extended description via the new functions will not store anything
      here; this should be considered standard practice. In other words,
      a file will have either an old 2 line description or a new extended
      description, but not both. If you wish to expand the description of
      an existing file, you should copy any text out of the Edescrip fields
      into a MsgPtr variable and save it as an extended description. Note
      that we might also check the Edescrip fields if the result of
      GetDescription was Nil (assuming that the EdfTxt pointer contained
      random garbage and the record probably was not intentionally saved
      with an extended description).
}