--************************************************************************
--
--  SERVER.ADA               Version 0.02
--
--  December 1993 revision.  Multiple drivers.
--                           Better Interface.
--                           48 users.
--  January  1994 revision.  Command line parameters
--
--  A copyright-reserved, free use program.
--  (c)John H. McCoy, 1994, Sam Houston St. Univ., TX 77341-2206
--************************************************************************
--
-- compile -fs -g -K                  don't need -fs if you don't optimize
-- bamp with -M 25000 -s 40500 -G for 48 sessions
--

with Types;        use Types;
with NetBios;      use NetBios;
with Drivers;      use Drivers;
with ServerTasks;  use ServerTasks;
with CDRoms;       use CDRoms;
with system;
with text_io;      use text_io;
with text_handler; use text_handler;
with arg;
with tty,box,cursor,video,common_display_types;

procedure Server is

NCB            : NetBiosCmdBlks;

ServerName     : string16 := ("SHSU-CD-SERVER  ");

MaxDrivers     : constant := 3;
DriverName     : string8  := ("CD00    ");
DriverHandle   : integer;
DriverStrategy : system.address;
DriverInterrupt: system.address;
DriverUnits    : integer;

MaxSessions    : constant := 48;
PerDriver      : constant := 7;
MaxCds         : constant := MaxDrivers * PerDriver;
LastCD         : integer := -1;
TimeOut        : integer;          -- session time out is not implemented yet.

NET            : NetAccess := new Nets;
HUB            : SchedulerAccess := new Schedulers;

SessionTable   : array (1..MaxSessions ) of SessionsAccess;

xch            : common_display_types.byte;
ch             : character;
CMD_Parm_Error : exception;

function to_caps (C: character) return character is
begin
  if (C >= 'a' and C<= 'z') then
    return character'val(character'pos(C) -32);
  else
    return c;
  end if;
end to_caps;
procedure get_parms is
  parm: text(60);
begin
  for i in 2..arg.count loop      -- first arg is program name
    set(parm, arg.data(i));       -- convert string argument to text object.

    if not empty(parm) then
      if value(parm)(1) = '-' or value(parm)(1) = '/' then
        if length(parm) >= 4 then
          case value(parm)(2) is
            when 's'|'S' =>
              if length(parm) > 19 then
                put_line("Server name to long.  Max is 16 characters.");
                raise CMD_Parm_Error;
              else
                ServerName := (others=> ' ');
                ServerName(1..length(parm)-3) := value(parm)(4..length(parm));
                for i in 1..16 loop
                  ServerName(i) := to_caps(ServerName(i));
                end loop;
              end if;
                -- session time out is not implemented yet.
--            when 't'|'T' =>
--              TimeOut := integer'value(value(parm)(4..length(parm)));
            when others =>
              put_line("Unknown parameter """ & value(parm) & "");
          end case;
        else
          put_line("Invalid parameter """ & value(parm) & "");
        end if;
      else
        put_line("Parameter """ & value(parm) & """ doesn't start with - or /.");
      end if;
    end if;

  end loop;

end get_parms;


begin

tty.clear_screen;
box.draw(0,0,9,79,box.double_sided);
tty.put(2,28,"SHSU CDROM SERVER 0.02");
tty.put(3,20,"A copyright-reserved, free use program.");
tty.put(4,28,"(c)John H. McCoy, 1994");
tty.put(5,22,"Sam Houston St. Univ., TX 77341-2206");
tty.put(7,17,"Latest version is available from FTP.SHSU.EDU");

tty.put(12,10,"Locating CDs.  ");

new_line;
get_parms;

CDs.SetUp(MaxCds);

for i in 1..MaxDrivers loop
    DriverName(5) := character'val(character'pos('0')+i);
    CDs.InitDriver(DriverName => DriverName,
                   Units      => DriverUnits);
    LastCd := LastCD + DriverUnits;
end loop;

if LastCD < 0 then
  raise DEV_Error;
end if;

tty.put(14,10,"Validating server name on network.  ");

NET.Start(ServerName);

Console.Init(MaxSessions => MaxSessions,
             LastCd      => LastCd,
             ServerName  => ServerName);

delay(1.0);            -- so initial screen display will complete

for i in 1..MaxSessions loop
    SessionTable(i) := new Sessions;
    SessionTable(i).Start(Net,ServerName,types.byte(integer'succ(LastCD)),HUB);
end loop;

tty.put(24,0,"Enter S to stop the server. ");

loop
  cursor.move(24,27);
  if tty.char_ready then
    tty.get(xch,ch);
    if ch = 'S' or ch = 's' then
      tty.put(24,0,"Are you sure you want to stop? (Y/N)");
      for i in 1..20 loop
        if tty.char_ready then
          tty.get(xch,ch);
          exit;
        end if;
        delay(0.5);
      end loop;
      exit when (ch = 'y' or ch = 'Y');
    end if;
    video.scroll_up(0,24,0,24,79);
    tty.put(24,0,"Enter S to stop the server. ");
  end if;
  delay(0.5);
end loop;

HUB.Hold;
Console.Shutdown;

video.clear_screen;
cursor.move(2,0);

NET.Shutdown;
put_line("Waiting for NetBios to reset.");
loop
  exit when Net'terminated;
end loop;

HUB.Shutdown;
put_line("Waiting for Scheduler to terminate.");
loop
  exit when HUB'terminated;
end loop;


CDs.Shutdown;
put_line("Waiting for CDs to terminate.");
loop
  exit when CDs'terminated;
end loop;

put_line("End of Main.");

exception
  when CMD_Parm_Error         => Put_line("Command line parm error.");
  when DEV_Error              => Put_line("No CD Roms found.");
  when NBX_NetBiosNotLoaded   => Put_line("Net BIOS not loaded.");
  when NBX_NameAlreadyclaimed => Put_line("Name already in use.");
  when NBX_GeneralError       => Put("Error attempting to start ");
                                 Put_line(ServerName);

end Server;