--************************************************************************
--
--  CDROMS.ADS
--
--  A copyright-reserved, free use program.
--  (c)John H. McCoy, 1994, Sam Houston St. Univ., TX 77341-2206
--************************************************************************

with Types; use Types;
with NetBios; use NetBios;
with Drivers; use Drivers;
with system;

package CDRoms is

-- The server joins the CDs sequentially with the first as drive 0.
-- All calls to CDRoms use these drive number.  CDRoms does a table
-- lookup to find the correct driver and subunit on that driver.

task type CDRoms is
  entry SetUp(MaxDrives: integer);
  entry InitDriver(DriverName: string8; Units: out integer);
  entry Call(rh: in out rhs);
  entry Lock(Drive: integer);
  entry UnLock(Drive     : integer);
  entry GetStatus(Drive       : integer;
                  DeviceStatus: out DEV_ReturnCodes;
                  CDStatus    : out DW;
                  DriverName  : out string8;
                  DriverUnit  : out byte;
                  Label       : out string11);
  entry ShutDown;
end CDRoms;

type CDAccess is access CDRoms;
CDs : CDRoms;

end CDRoms;