
PROC MessageContinue.u(msg.a,          ; Message to display
                       att.n,          ; Color for Message (not DialogBox!)
                       beep.l)         ; Wait for Keypress Beeper?
Private  proc.a,                       ; Name of current procedure
         pb.a                          ; Pushbutton variable
   proc.a = "MessageContinue.u"
   SetCanvas DEFAULT                   ; Set default canvas
   IF NOT beep.l THEN                  ; Just Beep three times
      Beep Sleep 50 Beep Sleep 50 Beep
   ENDIF                               
   IF Len(msg.a) < 23 THEN
      msg.a = Format("w23,ac",msg.a)
   ENDIF
   SHOWDIALOG "<Enter> to Continue"
               PROC "MessageBeeper.u" IDLE   ; Wait for Key Beeper proc
               @ 7,Int((74-Len(msg.a))/2)
               HEIGHT 7 WIDTH Len(msg.a)+6
               STYLE ATTRIBUTE att.n
               @ 1,1 ?? " " +msg.a+ " "
               PUSHBUTTON @ 3,Int(Len(msg.a)/2)-5
                          WIDTH 12 "~C~ontinue" OK DEFAULT
                          VALUE "OK" TAG "OK" To pb.a
   ENDDIALOG
   Cursor OFF Return
ENDPROC


PROC MessageConfirm.l(msg.a,           ; Message to display (< 70 chars)
                      att.n,           ; Color for message (not DialogBox!)
                      beep.l,          ; Wait for Keypress Beeper?
                      pbok.a,          ; Label of CONTINUE Pushbutton
                      pbcxl.a,         ; Label of CANCEL Pushbutton
                      confirm.l)       ; Should Confirm be default?
Private  proc.a,                       ; Name of current procedure
         width.n,                      ; Width of Dialog Box
         pb.a                          ; Value of selected Pushbutton
   proc.a = "MessageConfirm.l"
   SetCanvas DEFAULT
   IF NOT beep.l THEN                  ; Just beep three times
      Beep Sleep 50 Beep Sleep 50 Beep
   ENDIF                               ; Calculate width of Dialog Box
   IF Len(msg.a) < 22 THEN             ; Minimum width for Title
      msg.a = Format("w22,ac",msg.a)
   ENDIF
   width.n = Max(Len(msg.a)+ 6,Len(pbok.a) + Len(pbcxl.a) + 18)
   IF confirm.l THEN                   ; Confirm button is DEFAULT
      SHOWDIALOG "<Enter> to Confirm"
                  PROC "MessageBeeper.u" IDLE
                  @ 7,Int((78-width.n)/2)
                  HEIGHT 7 WIDTH width.n
                  Style ATTRIBUTE att.n
                  @ 1, 1 ?? Format("w"+StrVal(width.n-4)+",ac",msg.a)
                  PUSHBUTTON  @ 3,5
                              WIDTH Len(pbok.a) + 2 pbok.a OK DEFAULT
                              VALUE "OK" TAG "OK" TO pb.a
                  PUSHBUTTON  @ 3,width.n-Len(pbcxl.a)-9
                              WIDTH Len(pbcxl.a) + 2 pbcxl.a CANCEL
                              VALUE "Cancel" TAG "Cancel" To pb.a
      ENDDIALOG
   ELSE                                ; Cancel button is DEFAULT

      SHOWDIALOG "Press <Enter> to Cancel"
                  PROC "MessageBeeper.u" IDLE
                  @ 7,Int((78-width.n)/2)
                  HEIGHT 7 WIDTH width.n
                  Style ATTRIBUTE att.n
                  @ 1, 1 ?? Format("w"+StrVal(width.n-4)+",ac",msg.a)
                  PUSHBUTTON  @ 3,5
                              WIDTH Len(pbcxl.a) + 2 pbcxl.a CANCEL DEFAULT
                              VALUE "Cancel" TAG "Cancel" To pb.a
                  PUSHBUTTON  @ 3,width.n-Len(pbok.a)-9
                              WIDTH Len(pbok.a) + 2 pbok.a OK
                              VALUE "OK" TAG "OK" TO pb.a
      ENDDIALOG
   ENDIF
   Return retval = confirm.l           ; TRUE always means "Confirmed"
ENDPROC


PROC MessageBeeper.u(type.a,           ; EVENT or TRIGGER
                     tag.a,            ; Control element tag or null
                     event.v,          ; DynArray of GetEvent, or control value
                     element.a)        ; Checkbox label or null
Private  proc.a                        ; Name of current procedure
;Global  beep.l                        ; To Beep or not to Beep
   proc.a = "MessageBeeper.u"	     
   IF beep.l THEN
      Sound 770 150
      Sound 440 150
   ENDIF
   Return
ENDPROC

messagecontinue.u("One-Button Dialog Box",3,True)
messageconfirm.l("Two-Button Dialog Box",3,True,"Continue ","Cancel ",True)
