; Screen swapping subroutine by Karl A. Weller [CIS 74620,2112]
;
; For use with Microsoft C
;
; Calling Convention:	void swap_scr(void);
;
; This function should be called when two images have been loaded
; into screen memory the left eye view at (0xb0000000) and the
; right eye view at (0xa0000000)
;
; It will then switch between the two until a key is pressed.

.MODEL LARGE, C
.CODE

	PUBLIC	swap_scr

swap_scr proc	far
         push	bp
         mov	bp,sp
begin:
rt1:	mov	dx,03dah	; Wait for non-vertical Retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	je	rt1

rt1a:	mov	dx,03dah	; Wait for a vertical Retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	jne	rt1a

rt1b: 	mov	dx,03dah	; Wait for non-vertical Retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	je	rt1b

	mov	dx,03d4h	; Scroll to display 320x200 image at
	mov	ax,0000dh	; 0xb0000000
	out	dx,ax
	mov	ax,0400ch
	out	dx,ax
	
	mov	dx,03bch	; Set glasses to left eye see through
	mov	al,255
	out	dx,al

rt2:	mov	dx,03dah	; Wait for non-vertical retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	je	rt2

rt2a:	mov	dx,03dah	; Wait for vertical retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	jne	rt2a

rt2b:	mov	dx,03dah	; Wait for non-vertical retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	je	rt2b

	mov	dx,03d4h	; Scroll to display 320x200 image at
	mov	ax,000ch	; 0xa0000000
	out	dx,ax
	mov	ax,000dh
	out	dx,ax
	
	mov	dx,03bch	; Set glasses to right eye see through
	mov	al,0
	out	dx,al

	mov	ah,0bh		; Check for key pressed
	int	21h
	cmp	al,0
	je	begin

done:	mov	sp,bp
	pop	bp
	retf
swap_scr endp

	PUBLIC	swap_scr_ega

swap_scr_ega proc	far
         push	bp
         mov	bp,sp
begin:
rt1:	mov	dx,03dah	; Wait for non-vertical Retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	je	rt1

rt1a:	mov	dx,03dah	; Wait for a vertical Retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	jne	rt1a

rt1b: 	mov	dx,03dah	; Wait for non-vertical Retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	je	rt1b

	mov	dx,03d4h	; Scroll to display 320x200 image at
	mov	ax,0600dh	; 0xa0000000 + 28000
	out	dx,ax
	mov	ax,06d0ch
	out	dx,ax
	
	mov	dx,03bch	; Set glasses to left eye see through
	mov	al,255
	out	dx,al

rt2:	mov	dx,03dah	; Wait for non-vertical retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	je	rt2

rt2a:	mov	dx,03dah	; Wait for vertical retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	jne	rt2a

rt2b:	mov	dx,03dah	; Wait for non-vertical retrace to pass
	in	al,dx
	and	al,8
	cmp	al,8
	je	rt2b

	mov	dx,03d4h	; Scroll to display 320x200 image at
	mov	ax,000ch	; 0xa0000000
	out	dx,ax
	mov	ax,000dh
	out	dx,ax
	
	mov	dx,03bch	; Set glasses to right eye see through
	mov	al,0
	out	dx,al

	mov	ah,0bh		; Check for key pressed
	int	21h
	cmp	al,0
	je	begin

done:	mov	sp,bp
	pop	bp
	retf
swap_scr_ega endp
	end
