/***************************************************************************
 PROGRAM:	SHOW3D.C
 AUTHOR:	Karl A. Weller [CIS 74620,2112]
 Date:		01/20/92
 
 This program reads in two mapped .TGA's displays them and toggles the 
 SEGA 3D glasses to produce a 3D perspective.

 Calls: swapscr.asm
 
 08/92 Added EGA Support (color may need some help)
 ***************************************************************************/

#include "stdio.h"
#include "stdlib.h"
#include "dos.h"
#include "graph.h"

extern void swap_scr(void);

void main(void )
{
    FILE *fp;
    unsigned int i,j;
    char *buffer, *buffer2;
    char vgapal[256*3];

    buffer = malloc(64000); /* Allocate buffers */
    buffer2 = malloc(64000);
    
    printf("SHOW3D.EXE 01/20/92\nBy Karl A. Weller [CIS 74620,2112]\nExample 3D Viewer For use with Sega 3D Glasses\n");
    printf("Reading Picture RS.TGA\n");
#ifndef EGA
    fp = fopen("RS.tga","rb"); /* Open Right Picture */
    fread(buffer,1,18,fp);     /* Read in tga header */
    for(i=0;i<256;++i) fread((char *)&vgapal[i*3],1,3,fp); /* Read in palette*/
#else
    fp = fopen("RSega.tga","rb"); /* Open Right Picture */
    fread(buffer,1,66,fp);     /* Read in tga header */
#endif
    fread(buffer,64000,1,fp); /* Read in picture */
    fclose(fp);

    printf("Reading Picture LS.TGA\n");
#ifndef EGA
    fp = fopen("ls.tga","rb"); /* Open Right Picture */
    fread(buffer2,1,18,fp);    /* Read in header */
    fread(buffer2,256,3,fp);   /* Read in palette (throw away) */
#else
    fp = fopen("lsega.tga","rb"); /* Open Right Picture */
    fread(buffer2,1,66,fp);     /* Read in tga header */
#endif
    fread(buffer2,64000,1,fp); /* Read in picture */
    fclose(fp);

#ifndef EGA
    _setvideomode(_MRES256COLOR); /* Set mode to 320x200x256 */
    outp(0x3ce,6);                /* Chain video memory together */
    outp(0x3cf,0x01);

    for(i=0;i<256;++i) set_vga_dac(i,vgapal[(i*3)+2]/4,vgapal[(i*3)+1]/4,vgapal[(i*3)]/4);
    memcpy((char far *)0xa0000000,buffer2,64000); /* Display Left */
    memcpy((char far *)0xb0000000,buffer,64000);  /* Display Right */
    swap_scr(); /* Call assembly sub-routine to alternate view */
#else
    _setvideomode(16); /* Set mode to 320x200x256 */
    outpw(0x3ce,0x0205);   /* Set write mode 2 */
    for(i=0;i<200;++i) {
        for(j=0;j<320;++j) {
            draw_egapt(j+160,i+75,buffer[(i*320)+j]);
        }
    }
    outpw(0x3d4,0x600d);   /* Show second screen */
    outpw(0x3d4,0x6d0c);   /* Show second screen */

    for(i=0;i<200;++i) {
        for(j=0;j<320;++j) {
            draw_egapt(j+160,i+75+350,buffer2[(i*320)+j]);
        }
    }
    swap_scr_ega(); /* Call assembly sub-routine to alternate view */
#endif


    _setvideomode(_DEFAULTMODE); /* Restore Video */

    free(buffer);                /* Free Buffers */
    free(buffer2);
}

set_vga_dac(dac,red,green,blue) /* Set palette color */
int dac,red,green,blue;
{
    union REGS r;

    r.h.ah = 0x10;
    r.h.al = 0x10;
    r.h.bh = 0;
    r.h.bl = dac;
    r.h.cl = blue;
    r.h.ch = green;
    r.h.dh = red;
    int86(0x10, &r, &r);
}

draw_egapt(x,y,color1)
int x,y;
char color1;
{
    unsigned int pos,b1;
    long temp;
    char t[2];
    char far *ptr;
    int a1;
    
    a1 = ((0x80 >> (x%8)) << 8) + 0x08;  /* calculate bit mask */
    outpw(0x3ce,a1);                     /* set it */

    b1 = y*80 + (x/8);                   /* calculate memory location */
    ptr = (char far *)0xa0000000+b1;
    memcpy(t,ptr,1);                     /* latch it */
    memset(ptr,color1,1);                /* plug it */
}
