/**/
v='$VER: Xlist Rexx Site Queue Lister  Williamson 55.04'
if ~show("L", "xferq.library") then
  if ~addlib("xferq.library", 0, -30, 0) then do
    say "Couldn't access xferq.library !"
    exit 20
  end
if ~show("L", "rexxdossupport.library") then
  if ~addlib("rexxdossupport.library", 0, -30, 2) then do
    say "Couldn't access rexxdossupport.library !"
    exit 20
  end

lf='0a'x
showall=1
if arg()~=0 then do
  parse upper arg site_pattern
  showall=0
end
sitelist=XfqGetSiteList()
call XfqWalkSession(sitelist,sites)
buf=lf||copies(" ",45)||'9B'x||'1mXLIST v'right(v,5)||'9B'x||'0m'||lf
do loop = 1 to sites.numentries
  addrtags.XQ_Mandatory=511;addrtags.XQ_Optional=511
  System=XfqPutAddress(sites.loop,addrtags)
  if ~showall & ~MatchPattern(site_pattern,upper(System),'N') then iterate
  call XfqWalkQueue(sites.loop,stem)
  buf=buf||lf||copies(" ",45)||'9B'x||'1m'||System||'9B'x||'0m'||lf
  do i=1 to stem.numentries
    bits=""
    if stem.i.FLAGS=0 then f='L'
    else do
      bin=bitXOR(d2x(stem.i.FLAGS),'00110000'B);f=""
      do z=7 to 0 by -1
        if bittst(bin,z) then bits=bits||'1'
        else bits=bits||'0'
      end
      if bittst(bin,4) then f=f||'K'
      if bittst(bin,3) then f=f||'A'
      else if bittst(bin,2) then f=f||'I'
      if bittst(bin,1) then f=f||'T'
      else if bittst(bin,0) then f=f||'D'
      else f=f||'L'
  end
  buf=buf||left_justify(stem.i.NAME,44)" "left_justify(stem.i.ASNAME,14)" "right_justify(stem.i.PRI,3)" "f" "bits||lf
  end
end
call XfqDropObject(sitelist)
call XfqClose()

call writech(STDOUT,buf)
exit

/* align text to right of field  adding spaces or trucating on left to fit   */
right_justify:
  if length(arg(1)) > arg(2) then return (right(arg(1),arg(2)))
  else return (copies(" ",arg(2)-length(arg(1))) || arg(1))

/* align text to left of field  adding spaces or trucating on right to fit   */
left_justify:
  if length(arg(1)) > arg(2) then return (left(arg(1),arg(2)))
  else return (arg(1) || copies(" ",arg(2)-length(arg(1))))
