/**/
v="$VER: ShowAC Rexx Display an RFS Account   Williamson 54.02"
numeric digits 14
say digits()
    call open('rcfg',"ram:RFS.cfg",'r')
    x=seek('rcfg',-512,'E')
    do while ~eof('rcfg')
        z=readln('rcfg')
        if upper(left(word(z,1),3))="MAX" then interpret z
    end
    call close('rcfg')

    parse arg username
    if index(upper(username),"LOG:RFSACCT/h/")>0 then do
        parse var username apath '/' u '.0' .
        AcctFile = username
    end;else if index(username,"/") ~= 0 then do
        u=translate(UserName,'...',"#:/")
        AcctFile="LOG:RFSacct/h/"u
    end;else do
        u=translate(UserName,'_'," ")
        AcctFile="LOG:RFSacct/h/"u||".0.0.0.0"
    end
    
    if ~exists(AcctFile) then do
        Say 'No account: 'AcctFile
    end;else do
        wspec = 'CON:0/10/420/100/ROOF RFS Account 'u'/WAIT/CLOSE'
        call close('STDOUT') ; call open('STDOUT',wspec,'w')
        call close 'STDIN';call open 'STDIN','*','R'
        call open('Acct',AcctFile,'R')
        FirstDate = readln('Acct')
        LastDate  = readln('Acct')
        NumReqs   = readln('Acct')
        ReqFiles  = readln('Acct')
        ReqBytes  = readln('Acct')
        LastBytes = readln('Acct')
        UserCalls = readln('Acct')
        call close('Acct')

        if Date() = LastDate then do
            availbytes      =(MaxHDaily-LastBytes) "*"
            availsessions   =(MaxCalls-UserCalls) "*"
        end;else do
            availbytes1=MaxBytes
            availbytes2=MaxHBytes
            availsessions=MaxCalls
        end

        Say ' First Call             :'Firstdate
        Say ' Last Call              :'LastDate
        Say ' Number of Requests     :'NumReqs
        Say ' Files Transfered       :'ReqFiles
        Say ' Total Bytes Sent       :'ReqBytes
        Say ' Bytes Sent Last Call   :'LastBytes
        Say ' Number of Sessions     :'Usercalls
        Say ' Bytes available        :'availbytes1  availbytes2
        Say ' Remaining Sessions     :'availsessions
    end
exit
