/**/
v="$VER: RFSNewGuide  Rexx NewFiles Guide Creator Williamson 54.10"
ck=1 /* add REQCK gadget */
debug=0
system="Amiga ECS"              /* Your system name and address here */
site="FIDONET#1:167/104.0"
default="  Sorry, there is no description for this area"||cr||cr
/*          ^^ spaces required! */
/*  You must create these files */
bbslist="CFG:Browse.CFG"        /* filearea config  */
htext="CFG:ABOUT.txt"  /* System header */
areatext='area.text'            /* area description */
/* output files - edit names to suit */
todayslist="RAM:today.lst"                    /* Files received today */  
newfileslist="MAIL:FILELISTS/NEWFILES.GUIDE"    /* Last 7 days */  
/* WB2 List Lformat parameters  */
EXCLUDE='~(area.text|files.bbs|LZTEMP.#?|.info)'    /* LIST exclusion parameters    */
LFMT_LIST='"%-20N%7L %-9D %C"'  /* all files list   */
FLLEN=77                        /* list line length  */
MARGINALL=39                    /* margin for LFMT_LIST  - wraptofile prepends a space  */
/* used internally */
fileslist="T:ALST-"Pragma('ID')      /* temporary all file */
tmpbbs="T:MLST-"Pragma('ID')         /* temporary area list */
script="RFSNewGuide";ver="v"||right(v,5);fmvers=script ver
cr='0a'x;lf='0a'x
CSI='9b'x;AOFF=CSI||'0m';BOLD=CSI||'1m';ULINE=CSI||'4m';ITALICS=CSI||'3;40m'
parse var site d '#' z ':' n '/' f '.' p
reqfile='OUTBOUND:'z'.'n'.'f'.'p'.REQ'
reqtmp='OUTBOUND:'z'.'n'.'f'.'p'.REQCK'

if ~show("L", "rexxsupport.library") then
    if ~addlib("rexxsupport.library", 0, -30, 0) then do
            say "Couldn't access support.library !"
            exit 20
    end

options results
options failat 20
signal on halt
signal on ioerr
signal on break_c
signal on break_d

call close('STDOUT')
if debug then call open('STDOUT',"CON:0/10/640/100/"script ver"/WAIT/CLOSE",'w')
else call open('STDOUT',"CON:0/10/640/100/"script ver"/CLOSE",'w')
call close('STDIN');call open('STDIN','*','R')
call Pragma("P",-1)

/* Start Area Processing */
if ~open('dlst',bbslist, 'R') then do
    call writeln(STDOUT, "Couldn't open fileareas list" bbslist)
    signal cleanup
end
if show('p',"ROOFLOG") then address 'ROOFLOG' 'logline' left(time(),5) script': Updating FILE Listing'
call writeln(STDOUT, lf||ITALICS||" "fmvers||lf||" by Robert Williamson 1:167/104.0@fidonet"||AOFF)
/* Start Area Processing */
call writeln(STDOUT, 'Reading file area configuration')
area=1
do while ~eof('dlst')
    call writech(STDOUT,'.')
    blstln=readln('dlst')
    if blstln="" then iterate
    parse var blstln Number.area '"' Path.area '"' '"' Name.area '"'
    if upper(strip(dequote(Path.area)))="NULL:" then iterate
    area=area+1
end /*eof*/
call close('dlst')

areas=area-1
call writeln(STDOUT,"")
call writeln(STDOUT,'Found 'areas' file areas')

parse arg days
if ~datatype(days,"N") | (days<=0 | days>16) then do
    call writeln(STDOUT,"Days "days" must be > 0 and < 16")
    exit 0
end
sincedate=space(date('n',date('i')-days),1,'-')
sincedate=left(overlay(substr(sincedate,10,2),sincedate,8,2),9)
call writeln(STDOUT,' Searching ALL areas for new files received in the last 'days' days since 'sincedate)
tmp=""
if days=1 then nlist=todayslist
else nlist=newfileslist

/* open new file listing, put title, date and system header */
call writeln(STDOUT,ULINE||"Generating "days" days New Files Listing for "system||AOFF||cr)
if debug then call writeln(STDOUT,'Adding date/version header to 'fileslist)

gbuf=""
gbuf=gbuf'@DataBase 'system' AmigaGuide NewFiles Listing'cr
gbuf=gbuf'@Node Main "About 'system' and AmigaGuide NewFiles Listing"'cr||cr
gbuf=gbuf" "fmvers" by Robert Williamson 1:167/104.0@fidonet"cr
gbuf=gbuf' GuideListing for Newfiles received on' system 'in the last 'days' days'cr
gbuf=gbuf' Since 'sincedate' Generated:' delstr(space(date(), 1, "-"), 8, 2) time()||cr||cr
gbuf=gbuf' @{"About 'system' and this Guide" link ABOUT}'cr
gbuf=gbuf' @{"File Requests" link REQS}'cr
gbuf=gbuf' @{"NewFiles" link NEW}'cr'@EndNode'cr||cr

gbuf=gbuf'@Node REQS "File Requests"'cr||cr
gbuf=gbuf'Clicking on a filename gadget will cause that file name to be written or'cr
gbuf=gbuf'appended to a REQ file. The REQ file will be placed in the Assigned OUTBOUND:,'cr
gbuf=gbuf'with the filename 'reqfile||cr
gbuf=gbuf'The * gadget is for those systems which can manage Freq tracking. A click on'cr
gbuf=gbuf'the * will cause a REQCK file to be created. The format is simply'cr
gbuf=gbuf'          filename description'cr
gbuf=gbuf'The REQCK file should NEVER be sent as a REQ file.'cr
gbuf=gbuf'If the Assign OUTBOUND: does not exist, you will get a'cr
gbuf=gbuf'          "Please Insert Volume: requester.'cr||cr
gbuf=gbuf'If you are a Terminal user and are calling a system running a Porticus Shelter'cr
gbuf=gbuf'Front-End, you may wish to rename the REQ file to Your_Name.GRAB. This will'cr
gbuf=gbuf'permit you to automate your GRAB requests.'cr||cr
gbuf=gbuf'@EndNode'cr

gbuf=gbuf'@Node ABOUT "About 'system' and this Guide"'cr||cr
call open('tbl', fileslist, 'W')
call writech('tbl',gbuf||cr);drop gbuf
call close('tbl')
if ~exists('htext') then do
    if debug then call writeln(STDOUT,'Adding headerfile' htext 'to 'fileslist)
    com='Type >> "'fileslist'" "'htext'"'
    address COMMAND com
end
call open('tbl', fileslist, 'A')
call writech('tbl','@EndNode'cr)

call writech('tbl','@Node NEW "NewFiles"'||cr||cr)
call close('tbl')

do area=1 to areas
    areadir=addslash(dequote(Path.area))
    if debug then call writeln(STDOUT,'Updating area' Name.area)
    if listandsort(areadir,tmpbbs,LFMT_LIST) then call addheaders(prepend)
    if ~open('ifn',tmpbbs,'R') then do
        call writeln(STDOUT,'wraptofile:Cannot open 'tmpbbs)
        signal cleanup
    end
    if ~open('ofn',fileslist,'A') then do
        call writeln(STDOUT,'wraptofile:Cannot append Area List to 'fileslist)
        signal cleanup
    end
    do while ~eof('ifn')
        line=readln('ifn')
        if left(line,1) ~= " " then call writech('ofn',' 'wrap_line(line,FLLEN,MARGINALL)) 
        else call writech('ofn',line||cr)
    end /*eof */
    call close('ifn')
    call close('ofn')
end
call open('tbl', fileslist, 'A');call writech('tbl','@EndNode'cr);call close('tbl')
address COMMAND 'COPY 'fileslist' TO 'nlist
if days>1 then call setcomment(nlist,"Last "days" days, since:"sincedate" MAGIC:NEWG")
call writeln(STDOUT,' Updated Last 'days' days NewFiles Guide listing'||NL)
cleanup:
call delete(fileslist)
call delete(tmpbbs)
exit 0
   
setcomment:
address command 'filenote' arg(1) '"'arg(2)'"'
return

listandsort:
/* list <tdir> with <lfmt> and sort to <tfile> */
tdir=arg(1);tfile=arg(2);lfmt=arg(3)
las='List DATES >'tfile tdir||exclude 'SINCE' sincedate 'FILES NOHEAD LFORMAT' lfmt
address command las
if word(statef(tfile),2)>0 then return 1
else return 0

/* prepend area.text to files.bbs                               */
/*    addareatext(areadir,files.bbs,area.text,output)           */
/*    addareatext(areadir,files.bbs,area.text,output,where)     */
/* where= append or prepend(DEFAULT)                            */
/*  example:                                                    */
/*    call addareatext(Path.area,availlist,areatext,availlist)  */
addareatext:
descfile=addslash(dequote(arg(1)))||arg(3)
inlist=arg(2);tolist=arg(4);where=arg(5)
if ~exists(inlist) then do
    call writeln(STDOUT,'addareatext: cannot find 'inlist)
    return 20
end

if ~exists(descfile) then do
    call writeln(STDOUT,'addareatext: cannot find 'descfile' using 'default)
    if where='append' then do
        call open('ds',descfile,'A')
        call writech('ds',default)
    end;else do
        call open('ds',descfile,'W')
        call writech('ds',default)
    end
    call close('ds')  
end
if where='append' then call join(inlist,descfile,tolist)
    else call join(descfile,inlist,tolist)
return 0

wrap_line:
text=arg(1)
right_edge=arg(2)  /* line length */
left_edge=arg(3)+2  /*   margin    */
new_text=''
do while length(text) > 0
    broken_word=0
    if length(text) < right_edge then do
        new_text=new_text || text || '0a'x
        text=''
    end;else do
        temp_text=strip(text,l)
        diff=length(text) - length(temp_text)
        first_break=lastpos(' ',temp_text,right_edge - diff)
        break_point=first_break + diff
        if left_edge=break_point then do
            break_point=right_edge - 1
            broken_word=1
        end
        new_text=new_text || strip(left(text,break_point),t)
        if broken_word then do
            new_text=new_text || '-'
        end
        new_text=new_text || '0a'x
        text=copies(' ',left_edge) || strip(right(text,length(text) - break_point),l)
    end
end
parse var new_text fn therest
if ck then return '@{"*" System "Echo >>'reqtmp fn subword(therest,3)'"} @{"'fn'" System "Echo >>'reqfile fn'"} 'therest
else return '@{"'fn'" System "Echo >>'reqfile fn'"}' therest

/*
    join -- a 'front end' for join. Fixes a problem with join.
    uses a tempfile if target filename is same as one to cat
*/
join:
x=arg(1)' 'arg(2)' 'arg(3)
temp='arexxtempfile'
do i=1 to (words(x)-1)
    if word(x,i)=word(x,words(x)) then do
        oops=word(x,words(x))
        x=delword(x,words(x))||'TO '||temp
        address COMMAND 'Join' x
        address COMMAND 'Copy 'temp' 'oops
        call delete(temp)
        return 0
    end
end
x=arg(1)' 'arg(2)' TO 'arg(3)
address COMMAND 'Join' x
return 0

addslash:
curr=arg(1)
select
    when right(curr, 1)=":" then nop
        when right(curr, 1)="/" then nop
            otherwise curr=curr"/"
end
return curr

/* a useful procedure by Walt Sullivan  */
dequote:
parse arg thing
parse var thing '"' unq_thing '"'
if unq_thing ~= "" then return unq_thing
return thing

halt:
ioerr:
break_c:
break_d:
call writech(stdout,cr)
call cleanup()
exit 10


addheaders:
    call writeln(STDOUT,'Appending 'areadir Number.area Name.area' to 'fileslist)
    tbuf=CR||CR||center("AREA: "Number.Area,79)||CR||center(Name.Area,79)||CR

    if debug then call writeln(STDOUT,'Adding Area Banner to 'fileslist)
    if ~open('tbl', fileslist, 'A') then do
        call writeln(STDOUT,'Cannot append Area Header to 'fileslist)
        signal cleanup
    end
    call writech('tbl',tbuf)
    close('tbl');drop tbuf
    if exists(areadir||areatext) then do
        if debug then call writeln(STDOUT,'Adding Area description to 'fileslist)
        com='Type >> "'fileslist'" "'areadir||areatext'"'
        address COMMAND com
    end
return
