/**/
v="$VER: RFSfreqList  Rexx WPL Freq List Creator Williamson 54.04"
/*
    Be sure to change the List command exclusion parameters (EXCLUDE)  
    for those files you want ignored in listings

    Config File Format:
    AREA# "PATH/" "NAME"
*/
call Pragma("P",-1)
sort=1
/* LIST exclusion parameters    */
EXCLUDE     =   '~(empty|area.text|files.bbs|LZTEMP.#?|.info)'
/* WB2 List Lformat parameters  */
LFFREQ      =   '"%N %F%N"'                       /* freq.lst         */

/*  You must create this file   */
bbslist     = "CFG:BROWSE.CFG"                   /* filearea config  */

/* output files - edit names to suit */
freqlist    = "MAIL:freq.lst"                  /* filename, full path */


/* Configuration of Magic File Names for FREQ List              */
/* A MAGIC NAME MAY POINT TO MORE THAN ONE FILE                 */

/* Standard MAGIC FileNames That Never Change                   */
/* DO NOT change these entries, these are configured above      */
magic.1 = "FILES    > Mail:FILELISTS/01670104.LHA"
magic.2 = "NEWFILES > Mail:FILELISTS/NEWFILES.LST"
magic.3 = "NEW      > Mail:FILELISTS/NEWFILES.LST"

/* add your FIXED MAGIC names here */
magic.4 = "MAGIC    > CFG:ABOUT.TXT"
magic.5 = "ABOUT    > CFG:ABOUT.TXT"
magic.6 = "ROOFREXX > bbsf6:ROOF/ROOF_REXX.LHA"
magic.7 = "ROOF     > BBSF6:ROOF/ROOF.LHA"
magic.8 = "XPACK    > BBSF6:wpl/XPACK.LHA"
magic.9 = "RFS      > BBSF6:WPL/RFS.LHA"
magic.10 = "SHELTER  ^ BBSF6:WPL/SHELTER#?.LHA"
magic.11 = "WFREQIT  > BBSF6:ROOF/WFREQIT.LHA"

/* FileNames that require updating to the latest version should */
/* use '^' instead of '>'                                       */
magic.12    = "FILEMGR      ^ BBSF6:ROOF/FILEMGR_V??.??.LHA"
magic.13    = "POP          ^ BBSF6:WPL/POP#?.LHA"
magic.14    = "JAZ          ^ BBSF6:WPL/JAZ#?.LHA"
magic.15    = "RAP          ^ BBSF6:WPL/RAP#?.LHA"
magic.16    = "SHE_UPD      ^ BBSF6:WPL/SHELTER??????.LHA"
magic.17    = "XPA_UPD      ^ BBSF6:WPL/XPACK??????.LHA"
magic.18    = "RFS_UPD      ^ BBSF6:WPL/RFS??????.LHA"
magic.19    = "BBSLIST      ^ BBSF5:MTL-BBS/BBS?????.LST"
magic.20    = "XQ_UPD       ^ BBSF6:WPL/XQUPD#?.LHA"
magic.21    = "MELODY       ^ BBSF6:WPL/POP#?.#?"
magic.22    = "MELODY       ^ BBSF6:WPL/JAZ#?.#?"
magic.23    = "MELODY       ^ BBSF6:WPL/RAP#?.#?"
magic.24    = "MELODY       > BBSF6:WPL/MELODY.DOC"
magic.25    = "XPRZ3        ^ BBSF4:commlib/XPRZ3#?.lha"
magic.26    = "WPLDEV       > BBSF6:WPL/WPL_DEV.LHA"
magic.27    = "WXIDEV       > BBSF6:WPL/WXI_DEV.LHA"
magic.28    = "FILESG       > MAIL:FILELISTS/AG167104.LHA"
magic.29    = "NEWG         > MAIL:FILELISTS/newfiles.guide"
magic.30    = "XQDEV        > BBSF6:wpl/XQ#?.LHA"
magic.31    = "FTICK        > BBSF7:foz/FTICK97.LHA"
magic.32    = "ALLFILES     > Mail:FILELISTS/01670104.LHA"
magic.33    = "ALLFILES     > Mail:FILELISTS/AG167104.LHA"
magic.34    = "ALLFILES     > MAIL:FILELISTS/newfiles.guide"
magic.35    = "ALLFILES     > MAIL:FILELISTS/newfiles.lst"
magic.36    = "FQ           > BBSF6:roof/FQ.lha"
magic.37    = "FQUERY       > BBSF6:roof/FQ.lha"
magic.38    = "MELODY       ^ BBSF6:WPL/ROCK#?.#?"

magics = 38
/* NUMBER of MAGIC NAMES */

/* used internally */
freqtemp = "T:FLST-"Pragma('ID')            /* temporary freq list */

script="RFSfreqList";ver="v"||right(v,5)
lf='0a'x;CSI='9b'x;AOFF=CSI||'0m';BOLD=CSI||'1m';ULINE=CSI||'4m';ITALICS=CSI||'3;40m'
quote='"';fmvers=BOLD||'[36;40m'script ver||AOFF
options results
options failat 20
signal on halt
signal on ioerr
signal on break_c
signal on break_d

call close('STDOUT');call open('STDOUT',"RAW:0/10/640/100/"script ver"/CLOSE",'w')
call close('STDIN');call open('STDIN','*','R')

if ~open('dlst',bbslist, 'R') then do
    call writeln(STDOUT, "Couldn't open fileareas list !")
    exit 20
end
if show('p',"ROOFLOG") then address 'ROOFLOG' 'logline' left(time(),5) script': Updating Freq Listing'
call writeln(STDOUT, lf||ITALICS||" "fmvers||lf||" by Robert Williamson 1:167/104.0@fidonet"||AOFF)
/* Start Area Processing */
call writeln(STDOUT, 'Reading file area configuration')
area = 0
do while ~eof('dlst')
    call writech(STDOUT,'.')
    blstln=readln('dlst')
    if blstln="" then iterate
    parse var blstln Number.area '"' Path.area '"' '"' Name.area '"'
    if Path.area="NULL:" then iterate
    area=area+1
end /*eof*/

areas=area-1
call writeln(STDOUT,lf||'Found 'areas' file areas')

call writeln(STDOUT, BOLD||"Generating File Request Listing"||AOFF||lf)
call open('lstf',freqtemp,'W')      /* create the file */
call close('lstf')                 /* delete old one  */
if (magics ~= 0) then do
    CR='0a'x
    if ~open('tfl',freqtemp,'A') then do
        call writeln(STDOUT, 'Unable to open 'freqtemp)
        exit 10
    end
    call writeln(STDOUT, 'Updating 'magics' Magic names')
    do i=1 to magics
        call writech(STDOUT,'.')
        /*                                                  file/magicname           !password                fullpath */
        if left(word(magic.i,2),1) = '!' then writech('tfl',strip(word(magic.i,1))' 'strip(word(magic.i,2))' 'strip(word(magic.i,3))||CR)
            else if word(magic.i,2) = '>' then writech('tfl',strip(word(magic.i,1))' 'strip(word(magic.i,3))||CR)
        if word(magic.i,2) = '^' then do
            close('tfl')
            cmd='List >>'freqtemp word(magic.i,3) LFORMAT '"'word(magic.i,1)' %P%N"'
            address COMMAND cmd
            open('tfl',freqtemp,'A')
        end
    end
    call close('tfl')
end

call writeln(STDOUT, lf||'Processing')
do area=0 to areas
    call writeln(STDOUT,Path.area)
    if Password.area = "PASSWORD."area | Password.area = "" then address COMMAND 'List >>"'freqtemp'"' Path.area||exclude 'FILES NOHEAD LFORMAT='LFFREQ
    else address COMMAND 'List >>"'freqtemp'"' Path.area||exclude 'FILES NOHEAD LFORMAT="%N !'Password.area' %F%N"'
end

if sort then do
    call writeln(STDOUT, BOLD||'Sorting 'freqtemp' to 'freqlist||AOFF)
    address COMMAND 'SORT' freqtemp freqlist
end;else do
    call writeln(STDOUT, BOLD||'Copying 'freqtemp' to 'freqlist||AOFF)
    address COMMAND 'COPY' freqtemp freqlist
end
call delete(freqtemp)      
if exists("RAM:FREQ.LST") then do
    call writeln(STDOUT, BOLD||'Copying 'freqlist' to RAM:'||AOFF)
    address COMMAND 'Copy' freqlist "RAM:FREQ.LST"
end
call writeln(STDOUT, 'Freq Listing completed')
if show('p',"ROOFLOG") then address 'ROOFLOG' 'logline' left(time(),5) script': Freq Listing completed'
exit

halt:
ioerr:
break_c:
break_d:
    call writech(STDOUT,lf)
    exit 10

