/**/
v="$VER: GenMailer Rexx  The Shelter Mailers Generator  Williamson 56.02.75"
USE_XPRASC=0        /* 1=use xprascii, 0 use redirected text reader         */
TxtRead="MoreText"  /* If USE_XPRASC is 0, then use this Redirectable       */
                    /* Text and AmigaGuide Reader for MENU, HELP and TEXT   */
SLASHPROGRESS=1     /* Convert multi-line modem progress to slash separated */
GPFAX=0             /* GPfax answer support */
H_REQ1=1            /* if 1, RH1 Hydra flag is added to EMSI Link flags     */
                    /* Presence of this flag indicates to the other side    */
                    /* that only .REQ files are transferred in first batch  */
                    /* and everything else in the second. This is only done */
                    /* if BOTH sides present the RH1 flag                   */
EMSI2=1
/* private */
wxi=1   /* wxitest.library */
FF=1
if ~show('L', "rexxsupport.library") then
    if ~addlib("rexxsupport.library", 0, -30, 0) then do
        say "Couldn't access WB1 rexxsupport.library !"
        exit 20
    end
if ~show('L',"rexxdossupport.library") then
    if ~addlib("rexxdossupport.library", 2, -30, 2) then do
        say "Couldn't access WB2 rexxdossupport.library !"
        exit 20
    end
address COMMAND 'Version'||'0a'x||'CPU check 68030'
if RC=0 then fastcpu=1;else fastcpu=0
ks=(left(ReadVar('KickStart',"R"),2))
if ks<37 then do
say 'Sorry, AmigaDOS Release 2 or higher is required to use Shelter';exit 20
end
options results
options failat 99
signal on syntax
signal on halt
signal on ioerr
signal on break_c
signal on break_d
janus=0;kermit=0
script="GenMailer"
xv=right(v,8);genver=left(xv,5);smver=strip(right(xv,5),'L','0');parse var smver hver '.' hrev .
say script" v"genver" The SHELTER v"smver" Mailers Generator by Robert Williamson"
call SetGlobal('SMVER',smver);call SetGlobal('GENVER',genver)
parse upper arg args;if args='V' then exit;if args="$" then args=GetVar('GENMAILER_ARGS',"G");if args='?' then signal usage
q=pragma("W","NULL")
CLS='0C'x;CSI='9b'x;AOFF=CSI'0m';BOLD=CSI'1m';ITALICS=CSI'3;40m'
LF="0A"x;cr="0D"x;nl="\r\n";wclr="\014"
mailer="";Opt="";cfgpath="";Optstr=""
ckversion('xferq.library',"1.9","S")
ckversion('wpl.library',"0.99.02","L")
ckversion('xprfts.library',"1.1","B")
ckversion('xprslk.library',"1.1","B")
ckversion('xprzedzap.library',"3.3","B")

/* command line switched ONLY */
NoResume=0      /* 1=Do not add Resume handling                             */
CloseDevice=0   /* 1=Close Device for serialprinter on request              */
FixDomain=0     /* 1=Fix or substitute domain, strip domain extension EMSI  */ 
                /* Uses EMSICVT.WPLRX, requires 680x0                       */
FixKnown=0      /* 1=FixDomain and return KNOWN addresses presented   EMSI  */
                /* Uses EMSICVT.WPLRX, requires 680x0                       */
KillBad=0       /* 0=send PASSWORD.BAD, 1=hangup on bad password      EMSI  */
NoAKAS=0        /* 0=Use AKAs in SiteCache, 1=Use presented AKAs      EMSI  */
LooseZMH=0      /* 0=HXT,HRQ presented during UMH                     EMSI  */
Debug=0         /* 1=Verbose Generator Output                               */
WPLdebug=0      /* 1=Verbose Mailer Output                                  */
LogResults=0    /* 1=Log Results of RexxMsg rexx/wplrx script execution     */
RP=0            /* EMSICVT and XHYDRA are compiled */
template="Mailer/A,Opt/K,NoResume/S,Debug/S,WPLdebug/S,LogResults/S,FixDomain/S,FixKnown/S,KillBad/S,NoAKAS/S,LooseZMH/S,CloseDevice/S,CfgPath/K,RP/S"
if ~ReadArgs(args,template) then do
    say;say Fault(RC,BOLD"  "script||AOFF)
    signal usage1
end;else do
    u_mailer=mailer
    roof=u_mailer=="ROOF";porticus=u_mailer=="PORTICUS"
    gazebo=u_mailer=="GAZEBO";umbrella=u_mailer=="UMBRELLA"
    if ~roof & ~porticus & ~gazebo & ~umbrella then call usage("Invalid Mailer Name:"BOLD||u_mailer||AOFF)
    l_mailer=lower(u_mailer);minitial=upper(left(u_mailer,1))
    loggroup=l_mailer'wpl'
    if umbrella then statgroup='umbrellawplstat1'
    else statgroup=l_mailer'wplstat$(line)'
    flush='RexxMsg NY LOGPROC "FlushLog 'loggroup'"'LF
    logf='RexxMsg NY LOGPROC "PutLog 'loggroup' $<time> $(line) '
    logw='RexxMsg NY LOGPROC "PutLine 'statgroup' '
    logr='RexxMsg FY ROOFLOG "'
    logrl='RexxMsg FY ROOFLOG "LOGLINE $<time> 'u_mailer'$(line): '
    logus='RexxMsg FY ROOFLOG "UPDATE_STAT '
    logcs='RexxMsg FY ROOFLOG "CALLSTATUS '
    arcmail="????????.(MO|TU|WE|TH|FR|SA|SU)[0-9]"
    showresult=logf'RC:$(RC) RESULT1:$(RESULT1) RESULT2:$(RESULT2)"'LF
    sindex='$(si.$(remote.address))'
    idxpnum='$(numbers.'sindex')'
    idxphone='$('sindex'.'idxpnum')'
    nctphone='$('sindex'.$(ncount.$(remote.address)))'
    power=(roof|porticus)
    if showlist('H','KCON') then mycon="KCON:";else mycon="CON:"
    wprogress=mycon'0/10/620/140/GenMailer v'genver' ['smver'] [Click to Close - ^C to Abort]/INACTIVE/AUTO/WAIT'
    call close('STDOUT');call open('STDOUT',wprogress,'W');call close('STDIN');call open('STDIN','*','R');call writech('STDOUT',CLS)
    werr=mycon'0/150/620/70/GenMailer Warnings [Click to Close]/INACTIVE/AUTO/WAIT'
    call close('STDERR');call open('STDERR',werr,'W')
    say " "BOLD||script||AOFF' v'genver||ITALICS||BOLD" The SHELTER Mailers Generator"AOFF" by "BOLD"Robert Williamson"AOFF
    if FixDomain & FixKnown then call errorabort('Switches FixDomain and FixKnown are mutually exclusive',20)
    BADEMSI="#?(Portal of Power|D'Bridge)#?"
    E_INQSEQ="\r\r**EMSI_INQC816~**EMSI_INQC816"
    E_NAKcr="**EMSI_NAKEEC3\r";E_HBTcr="**EMSI_HBTEAEE\r"
    E_INQcr="**EMSI_INQC816\r";E_REQcr="**EMSI_REQA77E\r"
    utc='RexxMsg SY,RY REXX "RETURN d2x((date(I)*86400)+time(S)+252460600)"'LF'Set host.trx $(RESULT2)'LF
    if EMSI2 then emsicompat=",DFB";else emsicompat=",ARC,XMA"
    emsicompat="HYD,DZA,SLK,ZAP,ZMO"emsicompat
    if NoResume then Optstr=Optstr"NoResume, ";else Optstr=Optstr"Resume Enabled, "
    if Debug then Optstr=Optstr"Debug Enabled, "
    if WPLDebug then Optstr=Optstr"WPLDebug Enabled, "
    if CloseDevice then Optstr=Optstr"Close Device Enabled, "
    stab=lf||copies(" ",10)">"
    Optstr=Optstr"EMSI Enabled"LF
    Optstr=Optstr">"BOLD"EMSI Options: "AOFF
    if FixKnown then Optstr=Optstr||stab"Correct FidoNet and all Known Domains"stab"Use only Known AKAs presented "
    else do
        Optstr=Optstr||stab"Correct FidoNet Domain"stab"Use ALL AKAs presented"
        if FixDomain then Optstr=Optstr||stab"Correct FidoNet and All Known Domains ";else Optstr=Optstr||stab"Correct Fidonet Domain"stab"Bad Other Domains not corrected"
    end
    if NoAKAS then Optstr=Optstr||stab"Send to Presented AKAs";else Optstr=Optstr||stab"Send to Known AKAS in SiteCache"
    if KillBad then Optstr=Optstr||stab"Hangup on Bad Password";else Optstr=Optstr||stab"Send BadPassword Text"
    if LooseZMH then Optstr=Optstr||stab"ArcMail and Freqs accepted during ZMH";else Optstr=Optstr||stab"Strict ZMH policy, ARCmail and Freqs NOT accepted"
    drop stab
    if (FixDomain | FixKnown) then do
        WplrxDomainFix=1
        if ~fastcpu then call warning("Options FixDomain and FixKnown may cause EMSI failures on slow CPUs")
    end;else WplrxDomainFix=0
    proczmh='RexxMsg SY "return((time(m)<(left(word(\"$(umh)\",1),2)*60+right(word(\"$(umh)\",1),2)))|(time(m)>(left(word(\"$(umh)\",2),2)*60+right(word(\"$(umh)\",2),2))))"'LF'Set RC $(result1)'LF
    domodules=0;doall=0;cfgonly=0
    if Opt="" | Opt="ALL" then do
        doall=1;domodules=1;Opt="All"
        say " "BOLD"Modules: "AOFF||Opt
        say " "BOLD"Options: "AOFF||translate(Optstr,"",">")
    end;else do
        say " "BOLD"Modules: "AOFF||Opt
        say " "BOLD"Options: "AOFF||translate(Optstr,"",">")
        Select    
        when Opt="KERNAL" then domodules=0
        when Opt="CONFIG" then do
            domodules=0;cfgonly=1
        end
        when Opt="CACHE" then do
            call initgen;signal gencache
        end
        when Opt="MODEM" then do
            addfax=ReadVar('FAX')=="TRUE"
            call initgen;signal genmodems
        end
        otherwise call usage('Invalid Option:'BOLD||Opt||AOFF)
        end
    end
end
call initgen
if doall & domodules then call gencache

if ~open('cfg',gencfg,"R") then CALL errorabort('Cannot open 'gencfg,10)

call SetGlobal('SHELTER',u_mailer)
/*indices*/
ic=0;id=0;iw=0;in=0;is=0;ip=0;it=0;im=0;ib=1;ix=1
noanswer=0;nobbs=0;nodoor=0;noinfo=0;nomagic=0
bbsname.1="";doorname.1="";info.0="";magicname.0=""
inflst="";bbslst="";cmdlst="";adllst="";wrxlst="";extlst=""
domainlst="";myakas="";myFQFA=""
SCANOPT="FALSE"
if power then do
menusbuf=';WPLSCRIPT 'strip(menuslabel,'T','!')||LF
xuBUF=';WPLSCRIPT 'strip(userlabel,'T','!')||LF
end
cBUF=';WPLSCRIPT 'l_mailer'cfg'LF';Options:'translate(strip(OptStr),';','>')||LF
cBUF=cBUF';GPFAX ANSWER:'GPFAX||LF';Build Slashed Progress:'SLASHPROGRESS||LF
cBUF=cBUF';Use XPRascii:'USE_XPRASC||LF';Text/AmigaGuide Reader:'TxtRead||LF
cBUF=cBUF'setstatics:'LF
abUF="";pBUF="";utBUF='setutils:'LF
dlBUF="";xprBUF="";ansBUF="";asBUF="";faxBUF="";uuBUF="";notBUF="";emsiBUF=""
wzBUF="";mainBUF="";uBUF="";varBUF="";loopBUF=""
sc_modem=0;sc_init=0;sc_dial=0;sc_answer=0;sc_connect=0;sc_user=0
addshell=0;adduucp=0;addfax=0;addhost=0;addclock=0;addbbs=0;addfreq=0;addspeech=0
genmenufile=0;freqsetup=0;showxpr=0;sendbanner=0;sendbull=0;primary=0;forcesort=0
usexflo=0
setDbuf="";setAbuf='setakas:'LF;setHbuf='sethostadr:'LF
if ~WplrxDomainFix then do
ckdBUF='j_ck_emsidomain:'LF'Pattern $(remote.address) FIDONET?(1:|2:|3:|4:|5:|6:)#?'LF'TrueReturn'LF
setEbuf=""
end
akas=0
say "Parsing "gencfg
do while ~eof('cfg')
    call writech('STDOUT',".")
    cfgline=strip(translate(ReadLn('cfg')," ",'09'x))
    if (cfgline="" | left(cfgline,2)="/*" | left(cfgline,2)="*/") then iterate
    cfgline=expand(cfgline);key=upper(word(cfgline,1))

    if key="ROOFLOG" & upper(dequote(strip(subword(cfgline,2))))="TRUE" then ROOFLOG=1
    if key="NOANSWER" & upper(dequote(strip(subword(cfgline,2))))="TRUE" then do
        if ~umbrella then call errorabort('Invalid Option: 'key' for 'u_mailer,10)
        noanswer=1
    end
    if umbrella & key="USEXFLO" & upper(dequote(strip(subword(cfgline,2))))="TRUE" then do
        if ~noanswer then call errorabort('Invalid Option: 'key' for 'u_mailer', NOASNWER must be TRUE',10)
        usexflo=1
    end
    if ~umbrella & key="SYSOPPW" then do;addshell=1;sysoppw=upper(dequote(strip(subword(cfgline,2))));end
    if key="SYSOP" then do
        sysop=dequote(strip(subword(cfgline,2)))
        call SetVars("SYSOP",sysop)
        utBUF=utBUF'Set host.sysop "'sysop'"'LF
    end
    if key="CITY" | key="PHONE" then do;utBUF=utBUF'Set host.'lower(key)' "'strip(dequote(subword(cfgline,2)))'"'LF;end
    if key="FLAGS" then do
        eflags=strip(dequote(subword(cfgline,2)))
        if length(eflags)>19 then do
            call warning("FLAGS ["eflags"] may be too long and cause")
            call warning("TRX# TZ field to be truncated during EMSI sessions")
        end
        utBUF=utBUF'Set emsi.'lower(key)' "'eflags'"'LF
    end
    if key="PPREF" then do
        ppref=subword(cfgline,2);pprefs=translate(ppref," ",",")
    end
    if key="AKA" then do
        aka.akas=space(subword(cfgline,2),1)
        if power & index(upper(word(cfgline,2)),'UUCP') > 0 then do
            setAbuf=setAbuf'Set host.uucp' word(aka.akas,1)||LF
            setDbuf=setDbuf'uucphost:'LF'Set host.domain "UUCP" host.address' word(aka.akas,1)||LF'Return'LF
            setHbuf=setHbuf'Cmp $(remote.network) UUCP'LF'TrueJump uucphost'LF
        end
        else akas=akas+1
        if akas=1 then default_address=upper(strip(word(cfgline,2)))
    end
    if key="DIR" then do
        parse var cfgline junk dirvar.id dirname.id .
        if right(dirname.id,1)=":" then CALL errorabort('DIR 'dirname.id' cannot be a VOLUME, must be a path',10)
        if right(dirname.id,1)="/" then CALL errorabort('DIR path 'dirname.id' cannot have a trailing slash',10)
        id=id+1
    end
    if pos(key,"WSPEC,SSPEC,WPOS,SPOS,BOSS") > 0 then call SetVars(key,upper(dequote(strip(subword(cfgline,2)))))
    if left(key,3)="AUX" then call SetVars(key,dequote(strip(subword(cfgline,2))))

    if key="ESC-ESC" & ~umbrella then escmode=upper(dequote(strip(subword(cfgline,2))))
    if key="BANNER" & ~umbrella then do
        sendbanner=1;bannerfile=upper(dequote(strip(subword(cfgline,2))))
        if bannerfile="BANNERFILE" | bannerfile="" then do
            call warning('No BANNER defined')
            bannerfile=0
        end;else if ~exists(bannerfile) then call errorabort('Banner 'bannerfile' not found')
    end
    if key="BULL" & ~umbrella then do
        sendbull=1;bullfile=upper(dequote(strip(subword(cfgline,2))))
        if bullfile="BULLFILE" | bullfile="" then do
            bullfile=0;call warning('No BULL defined')
        end;else if ~exists(bullfile) then call errorabort('Bulletin 'bullfile' not found')
    end
    if power & key="MENUS" then do
        menuvol="CFG:";menuext=".MENU"
        select
            when upper(word(cfgline,2))="GEN" then genmenufile=0
            when upper(word(cfgline,2))="MAKE" then do
                genmenufile=1;if word(cfgline,3)="RAM" then menuvol="RAM:"
            end
            otherwise genmenufile=0
        end
    end
    if key="SCROLL" then do
        scl=dequote(strip(word(cfgline,2)))
        Select
            when scl=5 then do;sc_modem=1;sc_init=1;sc_dial=1;sc_answer=1;sc_connect=1;sc_user=1;end
            when scl=4 then do;sc_modem=1;sc_dial=1;sc_answer=1;sc_connect=1;sc_user=1;end
            when scl=3 then do;sc_dial=1;sc_answer=1;sc_connect=1;sc_user=1;end
            when scl=2 then do;sc_connect=1;sc_user=1;end
            when scl=1 then sc_user=1
            when scl=0 then nop
            otherwise do;call warning('Invalid scroll level:'scl' ,using 0');end
        end
    end
    if key="POLLWIN" | key="XPRWIN" | key="SPEECH" ,
     | key="ACCESS" | key="ALLOWFREQS" | key="FTSFREQS" ,
     | key="DOMAINAWARE" | key="PRIMARYONLY" | key="IGNORENOANSWER" ,
     | key="WFHOST" | key="UUCP" | key="FAX" | key="CLOCK" | key="ONLINE" then do
        bolvar=upper(dequote(strip(subword(cfgline,2))))
        if bolvar="TRUE" | bolvar="FALSE" then call SetVars(key,bolvar)
        else CALL errorabort(key" value "bolvar" must be TRUE or FALSE",10)
        if ~umbrella & bolvar="TRUE" then do
            if key="SPEECH" then addspeech=1
            else if key="CLOCK" then addclock=1
            else if key="ONLINE" then addbbs=1
            else if key="UUCP" then adduucp=1
            else if key="FAX" then addfax=1
            else if key="WFHOST" then addhost=1
            else if key="ALLOWFREQS" then addfreq=1
        end
        if key="XPRWIN" & bolvar="TRUE" then showxpr=1
        if (key="PRIMARYONLY" & bolvar="TRUE") then primary=1
        if (key="DOMAINAWARE" & bolvar="FALSE") then forcesort=1
    end
    if key="LOWBYTES" then do;LowBytes=strip(word(cfgline,2));LowBlocks=LowBytes%512;end
    if key="CALLWINDOWMIN" | key="REDIALDELAY" | key="ALTDIALDELAY" | key="BUSYDELAY" then do 
        numvar=strip(word(cfgline,2))
        if datatype(numvar,"NUMERIC") then do
            if key="ALTDIALDELAY" then do
                utBUF=utBUF'Set altdialdelay 'numvar||LF
            end
            call SetVars(key,numvar)
        end
        else call errorabort(key" value "numvar" must be numeric",10)
    end
    if key="TZ" then do
        tz=strip(word(cfgline,2))
        tzx=strip(GetVar('TZ',"G"))
        if tzx="" then call SetVars('TZ',tz,'R')
        else if compare(tz,tzx)>0 then call warning("TZ is already set to:"tzx", use SetEnv command to change TZ to "tz)
    end
    if key="UMH" &  ~umbrella then do
        umh=dequote(strip(subword(cfgline,2)))
        call SetVars("UMH",umh)
        utBUF=utBUF'Set umh "'umh'"'LF
    end
    if key="PSCREEN" then do
        pscreen=dequote(strip(subword(cfgline,2)))
        call SetVars("SCREEN",pscreen)
        utBUF=utBUF'Set pscreen "'pscreen'"'LF
    end
    if key="LOGFILE" then do
        logfile=dequote(strip(subword(cfgline,2)))
        call SetVars("LOGFILE",logfile)
        utBUF=utBUF'Set logfile "'logfile'"'LF
    end
    if key="LOGWINDOW" then do
        logwindow=dequote(strip(subword(cfgline,2)))
        if logwindow ~= "" & logwindow ~= "LOGWINDOW" then do
            call SetVars("LOGWINDOW",logwindow)
            utBUF=utBUF'Set logwindow "'logwindow'"'LF
        end
    end
    if ~addfreq & (key="FREQCMD" | key="FREQCFG" | key="FREQLOG") then call warning('Request Server disabled, keyword 'key' ignored')
    else do
        if key="FREQCMD" then do;freqcmd=dequote(strip(subword(cfgline,2)));freqsetup=freqsetup+1;end
        if key="FREQCFG" then do;freqcfg=dequote(strip(subword(cfgline,2)));freqsetup=freqsetup+1;end
        if key="FREQLOG" then do;freqlog=dequote(strip(subword(cfgline,2)));freqsetup=freqsetup+1;end
    end
    if key="XFERQ" then do
        ADDRESS COMMAND 'ASSIGN XFERQ:' upper(strip(word(cfgline,2)))
        if RC~=0 then call errorabort('XFERQ: Assign failed',10)
        call SetVars('XFERQ',upper(strip(word(cfgline,2))))
        ADDRESS COMMAND 'ECHO >XFERQ:hostaddr 'default_address
    end
    if key="NODELIST" & ~umbrella  then do
        ADDRESS COMMAND 'ASSIGN NODELIST:' upper(strip(word(cfgline,2)))
        if RC~=0 then call errorabort('NODELIST: Assign failed',10)
        call SetVars('NODELIST',upper(strip(word(cfgline,2))))
    end
    if key="WAKEUP" | key="LOGINWAIT" | key="STACK" | key="PRIORITY" ,
        | key="LAUNCHPRI" | key="NEGOPRI" | key="XFERPRI" then do
        parse var cfgline cfgnumber.in cfgnvalue.in .;in=in+1
    end
    if key="LOOKUP" | key="UUCICO" | key="LOGIN" ,
        | key="FAXSEND" | key="FAXRECV" then do
        parse var cfgline cfgstring.is '"' cfgsvalue.is '"' .;is=is+1
    end
    if key="BAN" then do;parse var cfgline junk promptname.ip '"' prompt.ip '"' .;ip=ip+1;end

if power then do
    if (key="WRX" | key="WRM") then do
        parse var cfgline junk wrxcmd.iw '"' wrxdesc.iw '"' .
        if key="WRX" then wrxlst=wrxlst||wrxcmd.iw" "
        iw=iw+1
    end
    if key="INFO" then do;parse var cfgline junk info.it infopath.it '"' infodesc.it '"' .;it=it+1;end
    if key="MAGIC" then do;parse var cfgline junk magicname.im magicpath.im '"' magicdesc.im '"' .;im=im+1;end
    if key="DOOR" then do;parse var cfgline junk '"' doorname.ix '"' doorcmd.ix;ix=ix+1;end
    if key="SYSOPBASE" then call SetVars("SYSOPBASE",dequote(strip(subword(cfgline,2))))
end
    if key="BBS" & ~umbrella then do;parse var cfgline junk '"' bbsname.ib '"' bbscmd.ib;ib=ib+1;end
    if key="SCAN" then SCANOPT=upper(word(cfgline,2))
    if key="CMD" then do;parse var cfgline junk cmdname.ic cmdcmd.ic;ic=ic+1;end
end
call close('cfg');drop cfg cfgline key

if bbsname.1="" then nobbs=1
if doorname.1="" then nodoor=1
if info.0="" then noinfo=1
if magicname.0="" then nomagic=1

say;call writech('STDOUT','Compiling')
if power then do
    m1=" ͸"
    m2="  ۳ Shelter Mailer Command Menu ۲ "
    m3=" ;"
    if ~genmenufile then do
    wmBUF='wplmenu:'LF'Print "Sending MAIN menu\n"'LF'Send "'wclr||nl'"'LF'Send "'m1||nl'"'LF'Send "'m2||nl'"'LF'Send "'m3||nl'"'LF'Send "'nl'"'LF
    if nobbs then bmBUF="";else bmBUF='boardmenu:'LF'Print "Sending BBS menu\n"'LF'Send "'wclr||nl||copies('20'x,16)||u_mailer' BBS Menu'nl'"'LF
    if nomagic then mmBUF="";else mmBUF='magicmenu:'LF'Print "Sending MAGIC menu\n"'LF'Send "'wclr||nl||copies('20'x,16)||u_mailer' Magic Zmodem AutoDownLoad Menu'nl'"'LF
    if noinfo then tmBUF="";else tmBUF='infomenu:'LF'Print "Sending INFO menu\n"'LF'Send "'wclr||nl||copies('20'x,16)||u_mailer' Bulletin Menu'nl'"'LF
    if nodoor then dmBUF="";else dmBUF='doormenu:'LF'Print "Sending DOOR menu\n"'LF'Send "'wclr||nl||copies('20'x,16)||u_mailer' Door Menu'nl'"'LF
    end;else do
    MainMenuBuf=cr||m1||cr||m2||cr||m3||cr
    if nobbs then BBSmenuBUF="";else BBSmenuBUF=cr||copies('20'x,16)'The 'u_mailer' BBS Menu'cr
    if nomagic then MagicMenuBuf="";else MagicMenuBuf=cr||copies('20'x,16)'The 'u_mailer' Magic DownLoad Menu'cr
    if noinfo then infoMenuBuf="";else infoMenuBuf=cr||copies('20'x,16)'The 'u_mailer' Bulletin Menu'cr
    if nodoor then DoorMenuBuf="";else DoorMenuBuf= cr||copies('20'x,16)'The 'u_mailer' Door Menu'cr
    end
    drop m1 m2 m3
end

default=0
do x=0 to akas-1
    call writech('STDOUT','.')
    if index(aka.x,"UUCP") > 0 then iterate
    PARSE var aka.x domain.x '#' zone.x ':' net.x '/' node.x '.' point.x '"' sitename.x '"' wazoo.x zones.x
    point.x=strip(point.x);wazoo.x=strip(wazoo.x);zones.x=strip(zones.x)
    if ~default then do;defaultdomain=domain.x;default=1;end
    tmpadr=space(zone.x':'net.x'/'node.x'.'point.x)
    call SetVars('HOST.ADDRESS.'upper(domain.x),tmpadr)
    domainlst=domainlst" "upper(domain.x) strip(zone.x)

    if point.x=0 then tmpaka=zone.x":"net.x"/"node.x"@"strip(domain.x)
    else tmpaka=zone.x":"net.x"/"node.x"."strip(point.x)"@"strip(domain.x)
    myakas=myakas||tmpaka" "
    myFQFA=myFQFA||domain.x'#'zone.x':'net.x'/'node.x'.'point.x" "
    setAbuf=setAbuf'Set host.aka.'upper(domain.x) tmpaka||LF

    setAbuf=setAbuf'Set host.address.'upper(domain.x) tmpadr 'host.wzdomain.'upper(domain.x) domain.x"."wazoo.x||LF
    setAbuf=setAbuf'Set host.sitename.'upper(domain.x) '"'sitename.x'"'LF
    setDbuf=setDbuf||domain.x'host:'LF'Set host.domain 'upper(domain.x)||LF'Jump sethost'LF
    if ~WplrxDomainFix then setDbuf=setDbuf||domain.x'remote:'LF'Set remote.domain 'upper(domain.x)||LF'Jump setemsidomain'LF

    if domain.x ~= defaultdomain then do
        setHbuf=setHbuf'Pattern $(remote.address) ('domain.x'|#?'
        if ~WplrxDomainFix then setEbuf=setEbuf'Pattern $(remote.address) #?'
        if words(zones.x)=1 then do
            setHbuf=setHbuf||zones.x':)#?'LF
            if ~WplrxDomainFix then setEbuf=setEbuf||zones.x':#?'LF
        end;else do
            setHbuf=setHbuf"("
            if ~WplrxDomainFix then setEbuf=setEbuf"("
            do j=1 to words(zones.x)-1
                setHbuf=setHbuf||word(zones.x,j)':|'
                if ~WplrxDomainFix then setEbuf=setEbuf||word(zones.x,j)':|'
            end
            setHbuf=setHbuf||word(zones.x,j)':))#?'LF
            if ~WplrxDomainFix then setEbuf=setEbuf||word(zones.x,j)':)#?'LF
        end
        setHbuf=setHbuf'TrueJump 'domain.x'host'LF
        if ~WplrxDomainFix then setEbuf=setEbuf'TrueJump 'domain.x'remote'LF
    end
end
setHbuf=setHbuf'Jump 'defaultdomain'host'LF
if ~WplrxDomainFix then setEbuf=setEbuf'Jump unknownemsidomain'LF
setAbuf=setAbuf'Set host.akas "'strip(myakas)'"'LF
setAbuf=setAbuf'Set host.FQFA "'strip(myFQFA)'"'LF
setAbuf=space(setAbuf,1)||'Return'LF

if roof then call SetVars("DOMAIN",upper(defaultdomain))
else call SetVars("FTNDOMAIN",upper(defaultdomain))

call SetVars("DOMAINLIST",strip(upper(domainlst)))
call SetVars(minitial'CFG','TRUE')

aBUF=aBUF||setHbuf||setDbuf
drop setHbuf setDbuf

if ~WplrxDomainFix then do
  setEbuf=setEbuf'setemsidomain:'LF'Set inbound $(inbound.$(remote.domain))'LF
  setEbuf=setEbuf'SetA remote $(remote.domain)#$(remote.zone):$(remote.net)/$(remote.node).$(remote.point)'LF
  setEbuf=setEbuf||logw'$(p.remote) $(remote.address) $(p.number) $(remote.number)"'LF
  setEbuf=setEbuf'Return'LF
  setEbuf=setEbuf'unknownemsidomain:'LF'Set inbound $(nonsecure)'LF'Return'LF
  aBUF=aBUF||ckDbuf||setEbuf
end

aBUF=aBUF'sethost:'LF'Set host.wzdomain $(host.wzdomain.$(host.domain))'LF'Set inbound $(inbound.$(host.domain))'LF'Set host.sitename $(host.sitename.$(host.domain))'LF
aBUF=aBUF'SetA host $(host.domain)#$(host.address.$(host.domain))'LF
aBUF=aBUF||logw'$(p.host) $(host.address) $(p.inbound) SECURE $(p.hfreqs) $(host.freq)"'LF
aBUF=aBUF'Return'LF

aBUF=aBUF'setremote:'LF'CmpI $(remote.domain) $(host.domain)'LF'TrueReturn'LF
aBUF=aBUF'SetA remote $(host.domain)#$(remote.zone):$(remote.net)/$(remote.node).$(remote.point)'LF
aBUF=aBUF||logw'$(p.remote) $(remote.address) $(p.number) $(remote.number)"'LF
aBUF=aBUF'Return'LF

/* set dirs*/
do i=0 to id-1
    call writech('STDOUT',".")
    if upper(dirvar.i)="OUTDIR" then utBUF=utBUF'Set outbound' dirname.i'/'LF
    else if upper(dirvar.i)="INDIR" then do
        utBUF=utBUF'Set 'dirvar.i dirname.i'/'LF
        if pos("RAM:",upper(dirname.i))>0 then LowBytesCmd='RX \"RETURN ~(`AVAIL TOTAL` > 'LowBytes')\"'
        else LowBytesCmd='DFREE $(indir) 'LowBlocks
    end
    else utBUF=utBUF'Set 'dirvar.i dirname.i'/'LF
    call SetVars(upper(dirvar.i),upper(dirname.i))
end
singleinbound=GetClip('DOMAINAWARE')=="TRUE"
dl=GetClip('DOMAINLIST')
do ftn=1 to words(dl)-1 by 2
    call writech('STDOUT',".")
    if singleinbound then utBUF=utBUF'Set inbound.'strip(word(dl,ftn))' $(indir)'LF
    else utBUF=utBUF'Set inbound.'strip(word(dl,ftn))' $(indir)'strip(word(dl,ftn))'/'LF
end
/*number*/
do i=0 to in-1
    call writech('STDOUT',".")
    cBUF=cBUF'Set 'lower(cfgnumber.i) cfgnvalue.i||LF
    if upper(cfgnumber.i)="STACK" then stack=strip(cfgnvalue.i)
    if upper(cfgnumber.i)="XFERPRI" then xferpri=strip(cfgnvalue.i)
    if upper(cfgnumber.i)="NEGOPRI" then negopri=strip(cfgnvalue.i)
    if upper(cfgnumber.i)="LAUNCHPRI" then launchpri=strip(cfgnvalue.i)
end
/*string*/
do i=0 to is-1;call writech('STDOUT',".");cBUF=cBUF'Set 'lower(cfgstring.i) '"'cfgsvalue.i'"'LF;end
do i=0 to ip-1;call writech('STDOUT',".");pBUF=pBUF'Set 'strip(promptname.i) '"'prompt.i'"'LF;end

if power then do
    /*MAGIC*/
    if nomagic then call warning("No MAGIC menu")
    else do
        if ~genmenufile then wmBUF=wmBUF'Send "  'left_justify("MAGIC",14)'Magic Zmodem Downloads - no byte limits'nl'"'LF
        else MainMenuBuf=MainMenuBUF"  "left_justify("MAGIC",14)"Magic Downloads - no byte limits"cr
        do i=0 to im-1
            call writech('STDOUT',".")
            magicpath.i=strip(magicpath.i)
            if ~exists(magicpath.i) then do
                if pos('${',magicpath.i)>0 then do
                    if ~exists(ExpandEnv(magicpath.i)) then call warning("Deferred Magic File" ExpandEnv(magicpath.i)" does not presently exist, please create it")
                end;else do
                    call warning("Magic File" magicpath.i" does not exist, ignoring")
                    iterate
                end
            end
            utBUF=utBUF'Set 'magicname.i'.file' get_fn(magicpath.i) magicname.i'.full' magicpath.i magicname.i'.desc "'magicdesc.i'"'LF
            adllst=adllst||magicname.i" "
            if upper(magicdesc.i)~="HIDDEN" then do
                if ~genmenufile then mmBUF=mmBUF'Send "  'left_justify(upper(magicname.i),14)||magicdesc.i||nl'"'LF
                else MagicMenuBuf=MagicMenuBuf"  "left_justify(upper(magicname.i),14)||magicdesc.i||cr
            end
        end
        if ~genmenufile then mmBUF=mmBUF'Send "'nl'  Enter MAGIC name or hit Return to return to main menu: "'LF'Return'LF
        else MagicMenuBuf=MagicMenuBuf||cr"  Enter MAGIC name or hit Return to return to main menu: "cr
        utBUF=utBUF'Set magiclist "'strip(adllst)'"'LF
    end
    /*WRX*/
    rexxdir=addslash(GetCLip('REXXDIR'))
    do i=0 to iw-1
        call writech('STDOUT',".")
        wrxcmd.i=strip(wrxcmd.i)
        if (index(wrxlst,wrxcmd.i) > 0) & ~exists(rexxdir||wrxcmd.i".WPLRX") then call errorabort("Command" rexxdir||wrxcmd.i".WPLRX does not exist",40)
        if ~addfreq & (wrxcmd.i="GRAB" | wrxcmd.i="WFREQIT") then call errorabort("Request Handler disabled, Command" rexxdir||wrxcmd.i".WPLRX CANNOT be used",40)
        if upper(wrxdesc.i)~="HIDDEN" then do
            if ~genmenufile then wmBUF=wmBUF'Send "  'left_justify(upper(wrxcmd.i),14)||wrxdesc.i||nl'"'LF
            else MainMenuBuf=MainMenuBuf"  "left_justify(upper(wrxcmd.i),14)||wrxdesc.i||cr
        end
    end
    utBUF=utBUF'Set wrxlist "'space(wrxlst,1)'"'LF

    /*INFO*/
    if noinfo then call warning("No INFO menu")
    else do
        if ~genmenufile then wmBUF=wmBUF'Send "  'left_justify("INFO",14)'Information and Bulletins'nl'"'LF
        else MainMenuBUF=MainMenuBUF"  "left_justify("INFO",14)"Information and Bulletins"cr
        do i=0 to it-1
            call writech('STDOUT',".")
            infopath.i=strip(infopath.i)
            if ~exists(infopath.i) then do
                if pos('${',infopath.i)>0 then do
                    if ~exists(ExpandEnv(infopath.i)) then call warning("Deferred INFO" ExpandEnv(infopath.i)" does not presently exist, please create it")
                end;else do
                    call warning("INFO" infopath.i" does not exist, ignoring")
                    iterate
                end
            end
            utBUF=utBUF'Set 'info.i infopath.i||LF
            inflst=inflst||info.i" "
            if upper(infodesc.i)~="HIDDEN" then do
                if ~genmenufile then tmBUF=tmBUF'Send "  'left_justify(upper(info.i),14)||infodesc.i||nl'"'LF 
                else infoMenuBuf=infoMenuBuf"  "left_justify(upper(info.i),14)||infodesc.i||cr
            end
        end
        utBUF=utBUF'Set infolist "'strip(inflst)'"'LF
        if ~genmenufile then tmBUF=tmBUF'Send "'nl'  Enter Info name or hit Return to return to main menu: "'LF'Return'LF
        else infoMenuBuf=infoMenuBuf||cr"  Enter Info name or hit Return to return to main menu: "cr
    end

    /*BBS*/
    if nobbs then do
        call warning("No BBS menu")
        call SetVars('BBS','FALSE')
    end;else do
        if ~genmenufile then wmBUF=wmBUF'Send "  'left_justify("BOARD",14)'Select a Bulletin Board System'nl'"'LF
        else MainMenuBUF=MainMenuBUF"  "left_justify("BOARD",14)"Select a Bulletin Board System"cr
        do i=1 to ib-1
            call writech('STDOUT',".")
            utBUF=utBUF'Set bbsname.'i '"'bbsname.i'" bbs.'i '"'strip(bbscmd.i)'"'LF
            if upper(bbsname.i)~="HIDDEN" then do
                if ~genmenufile then bmBUF=bmBUF'Send "  'left_justify(i,14)||bbsname.i||nl'"'LF
                    else BBSmenuBUF=BBSmenuBUF"  "left_justify(i,14)||bbsname.i||cr
            end
            bbslst=bbslst||i" "
        end
        utBUF=utBUF'Set boardlist "'strip(bbslst)'"'LF
        if ~genmenufile then bmBUF=bmBUF'Send "'nl'  Enter number of BBS or hit Return to return to main menu: "'LF
            else BBSmenuBUF=BBSmenuBUF||cr"  Enter number of BBS or hit Return to return to main menu: "cr
        call SetVars('BBS',"TRUE")
    end

    /*DOOR*/
    if nodoor then call warning("No DOOR menu")
    else do
        if ~genmenufile then wmBUF=wmBUF'Send "  'left_justify("DOOR",14)'Select a Game or Utility Door'nl'"'LF
        else MainMenuBUF=MainMenuBUF"  "left_justify("DOOR",14)"Select a Game or Utility Door"cr
        do i=1 to ix-1
            call writech('STDOUT',".")
            utBUF=utBUF'Set doorname.'i '"'doorname.i'" door.'i '"'strip(doorcmd.i)'"'LF
            if doorname.i~="HIDDEN" then do
                if ~genmenufile then dmBUF=dmBUF'Send "  'left_justify(i,14)||doorname.i||nl'"'LF
                    else DOORmenuBUF=DOORmenuBUF"  "left_justify(i,14)||doorname.i||cr
            end
            extlst=extlst||i" "
        end
        utBUF=utBUF'Set doorlist "'strip(extlst)'"'LF
        if ~genmenufile then dmBUF=dmBUF'Send "'nl'  Enter number of DOOR or hit Return to return to main menu: "'LF
            else DOORmenuBUF=DOORmenuBUF||cr"  Enter number of DOOR or hit Return to return to main menu: "cr
    end

    /*CMD*/
    do i=0 to ic-1
        call writech('STDOUT',".")
        ecmd=strip(dequote(strip(cmdcmd.i)))
        if ecmd~="" & ecmd~="""" then do
            utBUF=utBUF'Set cmd.^'cmdname.i '"'ecmd'"'LF
            cmdlst=cmdlst||cmdname.i" "
            if index(ecmd,"$$(")>0 then call errorabort("CMD "strip(cmdcmd.i)" cannot contain deferred variables",10)
            if left(ecmd,2)~="${" then call SetVars(upper(cmdname.i),ecmd,'E')
        end
    end
    utBUF=utBUF'Set cmdlist "'strip(cmdlst)'"'LF
/* roof & porticus */
end;else do
    do i=0 to ic-1
        call writech('STDOUT',".")
        ecmd=strip(dequote(strip(cmdcmd.i)))
        if index(ecmd,"$$(")>0 then call errorabort("CMD "strip(cmdcmd.i)" cannot contain deferred variables",10)
        if (ecmd~="" & emcd~="""" & left(ecmd,2)~="${") then call SetVars(upper(cmdname.i),ecmd,'E')
    end
end
RFH=0
if addfreq then do
  select  
  when freqcmd="RFH" then do
    if exists("RPDIR:RFH") then do
      RFH=1;RFHcmd="Run >NIL: RFH"
    end;else if exists("RAM:rexx/RFH.REXX") then do
      RFH=1;RFHcmd="Run >NIL: RX RAM:rexx/RFH.REXX"
    end;else if exists("MAIL:REXX/RFH.rexx") then do
      RFH=1;RFHcmd="Run >NIL: RX MAIL:REXX/RFH.rexx"
    end
    if RFH then drop freqcmd freqcfg freqlog freqsetup
    else call errorabort('Unable to find RFH File Request handler',20)
  end
  when freqcmd="RFS" then do
    if exists("RAM:rexx/RFS.rexx) & exists("RAM:REXX/STARTRFS.rexx") then drop freqcmd freqcfg freqlog freqsetup
    else if exists("MAIL:rexx/RFS.rexx) & exists("MAIL:REXX/STARTRFS.rexx") then drop freqcmd freqcfg freqlog freqsetup
    else call errorabort('Unable to find RFS File Request handler',20)
  end
  otherwise do
    if freqsetup=3 then utBUF=utBUF'Set freqcmd "Run 'freqcmd' >>'freqlog freqcfg' $$(REMFILE) $$(INFILE) \"$$(remote.address)\" $$(Baud)"'LF
    else CALL errorabort('File Request handler setup missing parameters',20)
  end
  end/*select*/
end

if power then do
    if ~nobbs then bmBUF=bmBUF'Return'LF
    if ~nodoor then dmBUF=dmBUF'Return'LF
    wmBUF=wmBUF'Return'LF
    wmBUF=wmBUF||mmBUF||tmBUF||dmBUF
    drop mmBUF tmBUF dmBUF
end


call writech('STDOUT',".")
if showxpr then cBUF=cBUF'Set showxpr TRUE'LF
cBUF=cBUF'Set postinbound 'notifylabel'postinbound postoutbound 'notifylabel'postoutbound'LF
cBUF=cBUF'Set preinbound 'notifylabel'preinbound preoutbound 'notifylabel'preoutbound'LF
cBUF=cBUF'Set prefullname 'notifylabel'prefullname postfullname 'notifylabel'postfullname'LF
cBUF=cBUF'Set preoutfullname 'notifylabel'preoutfullname postoutfullname 'notifylabel'postoutfullname'LF
cBUF=cBUF'Set OwnDev "'notifylabel'showdevowner"'LF
cBUF=cBUF'Set xp.1 DietIFNA xp.4 ZedZip xp.8 ZedZap xp.32 Hydra wz.wzcap 45 wz.wzprot "$(xp.32) $(xp.8) $(xp.4) $(xp.1)"'LF
cBUF=cBUF'Set host.ver 'hver' host.rev 'hrev' host.version 'smver' host.mailer "'u_mailer'"'LF
cBUF=cBUF'Set host.product DA host.serial "'emsiserial'" host.baud $(linkrate) emsi.link "8N1"'LF
if umbrella then do
cBUF=cBUF'Set host.wzext "-Freq +Domain" host.freq "FALSE"'LF
end;else do
if addfreq then cBUF=cBUF'Set host.wzext "$(host.wzext.$(line))" host.freq $(host.freq.$(line))'LF
else cBUF=cBUF'Set host.wzext "-Freq +Domain" host.freq "FALSE"'LF
end
cBUF=cBUF'SubJump 'cfglabel'setakas'LF'SubJump 'cfglabel'setutils'LF
cBUF=space(cBUF,1)

if (umbrella | gazebo) then do
cBUF=cBUF'Set mname.0 "Fido" ftsflags.0 "ot" mname.5 "OPUS" mname.7 "JamMail" mname.12 "FrontDoor" "Binkley" mname.50'LF
cBUF=cBUF'Set mname.27 "Paragon" mname.42 "TIMS" mname.44 "FrontDoor" mname.50 "InterMail" mname.57 "TrapDoor" mname.58 "Welmat" ftsflags.58 "7n,by" mname.66 "Portal of Power"'LF
cBUF=cBUF'Set mname.106 "MacWoof" mname.170 "Xenolink" mname.196 "ProMailer" mname.218 "ROOF"'LF
end

if ROOFLOG then cBUF=cBUF'Set callsin 1 callsout 11 ftnin 2 ftnout 12 uucpin 3 uucpout 13 faxsin 4 faxsout 14 humanin 5 humanout 15 bbsin 6 bbsout 16 msgin 7 msgout 17 filesin 8 filesout 18 bytesin 9 bytesout 10'LF


cBUF=cBUF'Return'LF;cBUF=cBUF||setAbuf;cBUF=cBUF||utBUF;cBUF=cBUF||pBUF'Return'LF
drop setAbuf utBUF pBUF
call genvars()
cBUF=cBUF||varBUF
varBUF=""
call open('cw',cfgwpl,"W");call writech('cw',cBUF);call close('cw')
drop cw cBUF 
say;Say "Wrote "cfgwpl

if power then do
  call writech('STDOUT',"Generating User Menus: ")
  if genmenufile then do
      call writech('STDOUT',"MAIN ")
      call savemenu(menuvol"MAIN"menuext,MainMenuBuf)
      drop MainMenuBuf
      if ~nomagic then do
          call writech('STDOUT',"MAGIC ")
          call savemenu(menuvol"MAGIC"menuext,MagicMenuBuf)
      end
      drop MagicMenuBuf
      if ~noinfo then do
          call writech('STDOUT',"INFO ")
          call savemenu(menuvol"INFO"menuext,infoMenuBuf)
      end
      drop infoMenuBuf
      if ~nobbs then do
          call writech('STDOUT',"BOARD ")
          call savemenu(menuvol"BOARD"|menuext,BBSmenuBuf)
      end
      drop BBSmenuBuf
      if ~nodoor then do
          call writech('STDOUT',"DOOR ")
          call savemenu(menuvol"DOOR"|menuext,DOORmenuBuf)
      end
      drop DOORmenuBuf
      call SetVars('MENUS','FILE')
      say;say "Wrote Menu Files"
  end;else do
      menusbuf=menusbuf||bmBUF||wmBUF
      drop bmBUF wmBUF
      call writech('STDOUT',"MAIN ")
      if ~nomagic then call writech('STDOUT',"MAGIC ")
      if ~noinfo then call writech('STDOUT',"INFO ")
      if ~nobbs then call writech('STDOUT',"BOARD ")
      if ~nodoor then call writech('STDOUT',"DOOR ")
      call open('cw',menuwpl,"W");call writech('cw',menusbuf);call close('cw')
      drop cw menusbuf
      say;Say "Wrote "menuwpl
      call SetVars('MENUS','MENU')
  end
end

if cfgonly & show('P',u_mailer"1") then do
  say "ReLoading "l_mailer"cfg"
  address COMMAND 'LoadScript 'l_mailer'cfg' cfgwpl
  if RC~=0 then CALL errorabort('Cannot load 'cfgwpl,10)
  say "New Config loaded"

  if ~genmenufile then do
      say "ReLoading "menulabel
      address COMMAND 'LoadScript 'menuslabel menuwpl
      if RC~=0 then CALL errorabort('Cannot load 'menuwpl,10)
      say "New Menus loaded"
  end

  if umbrella then ports=1
  else ports=GetClip('SLAVES')
  do i=ports to 1 by -1
      if show('p',u_mailer||i) then do
          address VALUE u_mailer||i
          'Set exit CONFIG'
          say u_mailer||i 'activated new config'
      end
  end
end

if ~power then call gennotify
if doall then do
    if power & domodules then call gennotify
    if ~roof then call gencallscript
    if power then call genbootuserscript
    if ~cfgonly then signal genmodems
end
call SaveEnv()
Say 'Generation of 'u_mailer' Mailer completed'
if ~didcache then say 'Unmodified Cache was not regenerated'
exit

genitem:
ux='CmpI $(namebuf) 'upper(arg(1))||LF'FalseJump 'arg(3)||LF
if arg(1)='board' then do
  if escmode="SELECT" then ux=ux'selectbbs:'LF
  ux=ux||ckbbs('sbbs','DoMenu');drop cb
end
ux=ux'SubJump 'userlabel'get_user'LF'FalseJump DoMenu'LF
ux=ux'submenu.'arg(1)':'LF'CheckCarrier'LF'FalseJump freeline'LF'Cmp $(chatmode) SYSOP'LF'TrueJump forcechat'LF
ux=ux'Set RC $(bootuser)'LF'TrueJump hangfree'LF
if genmenufile then ux=ux'SubJump SendMenu'LF
else ux=ux'SubJump 'menuslabel||arg(1)'menu'LF
ux=ux'Set searchlist $('arg(1)'list)'LF'SubJump 'userlabel'menu_input'LF'TrueSubJump 'arg(2)||LF
ux=ux'Set RC $(inputerr)'LF'TrueJump hangfree'LF'Set RC $(main)'LF'TrueJump DoMenu'LF'Jump submenu.'arg(1)||LF
return ux

savemenu:
  if ~open('m',arg(1),"W") then call errorabort('Unable to save' arg(1),10)
  call writech('m',arg(2));call close('m')
  say 'Wrote 'arg(1)
return

genmodems:
nummodems=0;faxinitdone=0
if ~umbrella then do
    mdmcfgs=showdir(modemdir,'f')
    if words(mdmcfgs)=0 then CALL errorabort('No modem configs in 'modemdir,10)
    mBUF=""
    m1BUF=';WPLSCRIPT 'l_mailer'modem'LF
    do i=1 to words(mdmcfgs)
        call genline(modemdir||word(mdmcfgs,i))
        say
    end

    m1BUF=m1BUF'launchit:'LF'SubJump 'cfglabel'setstatics'LF'SubJump 'cfglabel'setglobals'LF'SubJump 'mdmlabel'preinit'LF
    if roof then m1BUF=m1BUF||logr'OPENSTATUS WPL $(line)"'LF
    else do
        m1BUF=m1BUF'Print "Opening Window\n"'LF'RexxMsg "" REXX "$(rexxdir)SHELTER.rexx OPENSTATUS $(line)"'LF
        if logresults then m1BUF=m1BUF||showresult
    end
    m1BUF=m1BUF||logf'Launched Slave:$(line) $(modem)"'LF

    m1BUF=m1BUF'Set openstatus "$(w_con)0/$(w_offset)/640/40/Session 'u_mailer' Line $(line) $(modem)/AUTO/INACTIVE/CLOSE/SCREEN$(pscreen)"'LF
    m1BUF=m1BUF'SetStatus NULL:'LF'Set PRIORITY $(launchpri)'LF
    m1BUF=m1BUF'Set RC ${CACHE}'LF'FalseReturn'LF
    m1BUF=m1BUF'SubJump xcache!setcache'LF
    m1BUF=m1BUF||logf'Loaded Cache"'LF'Return'LF

    m1BUF=m1BUF'preinit:'LF'Set modem "$(modem) $(baudlocked)bps"'LF
    if sc_modem then m1BUF=m1BUF'SetStatus "CON:0/10/600/60/PreInit $(modem)"'LF
    m1BUF=m1BUF'ModemOpen'LF'SetBaud $(lockedrate)'LF
    m1BUF=m1BUF'Print "$(state) Baud:$(Baud) Locked:$(baudlocked)\n"'LF'SubJump 'mdmlabel'attention'LF'TrueJump preinit1'LF
    m1BUF=m1BUF'SetBaud $(lockedrate)'LF'SubJump 'mdmlabel'init'LF'Jump preinit2'LF
    m1BUF=m1BUF'preinit1:'LF'Set state "ModemInit $(modem)"'LF'SubJump 'mdmlabel'init'LF'SetBaud $(lockedrate)'LF
    m1BUF=m1BUF'Print "$(state) Baud:$(Baud) Locked:$(baudlocked)\n"'LF'SubJump 'mdmlabel'attention'LF
    m1BUF=m1BUF'preinit2:'LF'FalseJump initerr'LF||logf'$(state)"'LF
    m1BUF=m1BUF'Print "Preinit OK  $(Baud) $(baudlocked)\n"'LF'Return'LF
    m1BUF=m1BUF'initerr:'LF||logf'Modem Dead: $(state)"'LF
    m1BUF=m1BUF||flush'Set RC FALSE'LF'SetStatus NULL:'LF'Return'LF

    m1BUF=m1BUF'attention:'LF'ModemClear'LF'SmartSend $(atten)'LF'GetResponse 30'LF
    m1BUF=m1BUF'Pattern $(event) #?$(prompt)#?'LF'TrueReturn'LF
    m1BUF=m1BUF'Print "$(atten) Response:$(event) $(LastResponse)\n"'LF'Return'LF

    m1BUF=m1BUF'hangup:'LF'ModemClear'LF'SmartSend "$(hangupstring)"'LF'GetResponse 5'LF
    m1BUF=m1BUF'Pattern $(event) #?$(prompt)#?'LF'TrueReturn'LF
    m1BUF=m1BUF||logf'Unable to Hangup,checking carrier"'LF
    m1BUF=m1BUF'CheckCarrier'LF'TrueJump hangup'LF
    m1BUF=m1BUF||logf'Carrier not present on hangup"'LF
    m1BUF=m1BUF'SmartSend "ATH0|"'LF'GetResponse 5'LF
    m1BUF=m1BUF||logf'Hangup response:$(event) $(LastResponse)"'LF
    m1BUF=m1BUF'Pattern $(event) #?$(prompt)#?'LF'FalseJump hangup'LF
    m1BUF=m1BUF'Return'LF

    m1BUF=m1BUF'openslave:'LF'Set State "BUSY MODEM OPEN"'LF'ModemClear'LF'ModemClose'LF
    m1BUF=m1BUF'ModemOpen'LF'FalseReturn'LF'SetBaud $(lockedrate)'LF'ModemInit'LF'Return'LF

    m1BUF=m1BUF'init:'LF'ModemClear'LF'SmartSend $(initstring)'LF'GetResponse 30'LF'Pattern $(event) #?$(prompt)#?'LF
    m1BUF=m1BUF'Print "$(initistring) Response:$(event)  $(LastResponse)\n"'LF'Return'LF

    m1BUF=m1BUF'modeminit:'LF'Print "WAKEUP\n"'LF'SetBaud $(lockedrate)'LF
    m1BUF=m1BUF'SubJump 'mdmlabel'attention'LF'FalseSubJump 'mdmlabel'init'LF'Return'LF

    mBUF=m1BUF||mBUF
/*NOT UMBRELLA*/
end;else do
/*IS UMBRELLA*/
    if ~exists(modemdir"MODEM.CFG") then CALL errorabort("Cannot find "modemdir"MODEM.CFG",10)
    mBUF='launchit:'LF
    mBUF=mBUF'Set openstatus "CON:0/80/600/80/Umbrella Session Status/INACTIVE/AUTO/CLOSE/SCREEN$(pscreen)"'LF
    if sc_modem then mBUF=mBUF'SetStatus $(openstatus)'LF
    mBUF=mBUF'Print "Modem Setup\n"'LF'Set RC $(locked)'LF'TrueSubJump umbrellamodem!preinit'LF
    mBUF=mBUF'SubJump umbrellacfg!setstatics'LF'SubJump umbrella!setglobals'LF
    mBUF=mBUF'Print "Opening Window\n"'LF'RexxMsg "" REXX "$(rexxdir)SHELTER.rexx OPENSTATUS"'LF
    if logresults then mBUF=mBUF||showresult
    mBUF=mBUF||logf'Launched Slave:$(line) $(modem)"'LF
    mBUF=mBUF'SetStatus NULL:'LF'Set priority $(launchpri)'LF
    mBUF=mBUF'Set RC ${CACHE}'LF'FalseReturn'LF'SubJump xcache!setcache'LF
    mBUF=mBUF||logf'Loaded Cache"'LF'Return'LF
    mBUF=mBUF'preinit:'LF'ModemOpen'LF'SetBaud $(lockedrate)'LF
    mBUF=mBUF'Print "$(state) Baud:$(Baud) Locked:$(baudlocked)\n"'LF'subJump umbrellamodem!attention'LF'TrueJump preinit1'LF
    mBUF=mBUF'SetBaud $(lockedrate)'LF'SubJump umbrellamodem!init'LF'Jump preinit2'LF
    mBUF=mBUF'preinit1:'LF'Set state "ModemInit $(modem)"'LF'SubJump umbrellamodem!init'LF'SetBaud $(lockedrate)'LF
    mBUF=mBUF'Print "$(state) Baud:$(Baud) Locked:$(baudlocked)\n"'LF'SubJump umbrellamodem!attention'LF
    mBUF=mBUF'preinit2:'LF'FalseJump initerr'LF||logf'$(state)"'LF
    mBUF=mBUF'Print "Preinit OK  $(Baud) $(baudlocked)\n"'LF'Return'LF
    mBUF=mBUF'initerr:'LF||logf'Modem Dead: $(state)"'LF
    mBUF=mBUF||flush'Set RC FALSE'LF'Return'LF
    mBUF=mBUF'attention:'LF'ModemClear'LF'SmartSend $(atten)'LF'GetResponse 30'LF'Pattern $(event) #?$(prompt)#?'LF
    mBUF=mBUF'Print "$(atten) Response:$(event) $(LastResponse)\n"'LF'return'LF
    mBUF=mBUF'init:'LF'ModemClear'LF'SmartSend $(initstring)'LF
    mBUF=mBUF'GetResponse 30'LF'Pattern $(event) #?$(prompt)#?'LF'Print "$(atten) Response:$(event) $(LastResponse)\n"'LF'Return'LF
    mBUF=mBUF'modeminit:'LF'Print "Reinit\n"'LF'SetBaud $(lockedrate)'LF'SetStatus NULL:'LF
    mBUF=mBUF'SubJump umbrellamodem!attention'LF'TrueReturn'LF
    mBUF=mBUF'SubJump umbrellamodem!init'LF'Return'LF
    call genline(modemdir"MODEM.CFG")
    say
end /*UMBRELLA*/
    call open('wpl',mdmwpl,'w');call writech('wpl',mBUF);call close('wpl')
    drop wpl mBUF
    say "Wrote" mdmwpl "for" nummodems "lines"
    if Opt="MODEM" then return
    say 'Generating startup code'
    launches=0
    sBUF=""
    if addhost & power then do
        firstmodem=2
        call genhost
    end;else do
        firstmodem=1
    end

do i=firstmodem to nummodems+1
    sBUF=sBUF'startup-'i':'LF'SubJump 'mdmlabel'modem'i||LF'SubJump cleargui'LF
    if islocked.i=1 then do
        tmppri=(xferpri+1)
        sBUF=sBUF'Set xferpri' tmppri||LF
        tmppri=(negopri+1)
        sBUF=sBUF'Set negopri' tmppri||LF
/*        tmppri=(launchpri+1)  */
/*        sBUF=sBUF'Set launchpri' tmppri||Lf */
    end
    sBUF=sBUF'Jump slaveloop'LF
    if umbrella then leave
end

sBUF=sBUF'startup:'LF'Set GENVER "'genver'" line 0 stack 50000 priority 0 pscreen "'pscreen'"'LF
sBUF=sBUF'SetEnv WPLVER "${WPLname}"'LF

if roof then do
sBUF=sBUF||logrl'${WPLname} 'genver'"'LF
sBUF=sBUF'Address LOGPROC "OpenLog 'l_mailer'file f ${W_SLAVE_LOGFILE}"'LF
sBUF=sBUF||logrl'OpenLog rooffile f ${W_SLAVE_LOGFILE} returned: $(RESULT1)"'LF
sBUF=sBUF'Address LOGPROC "AddLogGroup 'loggroup  l_mailer'file"'LF
sBUF=sBUF'Address LOGPROC "OpenLog 'l_mailer'win w 'logwindow'/SCREEN'pscreen'"'LF
sBUF=sBUF||logrl'OpenLog roofwin w 'logwindow'/SCREEN'pscreen' returned: $(RESULT1)"'LF
sBUF=sBUF'Address LOGPROC "AddLogGroup 'loggroup  l_mailer'win"'LF
sBUF=sBUF||logrl'AddLogGroup roofwpl rooffile returned: $(RESULT1)"'LF
end

if ~nodoor | (USE_XPRASC=0 & TxtRead~="") then do   /* Mount AUX Device */
sBUF=sBUF'RexxMsg SY,RY REXX "Return showlist(\"H\",delstr(\"${AUXDEV}\",pos(\":\",\"${AUXDEV}\")))"'LF
sBUF=sBUF'Set RC $(RESULT2)'LF'TrueJump noaux'LF
sBUF=sBUF'System "${AUXMOUNT}"'LF||logf'${AUXMOUNT} returned:$(RC)"'LF
sBUF=sBUF'noaux:'LF
end
/* Load Cache */
    sBUF=sBUF'RexxMsg SY REXX "return exists(\"CFG:WPL/'l_mailer'CACHE.WPL\")"'LF
    sBUF=sBUF'Set RC $(result1)'LF'FalseJump cache_none'LF
    sBUF=sBUF||logf'Loading Cache"'LF
if ROOFLOG then sBUF=sBUF||logrl'Loading Cache"'LF
    sBUF=sBUF'LoadScript xcache CFG:WPL/'l_mailer'CACHE.WPL'LF'FalseJump cache_loaderr'LF
    sBUF=sBUF'SetEnv CACHE TRUE'LF'Jump loadslaves'LF
    sBUF=sBUF'cache_loaderr:'LF
if ROOFLOG then sBUF=sBUF||logrl'Load failed Xcache[CFG:WPL/'l_mailer'CACHE.WPL]"'LF
    sBUF=sBUF||logf'Load failed RC:$(RC) Xcache[CFG:WPL/'l_mailer'CACHE.WPL]"'LF'SetEnv CACHE FALSE'LF'Jump loadslaves'LF
    sBUF=sBUF'cache_none:'LF
if ROOFLOG then sBUF=sBUF||logrl'Xcache[CFG:WPL/'l_mailer'CACHE.WPL] does not exist"'LF
    sBUF=sBUF||logf'Xcache[CFG:WPL/'l_mailer'CACHE.WPL] does not exist"'LF'SetEnv CACHE FALSE'LF
    sBUF=sBUF'loadslaves:'LF
if addhost & power then do
    sBUF=sBUF'Launch 'u_mailer'1 'l_mailer'!startup-1 -1 'stack||LF 
if ROOFLOG then sBUF=sBUF||logrl'Launch of ROOF1 'l_mailer'!startup-1 -1 'stack' returned $(RC)"'LF
    launches=launches+1
end

sBUF=sBUF||logf||'${WPLName}/KS:${Kickstart}/WB:${WorkBench}"'LF

if umbrella then say "Generating Modem launch code"
else do
say "Generating Modem launch code, BOLD=ENABLED, ITALICS=DISABLED"
call writech('STDOUT',"Modem line  : ")
end
do i=firstmodem to nummodems+1
    if dolaunch.i=1 then do
        if ~umbrella then call writech('STDOUT',BOLD||i||AOFF" ")
        sBUF=sBUF'Set slaves 'i' line 'i||LF
        sBUF=sBUF'Launch 'u_mailer||i l_mailer'!startup-'i launchpri stack||LF
        if ROOFLOG then sBUF=sBUF||logrl'Launch of 'u_mailer||i l_mailer'!startup-'i launchpri stack' returned $(RC)"'LF
        sBUF=sBUF||logf||'Launched 'u_mailer||i'"'LF
        if RFH & rfhline.i then do
            sBUF=sBUF'System "'RFHcmd l_mailer i'"'LF
            if ROOFLOG then sBUF=sBUF||logrl'Launched 'RFHcmd' for 'l_mailer||i'"'LF
        end
        launches=launches+1
    end;else do
        if umbrella then call errorabort('Modem Launch is DISABLED',10)
        else call writech('STDOUT',ITALICS||i||AOFF" ")
        sBUF=sBUF||logf||u_mailer||i' NOT Launched"'LF
        if ROOFLOG then sBUF=sBUF||logrl||u_mailer||i' NOT Launched"'LF
    end
    if umbrella then leave
end
if ~umbrella then do
call writech('STDOUT',LF||"Freq Handler: ")
    do i=firstmodem to nummodems+1;if freqline.i=1 then call writech('STDOUT',BOLD||i||AOFF" ");else call writech('STDOUT',ITALICS||i||AOFF" ");end
end
say
if ~umbrella & launches=0 then call errorabort('No Modems Launched',10)
sBUF=sBUF'Set slaves 'launches+1||LF
if ~umbrella then sBUF=sBUF'System "RXSET SLAVES $(slaves)"'LF
sBUF=sBUF||logf'${WPLName}/KS:${Kickstart}/WB:${WorkBench}"'LF
if ROOFLOG then sBUF=sBUF||logf'Compiled 'u_mailer' Mailer v'genver'['smver'] Stack: $(stack) Priority: $(priority)"'LF
    else sBUF=sBUF||logf'Compiled 'u_mailer' Mailer v'smver' Stack: $(stack) Priority: $(priority)"'LF
sBUF=sBUF||flush'Set RC 0'LF'Return'LF

                                         call genmain
                                         call genwazoo
                                         call genemsi
                       if ~umbrella then call genuucp
                                         call genxpr
              if ~umbrella & addfax then call genfax
if ~umbrella & addclock & domodules then call genclock
    else call writech('STDOUT',lf)
                                         call gendialer
                       if ~noanswer then call genanswer
                       if ~umbrella then call genuser
                                         call genloop
                                         call genkernal
                                         call genaftersession

if ~open('wpl',main,'A') then CALL errorabort("Unable to append to "main,40)
srcbuf=readch('wpl')
srcbuf=srcbuf||asBUF||sBUF
drop asBUF sBUF
call writech('wpl',srcbuf);call close('wpl')
drop srcbuf

if addhost then modems=launches-1
else modems=launches
Say 'Wrote' main 'for' launches 'line launches,' modems 'modems'
call SaveEnv()
say 'Generation of 'u_mailer' completed'
return

genkernal:
if power then do
    mainBUF=mainBUF||emsiBUF||wzBUF||xprBUF||faxBUF||uuBUF||aBUF||dlBUF||ansBUF||uBUF||loopBUF
    drop emsiBUF wzBUF xprBUF faxBUF uuBUF dlBUF ansBUF aBUF uBUF loopBUF
end;else do
    mainBUF=mainBUF||notBUF||emsiBUF||wzBUF||xprBUF||faxBUF||uuBUF||aBUF||dlBUF||ansBUF||uBUF||loopBUF
    drop notBUF emsiBUF wzBUF xprBUF faxBUF uuBUF dlBUF ansBUF aBUF uBUF loopBUF
end
if ~open('wpl',main,'W') then CALL errorabort("Unable to write "main,40)
call writech('wpl',mainBUF);call close('wpl')
drop mainBUF
return

genline:
if ~open('mcfg',arg(1),'R') then CALL errorabort("Cannot open ["arg(1)"]",10)

f=get_fn(upper(arg(1)))
parse var f 'MODEM' modem '.CFG'
if modem="" | modem="MODEM" then do
    if umbrella then modem=1
    else do
        Say 'Skipping Umbrella Modem config file:'arg(1)
        call close('mcfg')
        return
    end
end
say 'Compiling 'arg(1)' for line 'modem

nummodems=nummodems+1

mBUF=mBUF"modem"modem":"LF'Set line' modem||LF
dolaunch.modem=1;rfhline.modem=0;freqline.modem=0
progressline=0;faxline=0;cidline=0
inflags="E0";OutFlags="";emsiline=0;rings=0
bpsBUF="Set";dlyBUF="Set";dvBUF="Set";lvBUF="Set" 
do while ~eof('mcfg')
    call writech('STDOUT','.')
    cfgline=strip(translate(ReadLn('mcfg')," ",'09'x))
    if (cfgline="" | left(cfgline,2)="/*" | left(cfgline,2)="*/") then iterate
    cfgline=expand(cfgline)
    key=upper(word(cfgline,1))
    select
        when key="LAUNCH" then dolaunch.modem=1
        when key="NOLAUNCH" then dolaunch.modem=0
        when key="TRYFTS1" then do
            if word(cfgline,2)="TRUE" then do
                inflags=inflags",G1"
                OutFlags=OutFlags",G1,D1"
            end
        end
        when key="TRYWAZOO" then do
            if word(cfgline,2)="TRUE" then do
                inflags =inflags",G6"
                OutFlags=OutFlags",G6,D6"
            end
        end
        when key="TRYEMSI" then do
            if word(cfgline,2)="TRUE" then do
                inflags =inflags",GE"
                OutFlags=OutFlags",GE"
                emsiline=1
            end
        end
        when key="ALLOWFREQS" then do
            if word(cfgline,2)="TRUE" then do
                freqline.modem=1
                if RFH then rfhline.modem=1
            end
        end
        when key="LO" | key="ACCESS" | key="BBS" then lvBUF=lvBUF' 'key word(cfgline,2)
        when key="OFFSET" then lvBUF=lvBUF' w_offset 'word(cfgline,2)
        when key="CON" then lvBUF=lvBUF' w_con 'word(cfgline,2)
        when key="MODEM" then dvBUF=dvBUF' modem "'subword(cfgline,2)'"'
        when key="ANSWERON" then rings=word(cfgline,2)
        when key="DEVICE" then dvBUF=dvBUF' Device 'word(cfgline,2)' Unit 'word(cfgline,3)
        when key="RTSCTS" then do
            if word(cfgline,2)="TRUE" then flags=164
                else flags=160
            dvBUF=dvBUF' SerFlags' flags
        end
        when key="DTRCTL" then dvBUF=dvBUF' DTR_Control 'word(cfgline,2)
        when key="BUFFERS" then dvBUF=dvBUF' SerReadBuf 'word(cfgline,2)' SerWriteBuf 'word(cfgline,3)
        when key="SLOWMODEM" then dlyBUF=dlyBUF' SlowModem 'word(cfgline,2)
        when key="LOCKED" then do
            locked=strip(upper(word(cfgline,2)))
            if locked="TRUE" then islocked.modem=1
                else islocked.modem=0
            bpsBUF=bpsBUF' Locked 'locked
        end
        when key="LOCKEDBPS" then do
            lockbps=strip(word(cfgline,2))
            bpsBUF=bpsBUF' LockedRate 'lockbps
        end
        when key="LINKBPS" then do
            linkbps=strip(word(cfgline,2))
            bpsBUF=bpsBUF' LinkRate 'linkbps
        end
        when key="INITWAIT" then dlyBUF=dlyBUF' InitWait 'strip(word(cfgline,2))' InitLoop 5'
        when key="RESPONSETIMEOUT" then dlyBUF=dlyBUF' ResponseTimeout 'subword(cfgline,2)

        when key="OK" then mBUF=mBUF'Set prompt 'word(cfgline,2)||LF'AddResponse OK 'word(cfgline,2)||LF 
        when key="FIND" then mBUF=mBUF'AddResponse find "'subword(cfgline,2)' "'LF
        when key="300" then mBUF=mBUF'AddResponse 300 "'subword(cfgline,2)'"'LF
        when key="FAX" then do
            if ~addfax then call warning('FAX install disabled, response ['space(cfgline,1)'] ignored in Modem'modem'.cfg')
            else do
                mBUF=mBUF'AddResponse 'upper(key)' "'subword(cfgline,2)'"'LF
                faxline=1
            end
        end
        when key="PROGRESS" then do
            mBUF=mBUF'AddResponse 'upper(key)' "'subword(cfgline,2)'"'LF
            progressline=1
        end
        when key="CID" then do
            mBUF=mBUF'AddResponse 'upper(key)' "'subword(cfgline,2)'"'LF
            cidline=1
        end
        when key="BUSY" | key="CONNECT" | key="VOICE" ,
        | key="MAID" | key="LINE" | key="TIMEOUT" | key="ERROR" ,
            then mBUF=mBUF'AddResponse 'upper(key)' "'subword(cfgline,2)'"'LF
        when key="RING" then do
            if ~noanswer then mBUF=mBUF'AddResponse 'upper(key)' "'subword(cfgline,2)'"'LF
            else call errorabort('Invalid modem response: 'key' for dial only Umbrella',10)
        end
        when key="ATTEN" then mBUF=mBUF'Set Atten "'subword(cfgline,2)'"'LF
        when key="HANGUP" then mBUF=mBUF'Set HangupString "'subword(cfgline,2)'"'LF
        when key="INIT" then mBUF=mBUF'Set InitString "'subword(cfgline,2)'"'LF
        when key="CIDINIT" then mBUF=mBUF'Set CidInitString "'subword(cfgline,2)'"'LF
        when key="FAXINIT" then mBUF=mBUF'Set FaxInitString "'subword(cfgline,2)'"'LF
        when key="DIAL" then mBUF=mBUF'Set DialString "'subword(cfgline,2)'"'LF
        when key="ANSWER" then do
            if ~noanswer then mBUF=mBUF'Set AnswerString "'subword(cfgline,2)'"'LF
            else call errorabort('Invalid modem command: 'key' for dial only Umbrella',10)
        end
        when key="PROFILE" then mBUF=mBUF'Set ProfileString "'subword(cfgline,2)'"'LF
        otherwise CALL errorabort('Error in Modem'modem'.cfg' arg(1)':'cfgline,10)
    end
end
call close('mcfg');drop mcfg

if ~islocked.modem & (linkbps~=lockbps) then call errorabort('LINKBPS and LOCKBPS not EQUAL for LOCKED FALSE Modem',20)
if islocked.modem & flags~=164 then call errorabort('RTS/CTS Handshake not set for LOCKED modem',20)
if rings=0 then do
    call warning('AnswerOn undefined or 0, setting to 1 in Modem'modem'.cfg')
    rings=1
end
mBUF=mBUF'Set doemsi 'emsiline' dofax 'faxline' Progress 'progressline' AnswerOn 'rings' GotRing 0'LF
mBUF=mBUF'Set inflags.'modem strip(inflags,'L',',') 'OutFlags.'modem strip(OutFlags,'L',',')||LF

mBUF=mBUF||lvBUF||LF||dvBUF||LF||dlyBUF||LF
drop lvBUF dvBUF dlyBUF

if freqline.modem=1 then do
    if ~addfreq then call errorabort('Cannot enable request handler for line 'modem', ALLOWFREQS is FALSE in 'gencfg,20) 
    else mBUF=mBUF'Set host.freq.'modem' TRUE host.wzext.'modem' "+Freq +Domain"'LF
    if emsiline then mBUF=mBUF||'Set emsi.compat.'modem emsicompat||LF
end;else do
    mBUF=mBUF'Set host.freq.'modem' FALSE host.wzext.'modem' "-Freq +Domain"'LF
    if emsiline then mBUF=mBUF||'Set emsi.compat.'modem emsicompat',NRQ'LF
end
if locked="TRUE" then do
    bpsBUF=bpsBUF' BaudLocked 'lockbps' Baud 'linkbps' maxrate 'lockbps
    mBUF=mBUF'SetBaud 'lockbps||LF
end;else do
    bpsBUF=bpsBUF' BaudLocked 'linkbps' Baud 'linkbps' maxrate 'linkbps
    mBUF=mBUF'SetBaud 'linkbps||LF
end
mBUF=mBUF||bpsBUF||LF
drop bpsBUF
mBUF=mBUF'Jump launchit'LF
return


genuucp:
if adduucp then do
call writech('STDOUT',"UUCP ")
uuBUF='uucpconnect:'LF
uuBUF=uuBUF'SubJump ckpresess'LF'Cmp dialrc 5'LF'TrueJump dodial_exit'LF
uuBUF=uuBUF'Set session "OUTBOUND UUCP" state "SESSION $(session) $(remote.address)"'LF
if ROOFLOG then uuBUF=uuBUF||logcs'$(calltask.$(remote.address)) $(line) $(callcount.$(remote.address)) $(callstart.$(remote.address)) $<time> ??:??:?? $(remote.address) CONNECTED"'LF
uuBUF=uuBUF||logw'$(p.baud) $(Baud) $(p.status) $(session) Connect $(p.host) $(host.address) $(p.session) UUCP $(p.protocol) UUCP-G"'LF
uuBUF=uuBUF||logf'UUCPconnect:$(remote.address) $(LastResponse)[$(Baud)]"'LF
if ROOFLOG then uuBUF=uuBUF||logus'$(uucpout)"'LF
uuBUF=uuBUF'SetPri $(xferpri)'LF'Set systemcmd "$(uucico) -o -xx $(uuoptions.'sindex') -Getty -s$(remote.address) -DEVICE $(device) -UNIT $(unit)"'LF
uuBUF=uuBUF'SubJump runasync'LF'ReplyCall 0'LF'EndSession all'LF'Jump aftersession'LF
uuBUF=uuBUF'uucp_inbound:'LF'CmpI ${'envpath'UUCP} FALSE'LF'FalseJump uucp_inbound.1'LF
uuBUF=uuBUF||logf'Denied UUCP login: $(namebuf)"'LF
uuBUF=uuBUF'Set txt "'nl'  Sorry $(namebuf), UUCP logins are disabled during system maintenance'nl'  Call back in an hour or so, Thanks.'nl'"'LF
uuBUF=uuBUF'SubJump 'l_mailer'!showtxt'LF'Jump hangfree'LF
uuBUF=uuBUF'uucp_inbound.1:'LF
uuBUF=uuBUF||logw'$(p.baud) $(Baud) $(p.status) $(session) Connect $(p.login) $(namebuf) $(p.session) UUCP $(p.protocol) UUCP-G"'LF
uuBUF=uuBUF||logf'UUCP login: $(namebuf)"'LF
if ROOFLOG then uuBUF=uuBUF||logus'$(uucpin)"'LF
uuBUF=uuBUF'RexxMsg "SY,RY" REXX "return delstr(\"$(namebuf)\",1,2)"'LF'Set remote.address $(result2)'LF
if ROOFLOG then uuBUF=uuBUF||logrl'Inbound UUCP Session $(remote.address)"'LF
uuBUF=uuBUF'Cmp $(password.'sindex') ""'LF
uuBUF=uuBUF'TrueJump getuulogin'LF'SubJump getuucached'LF'Set pw CACHE listed 1 issecure TRUE'LF
uuBUF=uuBUF'Set txt "Whats the Password: "'LF'SubJump 'l_mailer'!showtxt'LF'GetInbound E2 20'LF'Cmp $(event) LOGIN'LF'FalseJump DoMenu'LF
uuBUF=uuBUF'CmpI $(remote.password) $(namebuf)'LF'FalseJump badlogin'LF'Set pw "$(pw) OK"'LF
uuBUF=uuBUF||logf'Inbound UUCP Session $(remote.sitename)"'LF
uuBUF=uuBUF||logw'$(p.password) $(pw)"'LF
uuBUF=uuBUF'SetPri $(xferpri)'LF
uuBUF=uuBUF'Set systemcmd "$(uucico) -xx $(uuoptions.'sindex') -Getty -D $(device) -U $(unit)"'LF
uuBUF=uuBUF'SubJump runasync'LF'Jump aftersession'LF
uuBUF=uuBUF'getuulogin:'LF'Set systemcmd "$(login) -b$(Baud) -lower -oUUSPOOL:logfile -pCFG:passwd -d$(device) -u$(unit) \"$(namebuf)\""'LF
uuBUF=uuBUF'SubJump runasync'LF'Set tmprc $(RC)'LF'Cmp $(tmprc) 1'LF'TrueJump badlogin'LF'Cmp $(tmprc) 7'LF'TrueJump timeout_exit'LF'Cmp $(tmprc) 9'LF'TrueJump aftersession'LF
uuBUF=uuBUF||logf'UUCP Login returned: $(tmprc)"'LF
uuBUF=uuBUF'Jump aftersession'LF
uuBUF=uuBUF'badlogin:'LF'Set pw "$(pw) BAD"'LF
uuBUF=uuBUF||logw'$(p.password) $(pw)"'LF
uuBUF=uuBUF||logf'Password error $(remote.sitename) $(namebuf) [$(remote.password)]"'LF
uuBUF=uuBUF'Jump aftersession'LF
end;else do
uuBUF='uucpconnect:'LF'Print "ERROR: UUCP is not installed\n"'LF'Return'LF'uucp_inbound:'LF'Send "There are no UUCP logins here'nl'"'LF'Return'LF'getuulogin:'LF'Print "ERROR: UUCP is not installed\n"'LF'Return'LF
end
return


gennotify:
if ~NoResume then say "Generating Resume Handling"
if power then do
notBUF=';WPLSCRIPT 'l_mailer'notify'LF
notBUF=notBUF'runsync:'LF'Cmp $(systemcmd) ""'LF'TrueReturn'LF'System $(systemcmd)'LF'Clear systemcmd'LF'Return'LF
end
else notBUF=""

notBUF=notBUF'showdevowner:'LF'SubJump 'l_mailer'!cleargui'LF
notBUF=notBUF||logw'$(p.status) $(state) $(Owner)"'LF
notBUF=notBUF||logf'$(Owner) owns $(device) unit $(unit) - Waiting"'LF
if ROOFLOG then notBUF=notBUF||logus'$(humanout)'LF
notBUF=notBUF'Set RC TRUE'LF'Return'LF
if ~NoResume then do
notBUF=notBUF'set_resume:'LF'Set resumefile.$(remote.address) $(remfile) resume.cmd "$(resumedir)$(remote.domain).$(remote.zone).$(remote.net).$(remote.node).$(remote.point)"'LF
if exists("MAIL:ResumeFill") | exists("RAM:ResumeFill") then notBUF=notBUF'System "ResumeFill $(resume.cmd) $(remote.address) $(tempfile) $(remfile)"'LF
else do
call warning("ResumeFill command not found, using ECHO")
notBUF=notBUF'System "echo  >$(resume.cmd) resume:"'LF'System "echo >>$(resume.cmd) Set resumefull.$(remote.address) $(tempfile) resumefile.$(remote.address) $(remfile) resume TRUE"'LF
notBUF=notBUF'System "echo >>$(resume.cmd) XprSetFile $(tempfile) $(remfile) F"'LF'System "echo >>$(resume.cmd) return"'LF
end
notBUF=notBUF'Return'LF
notBUF=notBUF'GetResume:'LF'Set resume.cmd "$(resumedir)$(remote.domain).$(remote.zone).$(remote.net).$(remote.node).$(remote.point)"'LF
notBUF=notBUF'RexxMsg SY REXX "return exists(\"$(resume.cmd)\")"'LF'Set RC $(result1)'LF'FalseJump GetResume_none'LF
notBUF=notBUF'LoadScript xresume $(resume.cmd)'LF'FalseJump GetResume_loaderr'LF'SubJump xresume!resume'LF'LoadScript xresume ""'LF'Return'LF
notBUF=notBUF'GetResume_loaderr:'LF||logf'Load failed RC:$(RC) Xresume[$(resume.cmd)]"'LF
notBUF=notBUF'GetResume_none:'LF'Set resume FALSE'LF'Return'LF
notBUF=notBUF'clr_resume:'LF'Set resume.cmd "$(resumedir)$(remote.domain).$(remote.zone).$(remote.net).$(remote.node).$(remote.point)"'LF
if wpldebug then notBUF=notBUF||logf'Deleting Xresume[$(resume.cmd)]"'LF
notBUF=notBUF'LoadScript xresume ""'LF'RexxMsg SY REXX "call Delete(\"$(resume.cmd)\")"'LF
notBUF=notBUF'Clear resumefull.$(remote.address) resumefile.$(remote.address)'LF'Return'LF
end/*doresume*/
notBUF=notBUF'prefullname:'LF'Set RC $(fsend)'LF'TrueJump preoutfullname'LF
if ~NoResume then notBUF=notBUF'Set RC $(resume)'LF'TrueJump preresume'LF
notBUF=notBUF||logf'PreFullName Receiving:$(localfile)[$(remfile)][$(filesize)] from $(remote.address)"'LF
notBUF=notBUF||logw'$(p.status) $(session) Receiving $(remfile)"'LF'Return'LF
if power then do
notBUF=notBUF'preoutfullname:'LF||logf'$(protocol) PreFullName Sending:$(localfile)[$(remfile)][$(filesize)] to $(remote.address)"'LF
notBUF=notBUF||logw'$(p.status) $(session) Sending $(localfile)[$(remfile)] $(p.protocol) $(protocol)"'LF'Return'LF
end
notBUF=notBUF'postfullname:'LF
if (power | sendbull | sendbanner) then do
notBUF=notBUF'Set tmprc $(RC)'LF'Cmp $(protocol) ASCII'LF'FalseJump tstrc'LF
notBUF=notBUF'Set tmprc TRUE filestatus "Ascii Send OK" cps 240 'LF
notBUF=notBUF'tstrc:'LF'Set RC $(tmprc)'LF
end
notBUF=notBUF'FalseJump xfererr'LF
notBUF=notBUF'Set RC $(fsend)'LF'TrueJump postoutfullname'LF
if ~NoResume then notBUF=notBUF'Set RC $(resume)'LF'TrueJump postresume'LF
notBUF=notBUF||logf'PostFullName $(filestatus):$(localfile)[$(remfile)] $(protocol) CPS:$(CPS) ($(CPSP)%) Size:$(filesize)"'LF
notBUF=notBUF'Jump in_notify'LF
notBUF=notBUF'postoutfullname:'LF||logw'$(p.status) $(session) Sent $(localfile) for $(remfile)"'LF
notBUF=notBUF'SubJump 'notifylabel'out_notify'LF'Set fsend FALSE'LF'Return'LF
if ~NoResume then do
notBUF=notBUF'preresume:'LF||logf'Resuming $(protocol) receive $(remfile)[$(filesize)] $(resumefull.$(remote.address)) $(resumefile.$(remote.address))"'LF
notBUF=notBUF||logw'$(p.status) $(session) Resuming $(remfile)"'LF'Return'LF
end
notBUF=notBUF'preinbound:'LF||logf'Receiving:$(remfile) [$(filesize)] as $(tempfile) from $(remote.address)"'LF||logw'$(p.status) $(session) Receiving $(remfile)"'LF
if ~NoResume then do
    notBUF=notBUF'Pattern $(remfile) #?.REQ'LF'TrueReturn'LF
    notBUF=notBUF'Set RC $(resume)'LF'FalseSubJump 'notifylabel'set_resume'LF
end
notBUF=notBUF'Return'LF
if ~NoResume then do
notBUF=notBUF'postresume:'LF||logf'PostResume $(filestatus):$(localfile)[$(remfile)] $(protocol) CPS:$(CPS)[$(CPSP)%] Size:$(filesize)"'LF'CmpI $(resumefull.$(remote.address)) $(localfile)'LF
notBUF=notBUF'FalseJump in_notify'LF'Set remfile $(resumefile.$(remote.address)) infile $(inbound)$(remfile)'LF
notBUF=notBUF'RexxMsg SY REXX "call rename(\"$(localfile)\",\"$(inbound)\"||\"$(remfile)\")"'LF'Jump in_notify'LF
end
notBUF=notBUF'postinbound:'LF'FalseJump xfererr'LF'Cmp $(filesize) 0'LF'TrueJump zeroerr'LF
notBUF=notBUF'in_notify:'LF
if ~NoResume then do
if wpldebug then notBUF=notBUF||logf'Expected:[$(resumefile.$(remote.address))] Recd:[$(remfile)]"'LF
if addfreq then notBUF=notBUF'Pattern $(remfile) #?.REQ'LF'TrueJump filenotify'LF
notBUF=notBUF'CmpI $(resumefile.$(remote.address)) $(remfile)'LF
notBUF=notBUF'TrueSubJump 'notifylabel'clr_resume'LF
end
notBUF=notBUF||logf'$(protocol) $(filestatus):$(infile)[$(remfile)] CPS:$(CPS) ($(CPSP)%) Size:$(filesize)"'LF
if ROOFLOG then notBUF=notBUF||logus'$(bytesin) $(filesize)"'LF
notBUF=notBUF'Set RC $(FTS1)'LF'FalseJump filenotify'LF||logf'FTS1 Receive $(remfile)"'LF'SetA remote fidonet#1:1/1.1'LF

call writech('STDOUT','Generating WhenRecd Processing: ')
notBUF=notBUF'filenotify:'LF

if ~umbrella & addfreq then do
call writech('STDOUT','REQ ')
if freqsetup=3 then notBUF=notBUF'Set systemcmd "$(freqcmd)"'LF
else if ~RFH then notBUF=notBUF'Set systemcmd "Rx $(rexxdir)STARTRFS 'l_mailer' $(line) $(Baud) $(host.address) $(infile) $(listed) $(remote.address) $(remote.sysop)"'LF
notBUF=notBUF'Pattern $(remfile) #?.REQ'LF'FalseJump show_recd'LF'Set RC $(host.freq)'LF'FalseJump badreq'LF
notBUF=notBUF||logf'Processing REQ from $(remote.address)"'LF
if RFH then notBUF=notBUF'RexxMsg FY RFH$(line) "REQ $(Baud) $(host.address) $(infile) $(listed) $(fnc) 0 $(remote.address) $(remote.sysop)"'LF'Return'LF
else notBUF=notBUF'Jump runsync'LF
notBUF=notBUF'badreq:'LF||logf'$(remote.address) ignored $(session) No-FREQS"'LF
notBUF=notBUF'show_recd:'LF
end /*NOT UMBRELLA*/
if ROOFLOG then notBUF=notBUF||logr'SHOWRECD $(line) $(remfile) $(remote.address) $(filesize) $(cps) $(Baud)"'LF

notBUF=notBUF'Cmp $(issecure) TRUE'LF'TrueJump knownsite'LF||logf'$(remfile) from $(remote.address) is non-secure"'LF
if power then notBUF=notBUF'Jump logfiles'LF
else notBUF=notBUF'Return'LF

notBUF=notBUF'knownsite:'LF'Cmp $(multihub) FALSE'LF'TrueJump notmulti1'LF
notBUF=notBUF||logf'Sorting $(remfile) from $(remote.address) with ${'envpath'SORTRECD}" 'LF
if SCANOPT~="FALSE" then do
call writech('STDOUT','SCAN-MAIL ')
  notBUF=notBUF'ck_mail1:'LF'Pattern $(remfile) 'arcmail||LF'TrueJump ck_mail22'LF
  notBUF=notBUF'ck_mail2:'LF'Pattern $(remfile) ????????.PKT'LF'FalseJump ck_other'LF
  notBUF=notBUF'ck_mail22:'LF'Set mail TRUE'LF
end;else do
  call writech('STDOUT','SORT ')
  notBUF=notBUF'Set systemcmd "${'envpath'SORTRECD}"'LF'Jump ck_mail1'LF
  call writech('STDOUT','MAIL ')
  notBUF=notBUF'notmulti1:'LF'Set systemcmd "${'envpath'ARCRECD}"'LF
  notBUF=notBUF'ck_mail1:'LF'Pattern $(remfile) 'arcmail||LF'TrueJump ck_mail22'LF
  notBUF=notBUF'ck_mail11:'LF'Cmp $(multihub) FALSE'LF'TrueJump notmulti2'LF
  notBUF=notBUF'Set systemcmd "${'envpath'SORTRECD}"'LF'Jump ck_mail2'LF
  notBUF=notBUF'notmulti2:'LF'Set systemcmd "${'envpath'PKTRECD}"'LF
  notBUF=notBUF'ck_mail2:'LF'Pattern $(remfile) ????????.PKT'LF'FalseJump ck_other'LF
  notBUF=notBUF'ck_mail22:'LF'Set mail TRUE'LF'TrueSubJump runsync'LF
end
 notBUF=notBUF'ck_other:'LF
if adduucp & pos('uucprecd',cmdlst)>0 then do
    call writech('STDOUT','UUCP ')
    notBUF=notBUF'Set systemcmd "${'envpath'UUCPRECD}"'LF'Pattern $(remfile) X.#?'LF'TrueJump runsync'LF
end
if SCANOPT="ALL" then do
  call writech('STDOUT','SCAN-TIC ')
  notBUF=notBUF'Pattern $(remfile) #?.TIC 'LF
  if power then notBUF=notBUF'FalseJump logfiles'LF;else notBUF=notBUF'FalseReturn'LF
  notBUF=notBUF'Set mail TRUE'LF'Return'LF
end;else do
  if pos('tickrecd',cmdlst)=0 then do
    call warning('CMD ticrecd is undefined')
    if power then notBUF=notBUF'Jump logfiles'LF;else notBUF=notBUF'Return'LF
  end;else do
   call writech('STDOUT','TIC ')
   notBUF=notBUF'Set systemcmd "${'envpath'TICRECD}"'LF'Pattern $(remfile) #?.TIC 'LF
   if power then notBUF=notBUF'FalseJump logfiles'LF;else notBUF=notBUF'FalseReturn'LF
   notBUF=notBUF'Set tic TRUE'LF'Jump runsync'LF
 end
end
if power then do
call writech('STDOUT','UPLOAD ')
notBUF=notBUF'logfiles:'LF'Cmp $(session) UPLOAD'LF'FalseReturn'LF
notBUF=notBUF'RexxMsg SY REXX "if ~open(u,\"LOG:NEEDDESC$(line)\",\"A\") then x=open(u,\"LOG:NEEDDESC$(line)\",\"W\");x=writeln(u,\"$(remfile) $(infile)\");x=close(u)"'LF
notBUF=notBUF'Return'LF
end
notBUF=notBUF'preoutbound:'LF||logf'Sending:$(localfile) [$(filesize)] as $(remfile) to $(remote.address)"'LF||logw'$(p.status) $(session) Sending $(remfile)"'LF'Return'LF
notBUF=notBUF'postoutbound:'LF'FalseJump xfererr_out'LF'Cmp $(filesize) 0'LF'TrueJump zeroerr'LF
notBUF=notBUF'out_notify:'LF||logf'$(filestatus):$(localfile)[$(remfile)] $(protocol) CPS:$(CPS) ($(CPSP)%) Size:$(filesize)"'LF
if ROOFLOG then do
  notBUF=notBUF||logus'$(bytesout) $(filesize)"'LF
  notBUF=notBUF'Cmp $(protocol) ASCII'LF'TrueReturn'LF
  notBUF=notBUF||logr'SHOWSENT $(line) $(remfile) $(remote.address) $(filesize) $(cps) $(Baud)"'LF
end
notBUF=notBUF'Return'LF

notBUF=notBUF'xfererr_out:'LF'Pattern $(remfile) 'arcmail||LF
notBUF=notBUF'FalseJump xfererr'LF'Set tmprc $(RC)'LF
notBUF=notBUF'RexxMsg SY,RY REXX "f=\"$(localfile)\";return SetComment(f,\"ABORTED \"subword(statef(f),8))"'LF
notBUF=notBUF'Set RC $(tmprc)'LF'Jump xfererr'LF

notBUF=notBUF'zeroerr:'LF'Set filestatus "$(filestatus) zero-length"'LF
notBUF=notBUF'xfererr:'LF
if ~NoResume then notBUF=notBUF'Set filestatus "$(filestatus) Resume:$(resume) Send:$(fsend) RC:$(RC)" 'LF||logf'$(protocol) transfer $(filestatus):$(remfile)"'LF
else notBUF=notBUF'Set filestatus "$(filestatus) Send:$(fsend) RC:$(RC)" 'LF||logf'$(protocol) transfer $(filestatus):$(remfile)"'LF
notBUF=notBUF'Set fsend FALSE'LF
notBUF=notBUF||logw'$(p.status) Transfer $(filestatus):$(remfile)"'LF
notBUF=notBUF'Return'LF

if power then do
call open('not',notifywpl,"W");call writech('not',notBUF);call close('not')
drop not notBUF
say;Say "Wrote "notifywpl
end
return

genhost:
say 'Generating WPL Function Host'
sBUF=sBUF'startup-1:'LF'Set line 1 modem "WPL Function Host"'LF'SubJump 'cfglabel'setglobals'LF'SubJump 'cfglabel'setstatics'LF
sBUF=sBUF||logf'Launched Slave:$(line) $(modem)"'LF
sBUF=sBUF'SetStatus NULL:'LF
if ROOFLOG then do
sBUF=sBUF'Set sl 70 speech  "Launched Slave:$(line) $(modem)"'LF
sBUF=sBUF||logrl'$(speech)"'LF
if addspeech then sBUF=sBUF'SubJump 'l_mailer'!sayit'LF
end
if roof then do
    if exists("RPDIR:QUEUEMGR") then sBUF=sBUF'System "Run >NIL: QUEUEMGR SCHED"'LF
    else do
        sBUF=sBUF'RexxMsg "" AREXX "$(rexxdir)QUEUEMGR.rexx SCHED"'LF
        if logresults then sBUF=sBUF||showresult
    end
end
sBUF=sBUF||logf'Waiting for a Command"'LF
sBUF=sBUF'exeloop:'LF'Set CallInterupt FALSE'LF'Clear state remote.text remote.address remote.network'LF
sBUF=sBUF'CheckCall'LF'TrueJump ck_function'LF'Set RC $<abort>'LF'TrueJump mailer_exit'LF
sBUF=sBUF'Set CallInterupt TRUE'LF'WaitEvent 60'LF'Jump exeloop'LF
sBUF=sBUF'ck_function:'LF'Cmp $(remote.network) UUCP'LF'FalseJump ck_func'LF
sBUF=sBUF||logf'Received Call: $(remote.text)"'LF
sBUF=sBUF'Set state "EXECUTING Script $(remote.text)"'LF
if sc_modem then sBUF=sBUF'SetStatus "$(openstatus)"'LF'Print "$(state)\n"'LF
sBUF=sBUF||logf'Executing WPLrx script:$(rexxdir)$(remote.text)"'LF
if ROOFLOG then sBUF=sBUF||logcs'0 $(line) 1 $<time> $<time> ??:??:?? $(remote.text) RUNNING"'LF
sBUF=sBUF'Address REXX "$(rexxdir)$(remote.text)"'LF'ReplyCall $(RC)'LF
if ROOFLOG then sBUF=sBUF||logcs'0 $(line) 1 $<time> $<time> $(calldur.$(remote.address)) $(remote.text) COMPLETED"'LF
sBUF=sBUF||logf'Waiting for a Command"'LF
sBUF=sBUF'SetStatus NULL:'LF'Jump exeloop'LF
sBUF=sBUF'ck_func:'LF'Cmp $(remote.network) TEXT'LF'FalseJump exeloop'LF
sBUF=sBUF||logf'Received Call: $(remote.text)"'LF
sBUF=sBUF'Set state "EXECUTING Function $(remote.text)"'LF
if sc_modem then sBUF=sBUF'SetStatus "$(openstatus)"'LF'Print "$(state)\n"'LF
sBUF=sBUF'Pattern $(cmdlist) #?$(remote.text)#?'LF'FalseJump exeloop'LF
sBUF=sBUF'Set systemcmd $(cmd.$(remote.text))'LF
sBUF=sBUF||logf'Executing [$(systemcmd)]"'LF
sBUF=sBUF'SubJump runsync'LF'ReplyCall $(RC)'LF
sBUF=sBUF||logf'$(state) returned:$(RC)"'LF
sBUF=sBUF'SetStatus NULL:'LF'Clear state remote.address remote.network remote.text'LF
sBUF=sBUF'Jump exeloop'LF
sBUF=sBUF'mailer_exit:'LF'Set state "$(modem) CLOSE"'LF
sBUF=sBUF||logf'Closing Slave$(line)"'LF
sBUF=sBUF'Cmp $(exit) RESTART'LF'FalseJump closelogs'LF'Jump recompile'LF
return

genmain:
mainBUF=';WPLSCRIPT 'l_mailer||LF';$VER: 'u_mailer 'v'smver' GenMailer v'genver||LF
mainBUF=mainBUF'Print "If you see this, you Goofed up your config\n"'LF'Return'LF
mainBUF=mainBUF'wazoo: Jump j_wazoo'LF
mainBUF=mainBUF'pwemsi: Jump j_pwemsi'LF
if ~WplrxDomainFix then mainBUF=mainBUF'ck_emsidomain: Jump j_ck_emsidomain'LF
if sendbanner then mainBUF=mainBUF'sendbanner: Jump j_sendbanner'LF
if (sendbanner | sendbull | power) then do
    mainBUF=mainBUF'ascii_start: Jump j_ascii_start'LF
    mainBUF=mainBUF'ascii_end: Jump j_ascii_end'LF
end
if ~umbrella then do
    mainBUF=mainBUF'getlookup: Jump j_getlookup'LF
    mainBUF=mainBUF'getuulookup: Jump j_getuulookup'LF
end
mainBUF=mainBUF'getcached: Jump j_getcached'LF
if ~umbrella then mainBUF=mainBUF'getuucached: Jump j_getuucached'LF
mainBUF=mainBUF'ck_multiftn: Jump j_ck_multiftn'LF
mainBUF=mainBUF'xprdisplay: Jump j_xprdisplay'LF
mainBUF=mainBUF'xprend: Jump j_xprend'LF
if ~umbrella then do
    mainBUF=mainBUF'DoMenu: Jump j_DoMenu'LF
    mainBUF=mainBUF'user_input: Jump j_user_input'LF
end
if power then do
    mainBUF=mainBUF'showmenu: Jump j_showmenu'LF
    mainBUF=mainBUF'loadwplrx: Jump j_loadwplrx'LF
    mainBUF=mainBUF'sendhelp: Jump j_sendhelp'LF
if genmenufile then mainBUF=mainBUF'sendmenu: Jump j_sendmenu'LF
end

    mainBUF=mainBUF'cleargui:'LF
    mainBUF=mainBUF||logw'$(p.response) $(p.baud) $(p.number) $(p.password) $(p.session) $(p.protocol) $(p.login) $(p.host) $(p.remote) $(p.rsysop) $(p.hoffer) $(p.roffer) $(p.hfreqs) $(p.rfreqs) $(p.inbound) $(p.domain)"'LF
    mainBUF=mainBUF'Return'LF
if addspeech then do
    mainBUF=mainBUF'sayit:'LF'RexxMsg SY REXX "return (GetClip('SAYLEVEL') >= $(sl))"'LF'Set RC $(result1)'LF'TrueReturn'LF'System "run >nil: SAY \"$(speech).\""'LF
    mainBUF=mainBUF'Clear speech'LF'Return'LF
end
    mainBUF=mainBUF'showtxt:'LF'Print $(txt)'LF'Send $(txt)'LF'Clear txt'LF'Return'LF

    mainBUF=mainBUF'runsync:'LF'Cmp $(systemcmd) ""'LF'TrueReturn'LF'Set tstate $(state) state "EXTERNAL"'LF
if wpldebug then mainBUF=mainBUF||logf'Executing: $(systemcmd)" 'LF
    mainBUF=mainBUF'System $(systemcmd)'LF'Set state $(tstate)'LF'Clear systemcmd tstate'LF'Return'LF
    mainBUF=mainBUF'runasync:'LF'Cmp $(systemcmd) ""'LF'TrueReturn'LF
if wpldebug then mainBUF=mainBUF||logf'Executing: $(systemcmd)" 'LF
    mainBUF=mainBUF'RexxMsg SY REXX "Address COMMAND \"$(systemcmd)\""'LF'Set RC $(RESULT1)'LF
    mainBUF=mainBUF'Clear systemcmd'LF'Return'LF

if ~umbrella then do
mainBUF=mainBUF'j_getlookup:'LF'Seta remote ${$(line).domain}#${$(line).zone}:${$(line).net}/${$(line).node}.${$(line).point}'LF
mainBUF=mainBUF'Set pw LOOKUP remote.number ${$(line).number} remote.password ${$(line).password}'LF
mainBUF=mainBUF'Set remote.sysop ${$(line).sysop} remote.sitename ${$(line).sitename}'LF'Set useline $(line) dial $(DialString)'LF'Jump get_exit'LF
mainBUF=mainBUF'j_getuulookup:'LF'Address REXX "$(rexxdir)uulookup.wplrx $(remote.address)"'LF
mainBUF=mainBUF'Set pw LOOKUP remote.sitename $(remote.address) remote.sysop root'LF'Set useline $(line) dial $(DialString)'LF'Jump get_exit'LF
end
mainBUF=mainBUF'j_getcached:'LF'Seta remote $(remote.address)'LF
if ~umbrella then mainBUF=mainBUF'j_getuucached:'LF
mainBUF=mainBUF'Set pw CACHE remote.number 'idxphone' remote.password $(password.'sindex')'LF
mainBUF=mainBUF'Set remote.sysop $(sysop.'sindex') remote.sitename $(sitename.'sindex')'LF
mainBUF=mainBUF'get_exit:'LF
mainBUF=mainBUF||logw'$(p.host) $(host.address) $(p.password) $(pw) $(p.remote) $(remote.address) $(p.number) $(remote.number) $(p.rsysop) $(remote.sysop) $(remote.sitename)"'LF
mainBUF=mainBUF'Return'LF
mainBUF=mainBUF'j_ck_multiftn:'LF'Set RC $(multi.'sindex')'LF
mainBUF=mainBUF'FalseReturn'LF'SubJump 'l_mailer'!fidonethost'LF'Set inbound $(nonsecure) multihub TRUE 'LF
mainBUF=mainBUF||logw'$(p.inbound) NONSECURE"'LF
mainBUF=mainBUF||logf'Tagged $(remote.address) for FTN mail sort"'LF'Set RC 0'LF'Return'LF
return

genemsi:
call writech('STDOUT',"EMSI ")
if ~noanswer then do
emsiBUF=emsiBUF'login_emsi:'LF

emsiBUF=emsiBUF'Set RC $(nopickup)'LF'FalseJump le.1'LF
emsiBUF=emsiBUF'Set host.link "8N1,HAT,HRQ"'LF
emsiBUF=emsiBUF'le.1:'LF

if H_REQ1 then emsiBUF=emsiBUF'Set host.link "$(host.link),RH1"'LF

emsiBUF=emsiBUF'Pattern $(namebuf) "'bademsi'"'LF'FalseJump login_emsi_GoodSpec'LF
emsiBUF=emsiBUF'login_emsi_BadSpec:'LF
emsiBUF=emsiBUF'Pattern $(namebuf) #?**EMSI_CLIFA8C#?'LF'TrueJump user_input'LF
emsiBUF=emsiBUF'SmartSend "'E_NAKcr'"'LF
emsiBUF=emsiBUF'login_emsi_GoodSpec:'LF'SetPri $(negopri)'LF'Set host.akas "'strip(myakas)'"'LF
emsiBUF=emsiBUF||emsi_ext();drop ee
emsiBUF=emsiBUF'Set sentflags "Link:$(host.link) Prefs:'ppref' Compat:$(host.compat)"'LF
emsiBUF=emsiBUF'Print "\nInbound EMSI\n"'LF'XprSetup xpremsi.library ""'LF'XprReceive ""'LF'XprClose'LF
emsiBUF=emsiBUF'Set RC $(EMSI)'LF'FalseJump bademsilogin'LF
emsiBUF=emsiBUF'Set RC $(remote.akas)'LF'FalseJump bademsinego'LF

emsiBUF=emsiBUF||logf'EMSI HandShake OK $(remote.akas)"'LF
emsiBUF=emsiBUF'Set called 0'LF
if FIXDOMAIN then do
/*if RP then emsiBUF=emsiBUF'Address REXX "RPDIR:EMSICVT.wplrx C $(remote.akas)"'LF */
/*else emsiBUF=emsiBUF'Address REXX "$(rexxdir)EMSICVT.wplrx C $(remote.akas)"'LF */
if RP then emsiBUF=emsiBUF'Address REXX "RPDIR:EMSICVT.wplrx C $(called) $(remote.akas)"'LF
else emsiBUF=emsiBUF'Address REXX "$(rexxdir)EMSICVT.wplrx C $(called) $(remote.akas)"'LF
emsiBUF=emsiBUF||logf'EMSI akas Converted:$(remote.akas)"'LF
end;else if FIXKNOWN then do
/* RP then emsiBUF=emsiBUF'Address REXX "RPDIR:EMSICVT.wplrx K $(remote.akas)"'LF */
/*se emsiBUF=emsiBUF'Address REXX "$(rexxdir)EMSICVT.wplrx K $(remote.akas)"'LF */
if RP then emsiBUF=emsiBUF'Address REXX "RPDIR:EMSICVT.wplrx K $(called) $(remote.akas)"'LF
else emsiBUF=emsiBUF'Address REXX "$(rexxdir)EMSICVT.wplrx K $(called) $(remote.akas)"'LF
emsiBUF=emsiBUF||logf'Known EMSI akas Converted:$(remote.akas)"'LF
end
emsiBUF=emsiBUF'Seta Remote $(remote.akas)'LF
if ~WplrxDomainFix then emsiBUF=emsiBUF'SubJump ck_emsidomain'LF
emsiBUF=emsiBUF'SubJump pwemsi'LF
if KILLBAD then emsiBUF=emsiBUF'FalseJump hangfree'LF
else do
    emsiBUF=emsiBUF'TrueJump ppwok'LF
    emsiBUF=emsiBUF'Set remote.link "$(remote.link),NPU" inbound $(nonsecure)'LF
    emsiBUF=emsiBUF'BeginSession BADPASSWORD'LF
    emsiBUF=emsiBUF'ppwok:'LF
end
emsiBUF=emsiBUF'Pattern $(remote.compat) #?FNC#?'LF'FalseJump noIfnc'LF'Set FNC 1'LF
emsiBUF=emsiBUF'noIfnc:'LF'Set remote.freq FALSE'LF'Pattern $(remote.compat) #?NRQ#?'LF
emsiBUF=emsiBUF'TrueJump nrqemsi'LF'Set remote.freq TRUE'LF
emsiBUF=emsiBUF'nrqemsi:'LF'Pattern $(remote.link) #?PUP#?'LF'FalseJump pupemsi'LF
emsiBUF=emsiBUF'BeginSession "$(remote.address) EMSI"'LF
emsiBUF=emsiBUF'pupemsi:'LF'Pattern $(remote.link) #?NPU#?'LF'TrueJump npuemsi'LF
emsiBUF=emsiBUF'BeginSession $(remote.address)'LF

if ~NoAKAS then do
emsiBUF=emsiBUF'Cmp $(remote.number) ""'LF'TrueJump npuemsi'LF
emsiBUF=emsiBUF'BeginSession "$(akalist.'sindex')"'LF
end;else do
emsiBUF=emsiBUF'BeginSession "$(remote.akas) EMSI"'LF
end
emsiBUF=emsiBUF'npuemsi:'LF'Set state "SESSION INBOUND $(remote.address)"'LF
if ROOFLOG then emsiBUF=emsiBUF||logrl'Inbound EMSI FTN Session $(remote.address) @ $(Baud)"'LF

emsiBUF=emsiBUF||logf'System:[$(remote.sitename)][$(remote.address)] Sysop:$(remote.sysop)"'LF
emsiBUF=emsiBUF||emsilog();drop el

if forcesort then emsiBUF=emsiBUF'Set multihub TRUE'LF
emsiBUF=emsiBUF||GenProtocolSelect('Host','In');drop psBUF

emsiBUF=emsiBUF'bademsinego:'LF
emsiBUF=emsiBUF||logf'EMSI failed Ident:$(remote.extra)"'LF
emsiBUF=emsiBUF'bademsilogin:'LF||logf'EMSI HandShake Failed"'LF
emsiBUF=emsiBUF||logw'$(p.session) BADEMSI $(remote.akas)"'LF
emsiBUF=emsiBUF'Clear namebuf'LF'Jump hangfree'LF

emsiBUF=emsiBUF'j_pwemsi:'LF
emsiBUF=emsiBUF'Cmp $(password.'sindex') ""'LF'TrueJump notincache'LF
emsiBUF=emsiBUF'CmpI $(password.'sindex') $(remote.password)'LF'FalseJump badpwemsi'LF
emsiBUF=emsiBUF||logf'Password:OK $(remote.address)"'LF
emsiBUF=emsiBUF||logw'$(p.inbound) SECURE $(p.password) CACHE OK"'LF
emsiBUF=emsiBUF'Set listed 1 issecure TRUE inbound $(inbound.$(remote.domain)) RC TRUE'LF'Return'LF

emsiBUF=emsiBUF'notincache:'LF
emsiBUF=emsiBUF||logf'Password: NOCACHE $(remote.address)"'LF
emsiBUF=emsiBUF||logw'$(p.inbound) NONSECURE $(p.password) NOCACHE"'LF
emsiBUF=emsiBUF'Set listed 0 issecure FALSE inbound $(nonsecure) RC TRUE'LF'Return'LF

emsiBUF=emsiBUF'badpwemsi:'LF
emsiBUF=emsiBUF||logf'Password: BAD $(remote.address) His:[$(remote.password)] Ours:[$(password.'sindex')]"'LF
emsiBUF=emsiBUF||logw'$(p.inbound) NONSECURE $(p.password) CACHE BAD"'LF
emsiBUF=emsiBUF'Set listed 0 issecure FALSE inbound $(nonsecure) RC FALSE'LF'Return'LF
end/* not nonasnwer */

emsiBUF=emsiBUF'do_emsiN:'LF'Print "Emsi namebuf:'E_NAKcr'\r\n"'LF'SmartSend "'E_NAKcr'"'LF
emsiBUF=emsiBUF'do_emsi:'LF'SetPri $(negopri)'LF

if WplrxDomainFix then do
emsiBUF=emsiBUF'Set t $(host.zone):$(host.net)/$(host.node)@$(host.domain)'LF'Cmp $(host.point) 0'LF'TrueJump SetAkas'LF
emsiBUF=emsiBUF'Set t $(host.zone):$(host.net)/$(host.node).$(host.point)@$(host.domain)'LF
emsiBUF=emsiBUF'SetAkas:'LF'RexxMsg SY,RY REXX "t=\"$(t)\";return t\" \"delstr(\"$(host.akas)\",pos(t,upper(\"$(host.akas)\")),length(t)+1)"'LF
emsiBUF=emsiBUF'Set host.akas $(RESULT2)'LF
end
if primary then emsiBUF=emsiBUF'Set host.link "8N1,PUP"'LF
           else emsiBUF=emsiBUF'Set host.link "8N1,PUA"'LF
emsiBUF=emsiBUF'Set RC $(nopickup)'LF'FalseJump do_emsi.1'LF
emsiBUF=emsiBUF'Set host.link "8N1,NPU"'LF
emsiBUF=emsiBUF'do_emsi.1:'LF

if H_REQ1 then emsiBUF=emsiBUF'Set host.link "$(host.link),RH1"'LF

emsiBUF=emsiBUF'Set RC $(emsiRT)'LF'FalseJump do_emsi.11'LF
emsiBUF=emsiBUF'Print "\r\nEmsi RTOverDrive:'E_NAKcr'\n"'LF'SmartSend "'E_NAKcr'"'LF'Jump do_emsi.2'LF
emsiBUF=emsiBUF'do_emsi.11:'LF

emsiBUF=emsiBUF'Set RC $(emsiOD)'LF'FalseJump do_emsi.2'LF
emsiBUF=emsiBUF'Set emsiRT TRUE'LF
emsiBUF=emsiBUF'Print "\r\nEmsi OverDrive:WHACKing\n"'LF'SmartSend "\r~\r~\r~\r"'LF
emsiBUF=emsiBUF'Print "\r\nEmsi OverDrive:Delay 5\n"'LF'Delay 5'LF
emsiBUF=emsiBUF'Print "\r\nEmsi OverDrive:'E_INQSEQ'\n"'LF'SmartSend "'E_INQSEQ'"'LF
emsiBUF=emsiBUF'do_emsi.2:'LF||emsi_ext();drop ee
emsiBUF=emsiBUF'Set sentflags "Link:$(host.link) Compat:$(host.compat)"'LF
emsiBUF=emsiBUF'Print "Outbound EMSI\n"'LF'XprSetup xpremsi.library ""'LF'XprSend ""'LF'XprClose'LF
emsiBUF=emsiBUF'set RC $(EMSI)'LF'FalseJump bademsi_hs'LF
emsiBUF=emsiBUF||logf'EMSI HandShake OK $(remote.akas)"'LF
emsiBUF=emsiBUF||logw'$(p.session) EMSI_REQ"'LF
if FIXDOMAIN then do
/*if RP then emsiBUF=emsiBUF'Address REXX "RPDIR:EMSICVT.wplrx C $(remote.akas)"'LF */
/*else emsiBUF=emsiBUF'Address REXX "$(rexxdir)EMSICVT.wplrx C $(remote.akas)"'LF */
if RP then emsiBUF=emsiBUF'Address REXX "RPDIR:EMSICVT.wplrx C $(called) $(remote.akas)"'LF
else emsiBUF=emsiBUF'Address REXX "$(rexxdir)EMSICVT.wplrx C $(called) $(remote.akas)"'LF
emsiBUF=emsiBUF||logf'EMSI akas Converted:$(remote.akas)"'LF
end;else if FIXKNOWN then do
/*if RP then emsiBUF=emsiBUF'Address REXX "RPDIR:EMSICVT.wplrx K $(remote.akas)"'LF */
/*else emsiBUF=emsiBUF'Address REXX "$(rexxdir)EMSICVT.wplrx K $(remote.akas)"'LF */
if RP then emsiBUF=emsiBUF'Address REXX "RPDIR:EMSICVT.wplrx K $(called) $(remote.akas)"'LF
else emsiBUF=emsiBUF'Address REXX "$(rexxdir)EMSICVT.wplrx K $(called) $(remote.akas)"'LF
emsiBUF=emsiBUF||logf'Known EMSI akas Converted:$(remote.akas)"'LF
end

/*emsiBUF=emsiBUF'RexxMsg SY,RY REXX "t=\"$(Called)\";return t\" \"delstr(\"$(remote.akas)\",pos(t,upper(\"$(remote.akas)\")),length(t)+1)"'LF  */
/*emsiBUF=emsiBUF'RexxMsg SY,RY REXX "t=upper(\"$(Called)\");if upper(word(\"$(remote.akas)\",1))=t then return \"$(remote.akas)\";else return t\" \"delstr(\"$(remote.akas)\",pos(t,upper(\"$(remote.akas)\")),length(t)+1)"'LF */
/*emsiBUF=emsiBUF'Set remote.akas $(RESULT2)'LF */

emsiBUF=emsiBUF'Pattern $(remote.compat) #?FNC#?'LF'FalseJump noOfnc'LF'Set FNC 1'LF
emsiBUF=emsiBUF'noOfnc:'LF'Pattern $(remote.link) #?HAT#?'LF'TrueJump hatemsi'LF
emsiBUF=emsiBUF'Seta Remote $(remote.akas)'LF
if ~WplrxDomainFix then emsiBUF=emsiBUF'SubJump ck_emsipoint'LF
emsiBUF=emsiBUF'Pattern $(remote.link) #?HXT#?'LF'FalseJump hxtemsi'LF
emsiBUF=emsiBUF'Set MinSendPri 60'LF
emsiBUF=emsiBUF'hxtemsi:'LF
if ~NoAKAS then do
  emsiBUF=emsiBUF'Set RC "$(akalist.'sindex')"'LF'FalseJump noakalist'LF
  emsiBUF=emsiBUF'BeginSession "$(akalist.'sindex')"'LF
  emsiBUF=emsiBUF'Set RC $(remote.freq)'LF'FalseJump hatemsi'LF
if FF then emsiBUF=emsiBUF'Set remote.akas "$(akalist.'sindex')"'LF'SubJump findfreqs'LF
else emsiBUF=emsiBUF'FindFreq "$(akalist.'sindex')"'LF'Set freq $(RC)'LF
  emsiBUF=emsiBUF'Jump hatemsi'LF
  emsiBUF=emsiBUF'noakalist:'LF'Set remote.akas "$(called)"'LF
  emsiBUF=emsiBUF'CmpI $(called) $(remote.address)'LF'TrueJump noakas.1'LF
  emsiBUF=emsiBUF'Set remote.akas "$(called) $(remote.address)"'LF
  emsiBUF=emsiBUF'noakas.1:'LF'BeginSession $(remote.akas)'LF
  emsiBUF=emsiBUF'Set RC $(remote.freq)'LF'FalseJump hatemsi'LF
if FF then emsiBUF=emsiBUF'SubJump findfreqs'LF
else  emsiBUF=emsiBUF'FindFreq $(remote.akas)'LF'Set freq $(RC)'LF

end;else do
  emsiBUF=emsiBUF'BeginSession "$(remote.akas) EMSI"'LF
  emsiBUF=emsiBUF'Set RC $(remote.freq)'LF'FalseJump hatemsi'LF
if FF then emsiBUF=emsiBUF'SubJump findfreqs'LF
else emsiBUF=emsiBUF'FindFreq $(called)'LF'Set freq $(RC)'LF
end
emsiBUF=emsiBUF'hatemsi:'LF
if forcesort then emsiBUF=emsiBUF'Set multihub TRUE'LF
emsiBUF=emsiBUF||logf'Called:$(called)"'LF||emsilog();drop el
emsiBUF=emsiBUF||GenProtocolSelect('Remote','Out');drop psBUF

if ~WplrxDomainFix then do
emsiBUF=emsiBUF'ck_emsipoint:'LF
emsiBUF=emsiBUF'CmpI $(remote.address) $(host.address)'LF'FalseReturn'LF
emsiBUF=emsiBUF'Set remote.point 0'LF'SetA Remote $(remote.domain)#$(remote.zone):$(remote.net)/$(remote.node).$(remote.point)'LF
emsiBUF=emsiBUF'Return'LF
end
Return

genwazoo:
call writech('STDOUT',"Installing Handshakes: FTS1 WAZOO ")
wzBUF='j_wazoo:'LF'System "Wazoo $(remote.wzcap) $(line).RYH"'LF
wzBUF=wzBUF||logw'$(p.remote) $(remote.address) $(p.rsysop) $(remote.sysop) $(remote.sitename) $(p.login) 'nameprod' v$(remote.product_maj).$(remote.product_min) $<time> $(p.rfreqs) $(remote.freq)"'LF
wzBUF=wzBUF||logf'System:[$(remote.sitename)][$(remote.address)] Sysop:$(remote.sysop) Mailer:'nameprod' v$(remote.product_maj).$(remote.product_min)"'LF
wzBUF=wzBUF'Set RC $(IsOutbound)'LF'FalseJump notin'LF
wzBUF=wzBUF||logw'$(p.hoffer) $(host.wzprot) $(host.wzext)" 'LF
wzBUF=wzBUF||logf'Our Offer: $(host.wzprot) $(host.wzext) $(host.wzdomain)"'LF
wzBUF=wzBUF'notin:'LF||logw'$(p.roffer)${$(line).RYH} $(p.domain) $(remote.wzdomain)"'LF
wzBUF=wzBUF||logf'Remote Offer:${$(line).RYH} $(remote.wzdomain)"'LF
wzBUF=wzBUF'checkwzcap:'LF'Cmp $(host.wzcap) 1'LF'FalseJump wazoo.1.0'LF'Jump wazoo.4'LF
wzBUF=wzBUF'wazoo.1.0:'LF'Cmp $(host.wzcap) 4'LF'FalseJump wazoo.1.1'LF'Jump wazoo.4'LF
wzBUF=wzBUF'wazoo.1.1:'LF'Cmp $(host.wzcap) 8'LF'FalseJump wazoo.1.11'LF'Jump wazoo.4'LF
wzBUF=wzBUF'wazoo.1.11:'LF'Cmp $(host.wzcap) 32'LF'FalseJump wazoo.1.2'LF'Jump wazoo.4'LF
wzBUF=wzBUF'wazoo.1.2:'LF'Set protocol NOCOMMON'LF'Jump badwazoo'LF
wzBUF=wzBUF'wazoo.4:'LF'Set protocol $(xp.$(host.wzcap)) RC $(IsOutbound)'LF'TrueJump sentwazoo'LF'SubJump 'l_mailer'!sethostadr'LF'SubJump 'l_mailer'!setremote'LF
wzBUF=wzBUF||logw'$(p.remote) $(remote.address) $(p.hoffer) $(host.wzprot) $(host.wzext)" 'LF
wzBUF=wzBUF||logf'Our Offer: $(host.wzprot) $(host.wzext) $(host.wzdomain)"'LF

wzBUF=wzBUF'Set RC 'idxpnum||LF'FalseJump wazoo.4.0'LF'Set pw CACHE listed 1 issecure TRUE remote.number 'idxphone||LF
wzBUF=wzBUF'CmpI $(password.'sindex') $(remote.password)'LF'TrueJump wazoo_password'LF'Jump badwazoo'LF
wzBUF=wzBUF'wazoo.4.0:'LF'Set pw DEFERRED inbound $(nonsecure)'LF
if umbrella then wzBUF=wzBUF'Set listed 0 inbound $(nonsecure) issecure FALSE'LF
wzBUF=wzBUF||logw'$(p.protocol) $(protocol) $(p.host) $(host.address) $(p.password) $(pw) $(p.inbound) NONSECURE"'LF'Set RC TRUE'LF'Return'LF
if ~umbrella then do
wzBUF=wzBUF'dolookup:'LF'Set pw LOOKUP systemcmd "$(lookup) $(remote.address) nodelist: $(line) "'LF'SubJump runsync'LF'Cmp $(RC) 0'LF'FalseJump wazoo_unlisted'LF
wzBUF=wzBUF'Set listed 1 remote.number ${$(line).number}'LF'Jump wazoo_nopassword'LF
wzBUF=wzBUF'wazoo_unlisted:'LF'Set listed 0 inbound $(nonsecure) issecure FALSE'LF
wzBUF=wzBUF||logf'$(remote.address) not in NodeList - Lookup:$(RC) $(listed)"'LF
wzBUF=wzBUF||logw'$(p.inbound) NONSECURE"'LF'Set RC $(LO)'LF'TrueJump badwazoo'LF
end
wzBUF=wzBUF'wazoo_nopassword:'LF'Set pw "$(pw) NONE"'LF'Jump goodwazoo'LF
wzBUF=wzBUF'wazoo_password:'LF'Set pw "$(pw) OK"'LF'Jump goodwazoo'LF
wzBUF=wzBUF'sentwazoo:'LF'Set pw "$(pw) SENT"'LF
wzBUF=wzBUF'goodwazoo:'LF||logf'Password $(pw) Selected: $(protocol) Host:$(host.address)"'LF
wzBUF=wzBUF||logw'$(p.protocol) $(protocol) $(p.host) $(host.address) $(p.password) $(pw) $(p.number) $(remote.number)"'LF'Clear pw'LF'Set RC TRUE'LF'Return'LF
wzBUF=wzBUF'badwazoo:'LF'Set pw "$(pw) BAD" inbound $(nonsecure) issecure FALSE'LF
wzBUF=wzBUF||logf'BADWAZOO Cap:$(host.wzcap) Selected:$(protocol) Password:$(pw) His:[$(remote.password)] Ours:[$(password.'sindex')][${$(line).password}]"'LF
wzBUF=wzBUF||logw'$(p.password) $(pw) $(p.protocol) $(protocol) $(p.number) $(remote.number) $(p.inbound) NONSECURE"'LF
wzBUF=wzBUF'Clear pw'LF'Set RC FALSE'LF'Return'LF
return

genxpr:
say;call writech('STDOUT',"Installing Protocols: ")
call writech('STDOUT',"Hydra ")
if power then do
    xprBUF=xprBUF'upld_detect:'LF'Set uto 60'LF
    xprBUF=xprBUF'Set txt "\r\nThis system automatically detects Zmodem or Hydra protocol startup.\r\n"'LF'SubJump showtxt'LF
    xprBUF=xprBUF'Set txt "Start your upload within $(uto) seconds or you will be returned to the main menu.\r\n"'LF'SubJump showtxt'LF
    xprBUF=xprBUF'upld.1:'LF'GetInbound E0 $(uto)'LF'Cmp $(event) LOGIN'LF'FalseJump DoMenu'LF
    xprBUF=xprBUF'Pattern $(namebuf) "#?(hydra|cA\f5\a3)#?"'LF'TrueJump HydraRecv'LF
    xprBUF=xprBUF'Pattern $(namebuf) "#?(rz|**)#?"'LF'TrueJump ZmodemRecv'LF
    xprBUF=xprBUF'Pattern $(namebuf) ""'LF'FalseJump DoMenu'LF
    xprBUF=xprBUF'Set uto 5'LF'Jump upld.1'LF

    xprBUF=xprBUF'HydraRecv:'LF
    if ROOFLOG then XPRBUF=XPRBUF||logus'$(filesin)"'LF
    xprBUF=xprBUF'Set protocol HYDRA session "UPLOAD" inbound $(userdir) remote.sysop $(username) remote.sitename UNKNOWN'LF
    xprBUF=xprBUF||logf'$(session) from $(username) at $(remote.address)"'LF
    xprBUF=xprBUF||logw'$(p.session) $(session) $(p.protocol) $(protocol) $(p.inbound) USER $(p.rsysop) $(remote.sysop)"'LF
    xprBUF=xprBUF'System "HydraCom >NIL: port $(unit) device $(device) speed $(baudlocked) line $(baud) handshake hard noinit receive $(inbound) result T:USER.SES$(line) log LOG:Hydra.LOG send"'LF
    xprBUF=xprBUF'SetStatus "$(openstatus)"'LF'Print "Getting upload descriptions\n"'LF
    xprBUF=xprBUF||logf'Getting upload descriptions from $(username)"'LF
    xprBUF=xprBUF'Address REXX "$(rexxdir)UserUL.wplrx $(line) $(username)"'LF
    xprBUF=xprBUF'Jump DoMenu'LF
end/*power*/
xprBUF=xprBUF'HydraBi:'LF'EndSession all'LF
if H_REQ1 then do
    xprBUF=xprBUF'Set RH1 0'LF'Pattern $(remote.link) "#?RH1#?"'LF'FalseJump noRH1'LF
    xprBUF=xprBUF'Set RH1 1'LF'noRH1:'LF
end
xprBUF=xprBUF||logw'$(p.protocol) Hydra"'LF
if RP then xprBUF=xprBUF'RexxMsg "" REXX "RPDIR:Xhydra.wplrx $(line) $(session) $(RH1) $(FNC) $(MinSendPri) $(inbound) $(outbound) $(remote.akas)"'LF
else xprBUF=xprBUF'RexxMsg "" REXX "$(rexxdir)Xhydra.wplrx $(line) $(session) $(RH1) $(FNC) $(MinSendPri) $(inbound) $(outbound) $(remote.akas)"'LF
xprBUF=xprBUF||showresult
xprBUF=xprBUF'ReplyCall 0'LF'Jump aftersession'LF
if (power | sendbull | sendbanner) then do
    call writech('STDOUT',"Ascii ")
    xprBUF=xprBUF'j_ascii_start:'LF'Set protocol ASCII fsend TRUE'LF'Send "'wclr||nl'"'LF'XprSetup "xprascii.library" "E1,RA,FA"'LF
    xprBUF=xprBUF'SetUpdate NULL'LF'Return'LF
    xprBUF=xprBUF'j_ascii_end:'LF'XprClose'LF||flush
if ROOFLOG then xprBUF=xprBUF||logus'$(filesout)"'LF
    xprBUF=xprBUF'Clear protocol'LF'Return'LF
end   

if power then do
call writech('STDOUT',"Zmodem ")
xprBUF=xprBUF'zmodemsend:'LF'Set protocol ZMODEM session DOWNLOAD fsend TRUE'LF
xprBUF=xprBUF'XprSetup "xprzedzap.library" "B8,E10,SY,M1024,ZN,NN,C$(BAUD)"'LF
xprBUF=xprBUF'SubJump xprdisplay'LF
xprBUF=xprBUF'XprSetFile $($(namebuf).full) $($(namebuf).file) ""'LF'XprSend $($(namebuf).file)'LF'XprClose'LF'SetUpdate NULL'LF||flush
if ROOFLOG then xprBUF=xprBUF||logus'$(filesout)"'LF
xprBUF=xprBUF'Clear protocol session'LF'Return'LF

xprBUF=xprBUF'zmodemrecv:'LF'Set RC $(user)'LF'TrueJump zmrcv.1'LF'Set username USER remote.address "USER#0:0/0.0"'LF'SetA remote $(remote.address)'LF'Set remote.network FIDO'LF
xprBUF=xprBUF'zmrcv.1:'LF
if ROOFLOG then xprBUF=xprBUF||logus'$(filesin)"'LF
xprBUF=xprBUF'Set protocol ZMODEM session "UPLOAD" inbound $(userdir) remote.sysop $(username) remote.sitename UNKNOWN 'LF'BeginSession $(remote.address)'LF
xprBUF=xprBUF||logf'$(session) from $(username) at $(remote.address)"'LF
xprBUF=xprBUF||logw'$(p.session) $(session) $(p.protocol) $(protocol) $(p.inbound) USER $(p.rsysop) $(remote.sysop)"'LF'Jump zedzapin'LF
end

call writech('STDOUT',"DirectZap ")
xprBUF=xprBUF'directzapout:'LF
xprBUF=xprBUF'SetMailerFlags DN'LF'Set protocol DirectZap'LF
if ~NoResume then xprBUF=xprBUF'SubJump 'notifylabel'GetResume'LF
xprBUF=xprBUF'XprSetup xprzedzap.library C$(Baud),ZY,QY'LF
xprBUF=xprBUF'SubJump xprdisplay'LF'Jump xprout'LF 

xprBUF=xprBUF'directzapin:'LF
xprBUF=xprBUF'SetMailerFlags DN'LF'Set protocol DirectZap'LF
if ~NoResume then xprBUF=xprBUF'SubJump 'notifylabel'GetResume'LF
xprBUF=xprBUF'XprSetup xprzedzap.library C$(Baud),QY,ZY'LF
xprBUF=xprBUF'SubJump xprdisplay'LF'Jump xprin'LF

call writech('STDOUT',"ZedZip ")
xprBUF=xprBUF'zedzipin:'LF'SetMailerFlags DE'LF'Set protocol ZedZip'LF
if ~NoResume then xprBUF=xprBUF'SubJump 'notifylabel'GetResume'LF
xprBUF=xprBUF'XprSetup xprzedzap.library NN,M1024,C$(Baud)'LF
xprBUF=xprBUF'SubJump xprdisplay'LF'Jump xprin'LF

xprBUF=xprBUF'zedzipout:'LF'SetMailerFlags DN'LF'Set protocol ZedZip'LF
if ~NoResume then xprBUF=xprBUF'SubJump 'notifylabel'GetResume'LF
xprBUF=xprBUF'XprSetup xprzedzap.library NN,M1024,C$(Baud)'LF
xprBUF=xprBUF'SubJump xprdisplay 'LF'Jump xprout'LF

call writech('STDOUT',"ZedZap ")
xprBUF=xprBUF'zedzapin:'LF'SetMailerFlags DN'LF'Set protocol ZedZap'LF
if ~NoResume then xprBUF=xprBUF'SubJump 'notifylabel'GetResume'LF
xprBUF=xprBUF'XprSetup xprzedzap.library KN,C$(Baud)'LF
xprBUF=xprBUF'SubJump xprdisplay'LF
xprBUF=xprBUF'zmodemin:'LF'Jump xprin'LF

xprBUF=xprBUF'zedzapout:'LF'SetMailerFlags DN'LF'Set protocol ZedZap'LF
if ~NoResume then xprBUF=xprBUF'SubJump 'notifylabel'GetResume'LF
xprBUF=xprBUF'XprSetup xprzedzap.library KN,C$(Baud)'LF
xprBUF=xprBUF'SubJump xprdisplay'LF
xprBUF=xprBUF'zmodemout:'LF'Jump xprout'LF


call writech('STDOUT',"SeaLink ")
xprBUF=xprBUF'sealinkout:'LF'XprSetup xprslk.library ""'LF
xprBUF=xprBUF'SetMailerFlags DN'LF'Set protocol Sealink'LF'SubJump xprdisplay'LF'Jump xprout'LF

xprBUF=xprBUF'sealinkin:'LF'XprSetup xprslk.library ""'LF
xprBUF=xprBUF'SetMailerFlags DN'LF'Set protocol Sealink'LF'SubJump xprdisplay'LF'Jump xprin'LF

call writech('STDOUT',"Lotek ")
xprBUF=xprBUF'lotekout:'LF
if FF then xptBUF=xprBUF'Set remote.akas $(called)'LF'SubJump findfreqs'LF
else xprBUF=xprBUF'FindFreq $(called)'LF'Set freq $(RC)'LF
xprBUF=xprBUF'SetMailerFlags DY'LF'Set protocol Lotek'LF'Jump xmodemout'LF
xprBUF=xprBUF'lotekin:'LF'SetMailerFlags DY'LF'XprSetup xprfts.library "7Y,CY,OB,IB,SY,BN,AN,NY,WY,FY"'LF'Set protocol Lotek'LF'Jump xmodemin'LF
call writech('STDOUT',"DietIFNA ")
xprBUF=xprBUF'dietifnaout:'LF'SetMailerFlags DY'LF'Set protocol DietIFNA'LF
call writech('STDOUT',"Xmodem ")
xprBUF=xprBUF'xmodemout:'LF||logf'$(protocol) ftsflags: 'ftsprod'"'LF
xprBUF=xprBUF'XprSetup xprfts.library "'ftsprod'"'LF
xprBUF=xprBUF'e_xmodemout:'LF
xprBUF=xprBUF'SubJump xprdisplay'LF'Jump xpr_send'LF

xprBUF=xprBUF'dietifnain:'LF'SetMailerFlags DY'LF'Set protocol DietIFNA'LF||logf'$(protocol) ftsflags: 'ftsprod'"'LF
xprBUF=xprBUF'XprSetup xprfts.library "'ftsprod'"'LF
xprBUF=xprBUF'xmodemin:'LF'SubJump xprdisplay'LF'Jump xpr_recv'LF

xprBUF=xprBUF'j_xprdisplay:'LF
xprBUF=xprBUF||logf'$(protocol) Setup:$(XprSetup) RC:$(RC)"'LF'SetPri $(xferpri)'LF'Set RC $(showxpr)'LF'FalseReturn'LF
xprBUF=xprBUF'SetUpDate "RAW:0/$(w_offset)/640/130/Line $(line) $(protocol) $(session) $(remote.domain) $(remote.zone) $(remote.net) $(remote.node) $(remote.point) $(remote.sysop) $(remote.sitename)/AUTO/INACTIVE/NOCLOSE/NOSIZE/SCREEN$(pscreen)"'LF
xprBUF=xprBUF'SetStatus NULL:'LF'Return'LF

xprBUF=xprBUF'xprout:'LF||logw'$(p.protocol) $(protocol)"'LF
xprBUF=xprBUF'XprSend ""'LF'Set SendRC $(RC)'LF
xprBUF=xprBUF'FalseJump xprend'LF
xprBUF=xprBUF'Set RC $(nopickup)'LF'TrueJump xprend'LF
xprBUF=xprBUF'xpr_recv:'LF'XprReceive ""'LF'Set RecvRC $(RC)'LF
xprBUF=xprBUF'Jump xprend'LF

xprBUF=xprBUF'xprin:'LF||logw'$(p.protocol) $(protocol)"'LF
if ~NoResume then xprBUF=xprBUF'Set RC $(resume)'LF'FalseJump xprin_recv'LF||logf'Resuming"'LF
xprBUF=xprBUF'xprin_recv:'LF'XprReceive ""'LF'Set RecvRC $(RC)'LF
xprBUF=xprBUF'FalseJump xprend'LF
if power then xprBUF=xprBUF'Cmp $(session) UPLOAD'LF'TrueJump xprend'LF
xprBUF=xprBUF'xpr_send:'LF'XprSend ""'LF'Set SendRC $(RC)'LF
xprBUF=xprBUF'j_xprend:'LF'XprClose'LF'SetUpdate NULL'LF||logf'$(remote.address) $(protocol) Send:$(SendRC) Recv:$(RecvRC) Close:$(RC) Min:$(MinSendPri) Max:$(MaxSendPri)"'LF'ReplyCall 0'LF'EndSession all'LF
if power then xprBUF=xprBUF'Cmp $(session) UPLOAD'LF'TrueJump xprdesc'LF
if ROOFLOG then xprBUF=xprBUF'set tmp $(ftnin)'LF'Set RC $(IsOutbound)'LF'FalseJump setss'LF'Set tmp $(ftnout)'LF'setss:'LF||logus'$(tmp)"'LF
xprBUF=xprBUF'Jump aftersession'LF
if power then do
xprBUF=xprBUF'xprdesc:'LF
if sc_user then xprBUF=xprBUF'SetStatus "$(openstatus)"'LF'Print "Getting upload descriptions\n"'LF
if addfreq then do
xprBUF=xprBUF'RexxMsg "SY,RY" REXX "return upper(translate(\"$(username)\",\"_\",\" \"))" 'LF
xprBUF=xprBUF'Pattern $(remfile) #?$(result2).GRAB'LF'FalseJump xprdesc.1'LF||logf'Received GRAB request from $(username)"'LF'Set namebuf GRAB'LF'Jump loadwplrx'LF
end
xprBUF=xprBUF'xprdesc.1:'LF||logf'Getting upload descriptions from $(username)"'LF
xprBUF=xprBUF'Address REXX "$(rexxdir)UserUL.wplrx $(line) $(username)"'LF'Jump DoMenu'LF
end
return

genclock:
call writech('STDOUT',"CLOCK ")
clkBUF=';WPLSCRIPT 'l_mailer'clock'LF'clockcall:'LF
if sc_connect then clkBUF=clkBUF'SetStatus $(openstatus)'LF
clkBUF=clkBUF'Print "Switching to $(baud.'sindex')bps for $(sitename.'sindex') 'idxphone'\n"'LF
clkBUF=clkBUF'Print "$(baud.$(remote.address) $(xprsetup.'sindex')\n"'LF
clkBUF=clkBUF'SetBaud $(baud.'sindex')'LF'ModemInit'LF'Set state "DIALING $(remote.address)" protocol "XprClock"'LF
clkBUF=clkBUF||logw'$(p.status) $(state) $(p.baud) $(Baud) $(p.number) 'idxphone' $(p.remote) $(sitename.$(remote.address)) $(p.session) $(xprsetup.'sindex')"'LF
if ROOFLOG then clkBUF=clkBUF||logrl'Calling $(sitename.'sindex') @ 'idxphone'"'LF
clkBUF=clkBUF'SmartSend "|~~ATDT'idxphone'|"'LF'GetResponse 60'LF
clkBUF=clkBUF||logw'$(p.response) $(event) $(LastResponse)"'LF
clkBUF=clkBUF'Cmp $(event) CONNECT'LF'TrueJump clockconnect'LF'Cmp $(event) BUSY'LF'Set dialrc 5'LF'TrueJump clockexit'LF'Set dialrc 11'LF'Jump clockexit'LF
clkBUF=clkBUF'clockconnect:'LF'SetPri $(xferpri)'LF
clkBUF=clkBUF'Set state "OUTBOUND $(sitename.'sindex')"'LF
clkBUF=clkBUF||logw'$(p.status) $(state) $(p.protocol) $(protocol)"'LF
clkBUF=clkBUF||logf'CLOCKconnect:$(remote.address) $(LastResponse)[$(Baud)]"'LF
clkBUF=clkBUF'XprSetup xprclock.library "$(xprsetup.'sindex')"'LF
if showxpr then clkBUF=clkBUF'SetUpDate "RAW:0/$(w_offset)/640/130/Line $(line) $(protocol) $(session)/AUTO/INACTIVE/NOCLOSE/NOSIZE/SCREEN$(pscreen)"'LF
clkBUF=clkBUF'XprSend ""'LF'Set clockrc $(RC)'LF'XprClose'LF'Cmp $(clockrc) 1'LF'TrueJump clockset'LF
clkBUF=clkBUF'Set dialrc 15'LF||logf'ERROR Clock NOT Set"'LF
if ROOFLOG then clkBUF=clkBUF||logrl'$(protocol) ERROR Clock NOT Set"'LF
clkBUF=clkBUF'clockexit:'LF'SetUpdate NULL'LF'SmartSend "|~~AT|"'LF'Print "Switching back to $(LockedRate)bps\n"'LF
clkBUF=clkBUF'SetBaud $(LockedRate)'LF'SmartSend "|~~AT|"'LF'ReplyCall $(dialrc)'LF'SetStatus NULL:'LF
clkBUF=clkBUF'Clear tbaud dialrc clockrc'LF'Return 'LF
clkBUF=clkBUF'clockset:'LF'Set dialrc 0'LF'SubJump clockexit'LF'System "SetClock save"'LF
clkBUF=clkBUF||logf'Clock Set"'LF
if ROOFLOG then clkBUF=clkBUF||logrl'Clock Set"'LF
clkBUF=clkBUF'Return'LF

call open('clk',clockwpl,"W");call writech('clk',clkBUF);call close('clk')
drop clk clkBUF
Say;Say "Wrote "clockwpl
return


gendialer:
if umbrella | ~domodules then say
call writech('STDOUT',"Installing Dialers: FTN ")
dlBUF=dlBUF'setmanual:'LF'Set RC $(MANUAL)'LF'FalseReturn'LF'Set remote.number $(number)'LF
dlBUF=dlBUF||logf'Manual poll: $(remote.address) $(remote.number)"'LF
dlBUF=dlBUF||logw'$(p.remote) $(remote.address) $(p.number) $(remote.number)"'LF'Clear manual number'LF'Set RC TRUE'LF'Return'LF
dlBUF=dlBUF'line_check:'LF'Set RC $(line.'sindex')'LF'FalseJump dial_site'LF'Cmp $(line.'sindex') $(line)'LF'TrueJump dial_site'LF
dlBUF=dlBUF||logf'$(remote.address) UseLine:$(line.'sindex')"'LF
dlBUF=dlBUF'CallForward 'u_mailer'$(line.'sindex')'LF'ReplyCall 7'LF'Jump freeline'LF

dlBUF=dlBUF'ckpresess:'LF'Cmp "$(presess.'sindex')" ""'LF'TrueReturn'LF
dlBUF=dlBUF||logw'$(p.status) PreSession: $(presess.'sindex')"'LF
dlBUF=dlBUF||logf'PreSession: $(presess.'sindex') loading for $(remote.address)"'LF
dlBUF=dlBUF'RexxMsg SY REXX "Address COMMAND \"$(presess.'sindex')\""'LF'Set dialrc $(result1)'LF
dlBUF=dlBUF||logf'PreSession RC:$(RC) $(dialrc)"'LF
dlBUF=dlBUF'Return'LF

dlBUF=dlBUF'dialftn:'LF'Set state "DIALING FTN $(remote.address)"'LF
if addspeech then dlBUF=dlBUF'Set sl 70 speech $(state)'LF'SubJump 'l_mailer'!sayit'LF
dlBUF=dlBUF'Set ncount.$(remote.address) 'idxpnum' remote.number 'nctphone||LF
if wpldebug then dlBUF=dlBUF||logf'GET_NUMBER:$(ncount.$(remote.address)) $(remote.address) $(remote.number)"'LF
dlBUF=dlBUF||logw'$(p.status) $(state)"'LF'ModemClear'LF
if ~LooseZMH then do
dlBUF=dlBUF||proczmh'FalseJump notzmhdial'LF
dlBUF=dlBUF'Set host.link "8N1,HXT"'LF
dlBUF=dlBUF'notzmhdial:'LF
end

dlBUF=dlBUF'SubJump 'l_mailer'!sethostadr'LF'SubJump setmanual'LF'TrueJump dial_site'LF
dlBUF=dlBUF'dodial.0:'LF||logf'$(state)"'LF
dlBUF=dlBUF'Set RC 'idxpnum||LF
if umbrella then dlBUF=dlBUF'FalseJump nonumber'LF'SubJump getcached'LF'Jump line_check'LF
else do
dlBUF=dlBUF'FalseJump ftn_lookup'LF'SubJump getcached'LF'Jump line_check'LF
dlBUF=dlBUF'ftn_lookup:'LF'Set systemcmd "$(lookup) $(remote.address) nodelist: $(line) "'LF
dlBUF=dlBUF'SubJump runsync'LF'TrueJump nonumber'LF'SubJump getlookup'LF'Jump dial_site'LF
end
if addhost then dlBUF=dlBUF'dialforward:'LF'CallForward 'u_mailer'1'LF'Jump aftersession'LF

if addclock then do
call writech('STDOUT',"CLOCK ")
dlBUF=dlBUF'dialclock:'LF
if addspeech then dlBUF=dlBUF'Set sl 70 speech "Calling Atomic Clock $(remote.sitename)"'LF'SubJump 'l_mailer'!sayit'LF
dlBUF=dlBUF'ModemClear'LF'LoadScript clock CFG:WPL/'l_mailer'CLOCK.WPL'LF'SubJump clock!clockcall'LF'LoadScript clock ""'LF'Jump dodial_exit'LF
end

if addbbs then do
call writech('STDOUT',"BBS ")
dlBUF=dlBUF'dialbbs:'LF'Set state "DIALING BBS $(remote.address)" term TRUE'LF
if addspeech then dlBUF=dlBUF'Set sl 70 speech $(state)'LF'SubJump 'l_mailer'!sayit'LF
dlBUF=dlBUF||logw'$(p.status) $(state)"'LF'ModemCLear'LF'SubJump setmanual'LF'TrueJump dial_site'LF
dlBUF=dlBUF'dialbbs.0:'LF'Set RC 'idxpnum||LF'FalseJump nonumber'LF'SubJump getuucached'LF'Jump line_check'LF
dlBUF=dlBUF'bbsconnect:'LF
if ROOFLOG then dlBUF=dlBUF||logus'$(bbsout)"'LF
dlBUF=dlBUF'SubJump ckpresess'LF'Cmp dialrc 5'LF'TrueJump dodial_exit'LF
dlBUF=dlBUF'Set systemcmd "$(term.'sindex')"'LF'SubJump runasync'LF'ReplyCall 0'LF'Jump aftersession'LF
end

if addfax then do
call writech('STDOUT',"FAX ")
dlBUF=dlBUF'dialfax:'LF'Set state "DIALING FAX $(remote.address)" fax TRUE'LF
if addspeech then dlBUF=dlBUF'Set sl 70 speech $(state)'LF'SubJump 'l_mailer'!sayit'LF
dlBUF=dlBUF||logw'$(p.status) $(state)"'LF
dlBUF=dlBUF'ModemClear'LF'SubJump setmanual'LF'TrueJump faxconnect'LF
dlBUF=dlBUF'dialfax.0:'LF
dlBUF=dlBUF'Set RC 'idxpnum||LF'FalseJump nonumber'LF
dlBUF=dlBUF'SubJump getuucached'LF
dlBUF=dlBUF'Jump faxconnect'LF
end

if adduucp then do
call writech('STDOUT',"UUCP ")
dlBUF=dlBUF'dialuucp:'LF'Set state "DIALING UUCP $(remote.address)"'LF
if addspeech then dlBUF=dlBUF'Set sl 70 speech $(state)'LF'SubJump 'l_mailer'!sayit'LF
dlBUF=dlBUF||logw'$(p.status) $(state)"'LF'SubJump 'l_mailer'!sethostadr'LF'ModemClear'LF'SubJump setmanual'LF'TrueJump dial_site'LF
dlBUF=dlBUF'dialuucp.0:'LF
dlBUF=dlBUF'Set RC 'idxpnum||LF'FalseJump uucp_lookup'LF'SubJump getuucached'LF'Jump line_check'LF
dlBUF=dlBUF'uucp_lookup:'LF'SubJump getuulookup'LF'Cmp $(remote.number) ""'LF'TrueJump nonumber'LF'Jump dial_site'LF
end

dlBUF=dlBUF'dodial:'LF'SubJump cleargui'LF
if addclock then dlBUF=dlBUF'Pattern $(remote.address) CLOCK#?'LF'TrueJump dialclock'LF
if addbbs then dlBUF=dlBUF'Pattern $(remote.address) BBS#?'LF'TrueJump dialbbs'LF
if addfax then dlBUF=dlBUF'Pattern $(remote.address) FAX#?'LF'TrueJump dialfax'LF
if addhost then dlBUF=dlBUF'Cmp $(remote.network) TEXT'LF'TrueJump dialforward'LF
if adduucp then dlBUF=dlBUF'Cmp $(remote.network) UUCP'LF'TrueJump dialuucp'LF
dlBUF=dlBUF'Jump dialftn'LF
dlBUF=dlBUF'dial_site:'LF
dlBUF=dlBUF'Set RC "$(predial.'sindex')"'LF'FalseJump nopredial'LF
dlBUF=dlBUF'Set systemcmd "$(predial.'sindex')"'LF'SubJump runsync'LF
dlBUF=dlBUF'nopredial:'LF
dlBUF=dlBUF'Set dial $(DialString) RC $(dial.'sindex')'LF'FalseJump dial_mdm'LF'Set dial $(dial.'sindex')'LF

dlBUF=dlBUF'dial_mdm:'LF
if sc_dial then dlBUF=dlBUF'SetStatus $(openstatus)'LF'Print "Dialing $(remote.sitename)\n"'LF
dlBUF=dlBUF'SmartSend "$(dial)$(remote.number)|"'LF'Clear ProgressString'LF
dlBUF=dlBUF'getdialresponse:'LF'GetResponse $(responsetimeout)'LF
dlBUF=dlBUF||genprogress('dial')
drop proBUF
dlBUF=dlBUF||logw'$(p.status) $(state) $(LastResponse) $(p.response) $(event) $(p.baud) $(Baud)"'LF
dlBUF=dlBUF||logf'$(remote.address) $(LastResponse) $(event)"'LF
if addfax then dlBUF=dlBUF'Cmp $(event) FAX'LF'TrueJump faxconnect'LF
dlBUF=dlBUF'Cmp $(event) VOICE'LF'TrueJump voiceconnect'LF
dlBUF=dlBUF'Cmp $(event) BUSY'LF'TrueJump dodial_alternate'LF
if ~noanswer then do
dlBUF=dlBUF'Cmp $(event) RING'LF'FalseJump dt.0'LF
dlBUF=dlBUF||logf'Got Ring during dial"'LF
dlBUF=dlBUF||logw'$(p.status) Inbound call Dial interrupt"'LF
dlBUF=dlBUF'ReplyCall 5'LF'Set RC ${NOANSWER}'LF'FalseJump answerthering'LF
dlBUF=dlBUF'Print "Ring during dial IGNORED\n"'LF'Jump freeline'LF
dlBUF=dlBUF'answerthering:'LF'set txt "'nl'  Welcoming you despite the fact you interrupted my dialing out'nl'"'LF'SubJump 'l_mailer'!fidonethost'LF'Jump answerondial'LF
end
dlBUF=dlBUF'dt.0:'LF'Cmp $(event) NOMODEM'LF'FalseJump dt.1'LF'ReplyCall 10'LF'Jump slaveloop'LF
dlBUF=dlBUF'dt.1:'LF'Cmp $(event) OWNDEVUNIT'LF'FalseJump dt.2'LF'ReplyCall 1'LF'Jump freeline'LF
dlBUF=dlBUF'dt.2:'LF'Cmp $(event) CARRIER'LF'FalseJump dt.3'LF'ReplyCall 11'LF'Jump lost_carrier'LF
dlBUF=dlBUF'dt.3:'LF'Cmp $(event) TIMEOUT'LF'FalseJump dt.4'LF'Set dialrc 12'LF'Jump dodial_exit'LF'Set dialrc $(RC)'LF
dlBUF=dlBUF'dt.4:'LF||logf'Dialrc:$(dialrc) RC:$(RC) Event:[$(event)] Modem:[$(LastResponse)]"'LF'Jump dodial_exit'LF
dlBUF=dlBUF'nonumber:'LF'Set dialrc 6'LF||logf'No phone number for $(remote.address)"'LF'Jump dodial_exit'LF
dlBUF=dlBUF'dodial_alternate:'LF

dlBUF=dlBUF'Set RC $(MANUAL)'LF'TrueJump return_busy'LF
dlBUF=dlBUF'SubJump get_altnum'LF'FalseJump return_busy'LF
dlBUF=dlBUF'WaitEvent $(altdialdelay)'LF'Set RC $(BREAKE)'LF'TrueJump return_busy'LF
dlBUF=dlBUF||logf'Dialing $(remote.address) alternate:$(ncount.$(remote.address)) $(remote.number)"'LF
dlBUF=dlBUF||logw'$(p.number) $(remote.number)"'LF
dlBUF=dlBUF'Jump dial_site'LF
dlBUF=dlBUF'return_busy:'LF'Set dialrc 5'LF
dlBUF=dlBUF'dodial_exit:'LF'ReplyCall $(dialrc)'LF'Jump freeline'LF

dlBUF=dlBUF'dialconnect:'LF
dlBUF=dlBUF'SubJump ckpresess'LF'Cmp dialrc 5'LF'TrueJump dodial_exit'LF
dlBUF=dlBUF'Set session OUTBOUND state "SESSION $(session) $(remote.address) $(LastResponse) $(ProgressString)"'LF
dlBUF=dlBUF||utc
if sc_connect then dlBUF=dlBUF'SetStatus "$(openstatus)"'LF'Print "$(session)\n"'LF
dlBUF=dlBUF||logw'$(p.baud) $(Baud) $(p.status) $(session):$(LastResponse) $(ProgressString)"'LF
if ROOFLOG then dlBUF=dlBUF||logcs'$(calltask.$(remote.address)) $(line) $(callcount.$(remote.address)) $(callstart.$(remote.address)) $<time> ??:??:?? $(remote.address) CONNECTED"'LF
dlBUF=dlBUF||logf'DIALconnect:$(remote.address) $(LastResponse) $(ProgressString)[$(Baud)]"'LF
if ROOFLOG then dlBUF=dlBUF||logus'$(callsout)"'LF
if addbbs then dlBUF=dlBUF'Set RC $(term)'LF'TrueJump bbsconnect'LF
if adduucp then dlBUF=dlBUF'Cmp $(remote.network) UUCP'LF'TrueJump uucpconnect'LF
dlBUF=dlBUF'Set called $(remote.address)'LF
dlBUF=dlBUF'Set RC $(useakasout.'sindex')'LF'FalseJump dialconnect.1'LF
dlBUF=dlBUF'Set RC "$(akalist.$(si.$(remote.number)))"'LF'FalseJump dialconnect.1'LF
dlBUF=dlBUF'Set called "$(akalist.$(si.$(remote.number)))"'LF
dlBUF=dlBUF'dialconnect.1:'LF'Set MinSendPri 0'LF
dlBUF=dlBUF'Set RC $(crash)'LF'FalseJump dc.0'LF'Set MinSendPri 50'LF
dlBUF=dlBUF'dc.0:'LF'BeginSession $(called)'LF'SetPri $(negopri)'LF
dlBUF=dlBUF'Set host.wzext "-Freq +Domain" host.freq FALSE'LF
if usexflo then do
if exists('RPDIR:XFLO') then dlBUF=dlBUF'Set systemcmd "XFLO $(outbound) $(host.address) $(called)"'LF
else dlBUF=dlBUF'Set systemcmd "Rx $(rexxdir)XFLO.rexx $(outbound) $(host.address) $(called)"'LF
dlBUF=dlBUF'SubJump runsync'LF
end

dlBUF=dlBUF'Set RC $(doemsi)'LF'FalseJump gethandshake'LF
dlBUF=dlBUF'Cmp $(OutFlags.'sindex') ""'LF'TrueJump dc.2'LF
dlBUF=dlBUF'Pattern $(OutFlags.'sindex') "#?DE#?"'LF
dlBUF=dlBUF'FalseJump dc.1'LF'Set emsiOD TRUE'LF'Jump dc.2'LF
dlBUF=dlBUF'dc.1:'LF'Pattern $(OutFlags.'sindex') "#?GE#?"'LF
dlBUF=dlBUF'FalseJump gethandshake'LF

dlBUF=dlBUF'dc.2:'LF
if primary then dlBUF=dlBUF'Set host.akas $(host.aka.$(host.domain))'LF
else dlBUF=dlBUF'Set host.akas "'strip(myakas)'"'LF

dlBUF=dlBUF'Cmp $(present.'sindex') ""'LF'TrueJump do_emsi'LF
dlBUF=dlBUF'Set host.akas "$(present.'sindex')"'LF
dlBUF=dlBUF'Jump do_emsi'LF

dlBUF=dlBUF'bademsi_hs:'LF
dlBUF=dlBUF'Set RC $(emsiOD)'LF'FalseJump bademsi_hs2'LF
dlBUF=dlBUF'Print "\r\nRetry Bad Emsi OverDrive:'E_NAKcr||E_REQcr'\n"'LF
dlBUF=dlBUF'SmartSend "'E_NAKcr||E_REQcr'"'LF'Jump nood'LF
dlBUF=dlBUF'bademsi_hs2:'LF||logf'EMSI failed $(remote.address), trying $(OutFlags.$(line))"'LF

dlBUF=dlBUF'gethandshake:'LF
dlBUF=dlBUF'Set OutFlags $(OutFlags.$(line))'LF
dlBUF=dlBUF'Cmp $(OutFlags.'sindex') ""'LF'TrueJump gh.0'LF
dlBUF=dlBUF'Set OutFlags $(OutFlags.'sindex')'LF
dlBUF=dlBUF'gh.0:'LF

dlBUF=dlBUF'Set RC $(emsiOD)'LF'FalseJump nood'LF
dlBUF=dlBUF'Print "\r\nGetOutbound EMSI OverDrive:'E_INQSEQ'\n"'LF
dlBUF=dlBUF'SmartSend "'E_INQSEQ'"'LF
dlBUF=dlBUF'nood:'LF

dlBUF=dlBUF'Clear event'LF'GetOutbound $(OutFlags)'LF
dlBUF=dlBUF||logf'$(event):[$(namebuf)] $(called)"'LF
dlBUF=dlBUF||logw'$(p.login) $(event) $<time> $(p.hfreqs) $(host.freq) $(p.session) $(event) $(p.roffer) $(namebuf)"'LF
dlBUF=dlBUF'Pattern $(namebuf) #?EMSI#?'LF'TrueJump do_emsiN'LF
dlBUF=dlBUF'Pattern $(event) #?EMSI#?'LF'TrueJump do_emsi'LF
dlBUF=dlBUF'Cmp $(event) WAZOO'LF'TrueJump do_wazoo'LF
dlBUF=dlBUF'Cmp $(event) FTS1'LF'TrueJump do_fts1'LF
dlBUF=dlBUF'Jump bad_handshake'LF

dlBUF=dlBUF'do_fts1:'LF'Set protocol FTS1 FTS1 TRUE'LF'Jump lotekout'LF
dlBUF=dlBUF'do_wazoo:'LF
dlBUF=dlBUF'Set remote.akas $(called)'LF
dlBUF=dlBUF'CmpI $(called) $(remote.address)'LF'TrueJump do_wazoo.1'LF
dlBUF=dlBUF'Set remote.akas "$(called) $(remote.address)"'LF

dlBUF=dlBUF||logf'Called:$(called) Got:$(remote.address)"'LF
dlBUF=dlBUF'do_wazoo.1:'LF'Set IsOutbound TRUE'LF'SubJump wazoo'LF
dlBUF=dlBUF'Set RC $(remote.freq)'LF'TrueJump dofreqs'LF
dlBUF=dlBUF||logf'Freqs disabled at $(called)"'LF
/*
dlBUF=dlBUF'Set RC $(forcefreqs)'LF'FalseJump getwzcap'LF
dlBUF=dlBUF||logf'Sending REQ anyways"'LF'Jump dofreqs'LF
*/
dlBUF=dlBUF'Jump getwzcap'LF

if FF then do
dlBUF=dlBUF'findfreqs:'LF
if RP & exists("RPDIR:FINDFREQS.wplrx") then dlBUF=dlBUF'Address REXX "RPDIR:FINDFREQS.wplrx $<port> 'loggroup' $(outbound) $(remote.akas)"'LF
else dlBUF=dlBUF'Address REXX $(rexxdir)FINDFREQS.wplrx $<port> 'loggroup' $(outbound) $(remote.akas)"'LF
dlBUF=dlBUF||logf'FindFreqs RC:$(RC) RESULT1:$(RESULT1) RESULT2:$(RESULT2)"'LF
dlBUF=dlBUF'Set freq $(RESULT1)'LF'Return'LF
end

dlBUF=dlBUF'dofreqs:'LF
if FF then dlBUF=dlBUF'SubJump findfreqs'LF
else dlBUF=dlBUF'FindFreq "$(remote.akas)"'LF'Set freq $(RC)'LF
dlBUF=dlBUF'getwzcap:'LF||gen_wzp('out');drop wzp

dlBUF=dlBUF'bad_handshake:'LF||logf'Handshake failed:$(event) $(remote.address)"'LF
dlBUF=dlBUF'ReplyCall 99'LF'EndSession all'LF'Jump hangfree'LF

dlBUF=dlBUF'get_altnum:'LF
dlBUF=dlBUF'Set RC 'idxpnum||LF'FalseReturn'LF
dlBUF=dlBUF'RexxMsg RY,SY REXX "x=$(ncount.$(remote.address))-1;if x>0 then return x;else return FALSE"'LF
dlBUF=dlBUF'Set RC $(RESULT2)'LF'FalseReturn'LF
dlBUF=dlBUF'Set ncount.$(remote.address) $(RESULT2) remote.number $('sindex'.$(RESULT2))'LF
if wpldebug then dlBUF=dlBUF||logf'GOT $(remote.address) ALTERNATE:$(ncount.$(remote.address)):$('sindex'.$(RESULT2))"'LF
dlBUF=dlBUF'Set RC TRUE'LF'Return'LF
return

genanswer:
say;call writech('STDOUT','Installing Answer: FTN ')
call SetVars('NOANSWER','FALSE')
ansBUF=ansBUF'answer:'LF
ansBUF=ansBUF'Set RC ${'envpath'NOANSWER}'LF'FalseJump answer00'LF
ansBUF=ansBUF'Print "IGNORED\n"'LF'Jump waitring'LF
ansBUF=ansBUF'answer00:'LF
ansBUF=ansBUF'RexxMsg SY REXX "r=$(GotRing)+1;if r<$(AnswerOn) then return r;else return 0"'LF
ansBUF=ansBUF'Set GotRing $(RESULT1) RC $(RESULT1)'LF
ansBUF=ansBUF'TrueJump waitring'LF'Set GotRing 0'LF
ansBUF=ansBUF'answerondial:'LF'SetPri $(negopri)'LF'System "Run >NIL: Delete ENV:$(line).#?"'LF'SubJump cleargui'LF'Set state "ANSWERING" session INBOUND'LF
ansBUF=ansBUF||utc
if sc_answer then ansBUF=ansBUF'SetStatus "$(openstatus)"'LF'Print "$(state)\n"'LF
ansBUF=ansBUF||logw'$(p.status) $(state) $(LastResponse) $(p.response) $(event) $(p.baud) $(Baud)"'LF
if ROOFLOG then ansBUF=ansBUF||logus'$(callsin)"'LF
ansBUF=ansBUF'ModemClear'LF'SmartSend $(AnswerString)'LF'Clear ProgressString'LF
ansBUF=ansBUF'getanswerresponse:'LF'GetResponse $(responsetimeout)'LF
ansBUF=ansBUF'Cmp $(event) CID'LF'FalseJump answer02'LF
ansBUF=ansBUF||logf'AnsCID:$(LastResponse)"'LF
ansBUF=ansBUF'Jump getanswerresponse'LF
ansBUF=ansBUF'answer02:'LF||genprogress('answer')
drop proBUF
ansBUF=ansBUF||logw'$(p.status) $(state) $(LastResponse) $(p.response) $(event) $(p.baud) $(Baud)"'LF
ansBUF=ansBUF||logf'$(remote.address) $(LastResponse) $(event)"'LF

if addfax then do
call writech('STDOUT',"FAX ")
ansBUF=ansBUF'Cmp $(event) FAX'LF'TrueJump faxanswer'LF
end
ansBUF=ansBUF'Cmp $(event) RING'LF'TrueJump answer'LF
ansBUF=ansBUF'Cmp $(event) NOMODEM'LF'TrueJump freeline'LF
ansBUF=ansBUF'Cmp $(event) OWNDEVUNIT'LF'TrueJump freeline'LF
ansBUF=ansBUF'Cmp $(event) TIMEOUT'LF'TrueJump freeline'LF
ansBUF=ansBUF'Cmp $(event) CARRIER'LF'TrueJump lost_carrier'LF
ansBUF=ansBUF'Jump waitring'LF
ansBUF=ansBUF'answerconnect:'LF||logf'$(LastResponse) $(ProgressString)[$(Baud)]"'LF'Delay 6'LF'ModemClear'LF
ansBUF=ansBUF'CheckCarrier'LF'FalseJump lost_carrier'LF
if sc_connect then ansBUF=ansBUF'SetStatus "$(openstatus)"'LF
ansBUF=ansBUF'Set txt "'nl||u_mailer smver emsiserial' ${WPLVER}'nl'$(sysver)'nl'Line: $<port> $(ProgressString) at $<time> on $<date>'nl''LF'SubJump 'l_mailer'!showtxt'LF
if sendbanner then ansBUF=ansBUF'SubJump sendbanner'LF'CheckCarrier'LF'FalseJump lost_carrier'LF
else ansBUF=ansBUF'Set txt $(welcome)'LF'SubJump 'l_mailer'!showtxt'LF

if adduucp then ansBUF=ansBUF'Set txt "Do NOT use your name to login:'nl'"'LF'SubJump 'l_mailer'!showtxt'LF
ansBUF=ansBUF'SetPri $(negopri)'LF'Set state "SESSION $(session) unknown"'LF
ansBUF=ansBUF||logw'$(p.status) $(session) $(p.baud) $(Baud)"'LF

ansBUF=ansBUF'Set host.link "8N1"'LF
if ~LooseZMH then do
ansBUF=ansBUF||proczmh'FalseJump notzmhans'LF
ansBUF=ansBUF'Set host.link "$(host.link),HXT"'LF
ansBUF=ansBUF'notzmhans:'LF
end

if ~umbrella & addfreq then ansBUF=ansBUF'Cmp ${'envpath'ALLOWFREQS} TRUE'LF'TrueJump DoMenu'LF
ansBUF=ansBUF'Set host.wzext "-Freq +Domain" host.freq FALSE'LF
ansBUF=ansBUF'Set host.link "$(host.link),HRQ"'LF
ansBUF=ansBUF'j_DoMenu:'LF'Clear namebuf event'LF
ansBUF=ansBUF'CheckCarrier'LF'FalseJump lost_carrier'LF
ansBUF=ansBUF'Set RC $(emsireqsent)'LF'TrueJump DoMenu.1'LF
ansBUF=ansBUF'sendemsireq:'LF'Set RC $(user)'LF'TrueJump DoMenu.1'LF
ansBUF=ansBUF'Set RC $(doemsi)'LF'FalseJump DoMenu.1'LF
ansBUF=ansBUF'Set txt "'E_REQcr'" emsireqsent TRUE'LF
ansBUF=ansBUF'DoMenu.1:'LF

if umbrella then ansBUF=ansBUF'Set txt "$(txt) 'nl'Mailers only!'nl'"'LF
else do
ansBUF=ansBUF'Set txt "$(txt) $(sysprompt)"'LF
ansBUF=ansBUF'Set RC $(access)'LF'FalseJump mo'LF
ansBUF=ansBUF'Cmp ${'envpath'ACCESS} TRUE'LF'FalseJump mo'LF
ansBUF=ansBUF'Jump allwelcome'LF
ansBUF=ansBUF'mo:'LF'Set txt "$(txt) 'nl'Mailers only at this time for login: "'LF
end
ansBUF=ansBUF'allwelcome:'LF'SubJump 'l_mailer'!showtxt'LF
ansBUF=ansBUF'get_login:'LF'CheckCarrier'LF'FalseJump lost_carrier'LF'GetInbound "$(inflags.$(line))" $(loginwait)'LF
ansBUF=ansBUF||logw'$(p.status) $(session) $(p.session) $(event) $(p.login) $(namebuf) $<time> $(p.hfreqs) $(host.freq)"'LF

ansBUF=ansBUF'Cmp $(event) EMSI_INQ'LF'TrueJump login_emsi'LF
ansBUF=ansBUF'Cmp $(event) EMSI'LF'TrueJump login_emsi_BadSpec'LF
ansBUF=ansBUF'Cmp $(event) GOTYOOHOO'LF'TrueJump login_wazoo'LF
ansBUF=ansBUF'Cmp $(event) FTS1'LF'TrueJump login_fts1'LF
ansBUF=ansBUF'Cmp $(event) CARRIER'LF'TrueJump lost_carrier'LF
ansBUF=ansBUF'Cmp $(event) TIMEOUT'LF'TrueJump timeout_exit'LF
if ~umbrella then call writech('STDOUT',"HUMAN ")
ansBUF=ansBUF'Cmp $(event) LOGIN'LF'FalseJump get_login'LF
ansBUF=ansBUF'Pattern $(namebuf) #?**EMSI_CLIFA8C#?'LF'TrueJump user_input'LF
ansBUF=ansBUF'Pattern $(namebuf) "#?(EMSI|}{)#?"'LF
if umbrella then ansBUF=ansBUF'FalseJump get_login'LF
else ansBUF=ansBUF'FalseJump user_input'LF
ansBUF=ansBUF'Set event "EMSI_INQ"'LF'Jump login_emsi_GoodSpec'LF

ansBUF=ansBUF'login_wazoo:'LF||logw'$(p.session) WAZOO"'LF'SubJump wazoo'LF'FalseJump loginerr'LF
ansBUF=ansBUF'Set expect 2U2'LF'WazooRespond'LF'Cmp $(event) $(expect)'LF'FalseJump loginerr'LF'Cmp $(pw) DEFERRED'LF'FalseJump login1'LF'SubJump dolookup'LF'TrueJump login2'LF'Jump loginerr'LF
ansBUF=ansBUF'login1:'LF'SubJump ck_multiftn'LF
ansBUF=ansBUF'login2:'LF'SetPri $(launchpri)'LF'Set state "SESSION INBOUND $(remote.address)"'LF
ansBUF=ansBUF||logw'$(p.remote) $(remote.address)"'LF
if ROOFLOG then ansBUF=ansBUF||logrl'Inbound WAZOO FTN Session $(remote.address) @ $(Baud)"'LF
ansBUF=ansBUF'Set called $(remote.address)'LF
ansBUF=ansBUF'Set RC $(useakasin.'sindex')'LF'FalseJump login3'LF'Set called "$(akalist.'sindex')"'LF
ansBUF=ansBUF'login3:'LF
ansBUF=ansBUF'Set remote.akas "$(called)"'LF
ansBUF=ansBUF'BeginSession $(called)'LF||gen_wzp('in');drop wzp
ansBUF=ansBUF'login_fts1:'LF'Set state "SESSION $(session) $(event)"'LF'SetA remote fidonet#1:1/1.1'LF
ansBUF=ansBUF||logw'$(p.remote) $(remote.address)"'LF
if ~umbrella & addfreq then ansBUF=ansBUF'Cmp ${'envpath'FTSFREQS} TRUE'LF'TrueJump lotekin'LF
ansBUF=ansBUF'Set host.wzext "-Freq +Domain" host.freq FALSE'LF'Jump lotekin'LF

ansBUF=ansBUF'timeout_exit:'LF
ansBUF=ansBUF||logf'Login timeout"'LF
ansBUF=ansBUF'CheckCarrier'LF'FalseJump lost_carrier'LF
ansBUF=ansBUF'Set txt $(timeout)'LF'SubJump 'l_mailer'!showtxt'LF'Delay 2'LF'Jump hangfree'LF
ansBUF=ansBUF'loginerr:'LF||logf'WAZOO Negotiation failed:[$(event)] expected:[$(expect)]"'LF
ansBUF=ansBUF'Clear expect'LF'ReplyCall 111'LF'EndSession all'LF'Jump hangfree'LF
return

genaftersession:
call writech('STDOUT',lf"Generating AfterSession Process code: SCAN" SCANOPT" ")
asBUF=asBUF'aftersession:'LF'SetStatus NULL:'LF
asBUF=asBUF||setduration('af.0');drop as
asBUF=asBUF'SubJump 'mdmlabel'openslave'LF'FalseJump freeline'LF'SetPri $(launchpri)'LF
asBUF=asBUF||flush'SetStatus NULL:'LF
asBUF=asBUF'Set state "SESSION PROCESSING" issecure TRUE user FALSE'LF
asBUF=asBUF||logw'$(p.status) $(state)"'LF
asBUF=asBUF'aftersession.scan:'LF'Set RC $(mail)'LF
if SCANOPT="ALL" then asBUF=asBUF'FalseJump aftersession.freq'LF
else asBUF=asBUF'FalseJump aftersession.tic'LF

if SCANOPT~="FALSE" then do
call writech('STDOUT',"SCAN ")
  asBUF=asBUF'Cmp ${'envpath'IMPSCAN} ""'LF
  if SCANOPT="ALL" then asBUF=asBUF'TrueJump aftersession.freq'LF
  else asBUF=asBUF'TrueJump aftersession.tic'LF
  asBUF=asBUF||logw'$(p.status) AfterSession Mail Scan ${'envpath'IMPSCAN}"'LF
  asBUF=asBUF||logf'AfterSession Mail Scan: ${'envpath'IMPSCAN}"'LF
  asBUF=asBUF'Set systemcmd "${'envpath'IMPSCAN}"'LF'SubJump runsync'LF
  asBUF=asBUF'Set mail FALSE'LF
  if SCANOPT="ALL" then asBUF=asBUF'Jump aftersession.freq'LF
  else  asBUF=asBUF'Jump aftersession.tic'LF
end;else do
call writech('STDOUT',"HydraSCAN ")
  asBUF=asBUF'Set RC $(scan) scan FALSE'LF'FalseJump aftersession.sort'LF
  asBUF=asBUF'Cmp ${'envpath'IMPSCAN} ""'LF'TrueJump aftersession.sort'LF
  asBUF=asBUF'Set systemcmd "${'envpath'IMPSCAN}"'LF'Jump SSS'LF
call writech('STDOUT',"SORT ")
  asBUF=asBUF'aftersession.sort:'LF'Set RC $(multihub) multihub FALSE'LF'FalseJump aftersession.mail'LF

  asBUF=asBUF'Cmp "$(sortsess.'sindex')" ""'LF'TrueJump noSSS'LF
  asBUF=asBUF||logw'$(p.status) Site AfterSession $(sortsess.'sindex')"'LF
  asBUF=asBUF||logf'Site AfterSession Sort: $(sortsess.'sindex')"'LF
  asBUF=asBUF'Set systemcmd "$(sortsess.'sindex')"'LF'Jump SSS'LF
  asBUF=asBUF'noSSS:'LF
  asBUF=asBUF'Cmp "${'envpath'SORTSESS}" ""'LF'TrueJump aftersession.mail'LF
  asBUF=asBUF||logw'$(p.status) AfterSession ${'envpath'SORTSESS}"'LF
  asBUF=asBUF||logf'AfterSession Sort:${'envpath'SORTSESS}"'LF
  asBUF=asBUF'Set systemcmd "${'envpath'SORTSESS}"'LF
  asBUF=asBUF'SSS:'LF'SubJump runsync'LF'Set mail FALSE'LF'Jump aftersession.tic'LF
call writech('STDOUT',"MAIL ")
  asBUF=asBUF'aftersession.mail:'LF'Set RC $(mail) mail FALSE'LF'FalseJump aftersession.tic'LF
  asBUF=asBUF'Cmp "$(impsess.'sindex')" ""'LF'TrueJump noISS'LF
  asBUF=asBUF||logw'$(p.status) Site AfterSession $(impsess.'sindex')"'LF
  asBUF=asBUF||logf'Site AfterSession Import: $(impsess.'sindex')"'LF
  asBUF=asBUF'Set systemcmd "$(impsess.'sindex')"'LF'Jump ISS'LF
  asBUF=asBUF'noISS:'LF
  asBUF=asBUF'Cmp "${'envpath'IMPSESS}" ""'LF'TrueJump aftersession.tic'LF
  asBUF=asBUF||logw'$(p.status) AfterSession ${'envpath'IMPSESS}"'LF
  asBUF=asBUF||logf'AfterSession Import:${'envpath'IMPSESS}"'LF
  asBUF=asBUF'Set systemcmd "${'envpath'IMPSESS}"'LF
  asBUF=asBUF'ISS:'LF'SubJump runsync'LF
end
if SCAN~="ALL" then do
 call writech('STDOUT',"TIC ")
 asBUF=asBUF'aftersession.tic:'LF'Set RC $(tic)'LF'FalseJump aftersession.freq'LF
 asBUF=asBUF'Cmp "$(ticsess.'sindex')" ""'LF'TrueJump noFSS'LF
 asBUF=asBUF||logw'$(p.status) Site AfterSession $(ticsess.'sindex')"'LF
 asBUF=asBUF||logf'Site AfterSession Tick: $(ticsess.'sindex')"'LF
 asBUF=asBUF'Set systemcmd "$(ticsess.'sindex')"'LF'Jump FSS'LF
 asBUF=asBUF'noFSS:'LF
 asBUF=asBUF||logw'$(p.status) AfterSession ${'envpath'TICSESS}"'LF
 asBUF=asBUF||logf'AfterSession Tick:${'envpath'TICSESS}"'LF
 asBUF=asBUF'Set tic FALSE systemcmd "${'envpath'TICSESS}"'LF
 asBUF=asBUF'FSS:'LF'SubJump runsync'LF
end
call writech('STDOUT',"FREQ ")
asBUF=asBUF'aftersession.freq:'LF'Set RC $(freq)'LF'FalseJump aftersession.term'LF
asBUF=asBUF'Cmp "$(freqsess.'sindex')" ""'LF'TrueJump noRSS'LF
asBUF=asBUF||logw'$(p.status) Site AfterSession $(freqsess.'sindex')"'LF
asBUF=asBUF||logf'Site AfterSession Freq: $(freqsess.'sindex')"'LF
asBUF=asBUF'Set systemcmd "$(freqsess.'sindex')"'LF'Jump RSS'LF
asBUF=asBUF'noRSS:'LF
asBUF=asBUF||logw'$<p.status) AfterSession ${'envpath'FREQSESS}"'LF
asBUF=asBUF||logf'AfterSession Freq:${'envpath'FREQSESS}"'LF
asBUF=asBUF'Set freq FALSE systemcmd "${'envpath'FREQSESS}"'LF
asBUF=asBUF'RSS:'LF'SubJump runsync'LF
call writech('STDOUT',"TERM "LF)
asBUF=asBUF'aftersession.term:'LF'Set RC $(term)'LF'FalseJump aftersession_end'LF
asBUF=asBUF'Cmp "$(termsess.'sindex')" ""'LF'TrueJump noTSS'LF
asBUF=asBUF||logw'$(p.status) Site AfterSession $(termsess.'sindex')"'LF
asBUF=asBUF||logf'Site AfterSession Term: $(termsess.'sindex')"'LF
asBUF=asBUF'Set systemcmd "$(termsess.'sindex')"'LF'Jump TSS'LF
asBUF=asBUF'noTSS:'LF
asBUF=asBUF||logw'$<p.status) AfterSession ${'envpath'TERMSESS}"'LF
asBUF=asBUF||logf'AfterSession Term:${'envpath'TERMSESS}"'LF
asBUF=asBUF'Set term FALSE systemcmd "${'envpath'TERMSESS}"'LF
asBUF=asBUF'TSS:'LF'SubJump runsync'LF

asBUF=asBUF'aftersession_end:'LF'SubJump 'l_mailer'!fidonethost'LF'SubJump 'cfglabel'setglobals'LF'Set state "WAITING"'LF
asBUF=asBUF||logw'$(p.status) $(state)"'LF
asBUF=asBUF||flush'Jump idleloopinit'LF
return

genuser:
uBUF=uBUF'j_user_input:'LF
uBUF=uBUF'Cmp $(chatmode) SYSOP'LF'TrueJump forcechat'LF
uBUF=uBUF'Set RC $(bootuser)'LF'TrueJump hangfree'LF
uBUF=uBUF'Cmp $(namebuf) "
"'LF'TrueJump sendemsireq'LF
uBUF=uBUF'Cmp $(namebuf) ""'LF'TrueJump DoMenu'LF
uBUF=uBUF'Set state "SESSION LOGIN $(namebuf)"'LF
if sc_user then uBUF=uBUF'SetStatus "$(openstatus)"'LF'Print "$(state)\n"'LF
uBUF=uBUF||logw'$(p.status) $(state) $(p.session) $(event) $(p.login) $(username) $(namebuf) $<time>"'LF
if adduucp then do
call writech('STDOUT',"UUCP ")
uBUF=uBUF'Pattern $(namebuf) uu#?'LF'TrueJump uucp_inbound'LF
end
if addshell then uBUF=uBUF'Cmp $(namebuf) "${${'sysoppw'}}"'LF'TrueJump loadshell'LF
if power then uBUF=uBUF'CmpI $(namebuf) BYE'LF'TrueJump hangfree'LF
uBUF=uBUF'Set RC $(access)'LF'FalseJump no_access'LF
uBUF=uBUF'Cmp ${'envpath'ACCESS} TRUE'LF'FalseJump no_access'LF

if power then uBUF=uBUF'Cmp $(namebuf) "?"'LF'TrueJump showmenu'LF

if ~nobbs then do
    uBUF=uBUF'CmpI $(namebuf) BBS'LF
    if gazebo then do
      uBUF=uBUF'FalseJump DoMenu'LF
      if sendbull then uBUF=uBUF'SubJump 'userlabel'sendbull'LF'CheckCarrier'LF'FalseJump lost_carrier'LF
      uBUF=uBUF||ckbbs('pbbs','DoMenu');drop cb
      uBUF=uBUF'Set txt "'wclr||nl'  Please wait, 'bbsname.1||nl' loading time depends on system load'nl'"'LF
      uBUF=uBUF'SubJump 'l_mailer'!showtxt'LF
      uBUF=uBUF||logf||bbsname.1'['bbscmd.1'] loading"'LF
      uBUF=uBUF'RexxMsg "SY,RY" REXX "Address COMMAND \"'bbscmd.1'\""'LF'Set RC $(RESULT1)'LF
      uBUF=uBUF||logf||bbsname.1' RC:$(RC)"'LF
      uBUF=uBUF'Jump aftersession'LF
    end /*GAZEBO*/;else do /* power*/
      select
       when escmode="MENU" then uBUF=uBUF'TrueJump showmenu'LF
       when escmode="SELECT" then uBUF=uBUF'TrueJump selectbbs'LF
       when escmode="BBS" then uBUF=uBUF'TrueJump loadbbs1'LF
       otherwise call errorexit('INVALID ESC-ESC Option 'escmode,10)
      end
    end
end
if power then do
uBUF=uBUF'Pattern $(namebuf) HELP#?'LF'TrueJump sendhelp'LF
uBUF=uBUF'Pattern $(wrxlist) #?$(namebuf)#?'LF'TrueJump loadwplrx'LF
uBUF=uBUF'CmpI $(namebuf) UL'LF'FalseJump not_upload'LF
uBUF=uBUF'SubJump 'userlabel'get_user'LF'FalseJump DoMenu'LF
uBUF=uBUF'Jump upld_detect'LF
uBUF=uBUF'not_upload:'LF
if noinfo then uBUF=uBUF'Set 0 0'LF
else uBUF=uBUF||genitem('info',userlabel'sendinfo','input.1');drop ub
if nomagic then uBUF=uBUF'input.1:'LF'Set 1 1'LF
else uBUF=uBUF||'input.1:'LF||genitem('magic','zmodemsend','input.2');drop ub
if nobbs then uBUF=uBUF'input.2:'LF'Set 2 2'LF
else uBUF=uBUF||'input.2:'LF||genitem('board',userlabel'loadbbs','input.3');drop ub
if nodoor then uBUF=uBUF'input.3:'LF'Jump DoMenu'LF
else uBUF=uBUF||'input.3:'LF||genitem('door',userlabel'loaddoor','DoMenu');drop ub
end /*POWER*/

if addshell then do
uBUF=uBUF'loadshell:'LF'Set user TRUE username "$(host.sysop)" acmd "Execute Mail:Scripts/AUXCLI $(device) $(unit) $(baud)" RC locked'LF
uBUF=uBUF'FalseJump ls.1'LF'Set acmd "Execute Mail:Scripts/AUXCLI $(device) $(unit) $(baudlocked)"'LF
uBUF=uBUF'ls.1:'LF'RexxMsg "RY,SY" REXX "Address COMMAND \"$(acmd)\""'LF'Clear acmd'LF'Jump DoMenu'LF
end
uBUF=uBUF'no_access:'LF'Set txt "'nl' $(notumh)'nl'"'LF
uBUF=uBUF||proczmh'FalseJump notzmh'LF
uBUF=uBUF'RexxMsg "SY,RY" REXX "return (((left(word(\"$(umh)\",2),2))*60)-time(m))"'LF
if gazebo then uBUF=uBUF'Set txt "'nl'  BBS is not available during Universal Mail Hour'nl'  Call back in $(result2) minutes.'nl'"'LF
else uBUF=uBUF'Set txt "'nl'  $(namebuf) is not available during Universal Mail Hour'nl'  Call back in $(result2) minutes.'nl'"'LF
uBUF=uBUF'notzmh:'LF'SubJump 'l_mailer'!showtxt'LF
if gazebo then do
uBUF=uBUF||logf'Denied BBS access"'LF
if ROOFLOG then uBUF=uBUF||logrl'Denied BBS access"'LF
end;else do
uBUF=uBUF||logf'Refused access $(namebuf)"'LF
if ROOFLOG then uBUF=uBUF||logrl'$(username) denied access $(namebuf)"'LF
end
uBUF=uBUF'Jump DoMenu'LF

if sendbanner then do
uBUF=uBUF'j_sendbanner:'LF'RexxMsg SY REXX "return exists(\"'bannerfile'\")"'LF
uBUF=uBUF'Set RC $(result1)'LF'FalseReturn'LF
uBUF=uBUF'SubJump 'l_mailer'!ascii_start'LF'XprSetFile 'bannerfile' BANNER ""'LF'XprSend BANNER'LF'SubJump 'l_mailer'!ascii_end'LF'Return'LF
end
if sendbull then do
xuBUF=xuBUF'sendbull:'LF'RexxMsg SY REXX "return exists(\"'bullfile'\")"'LF
xuBUF=xuBUF'Set RC $(result1)'LF'FalseReturn'LF
xuBUF=xuBUF'SubJump 'l_mailer'!ascii_start'LF'XprSetFile 'bullfile' BULL ""'LF'XprSend BULL'LF'SubJump 'l_mailer'!ascii_end'LF'Return'LF
end

if power & genmenufile then do
xuBUF=xuBUF'j_sendmenu:'LF'Set menufile "'menuvol'$(namebuf)'menuext'"'LF
xuBUF=xuBUF'SubJump 'l_mailer'!ascii_start'LF'XprSetFile $(menufile) $(namebuf) ""'LF'XprSend $(namebuf)'LF
xuBUF=xuBUF'SubJump 'l_mailer'!ascii_end'LF'clear menufile'LF'return'LF
end

if power then do
xuBUF=xuBUF'sendinfo:'LF
if USE_XPRASC then xuBUF=xuBUF'SubJump 'l_mailer'!ascii_start'LF'XprSetFile $($(namebuf)) $(namebuf) ""'LF'XprSend $(namebuf)'LF'SubJump 'l_mailer'!ascii_end'LF
else do
xuBUF=xuBUF'Send "'nl'Hit Q to continue, H for Help'nl'"'LF
xuBUF=xuBUF'Set speed $(baudlocked)'LF'Set RC $(locked)'LF'TrueJump rd_sendinfo'LF'Set speed $(baud)'LF
xuBUF=xuBUF'rd_sendinfo:'LF'RexxMsg SY REXX "Address COMMAND \"'TxtRead' $($(namebuf)) <>NEWAUX:$(device)/$(unit)/con/shared/checkcd/speed$(speed)\""'LF
end
xuBUF=xuBUF'Return'LF

uBUF=uBUF'j_showmenu:'LF'SubJump 'userlabel'get_user'LF
if genmenufile then uBUF=uBUF'Set namebuf MAIN'LF'TrueSubJump SendMenu'LF
else uBUF=uBUF'TrueSubJump 'menuslabel'wplmenu'LF
uBUF=uBUF'Jump DoMenu'LF

xuBUF=xuBUF'get_user:'LF'Set RC $(user)'LF'TrueReturn'LF
xuBUF=xuBUF'Set usrcmdbuf $(namebuf)'LF
if ROOFLOG then xuBUF=xuBUF||logus'$(humanin)"'LF
if sendbull then xuBUF=xuBUF'SubJump 'userlabel'sendbull'LF

xuBUF=xuBUF'gt.1:'LF
xuBUF=xuBUF'Set txt "'nl'  Please enter your name: "'LF'SubJump 'l_mailer'!showtxt'LF
xuBUF=xuBUF'GetInbound E0 $(loginwait)'LF'Cmp $(event) LOGIN'LF'FalseReturn'LF
xuBUF=xuBUF'RexxMsg SY REXX "x=space(\"$(namebuf)\",1);return((verify(x,\"~`!@#$%^&*()_+=|{}[]:;<>,.?/\",\"m\")=0)&(upper(word(x,1))~="THE")&(words(x)>1)&(length(x)>6) )"'LF
xuBUF=xuBUF'Set RC $(result1)'LF'TrueJump set_it'LF
xuBUF=xuBUF'Set txt "  Your real name is required to access our services'nl'  There should be no punctuation marks,'nl'  dashs are permitted.'nl'""'LF'SubJump 'l_mailer'!showtxt'LF
xuBUF=xuBUF'Jump gt.1'LF

xuBUF=xuBUF'set_it:'LF
xuBUF=xuBUF'RexxMsg "SY,RY" REXX "x=BITOR(space(\"$(namebuf)\",1),\"20\"x);y=\"\";do z=1 to words(x);y=y||Upper(Left(Word(x,z),1))||SubStr(Word(x,z),2)||\"20\"x;end;return strip(y)"'LF
xuBUF=xuBUF'Set username $(result2)'LF
if ROOFLOG then xuBUF=xuBUF||logrl'Inbound HUMAN Session $(username) @ $(Baud)"'LF
xuBUF=xuBUF||logw'$(p.inbound) USER"'LF
xuBUF=xuBUF'RexxMsg "SY,RY" REXX "return upper(translate(\"$(namebuf)\",\"_\",\" \"))" 'LF
xuBUF=xuBUF'SetA remote "$(result2)#0:0/0.0"'LF
xuBUF=xuBUF'RexxMsg "SY,RY" REXX "return translate(\"$(remote.address)\",\"...\",\"#:/\")"'LF
xuBUF=xuBUF'Set YourMail "LOG:RFSacct/h/$(result2).m"'LF'Send "  Hello, $(username)'nl'"'LF
xuBUF=xuBUF'Set state "Inbound Session $(username)"'LF
xuBUF=xuBUF||logf'$(state)"'LF
if addspeech then do
xuBUF=xuBUF'Set sl 70 speech $(state)'LF'SubJump 'l_mailer'!sayit 'LF
end
xuBUF=xuBUF'RexxMsg SY REXX "return exists(\"$(YourMail)\")"'LF'Set RC $(result1)'LF'TrueSubJump 'userlabel'showmsg'LF
xuBUF=xuBUF'Clear YourMail'LF
xuBUF=xuBUF'Set namebuf "$(usrcmdbuf)" remote.network FIDO inbound $(userdir) user TRUE RC TRUE'LF
xuBUF=xuBUF'Return'LF

xuBUF=xuBUF'showmsg:'LF
xuBUF=xuBUF'Print "Sending sysop message to $(username)\n"'LF
xuBUF=xuBUF'Send "  The sysop left this message for you, $(username)'nl||nl'"'LF
xuBUF=xuBUF'SubJump 'l_mailer'!ascii_start'LF'XprSetFile $(YourMail) "YourMail" ""'LF'XprSend "YourMail"'LF'SubJump 'l_mailer'!ascii_end'LF
if ROOFLOG then xuBUF=xuBUF||logus'$(msgout)"'LF
xuBUF=xuBUF'CmpI $(usrcmdbuf) NOTE'LF'TrueReturn'LF
xuBUF=xuBUF'Print "Asking $(username) for reply to sysop message\n"'LF
xuBUF=xuBUF'Send "  If you missed the message, you can see it again on your next'nl'"'LF
xuBUF=xuBUF'Send "  call. It will be deleted after you reply to it.'nl||nl'"'LF
xuBUF=xuBUF'Send "  Do you wish to reply NOW? (y/N):"'LF
xuBUF=xuBUF'GetInbound E0 $(loginwait)'LF'Cmp $(event) LOGIN'LF'FalseReturn'LF
xuBUF=xuBUF'CmpI $(namebuf) Y'LF'FalseReturn'LF
xuBUF=xuBUF'Print "$(username) repling\n"'LF'Set tmpsession $(session) session NOTE'LF
xuBUF=xuBUF'Set txt "'wclr||nl'  Please wait $(username), $(session) loading time depends on system load'nl'"'LF
xuBUF=xuBUF'SubJump 'l_mailer'!showtxt'LF
xuBUF=xuBUF||logf'$(session) loading for $(username)"'LF
xuBUF=xuBUF'Address REXX "$(rexxdir)$(session) $(Baud) $(line) $(username)"'LF
xuBUF=xuBUF'Print "Reply completed\n"'LF'Set session $(tmpsession)'LF'Clear tmpsession'LF
if ROOFLOG then xuBUF=xuBUF||logus'$(msgin)"'LF
xuBUF=xuBUF'Return'LF

if roof then do
xuBUF=xuBUF'nasty:'LF
xuBUF=xuBUF'Set RC $(user)'LF'FalseReturn'LF
xuBUF=xuBUF'RexxMsg SY,RY REXX "return \"LOG:rfsacct/h/\"upper(translate(\"$(username)\",\"_\",\" \"))\".0.0.0.0.m\"" 'LF
xuBUF=xuBUF'System "Type >>$(RESULT2) Info:carrier"'LF
xuBUF=xuBUF'Return'LF
end

uBUF=uBUF'forcechat:'LF
uBUF=uBUF'Print "Forcing chat with $(username)\n"'LF'Set session CHAT'LF
uBUF=uBUF'Set txt "'wclr||nl'  Please wait $(username), $(host.sysop) is coming online'nl'"'LF'SubJump 'l_mailer'!showtxt'LF
uBUF=uBUF||logf'$(session) loading for $(username)"'LF
uBUF=uBUF'Address REXX "$(rexxdir)$(session) $(Baud) $(line) $(username)"'LF
uBUF=uBUF'Print "Chat completed\n"'LF
uBUF=uBUF'Jump DoMenu'LF

uBUF=uBUF'j_sendhelp:'LF'SubJump 'userlabel'get_user'LF'FalseJump DoMenu'LF
uBUF=uBUF'Print "Sending $(namebuf) help to $(username)\n"'LF
uBUF=uBUF'RexxMsg "SY,RY" REXX "if words(\"$(namebuf)\")=2 then return \"INFO:help/\"||subword(strip(\"$(namebuf)\"),2); else return \"INFO:HELP/HELP\""'LF
uBUF=uBUF'Set helpfile $(result2)'LF'RexxMsg SY REXX "return exists(\"$(helpfile)\")"'LF
uBUF=uBUF'Set RC $(result1)'LF'FalseJump no_help'LF
if USE_XPRASC then do
uBUF=uBUF'SubJump 'l_mailer'!ascii_start'LF
uBUF=uBUF'XprSetFile $(helpfile) "$(namebuf)" ""'LF'XprSend "$(namebuf)"'LF
uBUF=uBUF'CmpI $(namebuf) HELP'LF'FalseJump sh_exit'LF'System "List >T:HELPFILES INFO:help/ LFORMAT \"   Help %n\"'LF
uBUF=uBUF'Set fsend TRUE'LF'XprSetFile T:HELPFILES HELPFILES ""'LF'XprSend "HELPFILES"'LF
end;else do
uBUF=uBUF'Send "'nl'Hit Q to continue, H for Help'nl'"'LF
uBUF=uBUF'Set speed $(baudlocked)'LF'Set RC $(locked)'LF'TrueJump rd_sendhelp'LF'Set speed $(baud)'LF
uBUF=uBUF'rd_sendhelp:'LF'RexxMsg SY REXX "Address COMMAND \"'TxtRead' $(helpfile) <>NEWAUX:$(device)/$(unit)/con/shared/checkcd/speed$(speed)\""'LF
uBUF=uBUF'CmpI $(namebuf) HELP'LF'FalseJump sh_exit'LF'System "List >T:HELPFILES INFO:help/ LFORMAT \"   Help %n\"'LF
uBUF=uBUF'System "'TxtRead' T:HELPFILES <>NEWAUX:$(device)/$(unit)/con/shared/checkcd/speed$(speed)"'LF
end
uBUF=uBUF'sh_exit:'LF
if USE_XPRASC then uBUF=uBUF'SubJump 'l_mailer'!ascii_end'LF
uBUF=uBUF'Jump DoMenu'LF

uBUF=uBUF'no_help:'LF'Set txt "'nl'  Sorry, there is presently no help for $(namebuf)'nl'"'LF'SubJump 'l_mailer'!showtxt'LF'Jump DoMenu'LF
  
xuBUF=xuBUF'menu_input:'LF'Set inputerr FALSE main FALSE'LF'Clear event namebuf'LF
xuBUF=xuBUF'GetInbound E0 $(loginwait)'LF'Cmp $(event) TIMEOUT'LF'FalseJump menu_input.1'LF
xuBUF=xuBUF'Set txt $(timeout)'LF'SubJump 'l_mailer'!showtxt'LF
xuBUF=xuBUF'Set inputerr TRUE RC FALSE'LF'Return'LF

xuBUF=xuBUF'menu_input.1:'LF
xuBUF=xuBUF'Cmp $(event) CARRIER'LF'FalseJump menu_input.2'LF
xuBUF=xuBUF'Set inputerr TRUE RC FALSE'LF'Return'LF

xuBUF=xuBUF'menu_input.2:'LF
xuBUF=xuBUF'Cmp $(event) LOGIN'LF'FalseReturn'LF
xuBUF=xuBUF'Cmp $(namebuf) ""'LF'FalseJump menu_input.3'LF
xuBUF=xuBUF'Set main TRUE RC FALSE'LF'Return'LF

xuBUF=xuBUF'menu_input.3:'LF
xuBUF=xuBUF'Pattern $(searchlist) #?$(namebuf)#?'LF'TrueReturn'LF
xuBUF=xuBUF'Send "  Sorry, selection $(namebuf) is unavailable.'nl'"'LF
xuBUF=xuBUF'Set RC FALSE'LF'Return'LF

uBUF=uBUF'j_loadwplrx:'LF'RexxMsg SY,RY REXX "return length(\"$(namebuf)\")>1"'LF
uBUF=uBUF'Set RC $(RESULT2)'LF'FalseJump DoMenu'LF
uBUF=uBUF'Set session $(namebuf)'LF'SubJump 'userlabel'get_user'LF'FalseJump DoMenu'LF
uBUF=uBUF||logw'$(p.session) $(session) $(p.login) $(username) $<time>"'LF
uBUF=uBUF'Set txt "'wclr||nl'  Please wait $(username), $(session) loading time depends on system load'nl'"'LF'SubJump 'l_mailer'!showtxt'LF
uBUF=uBUF||logf'$(session) loading for $(username)"'LF
uBUF=uBUF'Address REXX "$(rexxdir)$(session) $(Baud) $(line) $(username)"'LF
uBUF=uBUF||logf'$(session) RC:$(RC)"'LF
uBUF=uBUF'Jump DoMenu'LF

if ~nodoor then do
xuBUF=xuBUF'loaddoor:'LF'Set session "$(doorname.$(namebuf))" systemcmd "$(door.$(namebuf))"'LF
xuBUF=xuBUF||logw'$(p.session) $(session) $(p.login) $(username) $<time>"'LF
xuBUF=xuBUF'Set txt "'wclr||nl'  Please wait $(username), $(session) loading time depends on system load'nl'"'LF'SubJump 'l_mailer'!showtxt'LF
xuBUF=xuBUF||logf'$(session) loading for $(username)"'LF
xuBUF=xuBUF'Address REXX "$(rexxdir)DOOR $(Baud) $(device) $(unit) $<port> \"$(username)\" $(systemcmd)"'LF
xuBUF=xuBUF||logf'$(session) RC:$(RC)"'LF
xuBUF=xuBUF'Return'LF
end

if ~nobbs then do
if escmode="BBS" then do
uBUF=uBUF'loadbbs1:'LF||ckbbs('ebbs','HangFree');drop cb
uBUF=uBUF'Set namebuf "1"'LF'SubJump 'userlabel'loadbbs'LF'Jump hangfree'LF
end

xuBUF=xuBUF'loadbbs:'LF'Set session "BBS $(bbsname.$(namebuf))" systemcmd "$(bbs.$(namebuf)) $(Baud) $(line)"'LF
xuBUF=xuBUF||logw'$(p.session) $(session) $(p.login) $(username) $<time>"'LF
if ROOFLOG then xuBUF=xuBUF||logus'$(bbsin)"'LF
xuBUF=xuBUF'Set txt "'wclr||nl'  Please wait $(username), $(session)'nl'  loading time depends on system load'nl'"'LF'SubJump 'l_mailer'!showtxt'LF
xuBUF=xuBUF||logf'$(session) loading for $(username)"'LF
xuBUF=xuBUF'RexxMsg "SY,RY" REXX "Address COMMAND \"$(systemcmd)\""'LF'Set RC $(RESULT1)'LF
xuBUF=xuBUF||logf'$(session) RC:$(RC)"'LF
xuBUF=xuBUF'Return'LF
end /*nobbs*/

call open('uw',userswpl,"W");call writech('uw',xuBUF);call close('uw')
drop uw xuBUF
say;Say "Wrote "userswpl
end /*POWER*/
return

ckbbs:
cb='Set RC $(bbs)'LF'TrueJump 'arg(1)||LF'Send "There is NO BBS on this line'nl'"'LF'Jump 'arg(2)||LF
cb=cb||arg(1)':'LF'Set RC ${'envpath'BBS}'LF'TrueJump 'arg(1)'ok'LF'Send "Sorry, board access is temporarly disabled'nl'"'LF'Jump 'arg(2)||LF
return cb||arg(1)'ok:'LF

genfax:
faxBUF=faxBUF'faxconnect:'LF
if ROOFLOG then faxBUF=faxBUF||logus'$(callsout)"'LF
faxBUF=faxBUF'SubJump ckpresess'LF'Cmp dialrc 5'LF'TrueJump dodial_exit'LF
faxBUF=faxBUF||logw'$(p.inbound) FAX"'LF
faxBUF=faxBUF'Set localfile "$(faxoutdir)$(remote.address)" faxrc 0'LF
faxBUF=faxBUF'RexxMsg SY REXX "return exists(\"$(localfile)\")"'LF'Set RC $(result1)'LF'FalseJump faxnofile'LF
faxBUF=faxBUF'SetStatus $(openstatus)'LF
faxBUF=faxBUF'RexxMsg "SY,RY" REXX "options failat 99;Address COMMAND \"$(faxsend)\";return RC"'LF
faxBUF=faxBUF'Set faxrc $(result2) tmprc 5'LF
faxBUF=faxBUF||logf'Fax Call $(remote.address) returned $(faxrc)"'LF
faxBUF=faxBUF'Cmp $(faxrc) 24'LF'TrueJump faxexit'LF'Set tmprc $(faxrc)'LF
faxBUF=faxBUF'faxexit:'LF'ReplyCall $(tmprc)'LF
if ROOFLOG then faxBUF=faxBUF||logus'$(faxsout)"'LF
faxBUF=faxBUF'Clear tmprc'LF'Jump freeline'LF
faxBUF=faxBUF'faxnofile:'LF'ReplyCall $(tmprc)'LF
faxBUF=faxBUF||logf'Call $(remote.address) aborted, nothing to send"'LF
faxBUF=faxBUF'Clear tmprc'LF'Jump freeline'LF

faxBUF=faxBUF'faxanswer:'LF'SetStatus $(openstatus)'LF
faxBUF=faxBUF||logw'$(p.inbound) FAX"'LF
if gpfax then faxBUF=faxBUF'RexxMsg SY REXX_GPFAX "\"openserial\";\"fconreceive\";\"closeserial\""'LF
else faxBUF=faxBUF'RexxMsg SY REXX "options failat 99;Address COMMAND \"$(faxrecv)\";return RC"'LF
faxBUF=faxBUF'Set faxrc $(result1)'LF'ReplyCall 0'LF
faxBUF=faxBUF||logf'Inbound Fax session returned $(faxrc)"'LF
if ROOFLOG then faxBUF=faxBUF||logus'$(faxsin)"'LF
faxBUF=faxBUF'Jump freeline'LF
return

genloop:
loopBUF=loopBUF'hangfree:'LF'SubJump 'mdmlabel'hangup'LF'Jump freeline'LF
loopBUF=loopBUF'lost_carrier:'LF||logf'Caller dropped carrier"'LF
loopBUF=loopBUF'ModemClear'LF'ModemInit'LF
if roof then loopBUF=loopBUF'SubJump 'userlabel'nasty'LF
loopBUF=loopBUF'freeline:'LF
loopBUF=loopBUF||setduration('fl.0');drop as
if ~sc_modem then loopBUF=loopBUF'SetStatus NULL:'LF
if power then loopBUF=loopBUF'Clear bootuser'LF
loopBUF=loopBUF'ModemClear'LF'SetPri $(launchpri)'LF
loopBUF=loopBUF'Cmp $(exit) RESTART'LF'TrueJump closeslave'LF
loopBUF=loopBUF'Set RC $<abort>'LF'TrueJump closeslave'LF
loopBUF=loopBUF'Set State "BUSY MODEM CLOSE"'LF'ModemClose'LF'System "Wait 3"'LF
loopBUF=loopBUF'slaveloop:'LF'SubJump 'cfglabel'setglobals'LF'SubJump 'mdmlabel'openslave'LF
loopBUF=loopBUF'TrueJump aftersession_end'LF
loopBUF=loopBUF'Set state "'u_mailer'$(line) MODEM not responding on $(state)"'LF
loopBUF=loopBUF||logw'$(p.status) $(state)"'LF
loopBUF=loopBUF||logf'$(state)"'LF
loopBUF=loopBUF'SubJump 'mdmlabel'openslave'LF'TrueJump aftersession_end'LF

if roof then loopBUF=loopBUF||logr'CLOSESTATUS WPL $(line)"'LF
else loopBUF=loopBUF'RexxMsg "" REXX "$(rexxdir)SHELTER.rexx CLOSESTATUS $(line)"'LF

loopBUF=loopBUF'Jump closelogs'LF
loopBUF=loopBUF'closeslave:'LF'Set state "MODEM CLOSE"'LF
loopBUF=loopBUF||logw'$(p.status) $(state)"'LF
loopBUF=loopBUF||logf'Closing modem Slave$(line)"'LF
loopBUF=loopBUF'ModemClose'LF

if RFH then do
loopBUF=loopBUF'Set RC $(Host.freq).$(line))'LF'FalseJump cs.1'LF
loopBUF=loopBUF'RexxMsg FY RFH$(line) "RFHEXIT"'LF'cs.1:'LF
end
if roof then loopBUF=loopBUF||logr'CLOSESTATUS WPL $(line)"'LF
else loopBUF=loopBUF'RexxMsg "" REXX "$(rexxdir)SHELTER.rexx CLOSESTATUS $(line)"'

loopBUF=loopBUF'Cmp $(exit) RESTART'LF'FalseJump closelogs'LF
loopBUF=loopBUF'recompile:'LF'Cmp $(line) 1'LF'FalseReturn'LF
loopBUF=loopBUF'Set state "RECOMPILING"'LF
loopBUF=loopBUF||logf'Re-compile requested Slave$(line)"'LF
loopBUF=loopBUF'closelogs:'LF'LoadScript xcache ""'LF
loopBUF=loopBUF||flush'Return'LF

if wxi then do
loopBUF=loopBUF'wxitest:'LF'SetStatus "$(OpenStatus)"'LF||utc
loopBUF=loopBUF'Print "Loading wxitest.library\n"'LF
loopBUF=loopBUF'XprSetup wxitest.library ""'LF
loopBUF=loopBUF||logf'WXITEST XPRSETUP:$(XPRSETUP) RC:$(RC)"'LF
loopBUF=loopBUF'XprClose'LF
loopBUF=loopBUF||logf'WXITEST RC:$(RC) RESULT3:$(RESULT3)"'LF
end

loopBUF=loopBUF'idleloopinit:'LF

if wxi then do
loopBUF=loopBUF'WaitEvent 2'LF
loopBUF=loopBUF'Set RC $(BREAKF)'LF
loopBUF=loopBUF'TrueJump wxitest'LF
end

if closedevice then do
loopBUF=loopBUF'Cmp ${CLOSEDEVICE} $<port>'LF'FalseJump nfd'LF
loopBUF=loopBUF'ModemClear'LF'ModemClose'LF'Set state "BUSY DEVICE $(device) CLOSED"'LF
loopBUF=loopBUF||logw'$(p.status) $(state)"'LF
loopBUF=loopBUF||logf'$(state)"'LF
loopBUF=loopBUF'SetEnv $<port>CLOSED TRUE'LF
loopBUF=loopBUF'fd.1:'LF
loopBUF=loopBUF'RexxMsg "SY,RY" REXX "Return left(time(),5)"'LF
loopBUF=loopBUF||logw'@1,55,6 @R $(result2)"'LF
loopBUF=loopBUF'Set callinterupt FALSE'LF'WaitEvent 60'LF'Set RC $(BREAKD)'LF'FalseJump fd.1'LF
loopBUF=loopBUF'CmpI ${CLOSEDEVICE} $<port>'LF'TrueJump fd.1'LF'Set state "BUSY REOPENING DEVICE $(device)"'LF
loopBUF=loopBUF||logw'$(p.status) $(state)"'LF
loopBUF=loopBUF||logf'$(state)"'LF
loopBUF=loopBUF'SetEnv $<port>CLOSED FALSE'LF'SubJump 'mdmlabel'openslave'LF'Set state "WAITING"'LF
loopBUF=loopBUF||logw'$(p.status) $(state)"'LF
loopBUF=loopBUF||logf'$(state)"'LF
loopBUF=loopBUF'Set callinterupt TRUE'LF
loopBUF=loopBUF'nfd:'LF
end
loopBUF=loopBUF'Cmp $(exit) CACHE'LF'FalseJump idl.0'LF
loopBUF=loopBUF'SubJump xcache!setcache'LF'Jump eload'LF
loopBUF=loopBUF'idl.0:'LF'Cmp $(exit) CONFIG'LF'FalseJump idl.1'LF
loopBUF=loopBUF'SubJump 'cfglabel'setstatics'LF
if RFH then do
loopBUF=loopBUF'Set RC $(Host.freq).$(line))'LF'FalseJump eload'LF
loopBUF=loopBUF'RexxMsg FY RFH$(line) "RFHCFG"'LF
end
loopBUF=loopBUF'eload:'LF
if ROOFLOG then loopBUF=loopBUF||logrl'Reloading $(exit)"'LF
loopBUF=loopBUF||logf'Reloaded $(exit)"'LF
loopBUF=loopBUF||flush'Clear exit'LF
loopBUF=loopBUF'idl.1:'LF
/*
loopBUF=loopBUF'; this commented section is suggested by Russ in order to'LF
loopBUF=loopBUF'; allow external REXX calls a safe window to call ModemOpen'LF
loopBUF=loopBUF';Set state "BUSY WAITEVENT"'LF
loopBUF=loopBUF';WaitEvent 5'LF
loopBUF=loopBUF';Print "WaitEvent:$(event)\n"'LF
*/
loopBUF=loopBUF'RexxMsg "SY,RY" REXX "Return left(time(),5)"'LF
loopBUF=loopBUF||logw'@1,55,6 @R $(result2)"'LF
loopBUF=loopBUF'Set state "BUSY MODEM INIT"'LF'SubJump 'mdmlabel'modeminit'LF'FalseJump freeline'LF
loopBUF=loopBUF'Set state "WAITING"'LF'CheckCall'LF'TrueJump dodial'LF
loopBUF=loopBUF'Set RC $<abort>'LF'TrueJump closeslave'LF
loopBUF=loopBUF'waitring:'LF'Set OwnDevUnit TRUE CallInterupt TRUE'LF
loopBUF=loopBUF'GetResponse $(wakeup)'LF'Set OwnDevUnit FALSE CallInterupt FALSE'LF
loopBUF=loopBUF'Cmp $(event) OWNDEVUNIT'LF'TrueJump freeline'LF
if ~noanswer then do
loopBUF=loopBUF'Cmp $(event) CID'LF'FalseJump wo.1'LF
loopBUF=loopBUF||logw'$(p.status) $(state) $(LastResponse) $(p.response) $(event) $(p.baud) $(Baud)"'LF
loopBUF=loopBUF||logf'Loop CID:$(LastResponse)"'LF
loopBUF=loopBUF'Jump waitring'LF
loopBUF=loopBUF'wo.1:'LF'Cmp $(event) RING'LF'TrueJump answer'LF
end
loopBUF=loopBUF'Jump idleloopinit'LF
return

genvars:
varBUF='setglobals:'LF
if power then varBUF=varBUF'SetEnv VUSER$(line) FALSE'LF'Set send FALSE user FALSE'LF
varBUF=varBUF'SubJump 'cfglabel'clearglobals'LF
varBUF=varBUF'Set host.wzcap $(wz.wzcap) host.wzprot "$(wz.wzprot)"'LF 
if addfreq then varBUF=varBUF'Set host.wzext "$(host.wzext.$(line))" host.freq $(host.freq.$(line))'LF
else varBUF=varBUF'Set host.wzext "-Freq +Domain" host.freq "FALSE"'LF
varBUF=varBUF'SubJump 'l_mailer'!fidonethost'LF
varBUF=varBUF'Set host.flags $(emsi.flags) host.link $(emsi.link) host.compat $(emsi.compat.$(line)) host.akas "'strip(myakas)'"'LF
varBUF=varBUF'Set fnc 0 crash FALSE nopickup FALSE resume FALSE multihub FALSE issecure TRUE term FALSE fax FALSE'LF
varBUF=varBUF'Set MaxSendPri 127 MinSendPri -127 baud 'lockbps' dial $(DialString) useline $(line)'LF
varBUF=varBUF'SetMailerFlags DY'LF'System "SetEnv WPLNAME \"'u_mailer smver vdate'\""'LF
varBUF=varBUF'System "'LowBytesCmd'"'LF'TrueReturn'LF'Set nopickup TRUE'LF
varBUF=varBUF||logf'NOPICKUP enabled, $(indir) free space below 'lowbytes' bytes limit"'LF
if ROOFLOG then varBUF=varBUF||logrl'NOPICKUP enabled, $(indir) free space below 'lowbytes' bytes limit"'LF
varBUF=varBUF'Return'LF

varBUF=varBUF'clearglobals:'LF
if ROOFLOG then varBUF=varBUF'Clear calltask.$(remote.address) callcount.$(remote.address)'LF
varBUF=varBUF'Clear session protocol systemcmd dialrc host.wzext fts1 isoutbound'LF
varBUF=varBUF'Clear infile remfile localfile recfile filesize filestatus called'LF
varBUF=varBUF'Clear event LastResponse resp NameBuf OwnDevUnit UserName temp'LF
varBUF=varBUF'Clear remote.text remote.network remote.address'LF
varBUF=varBUF'Clear remote.domain remote.zone remote.net remote.node remote.point'LF
varBUF=varBUF'Clear remote.number remote.cost remote.maxbaud remote.flags remote.sitename remote.sysop remote.password'LF
varBUF=varBUF'Clear remote.wzcap remote.wzdomain remote.product remote.product_maj remote.product_min remote.freq'LF
varBUF=varBUF'Clear searchlist inputerr main usrcmdbuf tmpbaud tmpbuf XprSetup SendRC RecvRC RC Result1 Result2'LF
varBUF=varBUF'Clear host.trx emsiRT emsiOD emsireqsent remote.akas remote.compat remote.baud remote.link remote.city remote.mailer remote.product remote.version remote.serial'LF
varBUF=varBUF'Return'LF
return

set_sitetype: procedure
if left(upper(arg(1)),3)="BBS" then return 5
else if left(upper(arg(1)),3)="FAX" then return 4
else if left(upper(arg(1)),5)="CLOCK" then return 3
else if (left(upper(arg(1)),2)="UU"|datatype(right(arg(1),2),'MIXED')) then return 2
else return 1

gencache:
if exists(cachewpl) then do
    if samestate(statef(cachewpl),statef(cachecfg)) then do
        say cachecfg 'has not been modified, skipping'
        didcache=0
        return
    end
end
if ~open('cfg',cachecfg,'r') then call ERRORABORT('Cannot find 'cachecfg,10)

/* allowable keywords per site type */
dtype.5="BBS";keys.5='number line dial sitename sysop term predial presess termsess'
dtype.4="FAX";keys.4='number line dial sysop xprsetup predial presess'
dtype.3="CLOCK";keys.3='number line dial sitename baud xprsetup predial presess'
dtype.2="UUCP";keys.2='number line dial sitename sysop password uuoptions predial presess impsess'
dtype.1="FTN";keys.1='number line dial sitename sysop password multi useakasin useakasout handshake present predial presess impsess freqsess ticsess'
dtypes=5
htype.4="FAST" ;hoflag.4="DE,"
htype.3="EMSI" ;hoflag.3="GE,"
htype.2="WAZOO";hoflag.2="G6,D6,"
htype.1="FTS1" ;hoflag.1="G1,D1,"
htypes=4
say 'Parsing 'cachecfg
i=1
do while ~eof('cfg')
    call writech('STDOUT','.')
    line.i=readln('cfg')
    if line.i="" | left(line.i,2)='/*' | left(line.i,2)='*/' then iterate
    i=i+1
end
call close('cfg')
drop cfg
say;call writech('STDOUT','Compiling')
Cend=i-1;nodes=0;numbers=0;dohs=0;cacheidx=0;hOutFlags=""
writebuf='setcache:'LF
do i=1 to Cend
    call writech('STDOUT','.')
    drop j k
    x=line.i;wplvar=word(x,1);wplvalue=strip(subword(x,2))

    if upper(wplvar)="NODE" then do
        call setsitefinal()
    end;else do  /*not NODE entry */
        if wplvalue="" then iterate

        if upper(wplvar)="HANDSHAKE" then do
            dohs=1
            do h=1 to htypes
                if pos(htype.h,wplvalue) > 0 then hOutFlags=hOutFlags||hoflag.h
            end
            iterate
        end

        if upper(wplvar)="NUMBER" then do
            numbers=numbers+1
            wplvalue=compress(wplvalue," -")
            node.j.numbers=wplvalue
            writebuf=writebuf'Set 'cacheidx'.'numbers wplvalue||LF
        end

        if akas>1 then do k=1 to akas
            stype=sitetype.k
            if debug then say sitetype.k keys.stype
            if index(keys.stype,wplvar)=0 then iterate
            akawplvar=wplvar'.'cacheidx
            if debug then Say "IDX:"cacheidx" AKA:"node.k  akawplvar wplvalue   

            if upper(wplvar)="NUMBER" & words(siteakalist) >1 then do
                writebuf=writebuf'Set akalist.'cacheidx '"'strip(siteakalist)'"'LF
                siteakalist=""   
            end

           if wplvar='number' then nop
           else do
               if pos(akawplvar,altset)=0 then do
                   altset=altset" "akawplvar 
                   writebuf=writebuf'Set 'akawplvar '"'wplvalue'"'LF
               end
           end
        end;else do
            k=1;stype=sitetype.k
            if debug then say sitetype.k keys.stype
            if index(keys.stype,wplvar)=0 then do
                if (SCAN & wplvar='impsess') then call warning("SCAN=1 invalidates impsess") 
                else call warning("Keyword" wplvar "invalid for "dtype.stype" site")
                iterate
            end
            if debug then Say "IDX:"cacheidx" NO AKA:" node.k wplvar wplvalue
            if wplvar='number' then nop
            else do
                wplvar=wplvar'.'cacheidx
                writebuf=writebuf'Set 'wplvar '"'wplvalue'"'LF
            end
        end
    end
end
call setsitefinal('real')

writebuf=writebuf'Return'LF
call open('cw',cachewpl,"W");call writech('cw',writebuf);call close('cw')
drop cw writebuf
say;Say "Wrote "cachewpl" for "cacheidx" sites" 
didcache=1
if ~debug & Opt="CACHE" & show('P',u_mailer"1") then do
    say "ReLoading "cachewpl
    address COMMAND 'LoadScript xcache' cachewpl
    if RC~=0 then CALL errorabort('Cannot load 'cachewpl,10)
    say "Cache loaded"
    if umbrella then ports=1
        else ports=GetClip('SLAVES')
    do i=ports to 1 by -1
        if show('p',u_mailer||i) then do
            address VALUE u_mailer||i
            'Set exit CACHE'
            say u_mailer||i 'activated new cache'
        end
    end
end
nocache=0
return nocache

setsitefinal:
  if numbers>0 then writebuf=writebuf'Set numbers.'cacheidx numbers||LF
  altset=""
  if dohs then do
      if hOutFlags="HOUTFLAGS" then call errorabort('Site handshake empty',10)
      writebuf=writebuf'Set OutFlags.'cacheidx '"'strip(hOutFlags,'T',',')'"'LF
      dohs=0;hOutFlags=""
  end
  if arg(1)='real' then return
  cacheidx=cacheidx+1 
  numbers=0;siteakalist=""
  akas=words(wplvalue)
  if akas > 1 then 
  do j=1 to akas
      node.j=word(wplvalue,j)
      sitetype.j=set_sitetype(node.j)
      if debug then Say "Found "sitetype.j" AKA" node.j
      sitetype.j=set_sitetype(node.j)
      if sitetype.j=1 then do
          if debug then say 'Adding 'node.j' to akalist'
          siteakalist=siteakalist" "node.j
      end
      writebuf=writebuf'Set si.'node.j cacheidx||LF
      nodes=nodes+1
  end;else do
      j=1;node.j=wplvalue
      sitetype.j=set_sitetype(node.j)
      if debug then Say "Found "sitetype.j" Site" node.j
      writebuf=writebuf'Set si.'node.j cacheidx||LF
      nodes=nodes+1
  end
return


gencallscript:
scriptbuf=""
if umbrella then scriptbuf=scriptbuf'.key a,b,c,d,e'LF'RUN RX ${'envpath'REXXDIR}/Scall <a> <b> <c> <d> <e>'LF
else scriptbuf=scriptbuf'.key a,b,c,d,e'LF'RUN RX ${'envpath'REXXDIR}/Scall <a> <b> <c> <d> <e>'LF
call open('cs',callscript,"W");call writech('cs',scriptbuf);call close('cs')
drop cs scriptbuf
Say "Wrote "callscript
address COMMAND "PROTECT" callscript "SWERD"
return

genbootuserscript:
scriptbuf='.key line/a'LF'RUN RX "Address 'u_mailer'<line> Set bootuser TRUE"'LF
call open('bus',buscript,"W");call writech('bus',scriptbuf);call close('bus')
drop bus scriptbuf
Say "Wrote "buscript
address COMMAND "PROTECT" buscript "SWERD"
return

get_fn:
if LastPos('/',arg(1))~=0 then return SubStr(arg(1),LastPos('/',arg(1))+1)
else if LastPos(':',arg(1))~=0 then return SubStr(arg(1),LastPos(':',arg(1))+1)
else return arg(1)

/* align text to right of field  adding spaces or trucating on left to fit   */
right_justify:
if length(arg(1))>arg(2) then return (right(arg(1),arg(2)))
else return (copies(" ",arg(2)-length(arg(1)))||arg(1))

/* align text to left of field  adding spaces or trucating on right to fit   */
left_justify:
if length(arg(1))>arg(2) then return (left(arg(1),arg(2)))
else return (arg(1)||copies(" ",arg(2)-length(arg(1))))

/* Walt Sullivan */
expand: procedure expose debug BOLD AOFF
answer=arg(1)
lmatch='$';rmatch=''
ndx=index(answer,lmatch)
rndx=index(answer,rmatch)
do while ndx ~= 0
    if rndx < ndx then CALL errorabort("Malformed string:" answer,10) 
    v=substr(answer,ndx+length(lmatch),rndx-(ndx+length(lmatch)))
    exp=ReadVar(v,"R")
    if exp="" then CALL errorabort('Environmental variable 'v' not set',10)
    answer=substr(answer,1,ndx+1-LENGTH(lmatch))||exp||substr(answer,rndx+length(rmatch))
    ndx=index(answer,lmatch)
    rndx=index(answer,rmatch)
end
return answer

ExpandEnv: procedure expose debug BOLD AOFF
answer=arg(1)
lmatch='${';rmatch='}'
ndx=index(answer,lmatch)
rndx=index(answer,rmatch)
do while ndx ~= 0
    if rndx < ndx then CALL errorabort("Malformed string:" answer,10) 
    v=substr(answer,ndx+length(lmatch),rndx-(ndx+length(lmatch)))
    exp=ReadVar(v,"R")
    if exp="" then CALL errorabort('Environmental variable 'v' not set',10)
    answer=substr(answer,1,ndx+1-LENGTH(lmatch))||exp||substr(answer,rndx+length(rmatch))
    ndx=index(answer,lmatch)
    rndx=index(answer,rmatch)
end
return answer

undefer: procedure expose debug BOLD AOFF
answer=arg(1)
lmatch='$$(';rmatch=')'
ndx=index(answer,lmatch)
rndx=index(answer,rmatch)
do while ndx ~= 0
    if rndx < ndx then CALL errorabort("Malformed string:" answer,10)
    v=substr(answer,ndx+length(lmatch),rndx-(ndx+length(lmatch)))
    exp="$("v")"
    answer=substr(answer,1,ndx+2-LENGTH(lmatch))||exp||substr(answer,rndx+length(rmatch))
    ndx=index(answer,lmatch)
    rndx=index(answer,rmatch)
end
return answer

lower: return(bitor(arg(1),'20'x))

addslash:
curr=arg(1)
if right(curr, 1)=":" | right(curr, 1)="/" then return curr
else return curr"/"

requote: return('"'strip(arg(1))'"')

/* a useful procedure by Walt Sullivan */
dequote:
parse arg thing
parse var thing '"' unq_thing '"'
if unq_thing ~= "" then return unq_thing
return thing

SaveEnv:
if roof then return   
call writech('STDOUT',"Saving prefs to ENVARC:"envpath)
address COMMAND "Copy ENV:"envpath"#? ENVARC:"envpath" ALL CLONE QUIET"
call writech('STDOUT'," ..Done"LF)
return

ReadVar: procedure expose ENVPATH
if arg(2)~="R" then x=GetVar(envpath||arg(1),"G")
else x=GetVar(arg(1),"G")
return x

SetVars:
if index(arg(3),"E")=0 then call SetClip(arg(1),arg(2))
if index(arg(3),"R")>0 then root=1
else root=0
    if root then call SetVar(arg(1),arg(2),"G")
    else call SetVar(envpath||arg(1),arg(2),"G")
/*    if root then address COMMAND 'Copy ENV:'arg(1)' ENVARC: CLONE QUIET'  */
    address COMMAND 'Copy ENV:'envpath||arg(1)' ENVARC:'envpath' CLONE QUIET'
return

SetGlobal:
call SetClip(upper(arg(1)),arg(2))
address COMMAND "SetEnv "arg(1) arg(2)
address COMMAND "SetEnv ENVARC:"arg(1) arg(2)
return

join:
x=arg(1)' 'arg(2)' 'arg(3)
temp='arexxtempfile'
do i=1 to (words(x)-1)
    if word(x,i)=word(x,words(x)) then do
        oops=word(x,words(x))
        x=delword(x,words(x))'TO 'temp
        address COMMAND 'Join' x
        address COMMAND 'Copy ' temp ' ' oops
        call delete(temp)
        return 0
    end
end
x=arg(1)' 'arg(2)' TO 'arg(3)
address COMMAND 'Join' x
return 0

errorabort:
say;say BOLD"ERROR:"AOFF arg(1)
exit arg(2)

initgen:
call SetGlobal('SHELTER',u_mailer)
ROOFLOG=0
if roof then do;ROOFLOG=1;envpath="";call roofusage();end
else do;call makedir("ENV:"u_mailer);call makedir("ENVARC:"u_mailer);envpath=u_mailer"/";end
wpldir="CFG:wpl/"
gendir=wpldir"gen/"u_mailer'/'
if cfgpath~="" then gendir=addslash(strip(cfgpath))
modemdir=gendir"modems/"
gencfg=gendir'GEN.cfg'
cachecfg=gendir'cache.cfg'
wdir=wpldir||l_mailer
main=wdir".wpl";menuwpl=wdir"MENUS.wpl";cfgwpl=wdir"CFG.wpl"
mdmwpl=wdir"MODEM.wpl";cachewpl=wdir"CACHE.wpl";clockwpl=wdir"CLOCK.wpl"
userswpl=wdir"USERS.wpl";notifywpl=wdir"NOTIFY.wpl"
callscript ="S:"minitial"call";buscript="S:"minitial"boot"
cfglabel=l_mailer'cfg!';mdmlabel=l_mailer'modem!'
if power then do
  notifylabel=l_mailer'notify!'
  userlabel=l_mailer'users!'
  menuslabel=l_mailer'menus!'
  ftsprod="${ftsflags.$(remote.product)}"
  nameprod="${mname.$(remote.product)}"
end;else do
  notifylabel=l_mailer'!'
  ftsprod="$(ftsflags.$(remote.product))"
  nameprod="$(mname.$(remote.product))"
end
vdate='('translate(date("E"),'.','/')')';emsiserial='ShelterGen v'genver time() vdate
Say "Compiling "BOLD||Opt||AOFF" for the "BOLD||u_mailer||AOFF" Mailer"
Say "["emsiserial"]["vdate"]"
return

samestate:
dDate=(((word(arg(1),5))*86400)+(word(arg(1),6)*60))
sDate=(((word(arg(2),5))*86400)+(word(arg(2),6)*60))
if dDate>sDate then return 1
else return 0 

ckversion: procedure expose ks
if arg(3)="S" then how="SAME"
if arg(3)="B" then how="SAME or BETTER than"
if arg(3)="L" then how="SAME or EARLIER than"
if ks<39 then opt="FILE FULL";else opt="FILE"
address COMMAND 'SetEnv GTMP `Version LIBS:'arg(1) opt'`'
lver=word(getvar('GTMP','G'),2)
slver=strip(strip(compress(lver,"."),'L','0'))
nver=strip(strip(compress(arg(2),"."),'L','0'))
select
when arg(3)="S" then vis=(slver==nver)
when arg(3)="L" then vis=(slver<=nver)
when arg(3)="B" then vis=(slver>=nver)
otherwise vis=0
end
if vis=0 then do
  say arg(1) 'v'lver 'is obsolete or incompatible, Need 'how' v'arg(2)
  exit 20
end
return (vis)

emsi_ext:
tz=GetVar('TZ','G')   
if tz="" then  return 'Set host.flags "$(host.flags)]}{TRX#}{[$(host.trx)"'LF
else return 'Set host.tz 'tz' host.flags "$(host.flags)]}{TRX#}{[$(host.trx)]['tz'"'LF

emsilog:
el=logf'Remote AKAs:$(remote.akas)"'LF
el=el||logf'Mailer:$(remote.mailer)[$(remote.product)] v$(remote.version) Serial:$(remote.serial)"'LF
el=el||logf'Pass:[$(remote.password)] $(password.'sindex') TRX:$(remote.time)[$(remote.tz)] $(host.trx)[$(host.tz)]"'LF
el=el||logf'Flags:$(remote.flags),$(remote.baud)bps"'LF
el=el||logf'Remote Link:$(remote.link) Compt:$(remote.compat)"'LF
el=el||logf'Sent Host $(sentflags)"'LF
el=el||logf'Host Link:$(host.link) Compt:$(host.compat)"'LF
el=el||logf'Host AKAs:$(host.akas)"'LF
if wpldebug then el=el||flush
el=el||logw'$(p.status) $(state) $(p.host) $(host.address) $(p.remote) $(remote.address) $(p.rsysop) $(remote.sysop) $(remote.sitename)"'LF
el=el||logw' $(p.login) $(remote.mailer) v$(remote.version) $<time>"'LF
el=el||logw'$(p.hoffer) $(host.compat) $(host.link) $(p.roffer) $(remote.compat) $(remote.link) $(p.rfreqs) $(remote.freq) $(p.domain) $(remote.domain)"'LF
return el

GenProtocolSelect:
psBUF=""
do p=1 to words(pprefs)
  pp=word(pprefs,p)
  if pp="ZMO" then psBUF=psBUF'Pattern $('arg(1)'.Compat) "#?ZMO#?"'LF'TrueJump ZedZip'arg(2)||LF
  else if pp="SLK" then psBUF=psBUF'Pattern $('arg(1)'.Compat) "#?SLK#?"'LF'TrueJump SeaLink'arg(2)||LF
  else if pp="ZAP" then psBUF=psBUF'Pattern $('arg(1)'.Compat) "#?ZAP#?"'LF'TrueJump ZedZap'arg(2)||LF
  else if pp="HYD" then psBUF=psBUF'Pattern $('arg(1)'.Compat) "#?HYD#?"'LF'TrueJump HydraBi'||LF
  else if pp="JAN" & janus then psBUF=psBUF'Pattern $('arg(1)'.Compat) "#?JAN#?"'LF'TrueJump Janus'arg(2)||LF
  else if pp="DZA" then psBUF=psBUF'Pattern $('arg(1)'.Compat) "#?DZA#?"'LF'TrueJump DirectZap'arg(2)||LF
  else if pp="KER" & kermit then psBUF=psBUF'Pattern $('arg(1)'.Compat) "#?KER#?"'LF'TrueJump Kermit'arg(2)||LF
end
drop p pp
psBUF=psBUF'Jump dietifna'arg(2)||LF
return psBUF

gen_wzp:
wzp=""
wzp=wzp'Cmp $(host.wzcap) 32'LF'TrueJump HydraBi'LF
wzp=wzp'Cmp $(host.wzcap) 8'LF'TrueJump zedzap'arg(1)||LF'Cmp $(host.wzcap) 4'LF'TrueJump zedzip'arg(1)||LF'Cmp $(host.wzcap) 1'LF'TrueJump dietifna'arg(1)||LF
wzp=wzp||logf'FTS1 fallback"'LF
wzp=wzp'Set protocol FTS1 FTS1 TRUE'LF
if arg(1)='out' then wzp=wzp'Jump lotek'arg(1)||LF
return wzp


setduration:
as='Set RC $(host.trx)'LF'FalseJump 'arg(1)||LF
as=as'RexxMsg SY,RY REXX "xt=((date(I)*86400)+time(S)+252460600-(x2d(\"$(host.trx)\")));return right(\"00\"xt%3600,2)\":\"right(\"00\"xt%60//60,2)\":\"right(\"00\"xt//60,2)"'LF
as=as'Set calldur.$(remote.address) $(RESULT2)'LF
as=as||logf'$(remote.address) Session Duration $(calldur.$(remote.address))"'LF||logw'$(p.session) $(calldur.$(remote.address))"'LF
if ROOFLOG then as=as||logrl'$(remote.address) Session Duration $(calldur.$(remote.address))"'LF
return as||arg(1)':'||LF

genprogress:
proBUF='Set RC $(progress)'LF'FalseJump no_'arg(1)'progress'LF
proBUF=proBUF'Cmp $(event) PROGRESS'LF'FalseJump not'arg(1)'progress'LF

if SLASHPROGRESS then do
proBUF=proBUF'RexxMsg RY,SY REXX "return subword(\"$(LastResponse)\",2)"'LF
proBUF=proBUF'Set ProgressString "$(RESULT2)/$(ProgressString)"'LF
proBUF=proBUF||logw'$(p.response) $(RESULT2) $(p.baud) $(Baud)"'LF
end;else do
proBUF=proBUF'Set ProgressString "$(LastResponse) $(ProgressString)"'LF
proBUF=proBUF||logw'$(p.status) $(state) $(LastResponse) $(p.response) $(event) $(p.baud) $(Baud)"'LF
proBUF=proBUF||logf'$(remote.address) $(LastResponse) $(event)"'LF
end
proBUF=proBUF'Pattern $(LastResponse) CONNECT#?'LF'TrueJump 'arg(1)'connect'LF
proBUF=proBUF'Pattern $(LastResponse) CARRIER#?'LF'FalseJump get'arg(1)'response'LF
proBUF=proBUF'RexxMsg RY,SY REXX "return word(\"$(LastResponse)\",2)"'LF
proBUF=proBUF'Set Baud $(RESULT2)'LF'Jump get'arg(1)'response'LF
proBUF=proBUF'no_'arg(1)'progress:'LF
proBUF=proBUF||logw'$(p.response) $(event):$(LastResponse)"'LF
proBUF=proBUF||logf'$(remote.address) $(LastResponse) $(event)"'LF
proBUF=proBUF'Cmp $(event) CONNECT'LF'TrueJump 'arg(1)'connect'LF
proBUF=proBUF'not'arg(1)'progress:'LF
return proBUF

roofusage:
say " The Roof Mailer, unlike the other Shelter Mailers, is NOT a standalone"
SAY " mailer, but is a  part of the Roof  System.  Configuration information"
SAY " is derived from an active Roof System's CFG:ROOF.CFG.  Keywords, ENVs,"
SAY " assigns, and Roof Function Hosts are assumed to be present and active."
say ""
if ~show('p',"ROOFLOG") then CALL errorabort("The ROOFLOG Function Host is not active, exiting",20)
return

break_c:
break_d:
    say "User Abort, Click on CLOSE gadget to close window"
exit 0
novalue: call template_oops "Novalue" sigl
syntax: call template_oops "Syntax(RC="RC")" sigl RC
failure: call template_oops "Failure(RC="RC")" sigl
ioerr: call template_oops "IOErr(RC="RC")" sigl
halt: call template_oops "Halt" sigl
template_oops:
parse arg what badline code
if code~="" then Say "ERROR LINE:"badline errortext(code)
    else say "ERROR LINE:"badline what
exit(40)

warning: 
call writeln('STDERR',arg(1))
return
usage:
say BOLD"  Error:"AOFF||arg(1)
usage1:
Say BOLD"  Usage:"AOFF||template
Say BOLD"       $"AOFF"               Uses command line stored in ENV:GENMAILER_ARGS"  
say ITALICS"   Mailer:"AOFF"             "BOLD"ROOF | PORTICUS | GAZEBO | UMBRELLA"AOFF
say ITALICS"   Opt:"AOFF
say BOLD"       ALL"AOFF"             All output modules are generated (default)"
say BOLD"       KERNAL"AOFF"          Cache, Clock, [Notify] are not regenerated"
say BOLD"       CONFIG"AOFF"          Regenerate and Reload Config"
say BOLD"       CACHE"AOFF"           Regenerate and Reload Site Cache"
say ITALICS"   Switches:"AOFF
say BOLD"       NoResume"AOFF"        Disable Resume"
say BOLD"       Debug"AOFF"           Verbose Generator Output"
say BOLD"       WPLdebug"AOFF"        Verbose Mailer Output"
say BOLD"       LogResults"AOFF"      Log Results of Rexx/Wplrx execution"  
say ITALICS"   EMSI Switches:"AOFF
say BOLD"       FixDomain"AOFF"       Fix FidoNet and other domains, requires 680x0"
say BOLD"       FixKnown"AOFF"        Fix FidoNet and Known domains, requires 680x0"
say        "                             Above two switches are mutually exclusive"
say BOLD"       KillBad"AOFF"         Hangup on bad password"
say BOLD"       NoAKAS"AOFF"          Send to Presented AKAs"
say BOLD"       LooseZMH"AOFF"        Accept Arcmail and File Requests during UMH"
say ITALICS"   CfgPath:"AOFF"            path to "ITALICS"Mailer"AOFF" configuration directories"
say "                       defaults to CFG:wpl/gen/"ITALICS"MailerName"AOFF
say
exit
/**/

