/**/
v="$VER: FTPtoNOTE Rexx Set Comment to Short in AmiNet ReadMe Williamson 54.02"
ftpdir="DL:ftp/"
/*
    Reads AmiNet *.readme file and sets the filenote of the file to the
    short description
*/
    if ~show('L',"rexxdossupport.library") then do
        if ~addlib("rexxdossupport.library", 2, -30, 2) then do
            say "Couldn't access rexxdossupport.library !"
            say "Will use slow env: variable read/write procedures"
            REXXDOS=0
        end
    end

parse arg colon
if upper(colon)=":" then short="SHORT:"
else short="SHORT"
mlen=length(short)

    filelist=showdir(ftpdir,'F')
    i=1
    j=1
    do x=1 until x=words(filelist)
        fn=word(filelist,x)
        if upper(right(fn,7))='.README' then do
            rdm.i=fn
            i=i+1
        end;else do
            ftps.j=fn
            j=j+1
        end
    end

readmes=i-1
ftpfiles=j-1

do i=1 to readmes
    if ~open('f',ftpdir||rdm.i,'r') then iterate
    do while ~eof('f')
        line=COMPRESS(readln('f'),'"')
        if upper(left(line,mlen))=short then do
            note=subword(line,2)
            call findmatch(rdm.i)
        end
    end
    call close('f')
end
exit

findmatch:
    rfile=upper(arg(1))
    pattern=delstr(rfile,index(rfile,'.README'))||"#?"
    say pattern
    do match=1 to ftpfiles
        if MatchPattern(pattern,ftps.match,"N") then do
            say "File:" ftps.match
            say "Desc:" note
            address COMMAND 'FileNote' ftpdir||ftps.match '"'note'"'
            return 1
        end
    end
    Say 'Found no file for 'rfile
return 0



