/**/
v="$VER: FTNsort Rexx Multi-FTN Extract and Sort Williamson 50.32"
import_mode="DIR"   /* or PKT */
Import_Packet=""
import_Dir=""
prodfile='CFG:ftscprod.069'
/* define your AmigaDOS script here with fullpath name. This will be    */
/* executed as: 'Run >NIL: Execute' Import_Packet domain pktfile       */
/* Your script key arguments should be:                                 */
/*  .key domain/a,file/a                                                */
/*      where domain is the FTN organization name of the file           */
/*      and file is the name of the file                                */
/* your script should be able to build the fullpathname                 */
/* If no command is specified, CYBERCRON will asyncronously execute     */ 
/* InboundMGR.rexx                                                      */
/*
     Some HUBS bundle mail for all ones' addresses in a single archive
     If you know this is case for your HUB, then you can use this utility
     to extract the packets from the archive and sort them by ftn,
     moving them to the proper inbound directory.
     It may also be necessary to use this, after EMSI sessions, if your 
     tosser is not domain or zone aware.
     Written for Guy Smith ;)
*/
debug=0
options results
options failat 20
signal on syntax
signal on halt
signal on ioerr
signal on break_c
signal on break_d

if ~show("L", "rexxsupport.library") then
    if ~addlib("rexxsupport.library", 0, -30, 0) then do
        PutLog("Couldn't access rexxsupport.library !",100,10)
        exit 20
    end
if ~show("L", "rexxdossupport.library") then
    if ~addlib("rexxdossupport.library", 0, -30, 2) then do
        PutLog("Couldn't access rexxdossupport.library !",100,10)
        exit 20
    end
pragma("W","NULL")
log=show('P','ROOFLOG')
sv="v"||right(v,5)
script="FTNsort"
dolist=0;impdir=0

rpath=GetClip('REXXDIR')||"/"
dl=GetClip('DOMAINLIST')
inroot=GetCLIP('INDIR')"/"
mback=GetClip('BACKUPDIR')"/"
call makedir(inroot||"ftnsort")
sortdir=inroot||"ftnsort/"
tfile="T:FTNS-"Pragma('ID')
ImportDirList=""
parse upper arg arcmail indir .
if (~openport('CMPORT')) then do
  call PutLog('Another task has CMPORT',40,90)
  if exists('RPDIR:FTNSORT') then  address "CYBERCRON" "ADD_EVENT" '* * * * * :NAME Sort Run >NIL: FTNSORT 'arcmail indir' :EXECONCE :OBEYQUEUE i'
  else address "CYBERCRON" "ADD_EVENT" '* * * * * :NAME Sort :REXX 'rpath'FTNsort.rexx 'arcmail indir' :EXECONCE :OBEYQUEUE i'
  exit 0
end
if arcmail="" then do
  call PutLog('No file name, exiting',10,10)
  exit 0
end
if arcmail="LIST" then do
  sortlist=indir
  if ~exists(sortlist) then do
    putlog(sortlist' does not exist',10,10)
    exit
  end
  arcmail=""
  indir=""
  dolist=1
end;else if arcmail="SCAN" then do
  sortlist="T:scan"||pragma('ID')
  lspec="????????.(PK|MO|TU|WE|TH|FR|SA|SU)[T,0-9]"
  cmd='List >'sortlist addslash(indir)||lspec 'nohead LFORMAT "%S%S"'         
  PutLog('Scanning: 'indir,10,90)
  address COMMAND cmd
  arcmail=""
  dolist=1
end

if debug then wspec='CON:0/10/640/100/'script sv'/WAIT/AUTO/SCREEN'||GetClip('ASYNCSCREEN')
else wspec='CON:0/10/640/100/'script sv'/INACTIVE/AUTO/SCREEN'||GetClip('ASYNCSCREEN')
call close('STDOUT');call open('STDOUT',wspec,'w')
call close('STDIN');call open('STDIN','*','R')

if dolist=0 then call sortarc()
else do
  call putLog('Sorting mail list' sortlist,10,10)
  x=open('list',sortlist,'r') 
  if x=0 then do
    call PutLog('Cannot find 'sortlist,10,10)
    exit
  end
  do while ~eof('list')
    arcmail=readln('list')
    if arcmail="" then iterate
    if exists(arcmail) then call sortarc()
    else call PutLog(arcmail' does not exist',10,10)
  end
  call close('list')
  call delete(sortlist)
end
if import_mode="DIR" & strip(ImportDirList)~="" then do
  do i=1 to words(ImportDirList) by 2
    destdir=word(ImportDirList,i)
    domain=word(ImportDirList,i+1)
    PutLog('Requesting import of 'DOMAIN' directory:'destdir,10,10)
    if Import_Packet="" then do
      Address CYBERCRON 'ADD_EVENT * * * * * :REXX Ram:rexx/InboundMGR.rexx TOSSPKT 'domain' :EXECONCE :OBEYQUEUE i'
    end;else do
      Address COMMAND "Run >NIL: Execute" Import_Packet destdir
    end
  end
end
exit

sortarc:
if indir="" | indir="INDIR" then do
  if index(arcmail,":")>0 | index(arcmail,"/")>0 then do
    indir=get_path(arcmail)
    arcmail=get_fn(arcmail)
  end;else do
    indir=inroot||"NONSECURE/"
  end
end;else do
  indir=addslash(indir)
  arcmail=get_fn(arcmail)
end
call Pragma('D',sortdir)
fnote=subword(statef(indir||arcmail),8)

PutLog('Processing:'indir||arcmail fnote,10,10)

if right(upper(arcmail),4)='.PKT' then do
  ispacket=1
  PutLog('Moving 'arcmail' to 'sortdir,10,10)
  if ~rename(indir||arcmail,sortdir||arcmail) then do
    PutLog('Move 'indir||arcmail' to 'sortdir||arcmail' failed',10,10)
    return
  end
end;else do
  ispacket=0
  if ~MatchPattern("????????.(MO|TU|WE|TH|FR|SA|SU)[0-9]",arcmail,'N') then do
    PutLog(indir||arcmail' is not valid ARCmail',10,10)
    return 
  end
  if exists('RPDIR:X') then address COMMAND "X" indir||arcmail "*.PKT"
  else address "REXX" rpath'X.rexx' indir||arcmail
  if RC ~= 0 then do
    PutLog('Extract of 'indir||arcmail' failed',10,10)
    return
  end
end
/* get list of packets */
pktlist=showdir(sortdir,"F")
if words(pktlist)=0 then do
  PutLog('Found no packets in' sortdir,10,10)
  return
end;else do
  PutLog('Found mail packets in' sortdir,10,10)
  err=0
  /* examine each packet */
  do i=1 to words(pktlist)
    moveit=0
    pktfile=word(pktlist,i)
    pktmail=sortdir||pktfile
    if word(statef(pktmail),2) ~= '0' then do
      domain=readpkt(pktmail)
      if domain=0 then err=err+1
      else do
        destdir=addslash(inroot||domain)
        moveit=1
      end
    end
    if ~moveit then iterate
    if ~rename(pktmail,destdir||pktfile) then do
      call PutLog('Rename of 'pktmail 'to' destdir||pktfile' failed',10,10)
      err=err+1
    end;else do
      Address COMMAND "FileNote" destdir||pktfile '"'fnote'"'

      if import_mode="PKT" then do
         PutLog('Requesting import of 'destdir||pktfile,10,10)
        if Import_Packet="" then do
          Address CYBERCRON 'ADD_EVENT * * * * * :REXX Ram:rexx/InboundMGR.rexx TOSSPKT 'domain pktfile' :EXECONCE :OBEYQUEUE i'
        end;else do
          Address COMMAND "Run >NIL: Execute" Import_Packet domain pktfile
        end
      end;else do
        impdir=1
        if pos(destdir,ImportDirList)=0 then ImportDirList=ImportDirList" "destdir" "domain" "
      end
    end
  end
end
if ispacket=0 then do
  if err=0 then do
    PutLog('Deleting 'indir||arcmail,10,10)
    call delete(indir||arcmail)
  end;else do
    PutLog('Had 'err' errors, renaming 'indir||arcmail' to 'indir||arcmail||'.BAD',10,10)
    call rename(indir||arcmail,indir||arcmail||'.BAD')
   end
end
return 0


/* read a packet and get destination address and domain */
readpkt:
packet=arg(1)
if ~open('pkt',packet,'R') then do
  PutLog("Can't open "packet,10,10)
  err=err+1
  return 0
end
buffer=readch('pkt',58)
call close('pkt')

ozone=getint(46)
if ozone=0 | ozone=256 then ozone=getint(34)
dzone=Getint(48)
if dzone=0 | dzone=256 then dzone=getint(36)

if ozone=0 | ozone=256 | dzone=0 | dzone=256 then do
  PutLog("ERR: Can't find domain, zone undefined in "packet,10,10)
  err=err+1
  drop buffer packet
  return 0
end
oaddress=ozone":"getint(20)"/"getint(0)"."getint(50)
daddress=dzone":"getint(22)"/"getint(2)"."getint(52)
PutLog('Packet 'packet' from 'oaddress' for 'daddress,10,10)

odomain=find_domain(ozone)
ddomain=find_domain(dzone)
PutLog('Origin Domain:'odomain', Destination Domain:'ddomain,10,10)
pch=GetByte(42)
pcl=GetByte(24)
pc=right("0000"||d2x(pcl),4)  
pver='v'||GetByte(25)'.'GetByte(43)
drop buffer packet
found=0
if open('pf',prodfile,'r') then do
  do while ~eof('pf')
    q=readln('pf')
    if left(q,length(pc))=pc then do
      found=1
      parse var q qa ',' name ',' qa ',' type ',' qa ',' qa
      leave
    end
  end
  call close('pf')
end
if found then call PutLog('Product:'name '('pc')' type pver' from 'oaddress,10,10)
else call PutLog('Product:'pch pcl '('pc')' pver' from 'oaddress,10,10)
return ddomain

getint:   return c2d('00'x||reverse(substr(buffer,arg(1)+1,2)))
getint2:  return right('00'||c2d('00'x||reverse(substr(buffer,arg(1)+1,2))),2)
getbyte:  return c2d('00'x||substr(buffer,arg(1)+1,1)) 

PutLog:  procedure expose log script
  if arg(3) < GetClip('STATUSLEVEL') then say arg(1)
  if arg(2) > GetClip('LOGLEVEL') then return 0
  if log then address 'ROOFLOG' 'logline' left(time(),5) script': 'arg(1)
return 0

cleanup:
  PutLog('Exiting',10,10)
  if exists(tfile) then call delete(tfile)
return 0


addslash:
curr=arg(1)
select
  when right(curr, 1)=":" then nop
  when right(curr, 1)="/" then nop
  otherwise curr=curr"/"
end
return(curr)

get_path:
pos=LastPos('/',arg(1))
if pos=0 then pos=LastPos(':',arg(1))
return SubStr(arg(1),1,pos)

get_fn:
if LastPos('/',arg(1))~=0 then return SubStr(arg(1),LastPos('/',arg(1))+1)
else if LastPos(':',arg(1))~=0 then return SubStr(arg(1),LastPos(':',arg(1))+1)
else return arg(1)

/*  Error handling */
break_c:
break_d:
    call cleanup
    exit 10
novalue: call template_oops "Novalue" sigl
syntax:  call template_oops "Syntax(RC="||RC||")" sigl RC
failure: call template_oops "Failure(RC="||RC||")" sigl
ioerr:   call template_oops "IOErr" sigl 
halt:    call template_oops "Halt" sigl 
template_oops: procedure
    parse arg what badline code
    if code ~= "" then call PutLog("ERR: Line" badline what errortext(code),10,10)
    else call PutLog("ERR: Line "badline what,10,10)
    call cleanup
    exit(40)
/**/

find_domain: procedure expose dl
dz=FIND(dl,arg(1))
if dz=0 then return 0
else return strip(word(dl,dz-1))
