/**/
v="$VER: FreqNote Rexx Set filenote to description Williamson 56.10"
outdir=addslash(GetClip("OUTDIR"))
parse arg indir site_address .
indir=addslash(indir)
parse var site_address d "#" z ":" n "/" f "." p

options failat 40

reqck=1;req=z'.'n'.'f'.'p'.REQCK'
if ~open('rf',outdir||req,'r') then do
    req=z'.'n'.'f'.'p'.REQTEMP'
    if ~open('rf',outdir||req,'r') then exit
    else reqck=0
end
inlist=upper(showdir(INDIR,'F'))
if inlist="" then exit
q=1
do while ~eof('rf')
    request=translate(readln('rf'),' ','09'x)
    say request
    if request="" then iterate
    if reqck then do
        parse var request request.q reqdesc.q
    end;else do
        x=pos('!',request);y=pos(';',request)
        if (x>0 & y>0) & x<y then parse var request request.q '!' password ';' reqdesc.q
        else parse var request request.q ';' reqdesc.q
    end
    if pos(">",reqdesc.q)>0 then parse var reqdesc.q reqdesc.q '>' reqdest.q
    else reqdest.q=""
    request.q=strip(request.q);reqdesc.q=strip(reqdesc.q);reqdest.q=strip(reqdest.q)
    q=q+1
end
requests=q-1
i=0
do forever
    i=i+1
    parse var inlist infile.i inlist
say infile.i
    if infile.i == "" then break
end
recd=i-1
if recd=0 then exit

do i=1 to recd
    do j=1 to requests
        if upper(request.j)=upper(infile.i) then do
            if show('p',"ROOFLOG") then Address "ROOFLOG"  'logline' left(time(),5) 'FreqNote: 'request.j':'strip(compress(reqdesc.j,'"'),'B')
            address COMMAND 'FileNote' indir||request.j '"'strip(compress(reqdesc.j,'"'),'B')'"'
            if reqdest.j~="" then do
                if exists(reqdest.j) then call movefile()
                else do
                  if pos(left(infile.i,5),reqdest.j)>0 then call movefile()  
                  else if show('p',"ROOFLOG") then Address "ROOFLOG"  'logline' left(time(),5) 'FreqNote: Destination 'reqdest.j' does not exist'
                end
            end
        end
    end
end
call delete(outdir||z'.'n'.'f'.'p'.REQHYD')
exit

movefile:
  if show('p',"ROOFLOG") then Address "ROOFLOG"  'logline' left(time(),5) 'FreqNote: Moving 'request.j' to 'reqdest.j
  address COMMAND 'COPY 'indir||request.j' TO 'reqdest.j' CLONE'
  if RC=0 then call delete(indir||request.j)
return

addslash:
curr=arg(1)
select
    when right(curr, 1) = ":" then nop
    when right(curr, 1) = "/" then nop
    otherwise curr = curr"/"
end
return(curr)
