#include <stdlib.h>

#define SETELEMENT int
#define NUMELEMENTS 10  // The number of elements in the universal set
#define MINELEMENT -3   // The smallest possible element

class Set {
private:
	#define SETELEMENTSIZE (NUMELEMENTS >> 3) + 1
	char *SetElements;
	void AddElem(SETELEMENT); // add an element to the set
	void ClearSet();          // creates the empty set
public:
	Set() {
		SetElements = (char *) malloc(SETELEMENTSIZE);
		ClearSet();
	} // end of Set() constructor

	Set(int size, SETELEMENT *Elements) {
		int counter;
		SetElements = (char *) malloc(SETELEMENTSIZE);
		ClearSet();
		for(counter = 0; counter < size; counter++) {
			AddElem(Elements[counter]);
		}
	} // end of Set(size, Elements) constructor

	Set(SETELEMENT Element) {
		SetElements = (char *) malloc(SETELEMENTSIZE);
		ClearSet();
		AddElem(Element);
	} // end of Set(Element) constructor

	~Set() {
		free(SetElements);
	} // end of ~Set() destructor

	Set operator=(Set);  // assignment
	Set operator+(Set);  // union
	Set operator|(Set);  // union
	Set operator+=(Set);
	Set operator|=(Set);
	Set operator-();     // inversion
	Set operator~();     // inversion
	Set operator*(Set);  // intersection
	Set operator^(Set);  // intersection
	Set operator&(Set);  // intersection
	Set operator*=(Set);
	Set operator^=(Set);
	Set operator&=(Set);
	Set operator-(Set);  // intersection of inversion (difference)
	Set operator-=(Set);
	int operator==(Set); // equivalence
	int operator!=(Set); // inequivalence
	int operator<=(Set); // subset
	int operator<(Set);  // proper subset
	int operator>=(Set); // superset
	int operator>(Set);  // proper superset

};
