#include "Sets.HPP"
#include <stdio.h>

static int counter;
#define DoOnWholeArray(x) for(counter = 0; counter < SETELEMENTSIZE; counter++) x

void Set::AddElem(SETELEMENT Element) {
	SETELEMENT Elem = Element - MINELEMENT;
	SETELEMENT Segment, Offset;

	Segment = Elem >> 3; // Elem / 8
	Offset = Elem - (Segment << 3); // Elem mod 8
	SetElements[Segment] |= 1 << Offset;
}

void Set::ClearSet() {
	DoOnWholeArray(SetElements[counter] = 0);
}

Set Set::operator=(Set Set2) {
	DoOnWholeArray(SetElements[counter] = Set2.SetElements[counter]);
	return *this;
}

Set Set::operator+(Set Set2) {
	Set Result;
	DoOnWholeArray(Result.SetElements[counter] = SetElements[counter] | Set2.SetElements[counter]);
	return Result;
}

Set Set::operator|(Set Set2) {
	Set Result;
	DoOnWholeArray(Result.SetElements[counter] = SetElements[counter] | Set2.SetElements[counter]);
	return Result;
}

Set Set::operator+=(Set Set2) {
	DoOnWholeArray(SetElements[counter] |= Set2.SetElements[counter]);
	return *this;
}

Set Set::operator|=(Set Set2) {
	DoOnWholeArray(SetElements[counter] |= Set2.SetElements[counter]);
	return *this;
}

Set Set::operator-() {
	Set Result;
	DoOnWholeArray(Result.SetElements[counter] = ~SetElements[counter]);
	return Result;
}

Set Set::operator~() {
	Set Result;
	DoOnWholeArray(Result.SetElements[counter] = ~SetElements[counter]);
	return Result;
}

Set Set::operator*(Set Set2) {
	Set Result;
	DoOnWholeArray(Result.SetElements[counter] = SetElements[counter] & Set2.SetElements[counter]);
	return Result;
}

Set Set::operator^(Set Set2) {
	Set Result;
	DoOnWholeArray(Result.SetElements[counter] = SetElements[counter] & Set2.SetElements[counter]);
	return Result;
}

Set Set::operator&(Set Set2) {
	Set Result;
	DoOnWholeArray(Result.SetElements[counter] = SetElements[counter] & Set2.SetElements[counter]);
	return Result;
}

Set Set::operator*=(Set Set2) {
	DoOnWholeArray(SetElements[counter] &= Set2.SetElements[counter]);
	return *this;
}

Set Set::operator^=(Set Set2) {
	DoOnWholeArray(SetElements[counter] &= Set2.SetElements[counter]);
	return *this;
}

Set Set::operator&=(Set Set2) {
	DoOnWholeArray(SetElements[counter] &= Set2.SetElements[counter]);
	return *this;
}

Set Set::operator-(Set Set2) {
	Set Result;
	DoOnWholeArray(Result.SetElements[counter] = SetElements[counter] & (~Set2.SetElements[counter]));
	return Result;
}

Set Set::operator-=(Set Set2) {
	DoOnWholeArray(SetElements[counter] &= !Set2.SetElements[counter]);
	return *this;
}

int Set::operator==(Set Set2) {
	int Equivalent = -1;
	DoOnWholeArray(Equivalent &= (SetElements[counter] == Set2.SetElements[counter]));
	return Equivalent;
}

int Set::operator!=(Set Set2) {
	int NotEquivalent = 0;
	DoOnWholeArray(NotEquivalent |= (SetElements[counter] != Set2.SetElements[counter]));
	return (NotEquivalent != 0);
}

int Set::operator<=(Set Set2) {
	int Subset = -1;
	DoOnWholeArray(Subset &= (~SetElements[counter] | Set2.SetElements[counter]));
	return (Subset == -1);
}

int Set::operator<(Set Set2) {
	int Subset = 0;
	DoOnWholeArray(Subset |= (SetElements[counter] != Set2.SetElements[counter]));
	Subset = (Subset != 0 ) ? -1 : 0;
	DoOnWholeArray(Subset &= (~SetElements[counter] | Set2.SetElements[counter]));
	return (Subset == -1);
}

int Set::operator>=(Set Set2) {
	int Superset = -1;
	DoOnWholeArray(Superset &= (SetElements[counter] | ~Set2.SetElements[counter]));
	return (Superset == -1);
}

int Set::operator>(Set Set2) {
	int Superset = 0;
	DoOnWholeArray(Superset |= (SetElements[counter] != Set2.SetElements[counter]));
	Superset = (Superset != 0) ? -1 : 0;
	DoOnWholeArray(Superset &= (SetElements[counter] | ~Set2.SetElements[counter]));
	return (Superset == -1);
}

