#! /usr/bin/awk -f
#
# convert qbsp acceptable list of items to a format
# acceptable by the function 'CtfItems' in _ctf.qc.
#

{
  if ($1 ~ /^\{.*$/) { 
    p = 1; 
  }
  else if ($1 ~ /^\}.*$/) {
    p = 0;
    n = n + 1;
    if (!have_classname) { printf "Error: entity has no classname\n"; exit; }
    printf "c%-2d = %-15s; ",n,c;
    if (have_angle)  printf "a%-2d = %-6s;   ",n,a;
    else             printf "%16s"," ";
    if (have_origin) printf "o%-2d = %-19s;   ",n,o;
    else             printf "%20s"," ";
    if (have_random_type) printf "r%-2d = %-5s;   ",n,r;
    else             printf "%20s"," ";
    if (have_spawnflags) printf "s%-2d = %-6s;   ",n,s;
    else             printf "%20s"," ";
    printf "\n";
    have_classname = 0;
    have_angle = 0;
    have_origin = 0;
    have_random_type = 0;
    have_spawnflags = 0;
  }
  else if (p==1) {
    if ($1 ~ /"classname"/) {
      if ($2 ~ /"item_flag_team1"/) {
	have_classname = 1;
	c="_FLAG_TEAM1";
      }
      else if ($2 ~ /"info_player_team1"/) {
	have_classname = 1;
	c="_SPOT_TEAM1";
      }
      else if ($2 ~ /"item_flag_team2"/) {
	have_classname = 1;
	c="_FLAG_TEAM2";
      }
      else if ($2 ~ /"info_player_team2"/) {
	have_classname = 1;
	c="_SPOT_TEAM2";
      }
      else if ($2 ~ /"weapon_nailgun"/) {
	have_classname = 1;
	c="_NAILGUN";
      }
      else if ($2 ~ /"item_spikes"/) {
	have_classname = 1;
	c="_SPIKES";
      }
      else if ($2 ~ /"item_rockets"/) {
	have_classname = 1;
	c="_ROCKETS";
      }
      else if ($2 ~ /"item_shells"/) {
	have_classname = 1;
	c="_SHELLS";
      }
      else if ($2 ~ /"weapon_supershotgun"/) {
	have_classname = 1;
	c="_SUPERSHOTGUN";
      }
      else if ($2 ~ /"weapon_supernailgun"/) {
	have_classname = 1;
	c="_SUPERNAILGUN";
      }
      else if ($2 ~ /"item_armor2"/) {
	have_classname = 1;
	c="_ARMOR_YELLOW";
      }
      else if ($2 ~ /"item_armorInv"/) {
	have_classname = 1;
	c="_ARMOR_RED";
      }
      else if ($2 ~ /"item_health"/) {
	have_classname = 1;
	c="_HEALTH";
      } else {
	printf "Error: unidentified classname\n"; 
        exit;
      }
    }
    else if ($1 ~ /"angle"/) {
      have_angle = 1;
      a = $2;
      gsub("\"","",a);
    }
    else if ($1 ~ /"origin"/) {
      have_origin = 1;
      o = "'" $2 " "$3 " " $4 "'";
      gsub("\"","",o);
    }
    else if ($1 ~ /"random_type"/) {
      have_random_type = 1;
      r = $2;
      gsub("\"","",r);
    }
    else if ($1 ~ /"spawnflags"/) {
      have_spawnflags = 1;
      s = $2;
      gsub("\"","",s);
    } else {
      printf "Error: unidentified entity field\n"; 
      exit;
    }
  }
}

