{ SERIAL.PAS   Serial Por Managment object
  TURBO PASCAL V7.0  (it should work with 6.0)
  January 1996
  Bugs, improvments, comments, etc:  Luis Alfonso Lastras
                                     lalm@cactus.iico.uaslp.mx


  The main purpose of this object is to do the most disgusting thing with
  serial ports: reading data through them. Writing data is a matter of usign
  a text variable and assigning it to 'COM1', but reading is a real pain.

  TESTSER.PAS is sample program for using this object;
}

unit serial;

interface
uses circular;

type
 PortNames = (COM1,COM2);

 PByte = ^Byte;

{ Serial Port object. Note: should only be called once, because uses only one buffer }
 PSerialPort = ^TSerialPort;
 TSerialPort = object
    SerialBuffer : PCircularBuffer;
    constructor Init(PortN : PortNames; BaudRate, Parity, Data,  Stop : integer);
    destructor Done;
 end;

 TPortData = array[Portnames] of word;

 procedure InterruptFunc(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Word); interrupt;


var
 Buffer        : TCircularBuffer;   { Buffer for the received data }
 Initialized   : boolean;
 PortNum       : PortNames;
 SaveInterrupt : Pointer;
const
{ 8250 UART port address offsets }
 Data    = 0;   { Send or receive data }
 BaudDiv = 0;   { Baud rate divisor (DLAB set to 1 }
 EnInt   = 1;   { Enable interrupts }
 IntId   = 2;   { Interrupt identification }
 LnCtrl  = 3;   { Line control }
 MdmCtrl = 4;   { MODEM control }
 LnStat  = 5;   { Line status }
 MdmStat = 6;   { MODEM status }

 DLAB    = $80;    { Divisor Latch Access Bit (in Line Control Register }
 DTR     = $01;    { Data Terminal Ready (in MODEM Control Register) }
 RTS     = $02;    { Request to Send (in MODEM Control Registere) }
 OUT2    = $08;    { UART OUT2 enables Interrupts on IBM-PC }
 RXINT   = $01;    { Enable Receive Interrupts for UART }
 RXREADY = $01;    { Receive Ready Bit (in Line Status Register }
 TXREADY = $60;    { Transmit Holding & Shift Register Empty bits }
 INTPEND = $01;    { This bit will be Zero if an interrupt is pending }
 DCTS    = $01;    { Delta (change in) Clear to Send }
 DDSR    = $02;    { Delta (change in) Data Set Ready }
 DRI     = $04;    { Delta (change in) Ring Indicator }
 DDCD    = $08;    { Delta (change in) Data Carrier Detect }
 CTS     = $10;    { Clear to Send }
 DSR     = $20;    { Data Set Ready }
 RI      = $40;    { Ring Indicator }
 DCD     = $80;    { Data Carrier Detect }

 CLOCK   = $1C200;  { Baud Rate Clock (1,843,200/16) }

 NONE    = 0;       { Parities }
 ODD     = 1;
 EVEN    = 3;
 MARK    = 5;
 SPACE   = 7;

 PICMR   = $21;     { Priority Interrupt Controller Mask Address }
 PICCR   = $20;     { Priority Interrupt Controller Control Reg. Address }
 EOI     = $20;     { End of interrupt signal }

 PortAdr : TPortData = ($03F8,$02F8);      { Serial port addresses }
 PortVec : TPortData = ($0C,$0B);          { Serial port vector numbers }
 PICMask : TPortData = ($10,$08);          { Masks for the priority interrupt controller }

implementation
uses dos;

procedure InterruptFunc(Flags, CS, IP, AX, BX, CX, DX, SI, DI, DS, ES, BP: Word);
var
  Data : byte;
  v : boolean;
begin
   Data := Port[PortAdr[PortNum]];
   v := Buffer.AddData(Data);
   Port[PICCR] := EOI;
end;

constructor TSerialPort.Init(PortN : PortNames; BaudRate, Parity, Data,Stop : integer);
var
  pic   : byte;
  adr   : integer;
  joker : byte;
begin
 If not Initialized then
  begin
    PortNum := PortN;
    adr := PortAdr[PortNum];
    Buffer.Init(1000);                                 { Buffer with 1000 bytes capability }
    SerialBuffer := @Buffer;                           { This is for external use }

    Port[adr+LnCtrl]  := DLAB;                         { Access divisor latch... }
    PortW[adr+BaudDiv] := Word(CLOCK DIV BaudRate);    { then set baud rate      }
    Port[adr+LnCtrl]  := (Data-5) OR (parity SHL 3) OR ((stop-1) SHL 2);  { Parity, Data bits and stop bits }

    GetIntVec(PortVec[PortNum],SaveInterrupt);         { Save old interrupt }
    SetIntVec(PortVec[PortNum],Addr(InterruptFunc));   { Install new interrupt function }

    { Enable interrupts in UART }
    Port[adr+MdmCtrl] := DTR or RTS or OUT2;
    Port[adr+EnInt] := RXINT;

    { Unmask the priority interrupt controller }
    pic := Port[PICMR];
    pic := Pic AND (not PICMask[PortNum]);
    Port[PICMR] := pic;

    If (Port[adr+LnStat] or $FE) = $FE then Joker := Port[adr+Data];      { Read any stuck byte }

    Initialized := true;       { To ensure the object is not called again }
  end;
end;

destructor TSerialPort.Done;
var
  adr : integer;
  pic : byte;
begin
  Buffer.Done;
  adr := PortAdr[PortNum];
  Port[adr+EnInt] := 0;
  Port[adr+MdmCtrl] := 0;
  pic := Port[PICMR];
  pic := pic or PicMASK[PortNum];
  Port[PICMR] := pic;
  SetIntVec(PortVec[PortNum],SaveInterrupt);    { Reset the saved interrupt }
  Initialized := false;        { Now you may call the serial object again }
end;

begin
  Initialized := false;
end.
