{ CIRCULAR.PAS   Circular Buffer object
  TURBO PASCAL V7.0  (it should work with 6.0)
  January 1996
  Bugs, improvments, comments, etc:  Luis Alfonso Lastras
                                     lalm@cactus.iico.uaslp.mx

  TCircularBuffer is a buffer of maximum 2000 bytes. You can add data to the
  buffer using the object's function AddData and extract it using ExtractByte
  The purpose of this buffer is that you could add and extract bytes
  without taking care of indexing matters.
  It was developed for use with the serial.pas unit
}

unit circular;

interface
const
  BUFFER_NORMAL = 0;
  BUFFER_EMPTY  = 1;
  BUFFER_FULL   = 2;

type
 PMB = ^MaxBuffer;
 MaxBuffer = array[0..2000] of byte;

 PCircularBuffer = ^TCircularBuffer;
 TCircularBuffer = object
    Buffer  : PMB;
    BufSize : word;
    First   : word;    { Position of the first available data }
    New     : word;    { Position of the first new position for adding data  }
                       { Note: if First = New, then no data is available in the buffer }

    constructor Init(BufferSize : word);
    function Next(index : word) : word;
    function Previous(index : word) : word;
    function AddData(Data : byte) : boolean;              { returns true if successfully added }

    function ExtractByte(var Data : byte) : boolean;      { returns true if succesfully extracted byte }

    function BufferStatus : word;                         { returns BUFFER_NORMAL, BUFFER_EMPTY OR BUFFER_FULL }
    function ExtractLine(TermChr : char; var Line : string) : boolean;
    destructor Done;
 end;

implementation

constructor TCircularBuffer.Init(BufferSize : word);
begin
  BufSize := BufferSize+1;  { Due configuration of circular buffer, one extra byte is needed for chaining purposes }
  GetMem(Buffer,BufSize);
  First := 0;               { Buffer data is numbered from 0 to BufSize-1}
  New   := 0;
end;
{ This function will scan for a termination character (TermChr) and
  if it exists, will copy all the string into Line
  True -> succesful   False- not succesful
}

function TCircularBuffer.ExtractLine(TermChr : char; var Line : string) : boolean;
var
   c : byte;
   SaveIndex : word;
   Found : boolean;
begin
  Line := '';               { Init line }
  SaveIndex := First;
  Found := false;
  while ExtractByte(c) do
   if chr(c) = TermChr then Found := true else Line := Line+chr(c);

  if Found then ExtractLine := true else
    begin
      first := SaveIndex;    { Restore index as it was }
      ExtractLine := false;
    end;
end;


function TCircularBuffer.Next(index : word) : word;
begin
 if index = (BufSize-1) then Next := 0
                        else Next := index+1;
end;

function TCircularBuffer.Previous(index : word) : word;
begin
 if index = 0 then Previous := BufSize-1
              else Previous := index-1;
end;

function TCircularBuffer.AddData(Data : byte) : boolean;
begin
 if Next(New)<>First then     { if no data overlapping can happe ... }
   begin
    Buffer^[New] := Data;      { Add the data }
    New := Next(New);         { Increment the counter }
    AddData := true;           { Data successfully added to the buffer }
   end
  else
    AddData := false;          { Data overlapping would ocurr. Byte not added to the buffer }
end;

{ This function returns in Data the next available byte in the buffer and
  makes the proper index adjustments. It returns false if no data was available }
function TCircularBuffer.ExtractByte(var Data : byte) : boolean;
begin
  if First <> New then
    begin
      Data  := Buffer^[First];
      First := Next(First);
      ExtractByte := true;
    end
   else ExtractByte := false;
end;

function TCircularBuffer.BufferStatus : word;
var
  Status : word;
begin
  Status := BUFFER_NORMAL;
  if First=New then Status := BUFFER_EMPTY;
  if Next(New)=First then Status := BUFFER_FULL;
  BufferStatus := Status;
end;

destructor TCircularBuffer.Done;
begin
  FreeMem(Buffer,BufSize);
end;

end.