//PAGE.CPP
//Elementfunktionen und Konstruktor
#include <page.h>
#include <stdio.h>

BYTE far swap[MAXPIX];    //Externe definition in pgextern.h
BYTE far pic[MAXPIX];

PAGE::PAGE()
{
  fpsegm[0]=FP_SEG(swap);
  fpoffs[0]=FP_OFF(swap);
  fpsegm[1]=FP_SEG(pic);
  fpoffs[1]=FP_OFF(pic);
  vram=(BYTE *)MK_FP(VIDEOSEGM,VIDEOOFFS);
}

BOOL PAGE::InitVGA(BYTE modus)
{
  if(modus<=GAME)
   {
     r.h.ah=0x00;
     r.h.al=modus;
     int86(0x10,&r,&r);
     return TRUE;
   }
 return FALSE;
}
//***************************************************
//VRAM ausschalten
void PAGE::Screen(BYTE status)
{
  r.h.ah=0x12;
  r.h.bl=0x36;
  r.h.al=status;
  int86(0x10,&r,&r);
}
//***************************************************
void PAGE::Fill(BYTE page,BYTE color)
{
  switch(page)
  {
   case SWAP:
     setmem(swap,MAXPIX,color);
     break;
   case PIC:
     setmem(pic,MAXPIX,color);
     break;
   case VRAM:
     setmem(vram,MAXPIX,color);
  }
}
