//BMP.H
//Klassendefinition
#ifndef __BMP_H
#define __BMP_H
#include <defin.h>
#include <stdio.h>
const DWORD RGB_SIZE=768;
const DWORD TEN_PAL=7680;
const DWORD NUM_OF_PICS=4000;
const DWORD GLOBAL_HEAD_SIZE=64022;

class BITMAP{
 private:
    BYTE far *vram;  //Zeiger auf VRAM
    char testproginfo[19];
    char s_name[10];
    struct {
	    char  name[10];
	    WORD  pal;
	    DWORD pixnum;
	    WORD  x;
	    WORD  y;
	    WORD  midx;
	    WORD  midy;
	    WORD  fill;
	   }head;
    FILE *in;
    char palette[RGB_SIZE];
 public:
    BITMAP();
    WORD InitResource(char filename[],SPRITE bmp[]);
    void CloseResource(void);
    BOOL LoadSprite(WORD name,SPRITE bmp[]);
    BOOL LoadSpriteToPage(WORD name,SPRITE bmp[],BYTE page);
    void Free(WORD name,SPRITE bmp[]);
    BOOL Put(WORD name,SPRITE bmp[],int x,int y,BYTE page,BOOL FAST);
    BOOL Zoom(WORD name,SPRITE bmp[],int x,int y,BYTE zoom,BYTE page);
    WORD Offset(int x,int y);
    void InitPalette(WORD palnr);
    BOOL SetRGB(int color,BYTE red,BYTE green,BYTE blue);

};
#endif