//BMP.CPP
//Elementfunktionen und Konstruktor
#include <page.h>
#include <bmp.h>
#include <draw.h>
#include <error.h>
#include <defin.h>
#include <pgextern.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
DRAW Draw;
ERROR Error;
BITMAP::BITMAP()
{
   vram=(BYTE *)MK_FP(VIDEOSEGM,VIDEOOFFS);
}
//*******************************************************************
WORD BITMAP::InitResource(char filename[],SPRITE bmp[])
{
  WORD i,nr,sprite_num=0;
  BOOL hires;
  DWORD offset;
   if((in=fopen(filename,"rb"))!=NULL)
    {
     fread(testproginfo,sizeof(testproginfo),1,in);
     if((strcmp("SpriteEnginePro220",testproginfo))==NULL)
      {
	fread(&hires,sizeof(BOOL),1,in);
	   if(hires==TRUE)
	      return FALSE;
	fread(&sprite_num,sizeof(WORD),1,in);
	for(i=0;i<sprite_num;i++)
	 {
	   fread(&nr,sizeof(WORD),1,in);
	   fread(s_name,sizeof(s_name),1,in);
	   fread(&offset,sizeof(DWORD),1,in);
	   bmp[i].offset=offset;
	 }
	for(i=0;i<sprite_num;i++)
	 {
	   fseek(in,bmp[i].offset,SEEK_SET);
	   fread(&head,sizeof(head),1,in);
	   bmp[i].x=head.x;
	   bmp[i].y=head.y;
	 }
      }
    }
  else
    {
      Error.Code(FILE_NOT_FOUND,filename);
      return FALSE;
    }
  return sprite_num;
}

void BITMAP::CloseResource(void)
{
   fclose(in);
}
//*******************************************************************
//Sprite laden und in  Puffer speichern
BOOL BITMAP::LoadSprite(WORD name,SPRITE bmp[])
{
   WORD i;
   BYTE color;
   fseek(in,bmp[name].offset,SEEK_SET);
   fread(&head,sizeof(head),1,in);
   if(!(bmp[name].color=(BYTE far *) new BYTE[head.pixnum]))
      {
	CloseResource();
	Error.Code(NOT_ENOUGH_MEM,"die Resource");
      }
   for(i=0;i<head.pixnum;i++)
     {
	fread(&color,sizeof(BYTE),1,in);
	*(bmp[name].color+i)=color;
     }
  return TRUE;
}
//*******************************************************************
BOOL BITMAP::LoadSpriteToPage(WORD name,SPRITE bmp[],BYTE page)
{
   WORD i;
   BYTE color;
   fseek(in,bmp[name].offset,SEEK_SET);
   fread(&head,sizeof(head),1,in);
   if(head.pixnum!=MAXPIX)
      return FALSE;
   for(i=0;i<head.pixnum;i++)
    {
      fread(&color,sizeof(BYTE),1,in);
      switch(page)
       {
	case SWAP:
	  swap[i]=color;
	  break;
	case PIC:
	  pic[i]=color;
	  break;
	case VRAM:
	  pokeb(VIDEOSEGM,i,color);
	  break;
       }
    }
  return TRUE;
}
//*******************************************************************
void BITMAP::Free(WORD name,SPRITE bmp[])
{
   delete bmp[name].color;
}
//*******************************************************************
//Sprite in Bildschirmseite schreiben
BOOL BITMAP::Put(WORD name,SPRITE bmp[],int x,int y,BYTE page,BOOL FAST)
{
  WORD i,pixnum;
 int xt=0,yt=0,xmid,ymid;
 WORD position;
 pixnum=bmp[name].x*bmp[name].y;
 if(FAST==TRUE && page==SWAP)
  {
    position=Offset(x,y);
    for(i=0;i<pixnum;i++)
     {
       if((*(bmp[name].color+i))==NOCOLOR)
	   continue;
       swap[position+i]=*(bmp[name].color+i);
     }
    return TRUE;
  }
  xmid=bmp[name].x/2;//Mittelpunkt
  ymid=bmp[name].y/2;
  x-=xmid;  //Damit das Sprite mittig gezoomt wird
  y-=ymid;
 for(i=0;i<pixnum;i++) //i um den Zeiger zu erhhen
  {
    position=Offset(x+xt,y+yt);
    xt++;
    if(xt>=bmp[name].x)
    {
      xt=0;
      yt++;
    }
   if((*(bmp[name].color+i))!=NOCOLOR)
   {
     switch(page)
     {
      case SWAP:
	 swap[position]=*(bmp[name].color+i);
	 break;
      case PIC:
	 pic[position]=*(bmp[name].color+i);
	 break;
      case VRAM:
	 pokeb(VIDEOSEGM,position,*(bmp[name].color+i) );
     }
   }
  }
}
//**********************************************************************
//Sprite zoomen; Das mit LoadSprite geladene Sprite kann nur vergrert werden.
BOOL BITMAP::Zoom(WORD name,SPRITE bmp[],int x,int y,BYTE zoom,BYTE page)
{
 WORD i,pixnum;
 int high,wide,xt=0,yt=0,xr=0,yr=0;
 if(zoom==0)
  {
    Put(name,bmp,x,y,page,FALSE);
    return FALSE;
  }
 x-=(bmp[name].x/2)*(zoom+1);//Damit das Sprite mittig gezoomt wird
 y-=(bmp[name].y/2)*(zoom+1);
 wide=bmp[name].x;//Breite
 high=bmp[name].y;//Hhe
 pixnum=bmp[name].x*bmp[name].y;
 for(i=0;i<pixnum;i++) //i um den Zeiger zu erhhen
  {
   if((*(bmp[name].color+i))!=NOCOLOR)
     Draw.Bar(xt+xr+x,yt+yr+y,xt+xr+x+zoom,yt+yr+y+zoom,*(bmp[name].color+i),page);
   xr+=zoom;
   xt++;
   if(xt>=bmp[name].x)
    {
      xt=0;
      xr=0;
      yr+=zoom;
      yt++;
    }
  }
}

WORD BITMAP::Offset(int x,int y)
{
 if(x>319)
    x=319;
 else if(x<0)
    x=0;
 if(y>199)
    y=199;
 else if(y<0)
    y=0;
 return 320*y+x;
}
//***************************************************
//Globale Farbpalette aktivieren
void BITMAP::InitPalette(WORD palnr)
{
  union REGS r;
  struct SREGS s;
  DWORD offs;
  if(palnr>9)
      palnr=0;
  offs=GLOBAL_HEAD_SIZE+(RGB_SIZE*palnr);
  fseek(in,offs,SEEK_SET);
  fread(&palette,sizeof(palette),1,in);
  r.x.dx=FP_OFF(palette);
  s.es=FP_SEG(palette);
  r.h.ah=0x10;
  r.h.al=0x12;
  r.x.bx=0;
  r.x.cx=256;
  int86x(0x10,&r,&r,&s);
}

BOOL BITMAP::SetRGB(int color,BYTE red,BYTE green,BYTE blue)
{
  color=color*3;
  if(color>767)
     return FALSE;
  palette[color]=red;
  palette[color+1]=green;
  palette[color+2]=blue;
 return TRUE;
}