#TEMPLATE (SecWin10, 'Datasoft Program Security for Clarion 1.5')
#!=====================================================================
#EXTENSION (Activate_Security,'Activate SecWin features'),APPLICATION
#!----------------------
#DISPLAY ()
#DISPLAY ('Enter the unique name of this Application.')
#DISPLAY ('You may use up to 20 characters and spaces are allowed.')
#DISPLAY ('Do NOT put the Version Number on this line')
#DISPLAY ()
#DISPLAY ('Note that if this module is a DLL, then this name is')
#DISPLAY ('not used - the name in the parent App is used.')
#DISPLAY ()
#PROMPT ('Unique Application Name :',@s20),%ApplicName
#PROMPT ('SecWin data defined in another DLL',Check),%SecWinExternal,AT(10,)
#PROMPT ('Export Secwin data defined in this DLL to other Dll''s & Apps',Check),%ThisDll,AT(10,)
#Display ()
#Prompt ('Enter the Application PIN number',@n-13),%AppPIN
#Prompt ('Use Btrieve files (not recommended)',check),%UseBtrieve,at(10)
#Display('Only 16 bit Btrieve is currently supported')
#Display('Only the commercial version of SecWin supports Btrieve.')
#!----------------------
#AT(%CustomGlobalDeclarations)
#IF(%Target32)
  #PROJECT('Secwin32.Lib')
#ELSE
  #IF(%UseBtrieve)
    #PROJECT('SecBtr16.Lib')
  #ELSE
    #PROJECT('Secwin16.Lib')
  #ENDIF
#ENDIF
#ENDAT
#!------------
#AT(%GlobalMap)
  include('SecMap15.Clw')
  #IF (%SecWinExternal)
  module('Other')  ! these are added to the dll where the SecWin data is.
    qAdd()
    qGet()
    qDelete()
  .
  #ENDIF
#ENDAT
#!---------
#GLOBALDATA
#ENDGLOBALDATA
#!------------
#AT(%GlobalData)
  include ('SecEqu15.Clw')
  #IF (%SecWinExternal)
AppNameDesc  string(20),External,Dll
AppNum         long,External,Dll
  #ELSIF (%ThisDll)
#!AppNameDesc string(20)  ! exp ordinal number problem
#!AppNum     long         ! exp ordinal number problem
AppNumQueue  Queue,pre()
AppNumV        long
             .
  #ELSE
AppNameDesc  string(20)
AppNumQueue  Queue,pre()
AppNum         long
             .
  #ENDIF
#ENDAT
#!------------
#AT(%ProgramSetup)
  AppNameDesc = '%Applicname'
  #IF ((%AppPin) and (%AppPin <> 0))
  ds_UsePIN(AppNameDesc,%AppPIN)
  #ENDIF
#ENDAT
#!------------
#AT(%DLLExportList)
#IF(%ThisDll)
  #!$AppNum           !! exp ordinal number problem
  #!$AppNameDesc      !! exp ordinal number problem
#ENDIF
#ENDAT
#!=====================================================================
#EXTENSION (User_Login,'User Login here'),PROCEDURE
#!--------
#DISPLAY()
#DISPLAY('This function MUST exit through the ProcedureReturn')
#DISPLAY('routine for the "Logout" to work correctly.')
#DISPLAY('Enter the name of the area this logon applies to.')
#PROMPT('Unique Area Name : ',@s20),%AreaName,REQ
#DISPLAY('Note that the name of each logon area in the Application')
#DISPLAY('( ie every time you get this screen, must be unique. )')
#DISPLAY('The same name may be used in different applications.')
#PROMPT ('Allow Case Insensitive User Password',Check),%SecCase,AT(10,)
#PROMPT ('Make Login Optional to End User',Check),%SecOptional,AT(10,)
#PROMPT ('Allow only 3 tries',Check),%ThreeTries,AT(10,)
#PROMPT ('Enable Internationalisation features',Check),%SwIntl,At(10,)
#PROMPT ('Allow automatic login from other Exe''s',Check),%AutoLogin,AT(10,)
#PROMPT ('Allow default login values',Check),%DefLogin,AT(10,)
#ENABLE(%DefLogin)
  #DISPLAY('Use ''quotes'' for fixed values, or enter variables below')
  #PROMPT('Default Login code',@s20),%DefLoginCode
  #PROMPT('Default Password',@s20),%DefPassword
#ENDENABLE
#PROMPT('Don''t show screen if default fails',Check),%DefShow,At(10,)
#!------------------
#AT(%ProcedureInitialize)
#DECLARE(%LoginOptions)
LocalRequest = GlobalRequest      ! Save GlobalRequest
LocalResponse = RequestCancelled  ! In case the login fails
  #SET(%LoginOptions,'0')
  #IF(%SecCase)
    #SET(%LoginOptions,Clip(%LoginOptions)&'+DS_CASESENSITIVITYOFF')
  #ENDIF
  #IF(%SecOptional)
    #SET(%LoginOptions,Clip(%LoginOptions)&'+DS_OPTIONALON')
  #ENDIF
  #IF(%ThreeTries)
    #SET(%LoginOptions,Clip(%LoginOptions)&'+DS_THREETRIES')
  #ENDIF
  #IF(%AutoLogin)
    #SET(%LoginOptions,Clip(%LoginOptions)&'+DS_USECURRENTLOGON')
  #ENDIF
  #IF(%DefShow)
    #SET(%LoginOptions,Clip(%LoginOptions)&'+DS_DONTSHOWSCREEN')
  #ENDIF
  #IF(%SwIntl)
    #SET(%LoginOptions,Clip(%LoginOptions)&'+DS_ENABLEINTL')
  #ENDIF
  #IF(%DefLogin)
    #SET(%LoginOptions,Clip(%LoginOptions)&'+DS_AUTOLOGON')
AppNum = ds_LogInText(Clip(AppNameDesc) & ' | %AreaName',%LoginOptions,%DefLoginCode,%DefPassword)
  #ELSE
AppNum = ds_LogInText(Clip(AppNameDesc) & ' | %AreaName',%LoginOptions,'','')
  #ENDIF
If AppNum = 0 then
  If Message('Access Denied','Security',Icon:Exclamation).
  #IF(%SecWinExternal or %ThisDll)
  qGet()
  #ELSE
  get(AppNumQueue,1)
  #ENDIF
  #IF(%ProcedureType='FUNCTION')
  Return(%ReturnValue)
  #ELSE
  Return
  #ENDIF
.
  #IF(%SecWinExternal or %ThisDll)
  qAdd()
  #ELSE
Add(AppNumQueue,1)
  #ENDIF
GlobalRequest = LocalRequest  ! Restore GlobalRequest
#ENDAT
#!-----------
#AT(%EndOfProcedure)
If ds_LogOut(AppNum). ! throw away the value returned from Logout
  #IF(%SecWinExternal or %ThisDll)
  qDelete()
  qGet()
  #ELSE
Delete(AppNumQueue)
Get(AppNumQueue,1)
  #ENDIF
#ENDAT
#!=====================================================================
#EXTENSION (User_Screen_Security,'User Screen Security'),PROCEDURE
#!--------
#PROMPT ('Screen Name : ',@s21),%ScreenName
#DISPLAY()
#DISPLAY('Also Restrict :')
#DISPLAY('---------------')
#PROMPT ('1) Equate',CONTROL),%RestrictEqu1
#ENABLE (%RestrictEqu1)
#BUTTON ('Details of 1')
  #PROMPT ('Name',@s7), %RestrictNam1
  #PROMPT ('Action',DROP('Hide|Disable')),%RestrictAct1
  #PROMPT ('Equivalent equate',CONTROL),%RestrictEquiv1
#ENDBUTTON
#ENDENABLE
#PROMPT ('2) Equate',CONTROL),%RestrictEqu2
#ENABLE (%RestrictEqu2)
#BUTTON ('Details of 2')
  #PROMPT ('Name',@s7), %RestrictNam2
  #PROMPT ('Action',DROP('Hide|Disable')),%RestrictAct2
  #PROMPT ('Equivalent equate',CONTROL),%RestrictEquiv2
#ENDBUTTON
#ENDENABLE
#PROMPT ('3) Equate',CONTROL),%RestrictEqu3
#ENABLE (%RestrictEqu3)
#BUTTON ('Details of 3')
  #PROMPT ('Name',@s7), %RestrictNam3
  #PROMPT ('Action',DROP('Hide|Disable')),%RestrictAct3
  #PROMPT ('Equivalent equate',CONTROL),%RestrictEquiv3
#ENDBUTTON
#ENDENABLE
#PROMPT ('4) Equate',CONTROL),%RestrictEqu4
#ENABLE (%RestrictEqu4)
#BUTTON ('Details of 4')
  #PROMPT ('Name',@s7), %RestrictNam4
  #PROMPT ('Action',DROP('Hide|Disable')),%RestrictAct4
  #PROMPT ('Equivalent equate',CONTROL),%RestrictEquiv4
#ENDBUTTON
#ENDENABLE
#PROMPT ('5) Equate',CONTROL),%RestrictEqu5
#ENABLE (%RestrictEqu5)
#BUTTON ('Details of 5')
  #PROMPT ('Name',@s7), %RestrictNam5
  #PROMPT ('Action',DROP('Hide|Disable')),%RestrictAct5
  #PROMPT ('Equivalent equate',CONTROL),%RestrictEquiv5
#ENDBUTTON
#ENDENABLE
#PROMPT ('6) Equate',CONTROL),%RestrictEqu6
#ENABLE (%RestrictEqu6)
#BUTTON ('Details of 6')
  #PROMPT ('Name',@s7), %RestrictNam6
  #PROMPT ('Action',DROP('Hide|Disable')),%RestrictAct6
  #PROMPT ('Equivalent equate',CONTROL),%RestrictEquiv6
#ENDBUTTON
#ENDENABLE
#PROMPT ('7) Equate',CONTROL),%RestrictEqu7
#ENABLE (%RestrictEqu7)
#BUTTON ('Details of 7')
  #PROMPT ('Name',@s7), %RestrictNam7
  #PROMPT ('Action',DROP('Hide|Disable')),%RestrictAct7
  #PROMPT ('Equivalent equate',CONTROL),%RestrictEquiv7
#ENDBUTTON
#ENDENABLE
#!--------
#LOCALDATA
ThisAllowed        long    ! contains the users access rights
#ENDLOCALDATA
#!------------------
#AT(%ProcedureSetup)
! get and check users access rights to this function
#IF (%ScreenName)
ThisAllowed = ds_Allowed(AppNum,'%ScreenName',0)
#ELSE
ThisAllowed = ds_Allowed(AppNum,'%procedure',0)
#ENDIF
If ~Band(ThisAllowed,1)
  If Message('Your access to this part of the program has been restricted','Security',ICON:Exclamation).
  GlobalResponse = RequestCancelled
  #IF(%ProcedureType='FUNCTION')
  Return(%ReturnValue)
  #ELSE
  Return
  #ENDIF
.
#ENDAT
#!----------------
#AT(%BeforeAccept)
  Alert(DS_SECURITYKEY)
  #IF (%RestrictEqu1)
  If ~Band(ThisAllowed,2) then %RestrictAct1(%RestrictEqu1).
      #IF (%RestrictEquiv1)
  If ~Band(ThisAllowed,2) then %RestrictAct1(%RestrictEquiv1).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu2)
  If ~Band(ThisAllowed,4) then %RestrictAct2(%RestrictEqu2).
      #IF (%RestrictEquiv2)
  If ~Band(ThisAllowed,4) then %RestrictAct2(%RestrictEquiv2).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu3)
  If ~Band(ThisAllowed,8) then %RestrictAct3(%RestrictEqu3).
      #IF (%RestrictEquiv3)
  If ~Band(ThisAllowed,8) then %RestrictAct3(%RestrictEquiv3).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu4)
  If ~Band(ThisAllowed,16) then %RestrictAct4(%RestrictEqu4).
      #IF (%RestrictEquiv4)
  If ~Band(ThisAllowed,16) then %RestrictAct4(%RestrictEquiv4).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu5)
  If ~Band(ThisAllowed,32) then %RestrictAct5(%RestrictEqu5).
      #IF (%RestrictEquiv5)
  If ~Band(ThisAllowed,32) then %RestrictAct5(%RestrictEquiv5).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu6)
  If ~Band(ThisAllowed,64) then %RestrictAct6(%RestrictEqu6).
      #IF (%RestrictEquiv6)
  If ~Band(ThisAllowed,64) then %RestrictAct6(%RestrictEquiv6).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu7)
  If ~Band(ThisAllowed,128) then %RestrictAct7(%RestrictEqu7).
      #IF (%RestrictEquiv7)
  If ~Band(ThisAllowed,128) then %RestrictAct7(%RestrictEquiv7).
      #ENDIF
  #ENDIF
#ENDAT
#AT(%AcceptLoopAfterFieldHandling)
  #IF (%RestrictEqu1)
  If ~Band(ThisAllowed,2) then %RestrictAct1(%RestrictEqu1).
      #IF (%RestrictEquiv1)
  If ~Band(ThisAllowed,2) then %RestrictAct1(%RestrictEquiv1).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu2)
  If ~Band(ThisAllowed,4) then %RestrictAct2(%RestrictEqu2).
      #IF (%RestrictEquiv2)
  If ~Band(ThisAllowed,4) then %RestrictAct2(%RestrictEquiv2).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu3)
  If ~Band(ThisAllowed,8) then %RestrictAct3(%RestrictEqu3).
      #IF (%RestrictEquiv3)
  If ~Band(ThisAllowed,8) then %RestrictAct3(%RestrictEquiv3).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu4)
  If ~Band(ThisAllowed,16) then %RestrictAct4(%RestrictEqu4).
      #IF (%RestrictEquiv4)
  If ~Band(ThisAllowed,16) then %RestrictAct4(%RestrictEquiv4).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu5)
  If ~Band(ThisAllowed,32) then %RestrictAct5(%RestrictEqu5).
      #IF (%RestrictEquiv5)
  If ~Band(ThisAllowed,32) then %RestrictAct5(%RestrictEquiv5).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu6)
  If ~Band(ThisAllowed,64) then %RestrictAct6(%RestrictEqu6).
      #IF (%RestrictEquiv6)
  If ~Band(ThisAllowed,64) then %RestrictAct6(%RestrictEquiv6).
      #ENDIF
  #ENDIF
  #IF (%RestrictEqu7)
  If ~Band(ThisAllowed,128) then %RestrictAct7(%RestrictEqu7).
      #IF (%RestrictEquiv7)
  If ~Band(ThisAllowed,128) then %RestrictAct7(%RestrictEquiv7).
      #ENDIF
  #ENDIF
#ENDAT
#!---------------------------------
#AT(%WindowEventHandling),Where(%WindowEvent='GainFocus')
#IF (%ScreenName)
ThisAllowed = ds_Allowed(AppNum,'%ScreenName',0)
#ELSE
ThisAllowed = ds_Allowed(AppNum,'%procedure',0)
#ENDIF
#IF(%RestrictEqu1)
  #IF(%RestrictAct1 = 'Disable')
    Enable(%RestrictEqu1)
  #ELSE
    UnHide(%RestrictEqu1)
  #ENDIF
#ENDIF
#IF(%RestrictEqu2)
  #IF(%RestrictAct2 = 'Disable')
    Enable(%RestrictEqu2)
  #ELSE
    UnHide(%RestrictEqu2)
  #ENDIF
#ENDIF
#IF(%RestrictEqu3)
  #IF(%RestrictAct3 = 'Disable')
    Enable(%RestrictEqu3)
  #ELSE
    UnHide(%RestrictEqu3)
  #ENDIF
#ENDIF
#IF(%RestrictEqu4)
  #IF(%RestrictAct4 = 'Disable')
    Enable(%RestrictEqu4)
  #ELSE
    UnHide(%RestrictEqu4)
  #ENDIF
#ENDIF
#IF(%RestrictEqu5)
  #IF(%RestrictAct5 = 'Disable')
    Enable(%RestrictEqu5)
  #ELSE
    UnHide(%RestrictEqu5)
  #ENDIF
#ENDIF
#IF(%RestrictEqu6)
  #IF(%RestrictAct6 = 'Disable')
    Enable(%RestrictEqu6)
  #ELSE
    UnHide(%RestrictEqu6)
  #ENDIF
#ENDIF
#IF(%RestrictEqu7)
  #IF(%RestrictAct7 = 'Disable')
    Enable(%RestrictEqu7)
  #ELSE
    UnHide(%RestrictEqu7)
  #ENDIF
#ENDIF
#IF(%RestrictEquiv1)
  #IF(%RestrictAct1 = 'Disable')
    Enable(%RestrictEquiv1)
  #ELSE
    UnHide(%RestrictEquiv1)
  #ENDIF
#ENDIF
#IF(%RestrictEquiv2)
  #IF(%RestrictAct2 = 'Disable')
    Enable(%RestrictEquiv2)
  #ELSE
    UnHide(%RestrictEquiv2)
  #ENDIF
#ENDIF
#IF(%RestrictEquiv3)
  #IF(%RestrictAct3 = 'Disable')
    Enable(%RestrictEquiv3)
  #ELSE
    UnHide(%RestrictEquiv3)
  #ENDIF
#ENDIF
#IF(%RestrictEquiv4)
  #IF(%RestrictAct4 = 'Disable')
    Enable(%RestrictEquiv4)
  #ELSE
    UnHide(%RestrictEquiv4)
  #ENDIF
#ENDIF
#IF(%RestrictEquiv5)
  #IF(%RestrictAct5 = 'Disable')
    Enable(%RestrictEquiv5)
  #ELSE
    UnHide(%RestrictEquiv5)
  #ENDIF
#ENDIF
#IF(%RestrictEquiv6)
  #IF(%RestrictAct6 = 'Disable')
    Enable(%RestrictEquiv6)
  #ELSE
    UnHide(%RestrictEquiv6)
  #ENDIF
#ENDIF
#IF(%RestrictEquiv7)
  #IF(%RestrictAct7 = 'Disable')
    Enable(%RestrictEquiv7)
  #ELSE
    UnHide(%RestrictEquiv7)
  #ENDIF
#ENDIF
#ENDAT
#!---------------------------------
#AT(%ControlPreEventHandling)
  #IF(%ControlEvent='Accepted')
    #IF (%Control=%RestrictEqu1)
If ~Band(ThisAllowed,2) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEquiv1)
If ~Band(ThisAllowed,2) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEqu2)
If ~Band(ThisAllowed,4) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEquiv2)
If ~Band(ThisAllowed,4) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEqu3)
If ~Band(ThisAllowed,8) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEquiv3)
If ~Band(ThisAllowed,8) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEqu4)
If ~Band(ThisAllowed,16) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEquiv4)
If ~Band(ThisAllowed,16) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEqu5)
If ~Band(ThisAllowed,32) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEquiv5)
If ~Band(ThisAllowed,32) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEqu6)
If ~Band(ThisAllowed,64) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEquiv6)
If ~Band(ThisAllowed,64) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEqu7)
If ~Band(ThisAllowed,128) then cycle.
    #ENDIF
    #IF (%Control=%RestrictEquiv7)
If ~Band(ThisAllowed,128) then cycle.
    #ENDIF
  #ENDIF
#ENDAT
#!---------------------------------
#AT(%AcceptloopBeforeeventHandling)
  #DECLARE (%RestrictStr)
  #SET(%RestrictStr,'Access')
  #IF (%RestrictNam1)
    #SET(%RestrictStr,%RestrictStr & '|' & %RestrictNam1)
  #ENDIF
  #IF (%RestrictNam2)
    #SET(%RestrictStr,%RestrictStr & '|' & %RestrictNam2)
  #ENDIF
  #IF (%RestrictNam3)
    #SET(%RestrictStr,%RestrictStr & '|' & %RestrictNam3)
  #ENDIF
  #IF (%RestrictNam4)
    #SET(%RestrictStr,%RestrictStr & '|' & %RestrictNam4)
  #ENDIF
  #IF (%RestrictNam5)
    #SET(%RestrictStr,%RestrictStr & '|' & %RestrictNam5)
  #ENDIF
  #IF (%RestrictNam6)
    #SET(%RestrictStr,%RestrictStr & '|' & %RestrictNam6)
  #ENDIF
  #IF (%RestrictNam7)
    #SET(%RestrictStr,%RestrictStr & '|' & %RestrictNam7)
  #ENDIF
  If Event() = Event:AlertKey
    If KeyCode() = DS_SECURITYKEY
    #IF (%ScreenName)
      ds_SetAccess(AppNum,'%ScreenName','%RestrictStr')
    #ELSE
      ds_SetAccess(AppNum,'%Procedure','%RestrictStr')
    #ENDIF
      SetKeyCode(0)
  . .
#ENDAT
#AT (%BeforeDeleteRecord)
  #FOR(%Control)
    #IF(%Control = '?Delete')
 IF ?Delete{prop:disable} or ?Delete{prop:hide} then exit.
    #ENDIF
  #ENDFOR
#ENDAT
#AT (%BeforeChangeRecord)
  #FOR(%Control)
    #IF(%Control = '?Change')
 IF ?Change{prop:disable} or ?Change{prop:hide} then exit.
    #ENDIF
  #ENDFOR
#ENDAT
#AT (%BeforeInsertRecord)
  #FOR(%Control)
    #IF(%Control = '?Insert')
 IF ?Insert{prop:disable} or ?Insert{prop:hide} then exit.
    #ENDIF
  #ENDFOR
#ENDAT
#!=====================================================================
#CODE (Call_OperatorBrowse,'Call SecWin''s Operator Browse function')
  ds_OperatorBrowse(AppNum)
#!=====================================================================
#CODE (Call_ChangePassword,'Call SecWin''s Change Password function')
  ds_ChangePassword(AppNum)
#!=====================================================================
#CODE (Call_ChangeLogin,'Call SecWin''s Change Login function')
  ds_ChangeLogin(AppNum)
Post(Event:GainFocus)
#!=====================================================================
#CODE (Call_LockScreen,'Call SecWin''s Lock Screen function')
  ds_LockScreen(AppNum)
#!=====================================================================
#CODE (Call_Current,'Call SecWin''s Current User functions')
  #DISPLAY('This code template calls one of the ds_Current')
  #DISPLAY('functions and puts the result on your status bar.')
  #DISPLAY()
  #PROMPT('Position in status bar to use',@n2),%StatusPos
  #DISPLAY()
  #DISPLAY('Enter any text here that you want before the')
  #DISPLAY('current user.  Use quotes for literal text.')
  #PROMPT('Variables can also be used.',@s40),%UserPrompt
  #DISPLAY()
  #PROMPT('Call',OPTION),%CurrentCall
    #PROMPT('Current Name',RADIO)
    #PROMPT('Current Login',RADIO)
    #PROMPT('Current Level',RADIO)
  #IF (%CurrentCall = 'Current Level')
  IF ds_CurrentLevel(AppNum) = DS_SUPERVISOR
    %Window{prop:statustext,%StatusPos} = %UserPrompt & 'Supervisor'
  ELSE
    %Window{prop:statustext,%StatusPos} = %UserPrompt & 'Operator'
  .
  #ELSIF (%CurrentCall = 'Current Login')
  %Window{prop:statustext,%StatusPos} = %UserPrompt & ds_CurrentLogin(AppNum)
  #ELSE
  %Window{prop:statustext,%StatusPos} = %UserPrompt & ds_CurrentName(AppNum)
  #ENDIF
#!=====================================================================
#EXTENSION (User_WorkGroup_Filtering,'User workgroup filtering'),PROCEDURE
#!----------------------
#Display ('This Extension creates, primes and binds a variable')
#Display ('called CWG.  This variable contains the Current WorkGroup')
#Display ('of the user who is currently logged on.')
#Display ('Use CWG in your filter to do WorkGroup filtering')
#Display ('on Browses and list boxes etc.')
#!----------------------
#LOCALDATA
Cwg    short
#ENDLOCALDATA
#!----------------------
#AT(%WindowEventHandling),Where(%WindowEvent='GainFocus')
Cwg = ds_CurrentWorkGroup(AppNum)
#ENDAT
#!----------------------
#AT(%BeforeAccept)
Bind('CWG',CWG)
#ENDAT
#!----------------------
#!=====================================================================
#UTILITY(Import_Queue_Handling,'Import Queue Handling')
#IMPORT('queues.txa')
#!=====================================================================
#EXTENSION (Call_SetDefaultFont,'Call SecWin''s Set Default Font function'),APPLICATION
  #DISPLAY ('Use this template to set the font')
  #DISPLAY ('that SecWin will use for its')
  #DISPLAY ('screens.')
  #DISPLAY ()
  #DISPLAY ('If you include this template, and')
  #DISPLAY ('leave all the entries blank, then')
  #DISPLAY ('the user will be able to select')
  #DISPLAY ('the font at runtime.')
  #PROMPT ('Font name',@s20),%FontName
  #PROMPT ('Font size',Spin(@n2,1,12)),%FontSize
  #PROMPT ('Font color',Drop('|Black|Maroon|Green|Olive|Navy|Purple|Teal|Gray|Silver|Red|Lime|Yellow|Blue|Fuschia|Aqua|White')),%FontColor
  #PROMPT ('Font style',Drop('|Regular|Thin|Bold|Italic')),%FontStyle
#AT(%ProgramSetup)
#DECLARE(%FColor,@s20)
#DECLARE(%FStyle,@s20)
  #IF(%FontColor)
    #SET(%FColor,'Color:'&%FontColor)
  #ELSE
    #SET(%FColor,'')
  #ENDIF
  #IF(%FontStyle)
    #SET(%FStyle,'Font:'&%FontStyle)
  #ELSE
    #SET(%FStyle,'')
  #ENDIF
  ! Generated by SecWin's Call_SetDefault
  #IF(%FontName)
  ds_SetDefaultFont('%FontName',%FontSize,%FColor,%FStyle)
  #ELSE
  ds_SetDefaultFont(,%FontSize,%FColor,%FStyle)
  #ENDIF
  ! End of SecWin Extension template
#ENDAT
#!=====================================================================
#CODE (Call_RunAnotherExe,'Call SecWin''s Run function')
  #Display('Enter the name of the program to run, including')
  #PROMPT('the path if necessary',@s40),%ProgName
  #Display('Enter any parameters that need to be included')
  #PROMPT('on the command line here',@s40),%ProgParam
  #Display()
  #Display('Note that in order to work the program being called')
  #Display('must have the "Allow automatic logins" clicked on')
  ! Generated by SecWin's Call_RunAnotherEXE Code template
  run('%ProgName %ProgParam ' & ds_Run(AppNum))
  if runcode() < 0
    message('Could not run application.  Reason : ' & runcode())
  .
  ! End of SecWin Code template
#!=====================================================================
#CODE (Call_SetPin,'Call SecWin''s SetPin function')
  #Display('This template stamps the DSSW file with an Application')
  #Display('PIN number.  You need to specify both the Application')
  #Display('name and the Application''s PIN number.')
  #Display('Both of these items can be found in the APP file, in')
  #Display('the Global Extensions area, in the "Activate Security"')
  #Display('template.')
  #Display()
  #Display('If you are hardcoding the values into this SetPin')
  #Display('application, then put ''quotes'' around the')
  #Display('Application name.  Otherwise you can use variables')
  #Display('here instead.')
  #Display()
  #Prompt('Enter the application name',@s20),%ApplicationName
  #Prompt('Enter the application''s PIN number',@s20),%ApplicationPIN
  ! The next line generated by SecWin's Call_SetPIN code template
   ds_SetPin(%ApplicationName,%ApplicationPIN)
  ! End of SecWin Code template
#!=====================================================================
#CODE (Call_SetLanguage,'Call SecWin''s SetLanguage function')
  #Display('This template changes the language file that SecWin')
  #Display('is currently using.')
  #Display('Enter the name of the language file to use at this')
  #Display('point.')
  #Display()
  #Display('If you are hardcoding the value at this point')
  #Display('in the application, then put ''quotes'' around the')
  #Display('language file name. Otherwise you can use a variable')
  #Display('here instead.')
  #Display()
  #Display('At runtime SecWin will prefix the value below with the')
  #Display('contents of the LanguagePath entry in the INI file.')
  #Display()
  #Prompt('Enter the language file name',@s60),%LanguageFileName
  ! The next line generated by SecWin's Set Language code template
   ds_SetLanguage(%LanguageFileName)
  ! End of SecWin Code template
#!=====================================================================
#!Template(SecWiz,'SecWin Wizard')
#Utility(SecWiz,'SecWin Wizard'),Wizard
#Sheet
  #Tab('SecWin Wizard'),Finish(1)
    #Display('SecWin Wizard - Adding SecWin security to your Application')
    #Display()
    #Display('This Wizard is only available in the Registered version')
    #Display('of SecWin.  It will automatically add a Screen Security')
    #Display('extension template to all your screens, with control')
    #Display('security on the Insert, Change, Delete, Print && Ok buttons.')
    #Display()
    #Display('It will also add a user login to your program, and')
    #Display('a new menu to your main menu pre-filled with common')
    #Display('Security menu options.')
    #Display()
    #Display('You can order the Registered version by contacting')
    #Display('Topspeed Corporation (800-354-544 in US && Canada)')
    #Display('or your local Topspeed dealer elsewhere.')
  #EndTab
#EndSheet
#!=====================================================================
