/* Secure Drive CRYPTDSK V1.0 */
/* Encrypts/decrypts disks */

#include "secdrv.h"

void readseca(unsigned drive,unsigned head,unsigned track,unsigned sector,
     unsigned nsects,unsigned secsize,unsigned char *buffer);
void writeseca(unsigned drive,unsigned head,unsigned track,unsigned sector,
     unsigned nsects,unsigned secsize,unsigned char *buffer);
void rstfsetup(void);
void freebuf(void);

unsigned char *buf;

main()
{
unsigned drive,firstcyl,firsthead,encrypt;
unsigned track,head,sector,maxtrack,maxhead,maxsector,secsize,t;
unsigned serial[2];
unsigned char key[16],check[4],iv[8];
unsigned char *bufptr,*dummy;
unsigned long i;
char drvltr;
word16 expkey[52];
			       
clrscr();

cryptdata=gettsradr();

if(cryptdata) {
    cryptdata->fda.firstcyl=0x0ffff;
    cryptdata->fdb.firstcyl=0x0ffff;
    atexit(rstfsetup); }

if(!(buf=malloc(512))) {
    printf("Error: unable to allocate memory for track buffer.\n");
    exit(1); }

atexit(freebuf);

printf("\
Secure Drive CryptDisk Version 1.0\n\
\n\
This program will encrypt or decrypt a floppy disk or hard drive\
 partition.\n\
\n");

askdrive:
printf("Enter the letter of the drive to process, or X to enter the\n\
drive, cylinder, and head manually, or Z to cancel: ");
while(!isalpha(drvltr=toupper(getch())));
printf("%c\n",drvltr);

if((drvltr>'B')&&cryptdata) {
    printf("\nYou cannot encrypt or decrypt a hard drive partition \
while\nthe TSR is resident in memory.\n");
    exit(1); }

if(drvltr=='A') { firstcyl=0; firsthead=0; drive=0; }
else if(drvltr=='B') { firstcyl=0; firsthead=0; drive=1; }
else if(drvltr=='X') {
    printf("\nEnter physical drive (0-1), cylinder, and head for the\
 beginning\n\(boot sector) of this partition: ");
    scanf("%u,%u,%u",&drive,&firstcyl,&firsthead);
    drive+=0x80;
    }
else if(drvltr=='Z') { printf("\n"); exit(0); }
else {
    drive=255;
    readptbl(0,0,0,drvltr,&drive,&firsthead,&firstcyl);
    if(drive==255) {
	printf("\nDrive not found.\n\n");
	goto askdrive; }
    printf("\nDrive %c is physical hard drive %u, head %u,\
 cylinder %u\n\n",drvltr,drive,firsthead,firstcyl);
    drive+=0x80;
    }

if(drive<0x80) {
   printf("\nInsert disk in drive %c and press any key to\
 continue ",drvltr);
   getch();
   printf("\n\n"); }

readsec(drive,firsthead,firstcyl,1,1,buf);
if((buf[510]!=0x55)||(buf[511]!=0xaa)) {
    printf("This is not a boot sector.\n\n");
    exit(1); }

encrypt=memcmp(buf+3,"CRYP",4);

calcdiskparams(buf,&maxtrack,&maxhead,&maxsector,
	       &secsize,serial);

printf("This disk has \
%u tracks, %u sectors, %u heads, sector size %u bytes\n\n",
       maxtrack+1,maxsector,maxhead,secsize);

if(buf=realloc(buf,maxsector*secsize))
    printf("Allocated %u bytes for track buffer\n\n",
	    maxsector*secsize);
else {
    printf("Error: unable to allocate %u bytes for track buffer\n",
	    maxsector*secsize);
    exit(1); }

if(encrypt)
    {
    printf("This disk is not encrypted. Do you want to encrypt it? ");
    if(!getyn())
	{
	printf("\n");
	exit(0);
	}
    getkey(key,check,TRUE);
    }
else
    {
    printf("This disk is encrypted. Do you want to decrypt it? ");
    if(!getyn())
	{
	printf("\n");
	exit(0);
	}
    for(t=0;t<3;t++) {
	printf("\nEnter passphrase: "); 
	getkey(key,check,FALSE);
	if(!memcmp(check,buf+7,4)) break;
	printf("Wrong passphrase.\n");
	if(t==2) exit(0);
	}
    }

clrscr();
printf("Last chance to abort. Continue? ");
if(!getyn()) exit(1);
en_key_idea((word16 *)key,expkey);

printf("\n");
for(track=0;track<=maxtrack;track++)
    for(head=0;head<maxhead;head++) {
	if(track==0&&head<firsthead) head=firsthead;
	gotoxy(1,4);
	printf("Track %u, Head %u ",track,head);
	readseca(drive,head,track+firstcyl,1,maxsector,secsize,buf);
	bufptr=buf;
	for(sector=1;sector<=maxsector;sector++) {
	    if(track==0&&head==firsthead&&sector==1)
		if(encrypt) {
		    memcpy(&buf[0x03],"CRYP",4);
		    memcpy(&buf[0x07],check,4); }
		else
		    memcpy(&buf[0x03],"MSDOS   ",8);
	    else {
		t=track+firstcyl;
		iv[0]=t%256;
		iv[1]=t/256;
		iv[2]=head;
		iv[3]=sector;
		iv[4]=serial[0]%256;
		iv[5]=serial[0]/256;
		iv[6]=serial[1]%256;
		iv[7]=serial[1]/256;
		IDEACFB(iv,expkey,dummy,dummy,1);
		if(encrypt)
		    IDEACFB(iv,expkey,bufptr,bufptr,secsize/8+1);
		else    
		    IDEACFBX(iv,expkey,bufptr,bufptr,secsize/8+1);
		}
	    bufptr+=secsize;
	    }
	writeseca(drive,head,track+firstcyl,1,maxsector,secsize,buf);
	}


for(t=0;t<16;t++) key[t]='\0';
for(t=0;t<52;t++) expkey[t]=0;

gotoxy(1,22);
printf("\n\nDone.\n");
return(0);
}

void rstfsetup(void)
{
if(cryptdata) {
    cryptdata->fda.firstcyl=0;
    cryptdata->fdb.firstcyl=0; }
}

void freebuf(void)
{
free(buf);
}

void readseca(unsigned drive,unsigned head,unsigned track,unsigned sector,
     unsigned nsects,unsigned secsize,unsigned char *buffer)
{
unsigned i,j;
char c;
for(i=0;i<3;i++) 
  if(!biosdisk(2,drive,head,track,sector,nsects,buffer)) return;
printf("\nRead error: drive %02x, head %u, track %u\n",
       drive,head,track);
printf("Reading one sector at a time.\n");
for(j=0;j<nsects;j++) {
  for(i=0;i<3;i++) 
    if(!biosdisk(2,drive,head,track,sector+j,1,buffer)) goto goodsec;
  printf("Bad sector: drive %02x, head %u, track %u, sector %u\n",
	 drive,head,track,sector+j);
  goodsec:
  buffer+=secsize;
  }    
}

void writeseca(unsigned drive,unsigned head,unsigned track,unsigned sector,
     unsigned nsects,unsigned secsize,unsigned char *buffer)
{
unsigned i,j;
char c;
for(i=0;i<3;i++) 
  if(!biosdisk(3,drive,head,track,sector,nsects,buffer)) return;
printf("\nWrite error: drive %02x, head %u, track %u\n",
       drive,head,track);
printf("Writing one sector at a time.\n");
for(j=0;j<nsects;j++) {
  for(i=0;i<3;i++) 
    if(!biosdisk(3,drive,head,track,sector+j,1,buffer)) goto goodsec;
  printf("Bad sector: drive %02x, head %u, track %u, sector %u\n",
	 drive,head,track,sector+j);
  goodsec:
  buffer+=secsize;
  }    
}
