#define YY_DEFAULT_ACTION YY_FATAL_ERROR( "flex scanner jammed" );
#define FLEX_USE_ECS
#define FLEX_USE_MECS
/* A lexical scanner generated by flex */

#include "skeleton.h"

#define INITIAL 0
/*
**	file:		scan.l
**	purpose:	Scanner for flex input
**	mods:		1989.12.30 - Roberto Artigas Jr
**			Updated this file to match the 'scan.c'
**			more closely. It seems that the same
**			indivitual that had NOT run the 'parse.y'
**			file through BISON/YACC for a while, had
**			ALSO not run 'scan.l' through FLEX/LEX.
*/
/*
 * Copyright (c) 1987, the University of California
 * 
 * The United States Government has rights in this work pursuant to
 * contract no. DE-AC03-76SF00098 between the United States Department of
 * Energy and the University of California.
 * 
 * This program may be redistributed.  Enhancements and derivative works
 * may be created provided the new works, if made available to the general
 * public, are made available for use by anyone.
 */
#include <io.h>
#include <fcntl.h>

#include "flexdef.h"
#include "parse.h"
#include "sym.h"
#include "main.h"
#include "misc.h"


#define ACTION_ECHO fprintf( temp_action_file, "%s", yytext )
#define MARK_END_OF_PROLOG fprintf( temp_action_file, "%%%% end of prolog\n" );


#undef YY_DECL
#define YY_DECL \
	int flexscan( void)

#define RETURNCHAR \
	yylval = yytext[0]; \
	return ( CHAR );

#define RETURNNAME \
	(void) strcpy( nmstr, yytext ); \
	return ( NAME );

#define PUT_BACK_STRING(str, start) \
	for ( i = strlen( str ) - 1; i >= start; --i ) \
	    unput(str[i])
#define SECT2 2
#define SECT2PROLOG 4
#define SECT3 6
#define CODEBLOCK 8
#define PICKUPDEF 10
#define SC 12
#define CARETISBOL 14
#define NUM 16
#define QUOTE 18
#define FIRSTCCL 20
#define CCL 22
#define ACTION 24
#define RECOVER 26
#define BRACEERROR 28
#define C_COMMENT 30
#define C_COMMENT_2 32
#define ACTION_COMMENT 34
#define ACTION_STRING 36
#define PERCENT_BRACE_ACTION 38
#define YY_JAM 234
#define YY_JAM_BASE 886
#define YY_TEMPLATE 235
static char l[235] =
    {   0,
       -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
       -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
       -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
       -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,   -2,
       14,    7,   13,   11,    7,   12,   14,   14,   14,   10,
       46,   39,   40,   32,   46,   45,   30,   46,   46,   46,
       39,   28,   46,   45,   31,  100,   27,   99,  100,   21,
      100,   23,   22,   24,   52,  100,   48,   49,   51,   53,
       67,   68,   65,   64,   66,   54,   56,   55,   54,   60,
       59,   60,   60,   62,   62,   62,   63,   76,   80,   79,

       81,   81,   74,   75,  100,   25,   70,   69,   17,   19,
       18,   89,   91,   90,   83,   85,   84,   92,   94,   95,
       96,   72,   72,   73,   72,    7,   11,    0,    7,    1,
        0,    2,    0,    8,    4,    5,    0,    3,   10,   39,
       40,    0,    0,   35,    0,    0,   97,   97,   34,   33,
       34,    0,   39,   28,    0,    0,    0,   42,   38,    0,
       27,   26,    0,   21,    0,   23,   22,   50,   51,   64,
       98,   98,   57,   58,   61,   76,    0,   78,    0,   77,
        0,   25,   17,   15,   89,   87,   83,   82,   92,   93,
       72,   72,   72,   71,    1,    0,    9,    8,    0,    0,

        6,   36,    0,   37,   43,    0,   97,   34,   34,   44,
       29,    0,   36,    0,   29,    0,   42,    0,   20,   98,
        0,   16,    0,   88,   71,    0,    0,   97,   98,    0,
        0,    4,    0,    0
    } ;

static char e[128] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    6,    7,    1,    8,    9,
        9,   10,    9,   11,   12,    9,   13,   14,   15,   15,
       15,   15,   15,   15,   15,   15,   15,    1,    1,   16,
        1,   17,    9,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
       18,   19,   20,   21,   22,    1,   23,   22,   22,   22,

       22,   22,   22,   22,   22,   22,   22,   22,   22,   22,
       22,   22,   22,   24,   25,   26,   22,   22,   22,   27,
       22,   22,   28,   29,   30,    1,    1
    } ;

static char m[31] =
    {   0,
        1,    2,    3,    4,    1,    1,    1,    5,    1,    6,
        1,    1,    5,    7,    7,    1,    1,    1,    8,    9,
        1,    7,    7,    7,    7,    7,    7,    5,    1,   10
    } ;

static short int b[291] =
    {   0,
        0,   26,   52,   80,  276,  275,    0,    0,  274,    1,
        3,    7,  107,  132,  255,  254,  157,  185,   11,   13,
       54,   57,   85,  100,  213,  241,  271,  267,    4,    8,
        9,   10,   32,   33,   34,   37,   60,   88,  114,  120,
      886,  266,  886,    0,   43,  886,  264,  119,  256,    0,
      886,  134,  886,  886,   92,  886,  886,  246,  250,  258,
      284,  886,  256,  252,  886,  258,    0,  886,  257,  886,
      108,    0,  257,  886,  886,  886,  886,  237,    0,  886,
      886,  886,  886,   99,  886,  886,  886,  886,  243,  886,
      886,  242,  243,  886,    0,  239,  886,    0,  886,  886,

       66,  242,  886,  886,  248,  886,  886,  886,    0,  886,
      237,    0,  886,  235,    0,  886,  234,    0,  886,  886,
        0,    0,   65,  886,  216,  240,    0,  237,  137,  886,
      236,  886,  235,    0,  211,  886,  233,  886,    0,  162,
      886,  207,  231,  886,  131,   86,  886,  138,    0,  886,
      300,  112,  329,  886,  164,  163,  167,    0,  886,  230,
        0,  886,  229,  886,  228,    0,  228,  886,    0,  147,
      886,  160,  886,  886,  886,    0,  170,  886,    0,  886,
      226,  886,    0,  222,    0,  219,    0,  886,    0,  886,
        0,  174,  190,    0,  886,  190,  886,    0,  167,  145,

      886,  886,  142,  886,  886,  183,  168,    0,    0,  886,
      886,  176,  181,  182,  886,  198,    0,  139,  886,  190,
      125,  886,   99,  886,    0,   53,  192,  195,  199,   33,
      204,  886,  208,  886,  358,  368,  378,  388,  398,  408,
      418,  428,  438,  448,  458,  468,  478,  488,  498,  508,
      518,  528,  538,   34,  548,  558,  568,   14,  578,  588,
      598,  608,  618,  628,  638,  648,   11,  658,  668,  678,
      688,  697,  707,  717,  727,  737,  747,  757,  767,  777,
      787,  797,  807,  817,  826,  836,  846,  856,  866,  876
    } ;

static short int d[291] =
    {   0,
      235,  235,  236,  236,  237,  237,  238,  238,  239,  239,
      240,  240,  241,  241,  242,  242,  243,  243,  244,  244,
      245,  245,  246,  246,  247,  247,  248,  248,  242,  242,
      249,  249,  250,  250,  251,  251,  252,  252,  253,  253,
      234,  234,  234,  254,  255,  234,  256,  257,  234,  258,
      234,  234,  234,  234,  234,  234,  234,  259,  260,  261,
      262,  234,  234,  234,  234,  263,  264,  234,  265,  234,
      265,  266,  234,  234,  234,  234,  234,  234,  267,  234,
      234,  234,  234,  234,  234,  234,  234,  234,  260,  234,
      234,  268,  269,  234,  270,  260,  234,  271,  234,  234,

      272,  234,  234,  234,  273,  234,  234,  234,  274,  234,
      234,  275,  234,  234,  276,  234,  234,  277,  234,  234,
      278,  279,  279,  234,  279,  234,  254,  255,  255,  234,
      256,  234,  280,  281,  234,  234,  282,  234,  258,  234,
      234,  234,  283,  234,  259,  259,  234,  234,  284,  234,
      284,  262,  262,  234,  262,  262,  285,  286,  234,  263,
      264,  234,  265,  234,  287,  266,  234,  234,  267,  234,
      234,  234,  234,  234,  234,  271,  272,  234,  272,  234,
      273,  234,  274,  288,  275,  289,  276,  234,  277,  234,
      279,  279,  279,  290,  234,  280,  234,  281,  234,  282,

      234,  234,  283,  234,  234,  259,  234,  284,  151,  234,
      234,  262,  262,  285,  234,  285,  286,  287,  234,  234,
      288,  234,  289,  234,  290,  234,  259,  234,  234,  234,
      259,  234,  259,-32767,  234,  234,  234,  234,  234,  234,
      234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
      234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
      234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
      234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
      234,  234,  234,  234,  234,  234,  234,  234,  234,  234
    } ;

static short int n[917] =
    {   0,
      234,   42,   43,   70,   73,   74,  107,   71,   73,   74,
      107,  110,  110,   87,   88,   87,   88,  169,  111,  111,
      139,   44,   44,   44,   44,   44,   44,   45,   46,   89,
       47,   89,   48,  108,  113,  113,  116,  108,   49,  116,
      127,  114,  114,  117,  129,  130,  117,   50,   50,   50,
       50,   50,   50,   52,   53,   54,   76,   55,  232,   76,
       56,   56,  119,  120,   56,   91,  192,   57,   91,   58,
       59,  193,   92,  178,   93,   92,  230,   93,  121,   60,
       56,   61,   62,   54,  179,   55,   63,   76,   56,   56,
      119,  120,   64,  144,  144,   57,   95,   58,   59,  206,

       65,  224,   76,   96,   97,  145,  121,   60,   56,   76,
      164,   95,  170,  170,  211,  123,  124,   77,   96,   97,
      125,  123,  124,   78,  212,  134,  125,  222,   79,   79,
       79,   79,   79,   79,   76,  140,  141,  165,  129,  130,
      142,  219,   77,  135,  204,  136,  137,  201,   78,  146,
      205,  207,  207,   79,   79,   79,   79,   79,   79,   82,
      170,  170,  143,  140,  141,  211,  211,   83,  142,  215,
       84,   84,  159,  220,  220,  192,  212,  178,  211,  216,
      193,  228,  228,  211,  215,  234,   85,   82,  179,  226,
      143,  213,  197,  212,  216,   83,  227,  227,   84,   84,

      215,  146,  205,  229,  229,  231,  231,  203,  147,  147,
      146,  205,  171,  171,   85,   99,  100,  233,  233,  194,
      101,  224,  146,  205,  222,  102,  146,  205,  182,  167,
      219,  164,  161,  204,  202,  201,  199,  197,  132,  195,
      103,  126,  104,   99,  100,  194,  188,  186,  101,  184,
      182,  180,  148,  102,  174,  172,  148,  168,  167,  164,
      161,  159,  158,  148,  146,  138,  132,  126,  103,  106,
      104,  150,  150,  106,   80,   80,   70,   67,   67,  151,
      151,  151,  151,  151,  151,  153,  154,  234,  234,  234,
      155,  234,  234,  234,  234,  234,  156,  234,  234,  234,

      234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
      234,  234,  157,  209,  209,  234,  234,  234,  234,  234,
      234,  209,  209,  209,  209,  209,  209,  234,  234,  210,
      153,  154,  234,  234,  234,  155,  234,  234,  234,  234,
      234,  156,  234,  234,  234,  234,  234,  234,  234,  234,
      234,  234,  234,  234,  234,  234,  234,  157,   41,   41,
       41,   41,   41,   41,   41,   41,   41,   41,   51,   51,
       51,   51,   51,   51,   51,   51,   51,   51,   66,   66,
       66,   66,   66,   66,   66,   66,   66,   66,   68,   68,
       68,   68,   68,   68,   68,   68,   68,   68,   69,   69,

       69,   69,   69,   69,   69,   69,   69,   69,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   75,   75,
       75,   75,   75,   75,   75,   75,   75,   75,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   81,   81,
       81,   81,   81,   81,   81,   81,   81,   81,   86,   86,
       86,   86,   86,   86,   86,   86,   86,   86,   90,   90,
       90,   90,   90,   90,   90,   90,   90,   90,   94,   94,
       94,   94,   94,   94,   94,   94,   94,   94,   98,   98,
       98,   98,   98,   98,   98,   98,   98,   98,  105,  105,
      105,  105,  105,  105,  105,  105,  105,  105,  109,  109,

      109,  109,  109,  109,  109,  109,  109,  109,  112,  112,
      112,  112,  112,  112,  112,  112,  112,  112,  115,  115,
      115,  115,  115,  115,  115,  115,  115,  115,  118,  118,
      118,  118,  118,  118,  118,  118,  118,  118,  122,  122,
      122,  122,  122,  122,  122,  122,  122,  122,  128,  128,
      128,  128,  128,  128,  128,  128,  128,  128,  131,  131,
      131,  131,  131,  131,  131,  131,  131,  131,  133,  133,
      133,  133,  133,  133,  133,  133,  133,  133,  145,  145,
      234,  145,  145,  145,  145,  145,  234,  145,  147,  147,
      234,  147,  147,  147,  147,  147,  147,  147,  149,  149,

      234,  149,  149,  149,  149,  149,  149,  149,  152,  152,
      152,  152,  152,  152,  152,  152,  152,  152,  160,  160,
      160,  160,  160,  160,  160,  160,  160,  160,  162,  234,
      234,  162,  162,  162,  162,  162,  162,  162,  163,  163,
      163,  163,  163,  163,  163,  163,  163,  163,  166,  166,
      234,  166,  166,  166,  166,  166,  166,  166,  171,  171,
      234,  171,  171,  171,  171,  171,  171,  171,  173,  173,
      234,  173,  173,  173,  173,  173,  173,  173,  175,  175,
      234,  175,  175,  175,  175,  175,  234,  175,  176,  176,
      234,  234,  234,  176,  176,  176,  176,  177,  177,  234,

      177,  177,  177,  177,  177,  177,  177,  181,  181,  181,
      181,  181,  181,  181,  181,  181,  181,  183,  183,  234,
      183,  183,  234,  183,  183,  183,  183,  185,  185,  234,
      185,  185,  234,  185,  185,  185,  185,  187,  187,  234,
      187,  187,  234,  187,  187,  187,  187,  189,  189,  234,
      234,  189,  189,  189,  234,  189,  189,  190,  190,  234,
      190,  190,  190,  190,  190,  190,  190,  191,  191,  234,
      191,  191,  191,  191,  191,  191,  191,  196,  196,  196,
      196,  196,  196,  196,  196,  196,  196,  198,  198,  234,
      198,  198,  198,  198,  198,  198,  198,  200,  200,  200,

      200,  200,  200,  200,  200,  200,  200,  203,  203,  203,
      203,  203,  203,  203,  203,  203,  203,  208,  208,  234,
      208,  208,  208,  208,  208,  208,  214,  214,  214,  214,
      214,  214,  214,  214,  214,  214,  217,  217,  234,  217,
      217,  217,  217,  217,  217,  217,  218,  218,  218,  218,
      218,  218,  218,  218,  218,  218,  221,  221,  221,  221,
      221,  221,  221,  221,  221,  221,  223,  223,  223,  223,
      223,  223,  223,  223,  223,  223,  225,  225,  234,  225,
      225,  225,  225,  225,  225,  225,  234,  234,  234,  234,
      234,  234,  234,  234,  234,  234,  234,  234,  234,  234,

      234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
      234,  234,  234,  234,  234,  234
    } ;

static short int c[917] =
    {   0,
        0,    1,    1,   10,   11,   11,   29,   10,   12,   12,
       30,   31,   32,   19,   19,   20,   20,  267,   31,   32,
      258,    1,    1,    1,    1,    1,    1,    2,    2,   19,
        2,   20,    2,   29,   33,   34,   35,   30,    2,   36,
      254,   33,   34,   35,   45,   45,   36,    2,    2,    2,
        2,    2,    2,    3,    3,    3,   21,    3,  230,   22,
        3,    3,   37,   37,    3,   21,  123,    3,   22,    3,
        3,  123,   21,  101,   21,   22,  226,   22,   37,    3,
        3,    4,    4,    4,  101,    4,    4,   23,    4,    4,
       38,   38,    4,   55,   55,    4,   23,    4,    4,  146,

        4,  223,   24,   23,   23,  146,   38,    4,    4,   13,
       71,   24,   84,   84,  152,   39,   39,   13,   24,   24,
       39,   40,   40,   13,  152,   48,   40,  221,   13,   13,
       13,   13,   13,   13,   14,   52,   52,   71,  129,  129,
       52,  218,   14,   48,  203,   48,   48,  200,   14,  145,
      145,  148,  148,   14,   14,   14,   14,   14,   14,   17,
      170,  170,   52,  140,  140,  156,  155,   17,  140,  157,
       17,   17,  156,  172,  172,  192,  155,  177,  212,  157,
      192,  207,  207,  213,  214,  212,   17,   18,  177,  199,
      140,  155,  196,  213,  214,   18,  206,  206,   18,   18,

      216,  206,  206,  220,  220,  227,  227,  216,  228,  228,
      227,  227,  229,  229,   18,   25,   25,  231,  231,  193,
       25,  186,  231,  231,  184,   25,  233,  233,  181,  167,
      165,  163,  160,  143,  142,  137,  135,  133,  131,  128,
       25,  126,   25,   26,   26,  125,  117,  114,   26,  111,
      105,  102,   96,   26,   93,   92,   89,   78,   73,   69,
       66,   64,   63,   59,   58,   49,   47,   42,   26,   28,
       26,   60,   60,   27,   16,   15,    9,    6,    5,   60,
       60,   60,   60,   60,   60,   61,   61,    0,    0,    0,
       61,    0,    0,    0,    0,    0,   61,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,   61,  151,  151,    0,    0,    0,    0,    0,
        0,  151,  151,  151,  151,  151,  151,    0,    0,  151,
      153,  153,    0,    0,    0,  153,    0,    0,    0,    0,
        0,  153,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,  153,  235,  235,
      235,  235,  235,  235,  235,  235,  235,  235,  236,  236,
      236,  236,  236,  236,  236,  236,  236,  236,  237,  237,
      237,  237,  237,  237,  237,  237,  237,  237,  238,  238,
      238,  238,  238,  238,  238,  238,  238,  238,  239,  239,

      239,  239,  239,  239,  239,  239,  239,  239,  240,  240,
      240,  240,  240,  240,  240,  240,  240,  240,  241,  241,
      241,  241,  241,  241,  241,  241,  241,  241,  242,  242,
      242,  242,  242,  242,  242,  242,  242,  242,  243,  243,
      243,  243,  243,  243,  243,  243,  243,  243,  244,  244,
      244,  244,  244,  244,  244,  244,  244,  244,  245,  245,
      245,  245,  245,  245,  245,  245,  245,  245,  246,  246,
      246,  246,  246,  246,  246,  246,  246,  246,  247,  247,
      247,  247,  247,  247,  247,  247,  247,  247,  248,  248,
      248,  248,  248,  248,  248,  248,  248,  248,  249,  249,

      249,  249,  249,  249,  249,  249,  249,  249,  250,  250,
      250,  250,  250,  250,  250,  250,  250,  250,  251,  251,
      251,  251,  251,  251,  251,  251,  251,  251,  252,  252,
      252,  252,  252,  252,  252,  252,  252,  252,  253,  253,
      253,  253,  253,  253,  253,  253,  253,  253,  255,  255,
      255,  255,  255,  255,  255,  255,  255,  255,  256,  256,
      256,  256,  256,  256,  256,  256,  256,  256,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  259,  259,
        0,  259,  259,  259,  259,  259,    0,  259,  260,  260,
        0,  260,  260,  260,  260,  260,  260,  260,  261,  261,

        0,  261,  261,  261,  261,  261,  261,  261,  262,  262,
      262,  262,  262,  262,  262,  262,  262,  262,  263,  263,
      263,  263,  263,  263,  263,  263,  263,  263,  264,    0,
        0,  264,  264,  264,  264,  264,  264,  264,  265,  265,
      265,  265,  265,  265,  265,  265,  265,  265,  266,  266,
        0,  266,  266,  266,  266,  266,  266,  266,  268,  268,
        0,  268,  268,  268,  268,  268,  268,  268,  269,  269,
        0,  269,  269,  269,  269,  269,  269,  269,  270,  270,
        0,  270,  270,  270,  270,  270,    0,  270,  271,  271,
        0,    0,    0,  271,  271,  271,  271,  272,  272,    0,

      272,  272,  272,  272,  272,  272,  272,  273,  273,  273,
      273,  273,  273,  273,  273,  273,  273,  274,  274,    0,
      274,  274,    0,  274,  274,  274,  274,  275,  275,    0,
      275,  275,    0,  275,  275,  275,  275,  276,  276,    0,
      276,  276,    0,  276,  276,  276,  276,  277,  277,    0,
        0,  277,  277,  277,    0,  277,  277,  278,  278,    0,
      278,  278,  278,  278,  278,  278,  278,  279,  279,    0,
      279,  279,  279,  279,  279,  279,  279,  280,  280,  280,
      280,  280,  280,  280,  280,  280,  280,  281,  281,    0,
      281,  281,  281,  281,  281,  281,  281,  282,  282,  282,

      282,  282,  282,  282,  282,  282,  282,  283,  283,  283,
      283,  283,  283,  283,  283,  283,  283,  284,  284,    0,
      284,  284,  284,  284,  284,  284,  285,  285,  285,  285,
      285,  285,  285,  285,  285,  285,  286,  286,    0,  286,
      286,  286,  286,  286,  286,  286,  287,  287,  287,  287,
      287,  287,  287,  287,  287,  287,  288,  288,  288,  288,
      288,  288,  288,  288,  288,  288,  289,  289,  289,  289,
      289,  289,  289,  289,  289,  289,  290,  290,    0,  290,
      290,  290,  290,  290,  290,  290,  234,  234,  234,  234,
      234,  234,  234,  234,  234,  234,  234,  234,  234,  234,

      234,  234,  234,  234,  234,  234,  234,  234,  234,  234,
      234,  234,  234,  234,  234,  234
    } ;


/* these declarations have to come after the section 1 code or lint gets
 * confused about whether the variables are used
 */
FILE *yyin = stdin, *yyout = stdout;

/* these variables are all declared out here so that section 3 code can
 * manipulate them
 */
static int yy_start, yy_b_buf_p, yy_c_buf_p, yy_e_buf_p;
static int yy_saw_eof, yy_init = 1;

/* yy_ch_buf has to be 1 character longer than YY_BUF_SIZE, since when
 * setting up yytext we can try to put a '\0' just past the end of the
 * matched text
 */
static char yy_ch_buf[YY_BUF_SIZE + 1];
static int yy_st_buf[YY_BUF_SIZE];
static char yy_hold_char;

static char input( void) ;
static void unput( char) ;

char *yytext;
static int yyleng;

/*--------------------------------------------------------------------------*/
/*------------------------- BEGIN LEXICAL ANALYZER -------------------------*/
/*--------------------------------------------------------------------------*/

YY_DECL
    {
    int yy_n_chars, yy_lp, yy_iii, yy_buf_pos, yy_act;
#ifdef FLEX_REJECT_ENABLED
    int yy_full_match;
#endif


    static int bracelevel, didadef;
    int i, cclval;
    char nmdef[MAXLINE], myesc();


    if ( yy_init )
	{
	YY_INIT;
	yy_start = 1;
	yy_init = 0;
	}

    goto get_next_token;

do_action:

#ifdef FLEX_REJECT_ENABLED
    /* remember matched text in case we back up due to trailing context */
    yy_full_match = yy_c_buf_p;
#endif

    for ( ; ; )
	{
	YY_DO_BEFORE_ACTION

#ifdef FLEX_DEBUG
	fprintf( stderr, "--accepting rule #%d\n", yy_act );
#endif
	switch ( yy_act )
	    {
case 1:
++linenum; ECHO; /* indented code */
	YY_BREAK
case 2:
++linenum; ECHO; /* treat as a comment */
	YY_BREAK
case 3:
ECHO; BEGIN(C_COMMENT);
	YY_BREAK
case 4:
return ( SCDECL );
	YY_BREAK
case 5:
return ( XSCDECL );
	YY_BREAK
case 6:
++linenum; line_directive_out( stdout ); BEGIN(CODEBLOCK);
	YY_BREAK
case 7:
return ( WHITESPACE );
	YY_BREAK
case 8:
{
			sectnum = 2;
			line_directive_out( stdout );
			BEGIN(SECT2PROLOG);
			return ( SECTEND );
			}
	YY_BREAK
case 9:
{
			fprintf( stderr,
			     "old-style lex command at line %d ignored:\n\t%s",
				 linenum, yytext );
			++linenum;
			}
	YY_BREAK
case 10:
{
			(void) strcpy( nmstr, yytext );
			didadef = false;
			BEGIN(PICKUPDEF);
			}
	YY_BREAK
case 11:
RETURNNAME;
	YY_BREAK
case 12:
++linenum; /* allows blank lines in section 1 */
	YY_BREAK
case 13:
++linenum; return ( '\n' );
	YY_BREAK
case 14:
synerr( "illegal character" ); BEGIN(RECOVER);
	YY_BREAK
case 15:
ECHO; BEGIN(0);
	YY_BREAK
case 16:
++linenum; ECHO; BEGIN(0);
	YY_BREAK
case 17:
ECHO;
	YY_BREAK
case 18:
ECHO;
	YY_BREAK
case 19:
++linenum; ECHO;
	YY_BREAK
case 20:
++linenum; BEGIN(0);
	YY_BREAK
case 21:
++linenum; ECHO;
	YY_BREAK
case 22:
/* separates name and definition */
	YY_BREAK
case 23:
{
			(void) strcpy( nmdef, yytext );

			for ( i = strlen( nmdef ) - 1;
			      i >= 0 &&
			      nmdef[i] == ' ' || nmdef[i] == '\t';
			      --i )
			    ;

			nmdef[i + 1] = '\0';

                        ndinstal( nmstr, nmdef );
			didadef = true;
			}
	YY_BREAK
case 24:
{
			if ( ! didadef )
			    synerr( "incomplete name definition" );
			BEGIN(0);
			++linenum;
			}
	YY_BREAK
case 25:
++linenum; BEGIN(0); RETURNNAME;
	YY_BREAK
case 26:
YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
yy_c_buf_p -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
{
			++linenum;
			ACTION_ECHO;
			MARK_END_OF_PROLOG;
			BEGIN(SECT2);
			}
	YY_BREAK
case 27:
++linenum; ACTION_ECHO;
	YY_BREAK
case 28:
++linenum; /* allow blank lines in section 2 */
	YY_BREAK
	/* this horrible mess of a rule matches indented lines which
	 * do not contain "/*".  We need to make the distinction because
	 * otherwise this rule will be taken instead of the rule which
	 * matches the beginning of comments like this one
	 */
case 29:
{
			synerr( "indented code found outside of action" );
			++linenum;
			}
	YY_BREAK
case 30:
BEGIN(SC); return ( '<' );
	YY_BREAK
case 31:
return ( '^' );
	YY_BREAK
case 32:
BEGIN(QUOTE); return ( '"' );
	YY_BREAK
case 33:
YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
yy_c_buf_p = yy_b_buf_p;
YY_DO_BEFORE_ACTION; /* set up yytext again */
BEGIN(NUM); return ( '{' );
	YY_BREAK
case 34:
BEGIN(BRACEERROR);
	YY_BREAK
case 35:
YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
yy_c_buf_p = yy_b_buf_p;
YY_DO_BEFORE_ACTION; /* set up yytext again */
return ( '$' );
	YY_BREAK
case 36:
{
			bracelevel = 1;
			BEGIN(PERCENT_BRACE_ACTION);
			return ( '\n' );
			}
	YY_BREAK
case 37:
++linenum; return ( '\n' );
	YY_BREAK
case 38:
ACTION_ECHO; BEGIN(C_COMMENT_2);
	YY_BREAK
case 39:
{ /* needs to be separate from following rule due to
			   * bug with trailing context
			   */
			bracelevel = 0;
			BEGIN(ACTION);
			return ( '\n' );
			}
	YY_BREAK
case 40:
YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
yy_c_buf_p -= 1;
YY_DO_BEFORE_ACTION; /* set up yytext again */
{
			bracelevel = 0;
			BEGIN(ACTION);
			return ( '\n' );
			}
	YY_BREAK
case 41:
++linenum; return ( '\n' );
	YY_BREAK
case 42:
{
			/* guarantee that the SECT3 rule will have something
			 * to match
			 */
			yyless(1);
			sectnum = 3;
			BEGIN(SECT3);
			return ( EOF ); /* to stop the parser */
			}
	YY_BREAK
case 43:
{
			(void) strcpy( nmstr, yytext );

			/* check to see if we've already encountered this ccl */
			if ( (cclval = ccllookup( nmstr )) )
			    {
			    yylval = cclval;
			    ++cclreuse;
			    return ( PREVCCL );
			    }
			else
			    {
			    /* we fudge a bit.  We know that this ccl will
			     * soon be numbered as lastccl + 1 by cclinit
			     */
			    cclinstal( nmstr, lastccl + 1 );

			    /* push back everything but the leading bracket
			     * so the ccl can be rescanned
			     */
			    PUT_BACK_STRING(nmstr, 1);

			    BEGIN(FIRSTCCL);
			    return ( '[' );
			    }
			}
	YY_BREAK
case 44:
{
			register char *nmdefptr;
			char *ndlookup();

			(void) strcpy( nmstr, yytext );
			nmstr[yyleng - 1] = '\0';  /* chop trailing brace */

			/* lookup from "nmstr + 1" to chop leading brace */
			if ( ! (nmdefptr = ndlookup( nmstr + 1 )) )
			    synerr( "undefined {name}" );

			else
			    { /* push back name surrounded by ()'s */
			    unput(')');
			    PUT_BACK_STRING(nmdefptr, 0);
			    unput('(');
			    }
			}
	YY_BREAK
case 45:
return ( yytext[0] );
	YY_BREAK
case 46:
RETURNCHAR;
	YY_BREAK
case 47:
++linenum; return ( '\n' );
	YY_BREAK
case 48:
return ( ',' );
	YY_BREAK
case 49:
BEGIN(SECT2); return ( '>' );
	YY_BREAK
case 50:
YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
yy_c_buf_p = yy_b_buf_p;
YY_DO_BEFORE_ACTION; /* set up yytext again */
BEGIN(CARETISBOL); return ( '>' );
	YY_BREAK
case 51:
RETURNNAME;
	YY_BREAK
case 52:
synerr( "bad start condition name" );
	YY_BREAK
case 53:
BEGIN(SECT2); return ( '^' );
	YY_BREAK
case 54:
RETURNCHAR;
	YY_BREAK
case 55:
BEGIN(SECT2); return ( '"' );
	YY_BREAK
case 56:
{
			synerr( "missing quote" );
			BEGIN(SECT2);
			++linenum;
			return ( '"' );
			}
	YY_BREAK
case 57:
YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
yy_c_buf_p = yy_b_buf_p;
YY_DO_BEFORE_ACTION; /* set up yytext again */
BEGIN(CCL); return ( '^' );
	YY_BREAK
case 58:
YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
yy_c_buf_p = yy_b_buf_p;
YY_DO_BEFORE_ACTION; /* set up yytext again */
return ( '^' );
	YY_BREAK
case 59:
BEGIN(CCL); yylval = '-'; return ( CHAR );
	YY_BREAK
case 60:
BEGIN(CCL); RETURNCHAR;
	YY_BREAK
case 61:
YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */
yy_c_buf_p = yy_b_buf_p;
YY_DO_BEFORE_ACTION; /* set up yytext again */
return ( '-' );
	YY_BREAK
case 62:
RETURNCHAR;
	YY_BREAK
case 63:
BEGIN(SECT2); return ( ']' );
	YY_BREAK
case 64:
{
			yylval = myctoi( yytext );
			return ( NUMBER );
			}
	YY_BREAK
case 65:
return ( ',' );
	YY_BREAK
case 66:
BEGIN(SECT2); return ( '}' );
	YY_BREAK
case 67:
{
			synerr( "bad character inside {}'s" );
			BEGIN(SECT2);
			return ( '}' );
			}
	YY_BREAK
case 68:
{
			synerr( "missing }" );
			BEGIN(SECT2);
			++linenum;
			return ( '}' );
			}
	YY_BREAK
case 69:
synerr( "bad name in {}'s" ); BEGIN(SECT2);
	YY_BREAK
case 70:
synerr( "missing }" ); ++linenum; BEGIN(SECT2);
	YY_BREAK
case 71:
bracelevel = 0;
	YY_BREAK
case 72:
ACTION_ECHO;
	YY_BREAK
case 73:
{
			++linenum;
			ACTION_ECHO;
			if ( bracelevel == 0 )
			    {
			    fputs( "\tYY_BREAK\n", temp_action_file );
			    BEGIN(SECT2);
			    }
			}
	YY_BREAK
case 74:
ACTION_ECHO; ++bracelevel;
	YY_BREAK
case 75:
ACTION_ECHO; --bracelevel;
	YY_BREAK
case 76:
ACTION_ECHO;
	YY_BREAK
case 77:
ACTION_ECHO; BEGIN(ACTION_COMMENT);
	YY_BREAK
case 78:
ACTION_ECHO; /* character constant */
	YY_BREAK
case 79:
ACTION_ECHO; BEGIN(ACTION_STRING);
	YY_BREAK
case 80:
{
			++linenum;
			ACTION_ECHO;
			if ( bracelevel == 0 )
			    {
			    fputs( "\tYY_BREAK\n", temp_action_file );
			    BEGIN(SECT2);
			    }
			}
	YY_BREAK
case 81:
ACTION_ECHO;
	YY_BREAK
case 82:
ACTION_ECHO; BEGIN(ACTION);
	YY_BREAK
case 83:
ACTION_ECHO;
	YY_BREAK
case 84:
ACTION_ECHO;
	YY_BREAK
case 85:
++linenum; ACTION_ECHO;
	YY_BREAK
case 86:
ACTION_ECHO;
	YY_BREAK
case 87:
ACTION_ECHO; BEGIN(SECT2);
	YY_BREAK
case 88:
++linenum; ACTION_ECHO; BEGIN(SECT2);
	YY_BREAK
case 89:
ACTION_ECHO;
	YY_BREAK
case 90:
ACTION_ECHO;
	YY_BREAK
case 91:
++linenum; ACTION_ECHO;
	YY_BREAK
case 92:
ACTION_ECHO;
	YY_BREAK
case 93:
ACTION_ECHO;
	YY_BREAK
case 94:
++linenum; ACTION_ECHO;
	YY_BREAK
case 95:
ACTION_ECHO; BEGIN(ACTION);
	YY_BREAK
case 96:
ACTION_ECHO;
	YY_BREAK
case 97:
{
			yylval = myesc( yytext );
			return ( CHAR );
			}
	YY_BREAK
case 98:
{
			yylval = myesc( yytext );
			BEGIN(CCL);
			return ( CHAR );
			}
	YY_BREAK
case 99:
{
			register int numchars;

			/* black magic - we know the names of a flex scanner's
			 * internal variables.  We cap the input buffer with
			 * an end-of-string and dump it to the output.
			 */
			YY_DO_BEFORE_SCAN; /* recover from setting up yytext */

#ifdef FLEX_FAST_SKEL
			fputs( yy_c_buf_p + 1, stdout );
#else
			yy_ch_buf[yy_e_buf_p + 1] = '\0';

			/* ignore the first character; it's the second '%'
			 * put back by the yyless(1) above
			 */
			fputs( yy_ch_buf + yy_c_buf_p + 1, stdout );
#endif

			/* if we don't do this, the data written by write()
			 * can get overwritten when stdout is finally flushed
			 */
			(void) fflush( stdout );

			while ( (numchars = read( fileno(yyin), yy_ch_buf,
						  YY_BUF_MAX )) > 0 )
			    (void) write( fileno(stdout), yy_ch_buf, numchars );
	
			if ( numchars < 0 )
			    flexerror( "fatal read error in section 3" );

			return ( EOF );
			}
	YY_BREAK
case 100:
YY_DEFAULT_ACTION;
	YY_BREAK

case YY_NEW_FILE:
break; /* begin reading from new file */

case YY_END_TOK:
return ( YY_END_TOK );

default:
YY_FATAL_ERROR( "fatal flex scanner internal error" );
	    }

get_next_token:
	{
	register int yy_curst;
	register char yy_sym;

	YY_DO_BEFORE_SCAN

	/* set up to begin running DFA */

	yy_curst = yy_start;

	if ( yy_ch_buf[yy_c_buf_p] == '\n' )
	    ++yy_curst;

	/* yy_b_buf_p points to the position in yy_ch_buf
	 * of the start of the current run.
	 */

	yy_b_buf_p = yy_c_buf_p + 1;

	do /* until the machine jams */
	    {
	    if ( yy_c_buf_p == yy_e_buf_p )
		{ /* need more input */
		if ( yy_e_buf_p >= YY_BUF_LIM )
		    { /* not enough room to do another read */
		    /* see if we can make some room for more chars */

		    yy_n_chars = yy_e_buf_p - yy_b_buf_p;

		    if ( yy_n_chars >= 0 )
			/* shift down buffer to make room */
			for ( yy_iii = 0; yy_iii <= yy_n_chars; ++yy_iii )
			    {
			    yy_buf_pos = yy_b_buf_p + yy_iii;
			    yy_ch_buf[yy_iii] = yy_ch_buf[yy_buf_pos];
			    yy_st_buf[yy_iii] = yy_st_buf[yy_buf_pos];
			    }

		    yy_b_buf_p = 0;
		    yy_e_buf_p = yy_n_chars;

		    if ( yy_e_buf_p >= YY_BUF_LIM )
			YY_FATAL_ERROR( "flex input buffer overflowed" );

		    yy_c_buf_p = yy_e_buf_p;
		    }

		else if ( yy_saw_eof )
		    {
saweof:		    if ( yy_b_buf_p > yy_e_buf_p )
			{
			if ( yywrap() )
			    {
			    yy_act = YY_END_TOK;
			    goto do_action;
			    }
			
			else
			    {
			    YY_INIT;
			    yy_act = YY_NEW_FILE;
			    goto do_action;
			    }
			}

		    else /* do a jam to eat up more input */
			{
#ifndef FLEX_INTERACTIVE_SCANNER
			/* we're going to decrement yy_c_buf_p upon doing
			 * the jam.  In this case, that's wrong, since
			 * it points to the last non-jam character.  So
			 * we increment it now to counter the decrement.
			 */
			++yy_c_buf_p;
#endif
			break;
			}
		    }

		YY_INPUT( (yy_ch_buf + yy_c_buf_p + 1), yy_n_chars,
			  YY_MAX_LINE );

		if ( yy_n_chars == YY_NULL )
		    {
		    if ( yy_saw_eof )
	YY_FATAL_ERROR( "flex scanner saw EOF twice - shouldn't happen" );
		    yy_saw_eof = 1;
		    goto saweof;
		    }

		yy_e_buf_p += yy_n_chars;
		}

	    ++yy_c_buf_p;

#ifdef FLEX_USE_ECS
	    yy_sym = e[yy_ch_buf[yy_c_buf_p]];
#else
	    yy_sym = yy_ch_buf[yy_c_buf_p];
#endif

#ifdef FLEX_FULL_TABLE
	    yy_curst = n[yy_curst][yy_sym];

#else /* get next state from compressed table */

	    while ( c[b[yy_curst] + yy_sym] != yy_curst )
		{
		yy_curst = d[yy_curst];

#ifdef FLEX_USE_MECS
		/* we've arrange it so that templates are never chained
		 * to one another.  This means we can afford make a
		 * very simple test to see if we need to convert to
		 * yy_sym's meta-equivalence class without worrying
		 * about erroneously looking up the meta-equivalence
		 * class twice
		 */

		if ( yy_curst >= YY_TEMPLATE )
		    yy_sym = m[yy_sym];
#endif
		}

	    yy_curst = n[b[yy_curst] + yy_sym];

#endif

	    yy_st_buf[yy_c_buf_p] = yy_curst;

	    }
#ifdef FLEX_INTERACTIVE_SCANNER
	while ( b[yy_curst] != YY_JAM_BASE );
#else
	while ( yy_curst != YY_JAM );
	--yy_c_buf_p; /* put back character we jammed on */

#endif

	if ( yy_c_buf_p >= yy_b_buf_p )
	    { /* we matched some text */
	    yy_curst = yy_st_buf[yy_c_buf_p];
	    yy_lp = l[yy_curst];

#ifdef FLEX_REJECT_ENABLED
find_rule: /* we branch to this label when doing a REJECT */
#endif

	    for ( ; ; ) /* until we find what rule we matched */
		{
#ifdef FLEX_REJECT_ENABLED
		if ( yy_lp && yy_lp < l[yy_curst + 1] )
		    {
		    yy_act = a[yy_lp];
		    goto do_action; /* "continue 2" */
		    }
#else
		if ( yy_lp )
		    {
		    yy_act = yy_lp;
		    goto do_action; /* "continue 2" */
		    }
#endif

		if ( --yy_c_buf_p < yy_b_buf_p )
		    break;

		yy_curst = yy_st_buf[yy_c_buf_p];
		yy_lp = l[yy_curst];
		}
	    }

	YY_FATAL_ERROR( "no match in flex scanner - possible NULL in input" );
	}
	}

    /*NOTREACHED*/
    }


static  void unput( c )
char c;
{
 register int i;
 register int yy_buf_pos ;

    YY_DO_BEFORE_SCAN; /* undo effects of setting up yytext */

    if ( yy_c_buf_p == 0 )
	{
    yy_buf_pos = YY_BUF_MAX ;
	for ( i = yy_e_buf_p; i >= yy_c_buf_p; --i )
	    {
	    yy_ch_buf[yy_buf_pos] = yy_ch_buf[i];
	    yy_st_buf[yy_buf_pos] = yy_st_buf[i];
	    --yy_buf_pos;
	    }

	yy_c_buf_p = YY_BUF_MAX - yy_e_buf_p;
	yy_e_buf_p = YY_BUF_MAX;
	}

    if ( yy_c_buf_p <= 0 )
	YY_FATAL_ERROR( "flex scanner push-back overflow" );

    if ( yy_c_buf_p >= yy_b_buf_p && yy_ch_buf[yy_c_buf_p] == '\n' )
	yy_ch_buf[yy_c_buf_p - 1] = '\n';

    yy_ch_buf[yy_c_buf_p--] =  c;

    YY_DO_BEFORE_ACTION; /* set up yytext again */

    }


static char input( void)
{
    char c;

    YY_DO_BEFORE_SCAN

    if ( yy_c_buf_p == yy_e_buf_p )
	{ /* need more input */
	int yy_n_chars;

	/* we can throw away the entire current buffer */
	if ( yy_saw_eof )
	    {
	    if ( yywrap() )
		return ( EOF );

	    YY_INIT;
	    }

	yy_b_buf_p = 0;
	YY_INPUT( yy_ch_buf, yy_n_chars, YY_MAX_LINE );

	if ( yy_n_chars == YY_NULL )
	{
	    yy_saw_eof = 1;

	    if ( yywrap() )
		return ( EOF );

	    YY_INIT;

	    return ( input() );
	}

	yy_c_buf_p = -1;
	yy_e_buf_p = yy_n_chars - 1;
	}

    c = (unsigned char) yy_ch_buf[++yy_c_buf_p];

    YY_DO_BEFORE_ACTION;

    return ( c );
    }

/*--------------------------------------------------------------------------*/
/*------------------------- END OF LEXICAL ANALYZER ------------------------*/
/*--------------------------------------------------------------------------*/


