


BISON(1)            UNIX Programmer's Manual             BISON(1)



NAME
     bison - GNU Project parser generator (yacc replacement)

SYNOPSIS
     bison [ -dlvty ] file

DESCRIPTION
     Bison is a parser generator in the style of yacc(1).  It
     should be upwardly compatible with input files designed for
     yacc.

     Input files should follow the yacc convention of ending in
     ``.y''.  Unlike yacc, the generated files do not have fixed
     names, but instead use the prefix of the input file.  For
     instance, a grammar description file named parse.y would
     produce the generated parser in a file named parse.tab.c,
     instead of yacc's y.tab.c.

     Bison takes five optional flags.

     -d   Produce a .tab.h file, similar to yacc's y.tab.h file.

     -l   Omit #line lines in the parser output file. Error mes-
          sages from the C compiler will then be associated with
          lines in the parser output file, instead of lines in
          the original grammar file.

     -t   Turn on debugging. This option causes the bison output
          to have debugging code made available via the C pre-
          processor.  The external variable yydebug should be
          made non-zero to have the debugging code actually pro-
          duce output.

     -v   Be verbose. Analogous to the same flag for yacc.

     -y   Use fixed output file names. I.e., force the output to
          be in files y.tab.c, y.tab.h, and so on. This is for
          full yacc compatibility.

     If bison is invoked with the name yacc, it will behave like
     yacc does. This is equivalent to simply supplying the -y
     flag.

FILES
     /usr/local/lib/bison.simple   simple parser
     /usr/local/lib/bison.hairy    complicated parser

SEE ALSO
     yacc(1)
     The Bison Reference Manual, included as the file
     bison.texinfo in the bison source distribution.




Printed 12/28/88              local                             1






BISON(1)            UNIX Programmer's Manual             BISON(1)



DIAGNOSTICS
     ``Self explanatory.''





















































Printed 12/28/88              local                             2



