/*****************************************************************************/
/* Sched - An automated program launcher - (C) Raphal Vanney, 1995          */
/*****************************************************************************/
/* Configuring Sched is a simple matter of adapting the program to suit      */
/* your needs. The part that should be edited is everything before the       */
/* comment that reads "Private initializations".                             */
/*****************************************************************************/

/* LogFile defines the name of the file where Sched will put some            */
/* information regarding the events it processed.                            */

LogFile="e:\lora\logs\Sched.Log"

/* Debug defines whether Sched vill verbosely tell the user what's going     */
/* on. It is advisable to set it to 1 to activate it untill you get a fully  */
/* working setup.                                                            */

Debug=0

/* EvtCnt defines the number of events to schedule. There's no theoric       */
/* limit to the number of events you may define.                             */

EvtCnt=3

/* For each event, you must define four variables :                          */
/* EvtTim.x  : the time at which the event should occur                      */
/* EvtDay.x  : days the event should occur. Use "0" for monday, "1" for      */
/*             tuesday, etc...                                               */
/* EvtStr.x  : the complete parameter string that will be passed to the      */
/*             "start" command when the event occurs.                        */
/* EvtDsc.x  : a short description of the event. This description being      */
/*             used to identify the event in the .INI file, it is NOT        */
/*             advisable that several events have the same description.      */

EvtTim.1="15:00"
EvtDay.1="0123456"
EvtStr.1="/b /c /Win /Min d:\rva\4os2\4os2.exe /c e:\Lora\Zips.Btm"
EvtDsc.1="Sauvegardes diverses"

EvtTim.2="8:00"
EvtDay.2="0123456"
EvtStr.2="/b /c /Win /Min d:\rva\4os2\4os2.exe /c e:\Lora\SqFilt.Btm"
EvtDsc.2="SqFilters"

EvtTim.3="18:30"
EvtDay.3="6"
EvtStr.3="/b /c /Win /Min d:\RVa\IBMAV\RVa.Cmd"
EvtDsc.3="IBM Anti-virus"

/**************************************************************************/
/*                The user-configuration area ends here !                 */
/**************************************************************************/

/**************************************************************************/
/* Private initializations                                                */
/**************************************************************************/

Call Log "Sched begin"

call RxfuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

Arg Prm
If Prm="DEBUG" Then Debug=1

IniFile="Sched.Ini"
LastExec="Scheduled apps last exec"

rc=SysFileTree("Sched.Cmd", Res, "FO")
If Res.0=0 Then Do
     Say "Sched MUST be launched from the directory where it resides."
     Exit
End
rc=SysSetIcon("Sched.Cmd", "Sched.Ico")

Do i=1 To EvtCnt
     EvtTim.i=MakeTime(EvtTim.i)
End

/**************************************************************************/
/* Fetch last execution dates for each event                              */
/**************************************************************************/

Say "Checking the ini file..."

Do i=1 To EvtCnt
     rc=SysIni(IniFile, LastExec, EvtDsc.i)
     If rc="ERROR:" Then Do
          If Debug Then Say EvtDsc.i" has never been run."
          EvtTdy.i=0
     End
     Else Do
          If Debug Then Say EvtDsc.i" was last executed on "rc
          If rc<Date(Sorted) Then EvtTdy.i=0
                             Else EvtTdy.i=1
     End
End

/**************************************************************************/

Say "Sched enters its forever loop"
'@echo on'

Last=0

Do ForEver
     t=Time(Minutes)          /* current time, minutes elapsed since midnight */
     d=Date(BaseDate)//7      /* current day of week, 0..6 */
     If t<Last Then Do
          /* on a chang de jour */
          If Debug Then Say "New Day! ("Date()" at "Time(Normal)")"
          Call Log "New day"
          Do i=1 To EvtCnt
               EvtTdy.i=0
          End
     End
     Last=t
     If Debug Then Say "Time is "t

     Do i=1 To EvtCnt
          If Debug Then Say "Event "EvtDsc.i" at "EvtTim.i" (Done today="EvtTdy.i")"
          If EvtTdy.i=0 Then            /* if event not done today */
          If Pos(d, EvtDay.i)<>0 Then   /* if day of week matches */
          If EvtTim.i <= t Then Do      /* if time justifies */
               EvtTdy.i=1
               rc=SysIni(IniFile, LastExec, EvtDsc.i, Date(Sorted))
               Say "Starting event n"i" ("EvtDsc.i")"
               'Start 'EvtStr.i
               Say ""
               Call Log "Event "||EvtDsc.i||" started."
          End
          Else Do
               If Debug Then Say "Event #"i" in "EvtTim.i-t" minute(s)"
          End
     End

     If Debug Then Say "Back to sleep for 30 seconds."
     rc=SysSleep(30)
End

/**********************************************************************/
/* Log(<chane>)                                                      */
/**********************************************************************/
Log: Procedure Expose LogFile
Parse Arg St
rc=LineOut(LogFile, Date()||" "||Time()||" - "||St)
rc=LineOut(LogFile)
Return rc

/**********************************************************************/
/* MakeTime(<heure>)                                                  */
/* Returns a time compatible with Time(Minutes)                       */
/**********************************************************************/
MakeTime: Procedure
Arg HM
Parse Var HM H":"M
Return (60*H)+M

