@ECHO OFF

REM -- SAMPLE HSLINK COMMAND LINE TO SEND ALL FILES IN
REM -- C:\UPLOADS AND TO PLACE ANY RECEIVE FILES INTO
REM -- C:\DOWNLOADS.  EDIT THIS COMMAND LINE TO MATCH YOUR
REM -- REQUIRED COM PORT AND DIRECTORY NAMES.
SET DSZLOG=HSLINK.LOG
IF EXIST HSLINK.LOG DEL HSLINK.LOG
HSLINK -P2 C:\UPLOADS\*.* -UC:\DOWNLOADS

REM -- REPORT IF ANY OUTGOING FILES (UPLOADS) WERE SUCCESSFUL
SCANLOG HSLINK.LOG -O >NUL
IF ERRORLEVEL 255 GOTO NOLOG
IF ERRORLEVEL 1 GOTO UPLOADOK
ECHO NO FILES WERE TRANSMITTED.
GOTO CHECKI

:NOLOG
ECHO SINCE THERE IS NO DSZLOG FILE, NO FILES WERE TRANSFERRED.
GOTO CONTINUE

:UPLOADOK
ECHO AT LEAST 1 FILE WAS TRANSMITTED SUCCESSFULLY.

REM -- REPORT IF ANY INCOMING FILES (DOWNLOADS) WERE SUCCESSFUL
:CHECKI
SCANLOG HSLINK.LOG -I >NUL
IF ERRORLEVEL 1 GOTO DOWNLOADOK
ECHO NO FILES WERE RECEIVED.
GOTO CHECKT
:DOWNLOADOK
ECHO AT LEAST 1 FILE WAS RECEIVED SUCCESSFULLY.

REM -- REPORT IF ANY OUTGOING FILES (UPLOADS) WERE ABORTED
:CHECKT
SCANLOG HSLINK.LOG -T >NUL
IF ERRORLEVEL 1 GOTO UPLOADERR
ECHO NO OUTGOING FILES WERE ABORTED.
GOTO CHECKR
:DOWNLOADOK
ECHO AT LEAST 1 OUTGOING FILE WAS ABORTED.

REM -- REPORT IF ANY INCOMING FILES (DOWNLOADS) WERE ABORTED
:CHECKR
SCANLOG HSLINK.LOG -R >NUL
IF ERRORLEVEL 1 GOTO DOWNLOADERR
ECHO NO INCOMING FILES WERE ABORTED.
GOTO CONTINUE
:DOWNLOADOK
ECHO AT LEAST 1 INCOMING FILE WAS ABORTED.

:CONTINUE

