//   ͻ
//                                                                       
//    module:      semainfo.c                                            
//    abstract:    This module shows how to make the GetSemaphoreIn-     
//                 formation system call using the F2 Shell Interface.   
//                 Obviously, it requires the NetWare Shell.             
//                                                                       
//    environment: NetWare 3.x v3.11                                     
//                 Borland C 3.0                                         
//                                                                       
//     This software is provided as is and carries no warranty           
//     whatsoever.  Novell disclaims and excludes any and all implied    
//     warranties of merchantability, title and fitness for a particular 
//     purpose.  Novell does not warrant that the software will satisfy  
//     your requirements or that the software is without defect or error 
//     or that operation of the software will be uninterrupted.  You are 
//     using the software at your risk.  The software is not a product   
//     of Novell, Inc. or any of subsidiaries.                           
//   ͼ

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>

#include "nwsys.h"

//
//  First of all, we define the request and reply structures which are
//  needed for the GetSemaphoreInformation API call.  These structures are
//  layed out according to the System Call documentation.
//

struct  {
    WORD    sflen;          // length of the structure.  This is 6 + 'onlen'
    BYTE    sfcode;         // the subfunction code, in our case 53.
    WORD    lastRecordSeen; // length of name (below)
    BYTE    semaphoreNameLength;
    char    semaphoreName[128];
}Request;

struct connStruct {
    WORD    connectionNumber;
			    // Connection holding semaphore open
    WORD    taskNumber;     // task number holding semaphore open
};

struct  {
    WORD    nextRequestRec; // next record to be requested.
    WORD    openCount;      // total number of times opened
    WORD    value;          // value of semaphore
    BYTE    semaphoreCount; //  number of semaphores in this iteration
    struct  connStruct conn[150];
			    //  Array of connection information
} Reply;

int numConnections;
char semaphoreName[128];

void processEntries(void);
void displayData(void);
//
//  This routine allocates memory for the data returned for each file.
//  It also makes the GetConnectionOpenFiles call and parses the data
//  for each file.
//
void ProcessEntries(void)
{
	numConnections+=Reply.semaphoreCount;
}

//
//  Display the list of open files for the connection.
//
void DisplayData( void )
{
	int i;

	clrscr();
	printf("\n\nSemaphore Information For %s  Value: %d\n\n",
				semaphoreName,Reply.value);
	printf("Conn   Task\n");
	printf("----   ----\n");
	for(i=0;i<numConnections;i++) {
		printf(" %02d ",WordSwap(Reply.conn[i].connectionNumber));
		printf("    %02d\n",WordSwap(Reply.conn[i].taskNumber));
	}
}
//
//  This is the main program.  The purpose is to make the GetBinderyObjectID
//  API call to illustrate making system calls using the F2 interface.
//

void main(int argc, char *argv[])
{
	int     cc;
	int     length;

	if(argc!=2){printf("usage: SEMAINFO semaphoreName\n");exit(1);}
	strcpy(semaphoreName,argv[1]);
	numConnections=0;
	//
	//  Build the request buffer
	//
	Request.sflen = strlen(semaphoreName) + 6;
	Request.sfcode = 242;                       // subfunction code
	length=strlen(semaphoreName);
	Request.semaphoreNameLength=(BYTE)length;
	memcpy(Request.semaphoreName,semaphoreName,strlen(semaphoreName));
	Request.lastRecordSeen = 0;
	cc = NWSystemCall(23,&Request,sizeof Request,&Reply,sizeof Reply);
	printf("Function returned:    %03d--%#02x\n",cc,cc);
	if( cc == 0 ) {
		ProcessEntries();
		DisplayData();
	}
}
