program Fader;

(* The following 3 lines are not comments. *)

{$N-,E-,Q-,S-,R-,I-,O-,F-,P+,T-,X-,V-,B-,A+,G-,D-,L-,Y-}
{$M 8192,0,65536}
{$L Bgi256}  (* < Links the graphics object file (into the code segment). *)

(* Compiled in Borland Turbo Pascal 7.0 for DOS. Bgi256.Obj is a non-Borland
   aftermarket add-on file. It is "registered", meaning the Bgi256.Obj file
   itself isn't needed to run Fader.exe. *)

uses crt,drivers,graph;

var
Gd, Gm, Error : integer;
Red, Green, Blue, TimeValue, ColorValue : shortint;
Adjuster : char;

label Start;

(* Gm := 0 is 320x200x256, 1 is 640x400x256, 2 is 640x480x256,
         3 is 800x600x256, 4 is 1024x768x256, 5 is 1280x1024x256 *)

procedure Bgi256proc; external; (* The "public" name as declared by BinObj.exe *)

procedure InitBgi256;
begin
Gd := installuserdriver('Bgi256',nil);
Error := registerbgidriver(@Bgi256proc);
Gm := 0;  (* Run in 320x200x256 mode *)
initgraph(Gd,Gm,'');
Error := graphresult;
if Error <> 0 then
begin
closegraph;
textcolor(7);
textbackground(0);
clrscr;
textcolor(9);
gotoxy(1,3);
writeln(' Sorry, your display and/or video card is incompatible');
writeln(' with this screen saver program. Oh, well; No harm done.');
writeln;
halt(1);
end;
end;

procedure Exit_Program;
begin
closegraph;
textcolor(7);
textbackground(0);
clrscr;
gotoxy(1,3);
textcolor(9);
write('I hope you like playing this screen saver; Fader.....');
textcolor(137);
writeln('.');
textcolor(1);
writeln('"Mission Control" was here.');
donesyserror;
halt;
end;

begin
initsyserror;   (* Turns off ctrl-break, in drivers unit. *)
textcolor(1);
textbackground(3);
clrscr;
gotoxy(1,4);
write('  Welcome to Fader');
textcolor(129);
writeln('!');
textcolor(1);
writeln('  This program is a simple screen saver. What it does is put up one of up to');
writeln('  262,144 colors for a tiny fraction of a second before slightly changing into');
writeln('  a different hue. The effect is of the screen fading smoothly from color to');
writeln('  color, each of them very pretty. There are 10 speeds in all, with 0 being the');
writeln('  fastest and 9 being the slowest. While it''s playing, you may press a lower');
writeln('  number to speed it up, or press a higher number to slow it down. If you want');
writeln('  to re-randomize the colors, and the timimg, press the R key (for Randomize).');
writeln('  This resets the colors and timing at random. This can change a boring color.');
writeln('  All other keys will exit the program, either from here or from within Fader.');
write('  Press a key now, either R, or from 0 through 9 to begin the fader. Enjoy....');
Adjuster := readkey;

case Adjuster of
'0' : TimeValue :=  0;      (* Dummy assignment, only allows 0 key to get in. *)
'1' : TimeValue :=  2;
'2' : TimeValue :=  5;
'3' : TimeValue :=  8;
'4' : TimeValue := 11;
'5' : TimeValue := 14;
'6' : TimeValue := 17;
'7' : TimeValue := 20;
'8' : TimeValue := 23;
'9' : TimeValue := 26;
'r','R' : ColorValue := 0;  (* Dummy assignment, only allows R key to get in. *)
else Exit_Program;
end;

InitBgi256;
randomize;
Red:=random(64); Green:=random(64); Blue:=random(64);

Start:   (* Rapidly cycling loop. *)
repeat   (* Begin loop. *)
setrgbpalette(0, Red, Green, Blue);

if Adjuster <> '0' then
begin
if (Adjuster = 'r') or (Adjuster = 'R') then delay(random(27))
else delay(TimeValue);
end;
if (TimeValue <> 0) or (Adjuster = 'r') or (Adjuster = 'R') then delay(1);

ColorValue := random(9);
case ColorValue of
0 : Red := Red - 1;
2 : Red := Red + 1;
3 : Green := Green - 1;
5 : Green := Green + 1;
6 : Blue := Blue - 1;
8 : Blue := Blue + 1
end;

if Red = -1 then Red := 1;
if Red = 64 then Red := 63;
if Green = -1 then Green := 1;
if Green = 64 then Green := 63;
if Blue = -1 then Blue := 1;
if Blue = 64 then Blue := 63;
until keypressed; (* End loop. *)

Adjuster := readkey;
case Adjuster of
'0' : TimeValue :=  0;  (* Dummy assignment, only allows 0 key to work. *)
'1' : TimeValue :=  2;
'2' : TimeValue :=  5;
'3' : TimeValue :=  8;
'4' : TimeValue := 11;
'5' : TimeValue := 14;
'6' : TimeValue := 17;
'7' : TimeValue := 20;
'8' : TimeValue := 23;
'9' : TimeValue := 26;
'r','R' : begin Red:=random(64); Green:=random(64); Blue:=random(64); end;
else Exit_Program;
end;

goto Start;

end.