program Colors;

(* The following 3 lines are not comments. *)

{$N-,E-,Q-,S-,R+,I-,O-,F-,P+,T-,X-,V-,B-,A+,G-,D-,L-,Y-}
{$M 8192,0,65536}
{$L Bgi256}  (* < Links the graphics object file (into the code segment). *)

(* Compiled in Borland Turbo Pascal 7.0 for DOS. Bgi256.Obj is a non-Borland
   aftermarket add-on file. It is "registered", meaning the Bgi256.Obj file
   itself isn't needed to run Colors.exe. *)

uses crt,drivers,graph;

var
Gd, Gm, Error, Milliseconds : integer;                  
Adjuster : char;

label Top, Start;

(* Gm := 0 is 320x200x256, 1 is 640x400x256, 2 is 640x480x256,
         3 is 800x600x256, 4 is 1024x768x256, 5 is 1280x1024x256 *)

procedure Bgi256proc; external; (* The "public" name as declared by BinObj.exe. *)

procedure InitBgi256;
begin
Gd := installuserdriver('Bgi256',nil);
Error := registerbgidriver(@Bgi256proc);
Gm := 0;  (* Run in 320x200x256 mode *)
end;

procedure Exit_Program;
begin
closegraph;
textcolor(7);
textbackground(0);
clrscr;
gotoxy(1,3);
textcolor(9);
writeln('I hope you like playing this screen saver; Colors....');
writeln;
donesyserror;
halt;
end;

begin
initsyserror;   (* Turns off ctrl-break, in drivers unit. *)
Adjuster := 'A';
textcolor(7);
textbackground(1);
randomize;
Top:
clrscr;
gotoxy(1,3);
writeln(' This program is a simple screen saver. What it does is put up one of up to');
writeln(' 262,144 shades of color from black to white. It randomly chooses the color');
writeln(' using 6 bits each for red green and blue (18-bit color). It holds each color');
writeln(' for a random timeframe up to your millisecond entry. Requires only an 8088');
writeln(' or up and 256k of ram on the video card, and a color monitor. Below you will');
writeln(' determine the longest interval of time Colors can leave up any certain color.');
writeln(' Your entry is in milliseconds, from 100 to 2000 (0.1 second to 2.0 seconds).');
writeln(' Lower numbers will produce more rapid flickering. Colors will choose a random');
writeln(' value between 0 milliseconds and your entry to show each color. If you press');
writeln(' the N key (for New screen), you return to the menu to enter a new upper delay');
writeln(' value. It randomly chooses to display each color from 0 milliseconds to your');
write(' your entry for milliseconds. Any other key exits Colors. Have fun');
textcolor(135);
writeln('!');
textcolor(7);
writeln;
writeln(' Enter a whole number between 100 and 2000 (or 0 to exit)');
write(' >  ');
reset(input);
if not eoln(input) then
read(Milliseconds) else goto Top;

if ioresult = 106 then goto Top;

if Milliseconds = 0 then Exit_Program;

if (Milliseconds < 100) or (Milliseconds > 2000) then goto Top;

if Adjuster = 'A' then InitBgi256;

initgraph(Gd,Gm,'');
Error := graphresult;
if Error <> 0 then
begin
closegraph;
textcolor(7);
textbackground(0);
clrscr;
textcolor(9);
gotoxy(1,3);
writeln(' Sorry, your display and/or video card is incompatible');
writeln(' with this screen saver program. Oh, well; No harm done.');
writeln;
exit;
end;

Start:
repeat
setrgbpalette(0, Random(64), Random(64), Random(64));
delay(Random(Milliseconds));
delay(1);
until keypressed;

Adjuster := readkey;

if (Adjuster = 'n') or (Adjuster = 'N') then
begin
closegraph;
goto Top;
end else Exit_Program;

end.