/*>>> sanval.c: SAN project value access routines */

/* Revised: 1993.09.14 */

#include <stdio.h>
#include <stdlib.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanatk.h"
#include "sangen.h"
#include "sangtc.h"
#include "sanhsh.h"
#include "sanhst.h"
#include "sanmsc.h"
#include "sansss.h"
#include "sanval.h"

/*--> SANUpdate: update the current environment */
nonstatic
void
SANUpdate(void)
{
/* recalculate the material sums */

SANSetMaterial();

/* recalculate the piece vector and board index set */

SANSetPieceVector();

/* recalculate the hash address and signature */

SANHashCreate();

/* set the attacker vector */

SANSetAttackers();

/* generate */

if (SANCensus() == cen_lgl)
	SANGenMoves();

/* recalculate the global game termination code */

SANGTCAutoSet();

return;
}

/*--> SANZapUp: clear history and then update database */
nonstatic
void
SANZapUp(void)
{
/* mark position as being set up */

setup = 1;

/* clear history and update the environment */

SANHistClear();
SANUpdate();

/* strategies */

SANSSS(sep_setpos);

return;
}

/*--> SANClrBoard: clear the board */
nonstatic
void
SANClrBoard(void)
{
sqT sq;

for (sq = sq_a1; sq <= sq_h8; sq++)
	gb.bv[sq] = cp_v0;
curr_e.e_cast = 0;
curr_e.e_epsq = sq_nil;
SANZapUp();

return;
}

/*--> SANGetSq: get square value */
nonstatic
cpT
SANGetSq(sqT sq)
{

return (gb.bv[sq]);
}

/*--> SANGetBoard: get the board */
nonstatic
void
SANGetBoard(bptrT bptr)
{
sqT sq;

for (sq = sq_a1; sq <= sq_h8; sq++)
	bptr->bv[sq] = gb.bv[sq];

return;
}

/*--> SANGetACTC: get active color */
nonstatic
cT
SANGetACTC(void)
{

return (curr_e.e_actc);
}

/*--> SANGetCAST: get castling bits */
nonstatic
castT
SANGetCAST(void)
{

return (curr_e.e_cast);
}

/*--> SANGetEPSQ: get en passant square */
nonstatic
sqT
SANGetEPSQ(void)
{

return (curr_e.e_epsq);
}

/*--> SANGetHMVC: get halfmove clock */
nonstatic
siT
SANGetHMVC(void)
{

return (curr_e.e_hmvc);
}

/*--> SANGetFMVN: get fullmove number */
nonstatic
siT
SANGetFMVN(void)
{

return (curr_e.e_fmvn);
}

/*--> SANPutSq: put a square value */
nonstatic
void
SANPutSq(sqT sq, cpT cp)
{
gb.bv[sq] = cp;
SANZapUp();

return;
}

/*--> SANPutBoard: set the board */
nonstatic
void
SANPutBoard(bptrT bptr)
{
sqT sq;

for (sq = sq_a1; sq <= sq_h8; sq++)
	gb.bv[sq] = bptr->bv[sq];
SANZapUp();

return;
}

/*--> SANPutACTC: put active (and passive) color */
nonstatic
void
SANPutACTC(cT c)
{
curr_e.e_actc = c;
curr_e.e_pasc = inv_cv[c];
SANZapUp();

return;
}

/*--> SANPutCAST: put castling bits */
nonstatic
void
SANPutCAST(castT cast)
{
curr_e.e_cast = cast;
SANZapUp();

return;
}

/*--> SANPutEPSQ: put en passant square */
nonstatic
void
SANPutEPSQ(sqT epsq)
{
curr_e.e_epsq = epsq;
SANZapUp();

return;
}

/*--> SANPutHMVC: put halfmove clock */
nonstatic
void
SANPutHMVC(siT hmvc)
{
curr_e.e_hmvc = hmvc;
SANZapUp();

return;
}

/*--> SANPutFMVN: put fullmove number */
nonstatic
void
SANPutFMVN(siT fmvn)
{
curr_e.e_fmvn = fmvn;
SANZapUp();

return;
}

/*<<< sanval.c: EOF */
