/*>>> sanpgc.c: SAN project PGC routines */

/* Revised: 1994.02.06 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanpgc.h"
#include "santag.h"

/*--> SANPGNWriteInt1: write an int-1 to a file */
static
void
SANPGNWriteInt1(FILEptrT fptr, byteT int1)
{
fprintf(fptr, "%c", int1);

return;
}

/*--> SANPGNWriteInt2: write an int-2 to a file */
static
void
SANPGNWriteInt2(FILEptrT fptr, siT int2)
{
fprintf(fptr, "%c%c", (int2 & 0x00ff), ((int2 >> 8) & 0x00ff));

return;
}

/*--> SANPGNWriteInt4: write an int-4 to a file */
static
void
SANPGNWriteInt4(FILEptrT fptr, liT int4)
{
fprintf(fptr, "%c%c%c%c",
	(int4 & 0x00ff), ((int4 >> 8) & 0x00ff),
	((int4 >> 16) & 0x00ff), ((int4 >> 24) & 0x00ff));

return;
}

/*--> SANPGNWriteString1: write a string-1 to a file */
static
void
SANPGNWriteString1(FILEptrT fptr, liT length, charptrT s)
{
liT i;

SANPGNWriteInt1(fptr, length);
for (i = 0; i < length; i++)
	SANPGNWriteInt1(fptr, *(s + i));

return;
}

/*--> SANPGNWriteString2: write a string-2 to a file */
static
void
SANPGNWriteString2(FILEptrT fptr, liT length, charptrT s)
{
liT i;

SANPGNWriteInt2(fptr, length);
for (i = 0; i < length; i++)
	SANPGNWriteInt1(fptr, *(s + i));

return;
}

/*--> SANPGNWriteString4: write a string-4 to a file */
static
void
SANPGNWriteString4(FILEptrT fptr, liT length, charptrT s)
{
liT i;

SANPGNWriteInt4(fptr, length);
for (i = 0; i < length; i++)
	SANPGNWriteInt1(fptr, *(s + i));

return;
}

/*--> SANPGCWriteRPGC: write the current game in (reduced) PGC to a file */
static
void
SANPGCWriteRPGC(FILEptrT fptr)
{
rsvtagT rsvtag;
tagptrT tagptr;
siT hcn;
hptrT hptr;

SANPGNWriteInt1(fptr, 0x01);

for (rsvtag = 0; rsvtag < rsvtagL; rsvtag++)
	{
	tagptr = SANTagLocate(rsvtagv[rsvtag]);
	SANPGNWriteString1(fptr, strlen(tagptr->tag_value), tagptr->tag_value);
	};

SANPGNWriteInt2(fptr, hn);
hcn = 0;
hptr = hbase;
while (hcn < hn)
	{
	SANPGNWriteInt1(fptr, hptr->h_o);
	hcn++;
	hptr++;
	};

return;
}

/*--> SANPGCWriteCurrent: write the current game in PGC to a file */
nonstatic
void
SANPGCWriteCurrent(FILEptrT fptr)
{
SANPGCWriteRPGC(fptr);

return;
}

/*<<< sanpgc.c: EOF */
