/*>>> sanpce.c: SAN project parameter checking and evaluation */

/* Revised: 1993.05.16 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanpce.h"
#include "sanutl.h"

/*--> SANCheckShortInteger: check if the input is a short integer */
nonstatic
siT
SANCheckShortInteger(charptrT s)
{
siT flag;
siT i, c;

/* set default return value */

flag = 1;

/* set up */

i = 0;
c = *(s + i++);

if (c == '\0')
	flag = 0;
else
	{
	if ((c == '+') || (c == '-'))
		c = *(s + i++);
	if (c == '\0')
		flag = 0;
	else
		{
		while (isdigit(c))
			c = *(s + i++);
		if (c != '\0')
			flag = 0;
		};
	};

return (flag);
}

/*--> SANEvalShortInteger: evaluate short integer */
nonstatic
siT
SANEvalShortInteger(charptrT s)
{
siT value;
siT sign, i, c;

/* set default return value */

value = 0;

/* set up */

sign = 1;
i = 0;
c = *(s + i++);
if ((c == '+') || (c == '-'))
	{
	if (c == '-')
		sign = -1;
	c = *(s + i++);
	};
while (c != '\0')
	{
	value *= 10;
	value += (c - '0');
	c = *(s + i++);
	};
value *= sign;

return (value);
}

/*--> SANCheckLongInteger: check if the input is a long integer */
nonstatic
siT
SANCheckLongInteger(charptrT s)
{
siT flag;
siT i, c;

/* set default return value */

flag = 1;

/* set up */

i = 0;
c = *(s + i++);

if (c == '\0')
	flag = 0;
else
	{
	if ((c == '+') || (c == '-'))
		c = *(s + i++);
	if (c == '\0')
		flag = 0;
	else
		{
		while (isdigit(c))
			c = *(s + i++);
		if (c != '\0')
			flag = 0;
		};
	};

return (flag);
}

/*--> SANEvalLongInteger: evaluate long integer */
nonstatic
liT
SANEvalLongInteger(charptrT s)
{
liT value;
siT sign, i, c;

/* set default return value */

value = 0;

/* set up */

sign = 1;
i = 0;
c = *(s + i++);
if ((c == '+') || (c == '-'))
	{
	if (c == '-')
		sign = -1;
	c = *(s + i++);
	};
while (c != '\0')
	{
	value *= 10;
	value += (c - '0');
	c = *(s + i++);
	};
value *= sign;

return (value);
}

/*--> SANCheckOption: check if the input is an option name */
nonstatic
siT
SANCheckOption(charptrT s)
{
siT flag;
optnT optn;

/* set default return value */

flag = 0;

/* scan */

optn = 0;
while (!flag && (optn < optnL))
	if (SANCIEqStr(s, optnnamev[optn]))
		flag = 1;
	else
		optn++;

return (flag);
}

/*--> SANEvalOption: evaluate option name */
nonstatic
siT
SANEvalOption(charptrT s)
{
optnT optn;
siT flag;

/* scan */

flag = 0;
optn = 0;
while (!flag && (optn < optnL))
	if (SANCIEqStr(s, optnnamev[optn]))
		flag = 1;
	else
		optn++;

if (!flag)
	optn = optn_nil;

return (optn);
}

/*--> SANCheckCommand: check if the input is a command name */
nonstatic
siT
SANCheckCommand(charptrT s)
{
siT flag;
cmdT cmd;

/* set default return value */

flag = 0;

/* scan */

cmd = 0;
while (!flag && (cmd < cmdL))
	if (SANCIEqStr(s, civ[cmd].ci_name))
		flag = 1;
	else
		cmd++;

return (flag);
}

/*--> SANEvalCommand: evaluate command name */
nonstatic
siT
SANEvalCommand(charptrT s)
{
cmdT cmd;
siT flag;

/* scan */

flag = 0;
cmd = 0;
while (!flag && (cmd < cmdL))
	if (SANCIEqStr(s, civ[cmd].ci_name))
		flag = 1;
	else
		cmd++;

if (!flag)
	cmd = cmd_nil;

return (cmd);
}

/*--> SANCheckStrategy: check if the input is a strategy name */
nonstatic
siT
SANCheckStrategy(charptrT s)
{
siT flag;
ssT ss;

/* set default return value */

flag = 0;

/* scan */

ss = 0;
while (!flag && (ss < ssL))
	if (SANCIEqStr(s, ssstrv[ss]))
		flag = 1;
	else
		ss++;

return (flag);
}

/*--> SANEvalStrategy: evaluate strategy name */
nonstatic
siT
SANEvalStrategy(charptrT s)
{
ssT ss;
siT flag;

/* scan */

flag = 0;
ss = 0;
while (!flag && (ss < ssL))
	if (SANCIEqStr(s, ssstrv[ss]))
		flag = 1;
	else
		ss++;

if (!flag)
	ss = ss_nil;

return (ss);
}

/*--> SANCheckFile: check if the input is a file character */
nonstatic
siT
SANCheckFile(char ch)
{
siT flag;
fileT file;

/* set default return value */

flag = 0;

/* scan */

file = 0;
while (!flag && (file < fileL))
	if (SANCIEqChar(ch, acfv[file]))
		flag = 1;
	else
		file++;

return (flag);
}

/*--> SANEvalFile: evaluate file character */
nonstatic
siT
SANEvalFile(char ch)
{
fileT file;
siT flag;

/* scan */

flag = 0;
file = 0;
while (!flag && (file < fileL))
	if (SANCIEqChar(ch, acfv[file]))
		flag = 1;
	else
		file++;

if (!flag)
	file = file_nil;

return (file);
}

/*--> SANCheckRank: check if the input is a rank character */
nonstatic
siT
SANCheckRank(char ch)
{
siT flag;
rankT rank;

/* set default return value */

flag = 0;

/* scan */

rank = 0;
while (!flag && (rank < rankL))
	if (SANCIEqChar(ch, acrv[rank]))
		flag = 1;
	else
		rank++;

return (flag);
}

/*--> SANEvalRank: evaluate rank character */
nonstatic
siT
SANEvalRank(char ch)
{
rankT rank;
siT flag;

/* scan */

flag = 0;
rank = 0;
while (!flag && (rank < rankL))
	if (SANCIEqChar(ch, acrv[rank]))
		flag = 1;
	else
		rank++;

if (!flag)
	rank = rank_nil;

return (rank);
}

/*--> SANCheckSquare: check if the input is a square name */
nonstatic
siT
SANCheckSquare(charptrT s)
{
siT flag;

if (strlen(s) != 2)
	flag = 0;
else
	flag = (SANCheckFile(s[0]) && SANCheckRank(s[1]));

return (flag);
}

/*--> SANEvalSquare: evaluate square name */
nonstatic
siT
SANEvalSquare(charptrT s)
{
sqT sq;

sq = map_sq_rank_file(SANEvalRank(s[1]), SANEvalFile(s[0]));

return (sq);
}

/*--> SANCheckColor: check if the input is a color character */
nonstatic
siT
SANCheckColor(char ch)
{
siT flag;
cT c;

/* set default return value */

flag = 0;

/* scan */

c = 0;
while (!flag && (c < rcL))
	if (SANCIEqChar(ch, accv[c]))
		flag = 1;
	else
		c++;

return (flag);
}

/*--> SANEvalColor: evaluate color character */
nonstatic
siT
SANEvalColor(char ch)
{
rcT c;
siT flag;

/* scan */

flag = 0;
c = 0;
while (!flag && (c < rcL))
	if (SANCIEqChar(ch, accv[c]))
		flag = 1;
	else
		c++;

if (!flag)
	c = c_nil;

return (c);
}

/*--> SANCheckPiece: check if the input is a piece character */
nonstatic
siT
SANCheckPiece(char ch)
{
siT flag;
pT p;

/* set default return value */

flag = 0;

/* scan */

p = 0;
while (!flag && (p <= p_k))
	if (SANCIEqChar(ch, acpv[p]))
		flag = 1;
	else
		p++;

return (flag);
}

/*--> SANEvalPiece: evaluate piece character */
nonstatic
siT
SANEvalPiece(char ch)
{
pT p;
siT flag;

/* scan */

flag = 0;
p = 0;
while (!flag && (p <= p_k))
	if (SANCIEqChar(ch, acpv[p]))
		flag = 1;
	else
		p++;

if (!flag)
	p = p_nil;

return (p);
}

/*--> SANCheckCastling: check if the input is a castling availability */
nonstatic
siT
SANCheckCastling(charptrT s)
{
siT flag;

if (strlen(s) != 2)
	flag = 0;
else
	flag = (SANCIEqChar(s[0], accv[c_w]) ||
		SANCIEqChar(s[0], accv[c_b])) &&
		(SANCIEqChar(s[1], acpv[p_k]) ||
		SANCIEqChar(s[1], acpv[p_q]));


return (flag);
}

/*--> SANEvalCastling: evaluate castling availability */
nonstatic
caiT
SANEvalCastling(charptrT s)
{
caiT value;

/* set default return value */

if (SANCIEqChar(s[0], accv[c_w]))
	if (SANCIEqChar(s[1], acpv[p_k]))
		value = cai_wk;
	else
		value = cai_wq;
else
	if (SANCIEqChar(s[1], acpv[p_k]))
		value = cai_bk;
	else
		value = cai_bq;

return (value);
}

/*<<< sanpce.c: EOF */


