/*>>> sanopt.c: SAN project option control */

/* Revised: 1993.05.15 */

#include <stdio.h>
#include <stdlib.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanopt.h"

/*--> SANOPTEntry: initialize a program option */
static
void
SANOPTEntry(optnT optn, charptrT name, charptrT help)
{
optnnamev[optn] = name;
optnhelpv[optn] = help;
optnv[optn] = 0;

return;
}

/*--> SANOPTInit: one time option initialization */
nonstatic
void
SANOPTInit(void)
{
/* initilaize the option vectors */

SANOPTEntry(optn_dbug, "dbug", "debugging");
SANOPTEntry(optn_emde, "emde", "extraordinary move disambiguation effort");
SANOPTEntry(optn_nabd, "nabd", "no auto board display");
SANOPTEntry(optn_namd, "namd", "no auto move display");
SANOPTEntry(optn_napr, "napr", "no auto program response");
SANOPTEntry(optn_nmde, "nmde", "no move disambiguation effort");
SANOPTEntry(optn_test, "test", "testing");
SANOPTEntry(optn_trpt, "trpt", "trace: processing time");
SANOPTEntry(optn_verb, "verb", "verbosity");

return;
}

/*<<< sanopt.c: EOF */
