/*>>> sanmpu.c: SAN project move play/unplay routines */

/* Revised: 1994.02.10 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "sandef.h"
#include "sanvar.h"

#include "sandsp.h"
#include "sangtc.h"
#include "sanhst.h"
#include "sanmer.h"
#include "sanmne.h"
#include "sanmpu.h"
#include "sanmsc.h"
#include "sansrt.h"
#include "sansss.h"
#include "sanutl.h"
#include "sanval.h"

/*--> SANPlayMove: play a move */
nonstatic
void
SANPlayMove(mptrT mptr)
{
/* locate move in current list */

curr_g.g_curr = SANFindMove(mptr);
if (curr_g.g_curr == NULL)
	SANFatal("SANPlayMove: can't find move");

/* echo move */

if (!optnv[optn_namd])
	SANDspFullMove(curr_e.e_fmvn, curr_g.g_curr);

/* save transition information */

prev_e = curr_e;
prev_m = *curr_g.g_curr;
prev_b = gb;

/* push to history */

SANHistPush(SANLocateOrdinal(mptr));

/* execute the move */

SANExecute();

/* drop analysis index (current ply) */

an--;

/* regenerate current level */

SANUpdate();

/* handle game termination */

SANGTCAutoSet();

/* board display */

if (!optnv[optn_nabd])
	SANDspBoard();

/* strategies */

SANSSS(sep_play);

return;
}

/*--> SANUnplayMove: unplay the last played move */
nonstatic
void
SANUnplayMove(void)
{
/* save transition information (except for the move) */

prev_e = curr_e;
prev_b = gb;

/* "Activate the WayBack Machine, Sherman!" */

SANHistPop();

/* save transition move information */

prev_m = *curr_g.g_curr;

/* echo move */

if (!optnv[optn_namd])
	SANDspFullMove(curr_e.e_fmvn, curr_g.g_curr);

/* board display */

if (!optnv[optn_nabd])
	SANDspBoard();

/* undo game termination */

SANGTCSet(gtc_norm);

/* strategies */

SANSSS(sep_unplay);

return;
}

/*<<< sanmpu.c: EOF */
