/*>>> sanepd.c: SAN project Extended Position Description */

/* Revised: 1994.01.24 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <time.h>

#include "sandef.h"
#include "sanvar.h"

#include "sanepd.h"
#include "sanutl.h"

/*--> SANEPDGenBasic: generate basic EPD notation for the given position */
nonstatic
charptrT
SANEPDGenBasic(bptrT bptr, cT actc, castT cast, sqT epsq)
{
charptrT ptr;
cpT cp;
rankT rank;
fileT file;
siT bi, ps, ch;
char bv[epdL];

bi = 0;

/* output board */

for (rank = rank_8; rank >= rank_1; rank--)
	{
	ps = 0;
	for (file = file_a; file <= file_h; file++)
		{
		cp = bptr->bm[rank][file];
		if (cp == cp_v0)
			ps++;
		else
			{
			if (ps != 0)
				{
				bv[bi++] = '0' + ps;
				ps = 0;
				};
			ch = acpv[cv_p_cpv[cp]];
			if (cv_c_cpv[cp] == c_w)
				ch = map_upper(ch);
			else
				ch = map_lower(ch);
			bv[bi++] = ch;
			};
		};
	if (ps != 0)
		{
		bv[bi++] = '0' + ps;
		ps = 0;
		};
	if (rank != rank_1)
		bv[bi++] = '/';
	};
bv[bi++] = ' ';

/* output active color (lower case) */

bv[bi++] = map_lower(accv[actc]);
bv[bi++] = ' ';

/* output castling availablility */

if (cast == 0)
	bv[bi++] = '-';
else
	{
	if (cast & cast_wk)
		bv[bi++] = map_upper(acpv[p_k]);
	if (cast & cast_wq)
		bv[bi++] = map_upper(acpv[p_q]);
	if (cast & cast_bk)
		bv[bi++] = map_lower(acpv[p_k]);
	if (cast & cast_bq)
		bv[bi++] = map_lower(acpv[p_q]);
	};
bv[bi++] = ' ';

/* output ep capture square */

if (epsq == sq_nil)
	bv[bi++] = '-';
else
	{
	bv[bi++] = acfv[map_file_sq(epsq)];
	bv[bi++] = acrv[map_rank_sq(epsq)];
	};

/* NUL termination */

bv[bi++] = '\0';

ptr = SANStrGrab(bv);

return (ptr);
}

/*--> SANEPDGenBasicCurrent: generate basic EPD for current position */
nonstatic
charptrT
SANEPDGenBasicCurrent(void)
{
charptrT ebptr;

ebptr = SANEPDGenBasic(&gb, curr_e.e_actc, curr_e.e_cast, curr_e.e_epsq);

return (ebptr);
}

/*--> SANEPDInit: one time EPD initialization */
nonstatic
void
SANEPDInit(void)
{

return;
}

/*--> SANEPDTerm: one time EPD termination */
nonstatic
void
SANEPDTerm(void)
{

return;
}

/*<<< sanepd.c: EOF */
